/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import org.xvm.asm.ClassStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.numbers.xCheckedConstrainedInt;

public abstract class xCheckedUnsignedInt
extends xCheckedConstrainedInt {
    public xCheckedUnsignedInt(Container container, ClassStructure structure, long cMinValue, long cMaxValue, int cNumBits) {
        super(container, structure, cMinValue, cMaxValue, cNumBits, true);
    }

    @Override
    public int invokeAdd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long lr;
        long l2;
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        if ((l1 & (l2 = ((ObjectHandle.JavaLong)hArg).getValue()) | (l1 | l2) & ((lr = l1 + l2) ^ 0xFFFFFFFFFFFFFFFFL)) << this.f_cAddCheckShift < 0L) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeJavaLong(lr));
    }

    @Override
    public int invokeSub(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long lr;
        long l2;
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        if (((l1 ^ 0xFFFFFFFFFFFFFFFFL) & (l2 = ((ObjectHandle.JavaLong)hArg).getValue()) | (l1 ^ 0xFFFFFFFFFFFFFFFFL | l2) & (lr = l1 - l2)) << this.f_cAddCheckShift < 0L) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeJavaLong(lr));
    }

    @Override
    public int invokeMul(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long a2;
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        long lr = l1 * l2;
        long a1 = Math.abs(l1);
        if ((a1 | (a2 = Math.abs(l2))) >>> this.f_cMulCheckShift != 0L && (l2 != 0L && lr / l2 != l1 || l1 == this.f_cMinValue && l2 == -1L || lr > this.f_cMaxValue || lr < this.f_cMinValue)) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeJavaLong(lr));
    }

    @Override
    public int invokeNeg(Frame frame, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(-l));
    }

    @Override
    public int invokePrev(Frame frame, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(l - 1L));
    }

    @Override
    public int invokeNext(Frame frame, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(l + 1L));
    }

    @Override
    public int convertLong(Frame frame, long lValue, int iReturn, boolean fCheck) {
        return frame.assignValue(iReturn, this.makeJavaLong(lValue));
    }

    @Override
    public ObjectHandle.JavaLong makeJavaLong(long lValue) {
        if (this.f_cNumBits < 64) {
            lValue &= this.f_lValueMask;
        }
        return super.makeJavaLong(lValue);
    }
}

