/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.BaseBinaryFP;
import org.xvm.runtime.template.numbers.BaseDecFP;
import org.xvm.runtime.template.numbers.BaseInt128;
import org.xvm.runtime.template.numbers.LongLong;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.numbers.xIntLiteral;
import org.xvm.runtime.template.numbers.xIntNumber;
import org.xvm.runtime.template.numbers.xUInt64;
import org.xvm.runtime.template.numbers.xUnconstrainedInteger;
import org.xvm.runtime.template.text.xChar;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xOrdered;
import org.xvm.util.PackedInteger;

public abstract class xConstrainedInteger
extends xIntNumber {
    protected final long f_cMinValue;
    protected final long f_cMaxValue;
    protected final int f_cNumBits;
    protected final int f_cAddCheckShift;
    protected final int f_cMulCheckShift;
    protected final long f_lValueMask;
    protected final boolean f_fChecked;
    protected final boolean f_fSigned;

    protected xConstrainedInteger(Container container, ClassStructure structure, long cMinValue, long cMaxValue, int cNumBits, boolean fUnsigned, boolean fChecked) {
        super(container, structure, false);
        this.f_cMinValue = cMinValue;
        this.f_cMaxValue = cMaxValue;
        this.f_cNumBits = cNumBits;
        this.f_fChecked = fChecked;
        this.f_fSigned = !fUnsigned;
        this.f_cAddCheckShift = 64 - cNumBits;
        this.f_cMulCheckShift = fUnsigned ? cNumBits / 2 : cNumBits / 2 - 1;
        this.f_lValueMask = -1L >>> 64 - cNumBits;
    }

    @Override
    public void initNative() {
        super.initNative();
        if (this.f_fSigned) {
            this.markNativeProperty("magnitude");
        }
        this.markNativeProperty("leadingZeroCount");
        this.markNativeMethod("rotateLeft", INT, THIS);
        this.markNativeMethod("rotateRight", INT, THIS);
        this.markNativeMethod("retainLSBits", INT, THIS);
        this.markNativeMethod("retainMSBits", INT, THIS);
        this.markNativeMethod("reverseBits", VOID, THIS);
        this.markNativeMethod("reverseBytes", VOID, THIS);
        this.markNativeMethod("stepsTo", THIS, INT);
        this.markNativeMethod("add", THIS, THIS);
        this.markNativeMethod("sub", THIS, THIS);
        this.markNativeMethod("mul", THIS, THIS);
        this.markNativeMethod("div", THIS, THIS);
        this.markNativeMethod("mod", THIS, THIS);
        this.markNativeMethod("neg", VOID, THIS);
        this.markNativeMethod("and", THIS, THIS);
        this.markNativeMethod("or", THIS, THIS);
        this.markNativeMethod("xor", THIS, THIS);
        this.markNativeMethod("not", VOID, THIS);
        this.markNativeMethod("shiftAllRight", INT, THIS);
        this.invalidateTypeInfo();
    }

    protected abstract xConstrainedInteger getComplimentaryTemplate();

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof IntConstant) {
            IntConstant constInt = (IntConstant)constant;
            return frame.pushStack(new ObjectHandle.JavaLong(this.getCanonicalClass(), constInt.getValue().getLong()));
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    protected int constructFromString(Frame frame, String sText, int iReturn) {
        int cBytes;
        PackedInteger pi;
        try {
            pi = xIntLiteral.parsePackedInteger(sText);
        }
        catch (NumberFormatException e) {
            return frame.raiseException(xException.illegalArgument(frame, "Invalid number \"" + sText + "\""));
        }
        if (!this.f_fSigned && pi.isNegative()) {
            return this.overflow(frame);
        }
        int n = cBytes = this.f_fSigned ? pi.getSignedByteSize() : pi.getUnsignedByteSize();
        if (cBytes * 8 > this.f_cNumBits) {
            return this.overflow(frame);
        }
        return this.convertLong(frame, pi.getLong(), iReturn, this.f_fChecked);
    }

    @Override
    protected int constructFromBytes(Frame frame, byte[] ab, int cBytes, int iReturn) {
        return cBytes == this.f_cNumBits / 8 ? this.convertLong(frame, xConstrainedInteger.fromByteArray(ab, cBytes, this.f_fSigned), iReturn, this.f_fChecked) : frame.raiseException(xException.illegalArgument(frame, "Invalid byte count: " + cBytes));
    }

    @Override
    protected int constructFromBits(Frame frame, byte[] ab, int cBits, int iReturn) {
        return cBits == this.f_cNumBits ? this.convertLong(frame, xConstrainedInteger.fromByteArray(ab, cBits >>> 3, this.f_fSigned), iReturn, this.f_fChecked) : frame.raiseException(xException.illegalArgument(frame, "Invalid bit count: " + cBits));
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        switch (sPropName) {
            case "magnitude": {
                assert (this.f_fSigned);
                long l = ((ObjectHandle.JavaLong)hTarget).getValue();
                hTarget = this.getComplimentaryTemplate().makeJavaLong(l < 0L ? -l : l);
                return frame.assignValue(iReturn, hTarget);
            }
            case "digitCount": {
                long l = ((ObjectHandle.JavaLong)hTarget).getValue();
                if (l < 0L) {
                    l = -l;
                }
                int cDigits = 19;
                if (l >= 0L) {
                    long n = 10L;
                    for (cDigits = 1; cDigits < 19 && l >= n; n *= 10L, ++cDigits) {
                    }
                }
                return frame.assignValue(iReturn, xInt64.makeHandle(cDigits));
            }
            case "bits": {
                long l = ((ObjectHandle.JavaLong)hTarget).getValue();
                return frame.assignValue(iReturn, xArray.makeBitArrayHandle(xConstrainedInteger.toByteArray(l, this.f_cNumBits >>> 3), this.f_cNumBits, xArray.Mutability.Constant));
            }
            case "bitCount": {
                long l = ((ObjectHandle.JavaLong)hTarget).getValue();
                return frame.assignValue(iReturn, xInt64.makeHandle(Long.bitCount(l)));
            }
            case "bitLength": {
                return frame.assignValue(iReturn, xInt64.makeHandle(this.f_cNumBits));
            }
            case "leftmostBit": {
                long l = ((ObjectHandle.JavaLong)hTarget).getValue();
                return frame.assignValue(iReturn, this.makeJavaLong(Long.highestOneBit(l)));
            }
            case "rightmostBit": {
                long l = ((ObjectHandle.JavaLong)hTarget).getValue();
                return frame.assignValue(iReturn, this.makeJavaLong(Long.lowestOneBit(l)));
            }
            case "leadingZeroCount": {
                long l = ((ObjectHandle.JavaLong)hTarget).getValue();
                return frame.assignValue(iReturn, xInt64.makeHandle(Long.numberOfLeadingZeros(l)));
            }
            case "trailingZeroCount": {
                long l = ((ObjectHandle.JavaLong)hTarget).getValue();
                return frame.assignValue(iReturn, xInt64.makeHandle(Long.numberOfTrailingZeros(l)));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "add": {
                return this.invokeAdd(frame, hTarget, hArg, iReturn);
            }
            case "sub": {
                return this.invokeSub(frame, hTarget, hArg, iReturn);
            }
            case "mul": {
                return this.invokeMul(frame, hTarget, hArg, iReturn);
            }
            case "div": {
                return this.invokeDiv(frame, hTarget, hArg, iReturn);
            }
            case "mod": {
                return this.invokeMod(frame, hTarget, hArg, iReturn);
            }
            case "and": {
                return this.invokeAnd(frame, hTarget, hArg, iReturn);
            }
            case "or": {
                return this.invokeOr(frame, hTarget, hArg, iReturn);
            }
            case "xor": {
                return this.invokeXor(frame, hTarget, hArg, iReturn);
            }
            case "not": {
                return this.invokeCompl(frame, hTarget, iReturn);
            }
            case "shiftLeft": {
                return this.invokeShl(frame, hTarget, hArg, iReturn);
            }
            case "shiftRight": {
                return this.invokeShr(frame, hTarget, hArg, iReturn);
            }
            case "shiftAllRight": {
                return this.invokeShrAll(frame, hTarget, hArg, iReturn);
            }
            case "rotateLeft": {
                return this.invokeRotateL(frame, hTarget, hArg, iReturn);
            }
            case "rotateRight": {
                return this.invokeRotateR(frame, hTarget, hArg, iReturn);
            }
            case "stepsTo": {
                return xInt64.INSTANCE.invokeSub(frame, hArg, hTarget, iReturn);
            }
            case "toInt8": 
            case "toInt16": 
            case "toInt32": 
            case "toInt64": 
            case "toInt128": 
            case "toIntN": 
            case "toUInt8": 
            case "toUInt16": 
            case "toUInt32": 
            case "toUInt64": 
            case "toUInt128": 
            case "toUIntN": 
            case "toFloat16": 
            case "toFloat32": 
            case "toFloat64": 
            case "toFloatN": 
            case "toDec32": 
            case "toDec64": 
            case "toDecN": 
            case "toChar": {
                boolean fCheckBounds;
                TypeConstant typeRet = method.getReturn(0).getType();
                ClassTemplate template = this.f_container.getTemplate(typeRet);
                if (template == this) {
                    return frame.assignValue(iReturn, hTarget);
                }
                long lValue = ((ObjectHandle.JavaLong)hTarget).getValue();
                boolean bl = fCheckBounds = hArg == xBoolean.TRUE;
                if (template instanceof xConstrainedInteger) {
                    xConstrainedInteger templateTo = (xConstrainedInteger)template;
                    if (fCheckBounds && lValue < 0L && (this instanceof xUInt64 || templateTo instanceof xUInt64)) {
                        return templateTo.overflow(frame);
                    }
                    return templateTo.convertLong(frame, lValue, iReturn, fCheckBounds);
                }
                if (template instanceof xUnconstrainedInteger) {
                    xUnconstrainedInteger templateTo = (xUnconstrainedInteger)template;
                    PackedInteger piValue = this instanceof xUInt64 ? new PackedInteger(LongLong.toUnsignedBigInteger(lValue)) : PackedInteger.valueOf(lValue);
                    return piValue.isNegative() && !templateTo.f_fSigned ? templateTo.overflow(frame) : frame.assignValue(iReturn, templateTo.makeInt(piValue));
                }
                if (template instanceof BaseBinaryFP) {
                    BaseBinaryFP templateTo = (BaseBinaryFP)template;
                    return templateTo.convertLong(frame, lValue, iReturn);
                }
                if (template instanceof BaseInt128) {
                    BaseInt128 templateTo = (BaseInt128)template;
                    if (fCheckBounds && this.f_fSigned && lValue < 0L && !templateTo.f_fSigned) {
                        return this.overflow(frame);
                    }
                    return templateTo.convertLong(frame, lValue, iReturn, this.f_fSigned);
                }
                if (template instanceof BaseDecFP) {
                    BaseDecFP templateTo = (BaseDecFP)template;
                    return templateTo.convertLong(frame, lValue, iReturn);
                }
                if (!(template instanceof xChar)) break;
                if (lValue < 0L || lValue > 0x10FFFFL) {
                    if (fCheckBounds) {
                        return this.overflow(frame);
                    }
                    lValue &= 0xFFFFFL;
                }
                return frame.assignValue(iReturn, xChar.makeHandle(lValue));
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "toInt8": 
            case "toInt16": 
            case "toInt32": 
            case "toInt64": 
            case "toInt128": 
            case "toIntN": 
            case "toUInt8": 
            case "toUInt16": 
            case "toUInt32": 
            case "toUInt64": 
            case "toUInt128": 
            case "toUIntN": 
            case "toFloat16": 
            case "toFloat32": 
            case "toFloat64": 
            case "toFloatN": 
            case "toDec32": 
            case "toDec64": 
            case "toDecN": 
            case "toChar": {
                return this.invokeNative1(frame, method, hTarget, xBoolean.FALSE, iReturn);
            }
            case "neg": {
                return this.invokeNeg(frame, hTarget, iReturn);
            }
            case "reverseBits": 
            case "reverseBytes": {
                throw new UnsupportedOperationException("subclass implementation required for " + method.getName());
            }
            case "truncate": {
                long lValue = ((ObjectHandle.JavaLong)hTarget).getValue();
                long cBits = ((ObjectHandle.JavaLong)ahArg[0]).getValue();
                if (cBits < 0L || cBits > (long)this.f_cNumBits) {
                    return frame.raiseException(xException.outOfBounds(frame, cBits, this.f_cNumBits));
                }
                if (cBits == 0L) {
                    lValue = 0L;
                } else if (cBits != (long)this.f_cNumBits) {
                    lValue &= -1L >>> (int)(64L - cBits);
                }
                return frame.assignValue(iReturn, this.makeJavaLong(lValue));
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeAdd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        long lr = l1 + l2;
        return frame.assignValue(iReturn, this.makeJavaLong(lr));
    }

    @Override
    public int invokeSub(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        long lr = l1 - l2;
        return frame.assignValue(iReturn, this.makeJavaLong(lr));
    }

    @Override
    public int invokeMul(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        long lr = l1 * l2;
        return frame.assignValue(iReturn, this.makeJavaLong(lr));
    }

    @Override
    public int invokeNeg(Frame frame, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(-l));
    }

    @Override
    public int invokePrev(Frame frame, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(l - 1L));
    }

    @Override
    public int invokeNext(Frame frame, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(l + 1L));
    }

    @Override
    public int invokeDiv(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        if (l2 == 0L) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeJavaLong(l1 / l2));
    }

    @Override
    public int invokeMod(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        if (l2 == 0L) {
            return this.overflow(frame);
        }
        long lMod = l1 % l2;
        if (this.f_fSigned && lMod != 0L && lMod < 0L != l2 < 0L) assert ((lMod += l2) < 0L == l2 < 0L);
        return frame.assignValue(iReturn, this.makeJavaLong(lMod));
    }

    @Override
    public int invokeShl(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(l1 << (int)l2));
    }

    @Override
    public int invokeShr(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(l1 >> (int)l2));
    }

    @Override
    public int invokeShrAll(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(l1 >>> (int)l2));
    }

    @Override
    public int invokeAnd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(l1 & l2));
    }

    @Override
    public int invokeOr(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(l1 | l2));
    }

    @Override
    public int invokeXor(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(l1 ^ l2));
    }

    @Override
    public int invokeDivRem(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int[] aiReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        return frame.assignValues(aiReturn, this.makeJavaLong(l1 / l2), this.makeJavaLong(l1 % l2));
    }

    @Override
    public int invokeCompl(Frame frame, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeJavaLong(l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public int callCompare(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        ObjectHandle.JavaLong h1 = (ObjectHandle.JavaLong)hValue1;
        ObjectHandle.JavaLong h2 = (ObjectHandle.JavaLong)hValue2;
        return frame.assignValue(iReturn, xOrdered.makeHandle(this.f_fSigned ? (long)Long.compare(h1.getValue(), h2.getValue()) : (long)Long.compareUnsigned(h1.getValue(), h2.getValue())));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        return ((ObjectHandle.JavaLong)hValue1).getValue() == ((ObjectHandle.JavaLong)hValue2).getValue();
    }

    @Override
    public int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        return frame.assignValue(iReturn, xInt64.makeHandle(l));
    }

    protected int invokeRotateL(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        int c = (int)(((ObjectHandle.JavaLong)hArg).getValue() % (long)this.f_cNumBits);
        long lHead = l << c;
        long lTail = l >>> this.f_cNumBits - c;
        return frame.assignValue(iReturn, this.makeJavaLong(lHead | lTail));
    }

    protected int invokeRotateR(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        int c = (int)(((ObjectHandle.JavaLong)hArg).getValue() % (long)this.f_cNumBits);
        long lHead = l << this.f_cNumBits - c;
        long lTail = l >>> c;
        return frame.assignValue(iReturn, this.makeJavaLong(lHead | lTail));
    }

    public int convertLong(Frame frame, PackedInteger piValue, boolean fChecked, int iReturn) {
        return piValue.isBig() ? this.overflow(frame) : this.convertLong(frame, piValue.getLong(), iReturn, fChecked);
    }

    public int convertLong(Frame frame, long lValue, int iReturn, boolean fCheck) {
        if (fCheck && this.f_cNumBits != 64 && (lValue < this.f_cMinValue || lValue > this.f_cMaxValue)) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeJavaLong(lValue));
    }

    public ObjectHandle.JavaLong makeJavaLong(long lValue) {
        if (this.f_cNumBits < 64 && (lValue &= this.f_lValueMask) > this.f_cMaxValue) {
            lValue -= this.f_lValueMask + 1L;
        }
        return new ObjectHandle.JavaLong(this.getCanonicalClass(), lValue);
    }

    public static byte[] toByteArray(long l, int cBytes) {
        byte[] byArray;
        switch (cBytes) {
            case 8: {
                byte[] byArray2 = new byte[8];
                byArray2[0] = (byte)(l >> 56);
                byArray2[1] = (byte)(l >> 48);
                byArray2[2] = (byte)(l >> 40);
                byArray2[3] = (byte)(l >> 32);
                byArray2[4] = (byte)(l >> 24);
                byArray2[5] = (byte)(l >> 16);
                byArray2[6] = (byte)(l >> 8);
                byArray = byArray2;
                byArray2[7] = (byte)l;
                break;
            }
            case 4: {
                byte[] byArray3 = new byte[4];
                byArray3[0] = (byte)(l >> 24);
                byArray3[1] = (byte)(l >> 16);
                byArray3[2] = (byte)(l >> 8);
                byArray = byArray3;
                byArray3[3] = (byte)l;
                break;
            }
            case 2: {
                byte[] byArray4 = new byte[2];
                byArray4[0] = (byte)(l >> 8);
                byArray = byArray4;
                byArray4[1] = (byte)l;
                break;
            }
            case 1: {
                byte[] byArray5 = new byte[1];
                byArray = byArray5;
                byArray5[0] = (byte)l;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return byArray;
    }

    public static void copyAsBytes(long l, byte[] ab, int of) {
        int i = 0;
        int cShift = 56;
        while (i < 8) {
            ab[of + i] = (byte)(l >> cShift);
            ++i;
            cShift -= 8;
        }
    }

    public static long fromByteArray(byte[] aBytes, int cBytes, boolean fSigned) {
        return xConstrainedInteger.fromByteArray(aBytes, 0, cBytes, fSigned);
    }

    public static long fromByteArray(byte[] aBytes, int of, int cBytes, boolean fSigned) {
        long l = fSigned & aBytes[cBytes - 1] < 0 ? -1L : 0L;
        for (int i = of; i < cBytes; ++i) {
            l = l << 8 | (long)(aBytes[i] & 0xFF);
        }
        return l;
    }

    public static long divUnsigned(long l1, long l2) {
        if (l2 < 0L) {
            return l1 < 0L && l1 < l2 ? 1L : 0L;
        }
        if (l1 < 0L) {
            if (l2 == 1L) {
                return l1;
            }
            long l1L = l1 & Long.MAX_VALUE;
            return l1L / l2 - Long.MIN_VALUE / l2 + (l1L % l2 - Long.MIN_VALUE % l2) / l2;
        }
        return l1 / l2;
    }

    public static long modUnsigned(long l1, long l2) {
        if (l2 < 0L) {
            return l1 < 0L && l1 < l2 ? l1 - l2 : l1;
        }
        if (l1 < 0L) {
            if (l2 == 1L) {
                return 0L;
            }
            long l1L = l1 & Long.MAX_VALUE;
            return (l1L % l2 - Long.MIN_VALUE % l2) % l2;
        }
        return l1 % l2;
    }
}

