/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import java.math.BigDecimal;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.numbers.BaseBinaryFP;
import org.xvm.runtime.template.numbers.xDec32;
import org.xvm.runtime.template.numbers.xDec64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xException;
import org.xvm.type.Decimal32;
import org.xvm.type.Decimal64;

public class xFPLiteral
extends xConst {
    public static xFPLiteral INSTANCE;

    public xFPLiteral(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("construct", STRING, VOID);
        this.markNativeMethod("toString", VOID, STRING);
        this.markNativeMethod("toFloat16", null, new String[]{"numbers.Float16"});
        this.markNativeMethod("toFloat32", null, new String[]{"numbers.Float32"});
        this.markNativeMethod("toFloat64", null, new String[]{"numbers.Float64"});
        this.markNativeMethod("toFloat128", null, new String[]{"numbers.Float128"});
        this.markNativeMethod("toFloatN", null, new String[]{"numbers.FloatN"});
        this.markNativeMethod("toDec32", null, new String[]{"numbers.Dec32"});
        this.markNativeMethod("toDec64", null, new String[]{"numbers.Dec64"});
        this.markNativeMethod("toDec128", null, new String[]{"numbers.Dec128"});
        this.markNativeMethod("toDecN", null, new String[]{"numbers.DecN"});
        this.invalidateTypeInfo();
    }

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        LiteralConstant constVal = (LiteralConstant)constant;
        xString.StringHandle hText = (xString.StringHandle)frame.getConstHandle(constVal.getStringConstant());
        FPNHandle hFPLiteral = this.makeFPLiteral(constVal.getBigDecimal(), hText);
        return frame.pushStack(hFPLiteral);
    }

    @Override
    public int construct(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahVar, int iReturn) {
        xString.StringHandle hText = (xString.StringHandle)ahVar[0];
        try {
            return frame.assignValue(iReturn, this.makeFPLiteral(new BigDecimal(hText.getStringValue()), hText));
        }
        catch (NumberFormatException e) {
            return frame.raiseException(xException.illegalArgument(frame, "Invalid number \"" + hText.getStringValue() + "\""));
        }
    }

    @Override
    public int getFieldValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        switch (idProp.getName()) {
            case "text": {
                return frame.assignValue(iReturn, ((FPNHandle)hTarget).getText());
            }
        }
        return frame.raiseException("not supported field: " + idProp.getName());
    }

    @Override
    public int invokeAdd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        BigDecimal dec1 = ((FPNHandle)hTarget).getValue();
        BigDecimal dec2 = ((FPNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeFPLiteral(dec1.add(dec2)));
    }

    @Override
    public int invokeSub(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        BigDecimal dec1 = ((FPNHandle)hTarget).getValue();
        BigDecimal dec2 = ((FPNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeFPLiteral(dec1.subtract(dec2)));
    }

    @Override
    public int invokeMul(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        BigDecimal dec1 = ((FPNHandle)hTarget).getValue();
        BigDecimal dec2 = ((FPNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeFPLiteral(dec1.multiply(dec2)));
    }

    @Override
    public int invokeDiv(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        BigDecimal dec1 = ((FPNHandle)hTarget).getValue();
        BigDecimal dec2 = ((FPNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeFPLiteral(dec1.divide(dec2)));
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        FPNHandle hLiteral = (FPNHandle)hTarget;
        switch (method.getName()) {
            case "toFloat16": 
            case "toFloat32": 
            case "toFloat64": {
                TypeConstant typeRet = method.getReturn(0).getType();
                BaseBinaryFP template = (BaseBinaryFP)this.f_container.getTemplate(typeRet);
                return frame.assignValue(iReturn, template.makeHandle(hLiteral.getValue().doubleValue()));
            }
            case "toDec32": {
                return frame.assignValue(iReturn, xDec32.INSTANCE.makeHandle(new Decimal32(hLiteral.getValue())));
            }
            case "toDec64": {
                return frame.assignValue(iReturn, xDec64.INSTANCE.makeHandle(new Decimal64(hLiteral.getValue())));
            }
            case "toFloat128": 
            case "toFloatN": 
            case "toDecN": 
            case "toDec128": {
                throw new UnsupportedOperationException();
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    protected FPNHandle makeFPLiteral(BigDecimal decValue) {
        return new FPNHandle(this.getCanonicalClass(), decValue, null);
    }

    protected FPNHandle makeFPLiteral(BigDecimal decValue, xString.StringHandle hText) {
        return new FPNHandle(this.getCanonicalClass(), decValue, hText);
    }

    @Override
    protected int buildStringValue(Frame frame, ObjectHandle hTarget, int iReturn) {
        FPNHandle hLiteral = (FPNHandle)hTarget;
        return frame.assignValue(iReturn, hLiteral.getText());
    }

    public static class FPNHandle
    extends ObjectHandle {
        protected BigDecimal m_decValue;
        protected xString.StringHandle m_hText;

        public FPNHandle(TypeComposition clazz, BigDecimal decValue, xString.StringHandle hText) {
            super(clazz);
            assert (decValue != null);
            this.m_decValue = decValue;
            this.m_hText = hText;
        }

        public xString.StringHandle getText() {
            xString.StringHandle hText = this.m_hText;
            if (hText == null) {
                this.m_hText = hText = xString.makeHandle(this.m_decValue.toString());
            }
            return hText;
        }

        public BigDecimal getValue() {
            return this.m_decValue;
        }

        @Override
        public int hashCode() {
            return this.m_decValue.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FPNHandle)) return false;
            FPNHandle that = (FPNHandle)obj;
            if (!this.m_decValue.equals(that.m_decValue)) return false;
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + this.m_decValue.toString();
        }
    }
}

