/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import org.xvm.asm.ClassStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.numbers.BaseInt128;
import org.xvm.runtime.template.numbers.LongLong;
import org.xvm.runtime.template.numbers.xConstrainedInteger;
import org.xvm.runtime.template.numbers.xUInt128;
import org.xvm.runtime.template.numbers.xUInt64;

public class xInt128
extends BaseInt128 {
    public static xInt128 INSTANCE;

    public xInt128(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, true);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeProperty("magnitude");
        this.markNativeMethod("abs", VOID, THIS);
        super.initNative();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        switch (sPropName) {
            case "magnitude": {
                LongLong ll = ((BaseInt128.LongLongHandle)hTarget).getValue();
                if (ll.signum() < 0) {
                    ll = ll.complement().addUnsigned(LongLong.ONE);
                }
                return frame.assignValue(iReturn, xUInt128.INSTANCE.makeHandle(ll));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    protected int convertToConstrainedType(Frame frame, xConstrainedInteger template, LongLong ll, boolean fCheckBounds, int iReturn) {
        long lHigh = ll.getHighValue();
        long lLow = ll.getLowValue();
        if (fCheckBounds) {
            boolean fNeg;
            if (lHigh < -1L || lHigh > 0L || !(template instanceof xUInt64) && lHigh < 0L != lLow < 0L) {
                return this.overflow(frame);
            }
            boolean bl = fNeg = lHigh == -1L;
            if (!template.f_fSigned && fNeg) {
                return this.overflow(frame);
            }
            if (template.f_cNumBits < 64 && (lLow < template.f_cMinValue || lLow > template.f_cMaxValue)) {
                return this.overflow(frame);
            }
        }
        return frame.assignValue(iReturn, template.makeJavaLong(lLow));
    }
}

