/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import java.math.BigInteger;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ErrorList;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Lexer;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.numbers.BaseInt128;
import org.xvm.runtime.template.numbers.LongLong;
import org.xvm.runtime.template.numbers.xConstrainedInteger;
import org.xvm.runtime.template.numbers.xUnconstrainedInteger;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xOrdered;
import org.xvm.util.PackedInteger;

public class xIntLiteral
extends xConst {
    public static xIntLiteral INSTANCE;

    public xIntLiteral(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("construct", STRING, VOID);
        this.markNativeMethod("and", THIS, THIS);
        this.markNativeMethod("or", THIS, THIS);
        this.markNativeMethod("xor", THIS, THIS);
        this.markNativeMethod("shiftLeft", INT, THIS);
        this.markNativeMethod("shiftRight", INT, THIS);
        this.markNativeMethod("shiftAllRight", INT, THIS);
        this.markNativeMethod("add", THIS, THIS);
        this.markNativeMethod("sub", THIS, THIS);
        this.markNativeMethod("mul", THIS, THIS);
        this.markNativeMethod("div", THIS, THIS);
        this.markNativeMethod("mod", THIS, THIS);
        this.markNativeMethod("not", VOID, THIS);
        this.markNativeMethod("toString", VOID, STRING);
        this.markNativeMethod("toInt8", null, new String[]{"numbers.Int8"});
        this.markNativeMethod("toInt16", null, new String[]{"numbers.Int16"});
        this.markNativeMethod("toInt32", null, new String[]{"numbers.Int32"});
        this.markNativeMethod("toInt64", null, new String[]{"numbers.Int64"});
        this.markNativeMethod("toInt128", null, new String[]{"numbers.Int128"});
        this.markNativeMethod("toUInt8", null, new String[]{"numbers.UInt8"});
        this.markNativeMethod("toUInt16", null, new String[]{"numbers.UInt16"});
        this.markNativeMethod("toUInt32", null, new String[]{"numbers.UInt32"});
        this.markNativeMethod("toUInt64", null, new String[]{"numbers.UInt64"});
        this.markNativeMethod("toUInt128", null, new String[]{"numbers.UInt128"});
        this.markNativeMethod("toIntN", null, new String[]{"numbers.IntN"});
        this.markNativeMethod("toUIntN", null, new String[]{"numbers.UIntN"});
        this.markNativeMethod("toFloatN", null, new String[]{"numbers.FloatN"});
        this.markNativeMethod("toDecN", null, new String[]{"numbers.DecN"});
        this.invalidateTypeInfo();
    }

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        LiteralConstant constVal = (LiteralConstant)constant;
        xString.StringHandle hText = (xString.StringHandle)frame.getConstHandle(constVal.getStringConstant());
        IntNHandle hIntLiteral = this.makeIntLiteral(constVal.getPackedInteger(), hText);
        return frame.pushStack(hIntLiteral);
    }

    @Override
    public int construct(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahVar, int iReturn) {
        PackedInteger pi;
        xString.StringHandle hText = (xString.StringHandle)ahVar[0];
        String sText = hText.getStringValue();
        try {
            pi = xIntLiteral.parsePackedInteger(sText);
        }
        catch (NumberFormatException e) {
            return frame.raiseException(xException.illegalArgument(frame, "Invalid number \"" + sText + "\""));
        }
        return frame.assignValue(iReturn, this.makeIntLiteral(pi, hText));
    }

    @Override
    public int getFieldValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        switch (idProp.getName()) {
            case "text": {
                return frame.assignValue(iReturn, ((IntNHandle)hTarget).getText());
            }
        }
        return frame.raiseException("not supported field: " + idProp.getName());
    }

    @Override
    public int invokeAdd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        PackedInteger pi1 = ((IntNHandle)hTarget).getValue();
        PackedInteger pi2 = ((IntNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeIntLiteral(pi1.add(pi2)));
    }

    @Override
    public int invokeSub(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        PackedInteger pi1 = ((IntNHandle)hTarget).getValue();
        PackedInteger pi2 = ((IntNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeIntLiteral(pi1.sub(pi2)));
    }

    @Override
    public int invokeMul(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        PackedInteger pi1 = ((IntNHandle)hTarget).getValue();
        PackedInteger pi2 = ((IntNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeIntLiteral(pi1.mul(pi2)));
    }

    @Override
    public int invokeDiv(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        PackedInteger pi1 = ((IntNHandle)hTarget).getValue();
        PackedInteger pi2 = ((IntNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeIntLiteral(pi1.div(pi2)));
    }

    @Override
    public int invokeMod(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        PackedInteger pi1 = ((IntNHandle)hTarget).getValue();
        PackedInteger pi2 = ((IntNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeIntLiteral(pi1.mod(pi2)));
    }

    @Override
    public int invokeShl(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        PackedInteger pi = ((IntNHandle)hTarget).getValue();
        long count = ((ObjectHandle.JavaLong)hArg).getValue();
        if (count > Integer.MAX_VALUE) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeIntLiteral(pi.shl((int)count)));
    }

    @Override
    public int invokeShr(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        PackedInteger pi = ((IntNHandle)hTarget).getValue();
        long count = ((ObjectHandle.JavaLong)hArg).getValue();
        if (count > Integer.MAX_VALUE) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeIntLiteral(pi.shr((int)count)));
    }

    @Override
    public int invokeShrAll(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        PackedInteger pi = ((IntNHandle)hTarget).getValue();
        long count = ((ObjectHandle.JavaLong)hArg).getValue();
        if (count > Integer.MAX_VALUE) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeIntLiteral(pi.ushr((int)count)));
    }

    @Override
    public int invokeAnd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        PackedInteger pi1 = ((IntNHandle)hTarget).getValue();
        PackedInteger pi2 = ((IntNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeIntLiteral(pi1.and(pi2)));
    }

    @Override
    public int invokeOr(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        PackedInteger pi1 = ((IntNHandle)hTarget).getValue();
        PackedInteger pi2 = ((IntNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeIntLiteral(pi1.or(pi2)));
    }

    @Override
    public int invokeXor(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        PackedInteger pi1 = ((IntNHandle)hTarget).getValue();
        PackedInteger pi2 = ((IntNHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeIntLiteral(pi1.xor(pi2)));
    }

    @Override
    public int invokeNeg(Frame frame, ObjectHandle hTarget, int iReturn) {
        PackedInteger pi = ((IntNHandle)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeIntLiteral(pi.negate()));
    }

    @Override
    public int invokeCompl(Frame frame, ObjectHandle hTarget, int iReturn) {
        PackedInteger pi = ((IntNHandle)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeIntLiteral(pi.complement()));
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "and": {
                return this.invokeAnd(frame, hTarget, hArg, iReturn);
            }
            case "or": {
                return this.invokeOr(frame, hTarget, hArg, iReturn);
            }
            case "xor": {
                return this.invokeXor(frame, hTarget, hArg, iReturn);
            }
            case "shiftLeft": {
                return this.invokeShl(frame, hTarget, hArg, iReturn);
            }
            case "shiftRight": {
                return this.invokeShr(frame, hTarget, hArg, iReturn);
            }
            case "shiftAllRight": {
                return this.invokeShrAll(frame, hTarget, hArg, iReturn);
            }
            case "add": {
                return this.invokeAdd(frame, hTarget, hArg, iReturn);
            }
            case "sub": {
                return this.invokeSub(frame, hTarget, hArg, iReturn);
            }
            case "mul": {
                return this.invokeMul(frame, hTarget, hArg, iReturn);
            }
            case "div": {
                return this.invokeDiv(frame, hTarget, hArg, iReturn);
            }
            case "mod": {
                return this.invokeMod(frame, hTarget, hArg, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "toInt8": 
            case "toInt16": 
            case "toInt32": 
            case "toInt64": 
            case "toInt128": 
            case "toUInt8": 
            case "toUInt16": 
            case "toUInt32": 
            case "toUInt64": 
            case "toUInt128": 
            case "toIntN": 
            case "toUIntN": 
            case "toFloatN": 
            case "toDecN": {
                TypeConstant typeRet = method.getReturn(0).getType();
                ClassTemplate template = this.f_container.getTemplate(typeRet);
                IntNHandle hLiteral = (IntNHandle)hTarget;
                PackedInteger piValue = hLiteral.getValue();
                if (template instanceof xConstrainedInteger) {
                    xConstrainedInteger templateTo = (xConstrainedInteger)template;
                    return templateTo.convertLong(frame, piValue, true, iReturn);
                }
                if (template instanceof BaseInt128) {
                    BaseInt128 templateTo = (BaseInt128)template;
                    BigInteger biValue = piValue.getBigInteger();
                    if (biValue.bitLength() > 128) {
                        return templateTo.overflow(frame);
                    }
                    LongLong llValue = LongLong.fromBigInteger(biValue);
                    return !templateTo.f_fSigned && llValue.signum() < 0 ? templateTo.overflow(frame) : frame.assignValue(iReturn, templateTo.makeHandle(llValue));
                }
                if (!(template instanceof xUnconstrainedInteger)) break;
                xUnconstrainedInteger templateTo = (xUnconstrainedInteger)template;
                return piValue.isNegative() && !templateTo.f_fSigned ? templateTo.overflow(frame) : frame.assignValue(iReturn, templateTo.makeInt(piValue));
            }
            case "not": {
                return this.invokeCompl(frame, hTarget, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    protected IntNHandle makeIntLiteral(PackedInteger piValue) {
        return new IntNHandle(this.getCanonicalClass(), piValue, null);
    }

    protected IntNHandle makeIntLiteral(PackedInteger piValue, xString.StringHandle hText) {
        return new IntNHandle(this.getCanonicalClass(), piValue, hText);
    }

    @Override
    protected int buildStringValue(Frame frame, ObjectHandle hTarget, int iReturn) {
        IntNHandle hLiteral = (IntNHandle)hTarget;
        return frame.assignValue(iReturn, hLiteral.getText());
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        IntNHandle h1 = (IntNHandle)hValue1;
        IntNHandle h2 = (IntNHandle)hValue2;
        return frame.assignValue(iReturn, xBoolean.makeHandle(h1.getValue().equals(h2.getValue())));
    }

    @Override
    public int callCompare(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        IntNHandle h1 = (IntNHandle)hValue1;
        IntNHandle h2 = (IntNHandle)hValue2;
        return frame.assignValue(iReturn, xOrdered.makeHandle(h1.getValue().cmp(h2.getValue())));
    }

    public static BigInteger parseBigInteger(String sText) {
        try {
            return new BigInteger(sText, 10);
        }
        catch (NumberFormatException e) {
            ErrorList errs = new ErrorList(5);
            Lexer lexer = new Lexer(new Source(sText), errs);
            if (!lexer.hasNext()) {
                throw e;
            }
            Token tokLit = lexer.next();
            if (errs.hasSeriousErrors() || tokLit.getId() != Token.Id.LIT_INT) {
                throw e;
            }
            return ((PackedInteger)tokLit.getValue()).getBigInteger();
        }
    }

    public static PackedInteger parsePackedInteger(String sText) {
        try {
            return new PackedInteger(Long.parseLong(sText));
        }
        catch (NumberFormatException e) {
            if (sText.isEmpty()) {
                throw e;
            }
            boolean fNeg = false;
            ErrorList errs = new ErrorList(5);
            Lexer lexer = new Lexer(new Source(sText), errs);
            Token tokLit = lexer.next();
            if (tokLit.getId() == Token.Id.SUB) {
                fNeg = true;
                tokLit = lexer.next();
            }
            if (errs.hasSeriousErrors() || tokLit.getId() != Token.Id.LIT_INT) {
                throw e;
            }
            PackedInteger pi = (PackedInteger)tokLit.getValue();
            return fNeg ? pi.negate() : pi;
        }
    }

    public static class IntNHandle
    extends ObjectHandle {
        protected PackedInteger m_piValue;
        protected xString.StringHandle m_hText;

        public IntNHandle(TypeComposition clazz, PackedInteger piValue, xString.StringHandle hText) {
            super(clazz);
            assert (piValue != null);
            this.m_piValue = piValue;
        }

        public xString.StringHandle getText() {
            xString.StringHandle hText = this.m_hText;
            if (hText == null) {
                this.m_hText = hText = xString.makeHandle(this.m_piValue.toString());
            }
            return hText;
        }

        public PackedInteger getValue() {
            return this.m_piValue;
        }

        @Override
        public int hashCode() {
            return this.m_piValue.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof IntNHandle)) return false;
            IntNHandle that = (IntNHandle)obj;
            if (!this.m_piValue.equals(that.m_piValue)) return false;
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + this.m_piValue.toString();
        }
    }
}

