/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xBitArray;
import org.xvm.runtime.template.collections.xByteArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xException;

public abstract class xNumber
extends xConst {
    public xNumber(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
    }

    @Override
    public void initNative() {
        String[] NAMES;
        for (String sName : NAMES = new String[]{"Int8", "Int16", "Int32", "Int64", "Int128", "IntN", "UInt8", "UInt16", "UInt32", "UInt64", "UInt128", "UIntN", "Float16", "Float32", "Float64", "FloatN", "Dec32", "Dec64", "Dec128", "DecN"}) {
            String sNameQ = "numbers." + sName;
            if (sNameQ.equals(this.f_sName)) continue;
            this.markNativeMethod("to" + sName, null, new String[]{sNameQ});
        }
        this.markNativeProperty("bits");
        ClassStructure structure = this.getStructure();
        structure.findMethodDeep("equals", m -> m.getParamCount() == 3).markNative();
        structure.findMethodDeep("compare", m -> m.getParamCount() == 3).markNative();
        structure.findMethodDeep("hashCode", m -> m.getParamCount() == 2).markNative();
    }

    @Override
    public int construct(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahVar, int iReturn) {
        SignatureConstant sig = constructor.getIdentityConstant().getSignature();
        if (sig.getParamCount() == 1) {
            TypeConstant typeParam = sig.getRawParams()[0];
            if (typeParam.equals(this.pool().typeString())) {
                xString.StringHandle hText = (xString.StringHandle)ahVar[0];
                return this.constructFromString(frame, hText.getStringValue(), iReturn);
            }
            TypeConstant typeElement = typeParam.getParamType(0);
            if (typeElement.equals(this.pool().typeByte())) {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)ahVar[0];
                byte[] abVal = xByteArray.getBytes(hArray);
                int cBytes = (int)hArray.m_hDelegate.m_cSize;
                return this.constructFromBytes(frame, abVal, cBytes, iReturn);
            }
            if (typeElement.equals(this.pool().typeBit())) {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)ahVar[0];
                byte[] abBits = xBitArray.getBits(hArray);
                int cBits = (int)hArray.m_hDelegate.m_cSize;
                return this.constructFromBits(frame, abBits, cBits, iReturn);
            }
        }
        return frame.raiseException(xException.unsupported(frame));
    }

    protected abstract int constructFromString(Frame var1, String var2, int var3);

    protected abstract int constructFromBytes(Frame var1, byte[] var2, int var3, int var4);

    protected abstract int constructFromBits(Frame var1, byte[] var2, int var3, int var4);

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(this.compareIdentity(hValue1, hValue2)));
    }

    @Override
    public abstract boolean compareIdentity(ObjectHandle var1, ObjectHandle var2);
}

