/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import java.math.BigInteger;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.constants.IntConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.numbers.xConstrainedInteger;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.numbers.xUnsignedConstrainedInt;
import org.xvm.util.PackedInteger;

public class xUInt64
extends xUnsignedConstrainedInt {
    public static xUInt64 INSTANCE;

    public xUInt64(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, 0L, -1L, 64, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    protected xConstrainedInteger getComplimentaryTemplate() {
        return xInt64.INSTANCE;
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof IntConstant) {
            IntConstant constInt = (IntConstant)constant;
            PackedInteger piValue = constInt.getValue();
            long lValue = piValue.isBig() ? piValue.getBigInteger().longValue() : piValue.getLong();
            return frame.pushStack(this.makeJavaLong(lValue));
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int invokeDiv(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        if (l2 == 0L) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeJavaLong(xUInt64.divUnsigned(l1, l2)));
    }

    @Override
    public int invokeMod(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        if (l2 == 0L) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeJavaLong(xUInt64.modUnsigned(l1, l2)));
    }

    @Override
    public int convertLong(Frame frame, PackedInteger piValue, boolean fChecked, int iReturn) {
        if (piValue.isBig()) {
            BigInteger bi = piValue.getBigInteger();
            if (bi.signum() > 0 && bi.bitLength() <= 64 || !fChecked) {
                return frame.assignValue(iReturn, this.makeJavaLong(bi.longValue()));
            }
            return this.overflow(frame);
        }
        if (fChecked && piValue.isNegative()) {
            return this.overflow(frame);
        }
        return super.convertLong(frame, piValue, fChecked, iReturn);
    }
}

