/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.reflect;

import java.util.Iterator;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.DecoratedClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTComponentTemplate;
import org.xvm.runtime.template._native.reflect.xRTPropertyClassTemplate;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.reflect.xEnumValue;
import org.xvm.runtime.template.reflect.xEnumeration;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xOrdered;

public class xClass
extends xConst {
    public static xClass INSTANCE;
    private static TypeConstant CLASS_ARRAY_TYPE;

    public xClass(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.f_container.getConstantPool();
        CLASS_ARRAY_TYPE = pool.ensureArrayType(pool.typeClass());
        this.markNativeProperty("abstract");
        this.markNativeProperty("canonicalParams");
        this.markNativeProperty("composition");
        this.markNativeProperty("virtualChild");
        this.markNativeMethod("allocate", null, null);
        this.markNativeMethod("isSingleton", null, null);
        this.markNativeMethod("defaultValue", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeComposition ensureClass(Container container, TypeConstant typeActual) {
        return typeActual.equals(this.getCanonicalType()) ? this.getCanonicalClass() : (this.isCanonicalStructure(typeActual) ? this.getCanonicalClass(container).ensureCanonicalizedComposition(typeActual) : super.ensureClass(container, typeActual));
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof ClassConstant || constant instanceof DecoratedClassConstant) {
            IdentityConstant idClz = (IdentityConstant)constant;
            TypeConstant typeClz = idClz.getValueType(frame.poolContext(), null);
            typeClz = typeClz.resolveGenerics(frame.poolContext(), frame.getGenericsResolver(typeClz.containsDynamicType()));
            xClass template = switch (idClz.getComponent().getFormat()) {
                case Component.Format.ENUMVALUE -> xEnumValue.INSTANCE;
                case Component.Format.ENUM -> xEnumeration.INSTANCE;
                default -> this;
            };
            TypeComposition clz = ((ClassTemplate)template).ensureClass(frame.f_context.f_container, typeClz);
            return template.construct(frame, null, clz, null, Utils.OBJECTS_NONE, -1);
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public ObjectHandle createStruct(Frame frame, TypeComposition clazz) {
        return new ClassHandle(clazz.ensureAccess(Constants.Access.STRUCT));
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        switch (sPropName) {
            case "abstract": {
                return this.getPropertyAbstract(frame, hTarget, iReturn);
            }
            case "canonicalParams": {
                return this.invokePropertyCanonicalParams(frame, (ClassHandle)hTarget, iReturn);
            }
            case "composition": {
                return this.getPropertyComposition(frame, hTarget, iReturn);
            }
            case "virtualChild": {
                return this.getPropertyVirtualChild(frame, hTarget, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "allocate": {
                return this.invokeAllocate(frame, hTarget, ahArg[0], aiReturn);
            }
            case "isSingleton": {
                return this.invokeIsSingleton(frame, hTarget, aiReturn);
            }
            case "defaultValue": {
                return this.invokeDefaultValue(frame, hTarget, aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    protected int callEqualsImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(xClass.getClassType(hValue1).equals(xClass.getClassType(hValue2))));
    }

    @Override
    protected int callCompareImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xOrdered.makeHandle(xClass.getClassType(hValue1).compareTo(xClass.getClassType(hValue2))));
    }

    @Override
    protected int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        return frame.assignValue(iReturn, xInt64.makeHandle(xClass.getClassType(hTarget).hashCode()));
    }

    public int getPropertyAbstract(Frame frame, ObjectHandle hTarget, int iReturn) {
        TypeConstant typeTarget = xClass.getClassType(hTarget);
        xBoolean.BooleanHandle hResult = xBoolean.makeHandle(typeTarget.ensureTypeInfo().isAbstract());
        return frame.assignValue(iReturn, hResult);
    }

    public int getPropertyComposition(Frame frame, ObjectHandle hTarget, int iReturn) {
        Constant constant;
        TypeConstant typeTarget = xClass.getClassType(hTarget);
        if (typeTarget.isSingleDefiningConstant() && (constant = typeTarget.getDefiningConstant()) instanceof IdentityConstant) {
            xRTComponentTemplate.ComponentTemplateHandle componentTemplateHandle;
            IdentityConstant id = (IdentityConstant)constant;
            Component component = id.getComponent();
            if (component instanceof PropertyStructure) {
                PropertyStructure prop = (PropertyStructure)component;
                componentTemplateHandle = xRTPropertyClassTemplate.makeHandle(prop);
            } else {
                componentTemplateHandle = xRTComponentTemplate.makeComponentHandle(frame.f_context.f_container, component);
            }
            return frame.assignValue(iReturn, componentTemplateHandle);
        }
        return frame.assignValue(iReturn, xRTComponentTemplate.makeComponentHandle(frame.f_context.f_container, this.pool().clzObject().getComponent()));
    }

    public int getPropertyVirtualChild(Frame frame, ObjectHandle hTarget, int iReturn) {
        TypeConstant typeTarget = xClass.getClassType(hTarget);
        xBoolean.BooleanHandle hResult = xBoolean.makeHandle(typeTarget.isVirtualChild());
        return frame.assignValue(iReturn, hResult);
    }

    public int invokeAllocate(Frame frame, ObjectHandle hTarget, ObjectHandle hParent, int[] aiReturn) {
        ServiceContext contextAlloc;
        TypeConstant typePublic = xClass.getClassType(hTarget);
        if (typePublic.ensureTypeInfo().isSingleton()) {
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        typePublic = typePublic.removeImmutable().removeAccess();
        Container container = frame.f_context.f_container;
        ClassTemplate template = container.getTemplate(typePublic);
        TypeComposition clzPublic = typePublic.ensureClass(frame);
        if (hParent == ObjectHandle.DEFAULT || hParent == xNullable.NULL) {
            if (typePublic.isVirtualChild()) {
                return frame.raiseException(xException.illegalArgument(frame, "Parent instance required"));
            }
            hParent = null;
        }
        switch (template.getStructure().getFormat()) {
            case SERVICE: {
                contextAlloc = container.createServiceContext(template.f_sName);
                break;
            }
            case CLASS: 
            case CONST: {
                if (hParent == null || !hParent.isService()) {
                    return xClass.completeStructAllocation(frame, template.createStruct(frame, clzPublic), hParent, aiReturn);
                }
                contextAlloc = hParent.getService().f_context;
                break;
            }
            default: {
                return frame.assignValue(aiReturn[0], xBoolean.FALSE);
            }
        }
        if (hParent != null && !hParent.isPassThrough()) {
            return frame.raiseException(xException.mutableObject(frame, hParent.getType()));
        }
        switch (contextAlloc.sendAllocateRequest(frame, clzPublic, hParent, -1)) {
            case -1: {
                return frame.assignValues(aiReturn, xBoolean.TRUE, frame.popStack());
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValues(aiReturn, xBoolean.TRUE, frameCaller.popStack()));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    public static int completeStructAllocation(Frame frame, ObjectHandle hStruct, ObjectHandle hParent, int[] aiReturn) {
        TypeComposition clzPublic = hStruct.getComposition().ensureAccess(Constants.Access.PUBLIC);
        MethodStructure methodAI = clzPublic.ensureAutoInitializer();
        if (methodAI != null) {
            switch (frame.call1(methodAI, hStruct, Utils.OBJECTS_NONE, -2)) {
                case -1: {
                    break;
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValues(aiReturn, xBoolean.TRUE, hStruct));
                    return -5;
                }
                case -3: {
                    return -3;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (hParent != null) {
            ((ObjectHandle.GenericHandle)hStruct).setField(frame, "$outer", hParent);
        }
        return frame.assignValues(aiReturn, xBoolean.TRUE, hStruct);
    }

    public int invokePropertyCanonicalParams(Frame frame, ClassHandle hClass, int iReturn) {
        ObjectHandle hMap = hClass.getField(frame, "canonicalParams");
        if (hMap == null) {
            int iResult;
            TypeConstant typeClz = xClass.getClassType(hClass);
            boolean fTuple = typeClz.isTuple();
            ClassStructure clz = null;
            int cParams = 0;
            if (typeClz.isSingleUnderlyingClass(true)) {
                clz = (ClassStructure)typeClz.getSingleUnderlyingClass(true).getComponent();
                cParams = fTuple ? typeClz.getParamsCount() : clz.getTypeParamCount();
            }
            Container container = frame.f_context.f_container;
            TypeComposition clzMap = container.resolveClass(xRTType.ensureListMapType(container));
            ConstantPool pool = frame.poolContext();
            if (cParams == 0) {
                iResult = Utils.constructListMap(frame, clzMap, xString.ensureEmptyArray(), xRTType.ensureEmptyTypeArray(container), -1);
            } else {
                xString.StringHandle[] ahNames = new xString.StringHandle[cParams];
                ObjectHandle[] ahTypes = new xRTType.TypeHandle[cParams];
                if (fTuple) {
                    TypeConstant[] atypeParam = typeClz.getParamTypesArray();
                    for (int i = 0; i < cParams; ++i) {
                        ahNames[i] = xString.makeHandle("ElementTypes[" + i + "]");
                        ahTypes[i] = atypeParam[i].ensureTypeHandle(container);
                    }
                } else {
                    Iterator iterNames = clz.getTypeParams().keySet().iterator();
                    TypeConstant[] atypeParam = clz.normalizeParameters(pool, typeClz.getParamTypesArray());
                    for (int i = 0; i < cParams; ++i) {
                        ahNames[i] = xString.makeHandle(((StringConstant)iterNames.next()).getValue());
                        ahTypes[i] = atypeParam[i].ensureTypeHandle(container);
                    }
                }
                iResult = Utils.constructListMap(frame, clzMap, xArray.makeStringArrayHandle(ahNames), xArray.createImmutableArray(xRTType.ensureTypeArrayComposition(container), ahTypes), -1);
            }
            switch (iResult) {
                case -1: {
                    hMap = frame.popStack();
                    hClass.setField(frame, "canonicalParams", hMap);
                    break;
                }
                case -5: {
                    Frame.Continuation stepNext = frameCaller -> {
                        ObjectHandle hResult = frameCaller.popStack();
                        hClass.setField(frame, "canonicalParams", hResult);
                        return frameCaller.assignValue(iReturn, hResult);
                    };
                    frame.m_frameNext.addContinuation(stepNext);
                    return -5;
                }
                case -3: {
                    return -3;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return frame.assignValue(iReturn, hMap);
    }

    public int invokeIsSingleton(Frame frame, ObjectHandle hTarget, int[] aiReturn) {
        TypeConstant typeClz = xClass.getClassType(hTarget);
        if (typeClz.ensureTypeInfo().isSingleton()) {
            IdentityConstant idClz = typeClz.getSingleUnderlyingClass(false);
            ConstantPool pool = frame.poolContext();
            SingletonConstant constInstance = pool.ensureSingletonConstConstant(idClz);
            return frame.assignConditionalDeferredValue(aiReturn, frame.getConstHandle(constInstance));
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    public int invokeDefaultValue(Frame frame, ObjectHandle hTarget, int[] aiReturn) {
        TypeConstant typeClz = xClass.getClassType(hTarget);
        Constant constDefault = typeClz.getDefaultValue();
        if (constDefault != null) {
            return frame.assignConditionalDeferredValue(aiReturn, frame.getConstHandle(constDefault));
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected static TypeConstant getClassType(ObjectHandle hTarget) {
        return hTarget.getComposition().getType().getParamType(0);
    }

    private boolean isCanonicalStructure(TypeConstant type) {
        if (type.isAnnotated()) {
            Annotation[] aAnno;
            ConstantPool pool = type.getConstantPool();
            for (Annotation anno : aAnno = type.getAnnotations()) {
                ClassConstant idAnno = (ClassConstant)anno.getAnnotationClass();
                if (idAnno.equals(pool.clzAbstract()) || idAnno.equals(pool.clzOverride())) continue;
                return false;
            }
        }
        return true;
    }

    public static TypeComposition ensureArrayComposition(Container container) {
        return container.ensureClassComposition(CLASS_ARRAY_TYPE, xArray.INSTANCE);
    }

    public static class ClassHandle
    extends ObjectHandle.GenericHandle {
        public ClassHandle(TypeComposition clazz) {
            super(clazz);
        }

        @Override
        public boolean isNativeEqual() {
            return true;
        }

        @Override
        public int hashCode() {
            return this.getType().getParamType(0).hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ClassHandle) {
                ClassHandle that = (ClassHandle)obj;
                TypeConstant typeThis = this.getType().getParamType(0);
                TypeConstant typeThat = that.getType().getParamType(0);
                return typeThis.equals(typeThat);
            }
            return false;
        }

        @Override
        public String toString() {
            return "(Class) " + String.valueOf(this.getType().getParamType(0));
        }
    }
}

