/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.reflect;

import java.util.Map;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorList;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.FileStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Version;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.VersionConstant;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Parser;
import org.xvm.compiler.Source;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.TypeCompositionStatement;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.reflect.xPackage;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;

public class xModule
extends xPackage {
    public static xModule INSTANCE;
    private static TypeConstant MODULE_ARRAY_TYPE;
    private static ArrayConstant EMPTY_MODULE_ARRAY;
    private static TypeConstant LISTMAP_TYPE;
    private static VersionConstant VERSION_DEFAULT;

    public xModule(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        if (this == INSTANCE) {
            ConstantPool pool = this.f_container.getConstantPool();
            MODULE_ARRAY_TYPE = pool.ensureArrayType(pool.typeModule());
            EMPTY_MODULE_ARRAY = pool.ensureArrayConstant(MODULE_ARRAY_TYPE, Constant.NO_CONSTS);
            VERSION_DEFAULT = new VersionConstant(this.pool(), new Version("CI"));
            this.markNativeProperty("simpleName");
            this.markNativeProperty("qualifiedName");
            this.invalidateTypeInfo();
        }
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof ModuleConstant) {
            ModuleConstant idModule = (ModuleConstant)constant;
            return this.ensureConstHandle(frame, idModule, idModule.getType());
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        xPackage.PackageHandle hModule = (xPackage.PackageHandle)hTarget;
        switch (sPropName) {
            case "qualifiedName": {
                return this.getPropertyQualifiedName(frame, hModule, iReturn);
            }
            case "simpleName": {
                return this.getPropertySimpleName(frame, hModule, iReturn);
            }
            case "version": {
                return this.getPropertyVersion(frame, hModule, iReturn);
            }
            case "modulesByPath": {
                return this.getPropertyModulesByPath(frame, hModule, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        xPackage.PackageHandle hModule = (xPackage.PackageHandle)hTarget;
        switch (method.getName()) {
            case "classForName": {
                assert (ahArg.length == 1);
                return this.invokeClassForName(frame, hModule, ahArg[0], aiReturn);
            }
            case "typeForName": {
                assert (ahArg.length == 1);
                return this.invokeTypeForName(frame, hModule, ahArg[0], aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    public int getPropertySimpleName(Frame frame, xPackage.PackageHandle hModule, int iReturn) {
        String sName = ((ModuleConstant)hModule.getId()).getUnqualifiedName();
        return frame.assignValue(iReturn, xString.makeHandle(sName));
    }

    public int getPropertyQualifiedName(Frame frame, xPackage.PackageHandle hModule, int iReturn) {
        String sName = hModule.getId().getName();
        return frame.assignValue(iReturn, xString.makeHandle(sName));
    }

    public int getPropertyVersion(Frame frame, xPackage.PackageHandle hModule, int iReturn) {
        ModuleStructure module = (ModuleStructure)hModule.getId().getComponent();
        VersionConstant ver = module.getVersionConstant();
        return frame.assignDeferredValue(iReturn, frame.getConstHandle(ver == null ? VERSION_DEFAULT : ver));
    }

    public int getPropertyModulesByPath(Frame frame, xPackage.PackageHandle hTarget, int iReturn) {
        Container container = frame.f_context.f_container;
        ModuleConstant idModule = (ModuleConstant)hTarget.getId();
        ModuleStructure module = (ModuleStructure)idModule.getComponent();
        TypeComposition clzMap = container.resolveClass(xModule.ensureListMapType());
        Map<ModuleConstant, String> mapModulePaths = module.collectDependencies();
        int cModules = mapModulePaths.size() - 1;
        if (cModules == 0) {
            return Utils.constructListMap(frame, clzMap, xString.ensureEmptyArray(), xModule.ensureEmptyArray(container), iReturn);
        }
        xString.StringHandle[] ahPaths = new xString.StringHandle[cModules];
        ObjectHandle[] ahModules = new ObjectHandle[cModules];
        boolean fDeferred = false;
        int index = 0;
        for (Map.Entry<ModuleConstant, String> entry : mapModulePaths.entrySet()) {
            ModuleConstant idDep = entry.getKey();
            if (idDep == idModule) continue;
            ObjectHandle hM = frame.getConstHandle(idDep);
            ahPaths[index] = xString.makeHandle(entry.getValue());
            ahModules[index] = hM;
            fDeferred |= Op.isDeferred(hM);
            ++index;
        }
        xArray.ArrayHandle hPaths = xArray.makeStringArrayHandle(ahPaths);
        TypeComposition clzArray = xModule.ensureArrayComposition(container);
        if (fDeferred) {
            Frame.Continuation stepNext = frameCaller -> {
                xArray.ArrayHandle hModules = xArray.createImmutableArray(clzArray, ahModules);
                return Utils.constructListMap(frame, clzMap, hPaths, hModules, iReturn);
            };
            return new Utils.GetArguments(ahModules, stepNext).doNext(frame);
        }
        xArray.ArrayHandle hModules = xArray.createImmutableArray(clzArray, ahModules);
        return Utils.constructListMap(frame, clzMap, hPaths, hModules, iReturn);
    }

    public int invokeClassForName(Frame frame, xPackage.PackageHandle hTarget, ObjectHandle hArg, int[] aiReturn) {
        ModuleStructure module = (ModuleStructure)hTarget.getStructure();
        String sClass = ((xString.StringHandle)hArg).getStringValue();
        Object oResult = xModule.resolveClass(module.getFileStructure(), module, sClass);
        if (oResult == null) {
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        if (oResult instanceof TypeConstant) {
            TypeConstant typeClz = (TypeConstant)oResult;
            IdentityConstant idClz = typeClz.getConstantPool().ensureClassConstant(typeClz);
            return frame.assignConditionalDeferredValue(aiReturn, frame.getConstHandle(idClz));
        }
        return frame.raiseException((String)oResult);
    }

    public int invokeTypeForName(Frame frame, xPackage.PackageHandle hTarget, ObjectHandle hArg, int[] aiReturn) {
        ModuleStructure module = (ModuleStructure)hTarget.getStructure();
        String sType = ((xString.StringHandle)hArg).getStringValue();
        Object oResult = xModule.resolveType(module.getFileStructure(), module, sType);
        if (oResult == null) {
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        if (oResult instanceof TypeConstant) {
            TypeConstant typeClz = ((TypeConstant)oResult).getType();
            return frame.assignConditionalDeferredValue(aiReturn, frame.getConstHandle(typeClz));
        }
        return frame.raiseException((String)oResult);
    }

    public static Object resolveClass(FileStructure structTS, ModuleStructure module, String sClass) {
        return xModule.resolveClassOrType(structTS, module, sClass, true);
    }

    public static Object resolveType(FileStructure structTS, ModuleStructure module, String sType) {
        return xModule.resolveClassOrType(structTS, module, sType, false);
    }

    private static Object resolveClassOrType(FileStructure structTS, ModuleStructure module, String sClassOrType, boolean fClass) {
        if (module == null) {
            ModuleStructure moduleStructure = module = structTS == null ? xModule.INSTANCE.f_struct.getFileStructure().getModule() : structTS.getModule();
        }
        if (fClass && sClassOrType.isEmpty()) {
            return module.getIdentityConstant().getType();
        }
        Source source = new Source(sClassOrType);
        ErrorList errs = new ErrorList(10);
        Parser parser = new Parser(source, errs);
        TypeExpression expr = null;
        try {
            expr = fClass ? parser.parseClassExpression() : parser.parseTypeExpression();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (expr != null && errs.getSeriousErrorCount() == 0) {
            new TypeCompositionStatement(module, source, expr);
            if (new StageMgr(expr, Compiler.Stage.Resolved, (ErrorListener)errs).fastForward(3)) {
                TypeConstant typeClz = null;
                try {
                    typeClz = expr.ensureTypeConstant();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (typeClz != null && !typeClz.containsUnresolved()) {
                    return typeClz;
                }
            }
        }
        return null;
    }

    public static TypeComposition ensureArrayComposition(Container container) {
        return container.ensureClassComposition(MODULE_ARRAY_TYPE, xArray.INSTANCE);
    }

    public static xArray.ArrayHandle ensureEmptyArray(Container container) {
        xArray.ArrayHandle haEmpty = (xArray.ArrayHandle)container.f_heap.getConstHandle(EMPTY_MODULE_ARRAY);
        if (haEmpty == null) {
            haEmpty = xArray.createImmutableArray(xModule.ensureArrayComposition(container), Utils.OBJECTS_NONE);
            container.f_heap.saveConstHandle(EMPTY_MODULE_ARRAY, haEmpty);
        }
        return haEmpty;
    }

    private static TypeConstant ensureListMapType() {
        TypeConstant type = LISTMAP_TYPE;
        if (type == null) {
            ConstantPool pool = INSTANCE.pool();
            LISTMAP_TYPE = type = pool.ensureParameterizedTypeConstant(pool.ensureEcstasyTypeConstant("maps.ListMap"), pool.typeString(), pool.typeModule());
        }
        return type;
    }
}

