/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.reflect;

import java.util.ArrayList;
import java.util.Map;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Op;
import org.xvm.asm.PackageStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.PackageConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.NativeContainer;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.reflect.xClass;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xOrdered;

public class xPackage
extends xConst {
    public static xPackage INSTANCE;
    private static TypeConstant LIST_MAP_TYPE;
    private static ClassTemplate LIST_MAP_TEMPLATE;

    public xPackage(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        if (this == INSTANCE) {
            ConstantPool pool = this.f_container.getConstantPool();
            LIST_MAP_TYPE = pool.ensureParameterizedTypeConstant(pool.ensureEcstasyTypeConstant("maps.ListMap"), pool.typeString(), pool.typeClass());
            LIST_MAP_TEMPLATE = this.f_container.getTemplate(LIST_MAP_TYPE);
        }
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof PackageConstant) {
            PackageConstant idPackage = (PackageConstant)constant;
            PackageStructure pkg = (PackageStructure)idPackage.getComponent();
            TypeConstant typePkg = pkg.isModuleImport() ? pkg.getImportedModule().getIdentityConstant().getType() : idPackage.getType();
            return this.ensureConstHandle(frame, idPackage, typePkg);
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        PackageHandle hModule = (PackageHandle)hTarget;
        switch (sPropName) {
            case "classByName": {
                return this.getPropertyClassByName(frame, hModule, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "isModuleImport": {
                return this.invokeIsModuleImport(frame, (PackageHandle)hTarget, aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    protected int callEqualsImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(((PackageHandle)hValue1).getId().equals(((PackageHandle)hValue2).getId())));
    }

    @Override
    protected int callCompareImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xOrdered.makeHandle(((PackageHandle)hValue1).getId().compareTo(((PackageHandle)hValue2).getId())));
    }

    @Override
    protected int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        return frame.assignValue(iReturn, xInt64.makeHandle(((PackageHandle)hTarget).getId().hashCode()));
    }

    public int getPropertyClassByName(Frame frame, PackageHandle hTarget, int iReturn) {
        ConstantPool pool = frame.poolContext();
        ClassStructure pkg = hTarget.getStructure();
        if (!pkg.getIdentityConstant().isShared(pool)) {
            return frame.raiseException("Foreign package");
        }
        Container container = frame.f_context.f_container;
        TypeComposition clzMap = xPackage.ensureListMapComposition(container);
        Map<String, Component> mapChildren = pkg.getChildByNameMap();
        ArrayList<xString.StringHandle> listNames = new ArrayList<xString.StringHandle>(mapChildren.size());
        ArrayList<ObjectHandle> listClasses = new ArrayList<ObjectHandle>(mapChildren.size());
        boolean fDeferred = false;
        for (Map.Entry<String, Component> entry : mapChildren.entrySet()) {
            Component component = entry.getValue();
            if (!(component instanceof ClassStructure) || component.isSynthetic()) continue;
            IdentityConstant id = component.getIdentityConstant();
            ObjectHandle hClass = frame.getConstHandle(pool.ensureClassConstant(id.getType()));
            listNames.add(xString.makeHandle(entry.getKey()));
            listClasses.add(hClass);
            fDeferred |= Op.isDeferred(hClass);
        }
        xString.StringHandle[] ahNames = listNames.toArray(Utils.STRINGS_NONE);
        ObjectHandle[] ahClasses = listClasses.toArray(Utils.OBJECTS_NONE);
        xArray.ArrayHandle hNames = xArray.makeStringArrayHandle(ahNames);
        if (fDeferred) {
            Frame.Continuation stepNext = frameCaller -> {
                xArray.ArrayHandle hClasses = xArray.createImmutableArray(xClass.ensureArrayComposition(container), ahClasses);
                return Utils.constructListMap(frame, clzMap, hNames, hClasses, iReturn);
            };
            return new Utils.GetArguments(ahClasses, stepNext).doNext(frame);
        }
        xArray.ArrayHandle hClasses = xArray.createImmutableArray(xClass.ensureArrayComposition(container), ahClasses);
        return Utils.constructListMap(frame, clzMap, hNames, hClasses, iReturn);
    }

    public int invokeIsModuleImport(Frame frame, PackageHandle hTarget, int[] aiReturn) {
        PackageStructure pkg;
        ModuleStructure module;
        ClassStructure struct = hTarget.getStructure();
        if (struct instanceof ModuleStructure && !(module = (ModuleStructure)struct).isMainModule()) {
            return frame.assignValues(aiReturn, xBoolean.TRUE, hTarget);
        }
        if (struct instanceof PackageStructure && (pkg = (PackageStructure)struct).isModuleImport()) {
            ModuleStructure module2 = pkg.getImportedModule();
            ModuleConstant idModule = module2.getIdentityConstant();
            ConstantPool pool = frame.poolContext();
            SingletonConstant constInstance = pool.ensureSingletonConstConstant(idModule);
            return frame.assignConditionalDeferredValue(aiReturn, frame.getConstHandle(constInstance));
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected int ensureConstHandle(Frame frame, IdentityConstant idPkg, TypeConstant typePkg) {
        Container container = frame.f_context.f_container;
        SingletonConstant constPkg = container.getConstantPool().ensureSingletonConstConstant(idPkg);
        ObjectHandle hPkg = constPkg.getHandle();
        if (hPkg != null) {
            return frame.pushStack(hPkg);
        }
        TypeComposition clazz = container.getTemplate(typePkg).ensureClass(container, typePkg, typePkg);
        switch (this.createPackageHandle(frame, clazz)) {
            case -1: {
                hPkg = frame.popStack();
                constPkg.setHandle(hPkg);
                container.f_heap.saveConstHandle(constPkg, hPkg);
                return frame.pushStack(hPkg);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> {
                    ObjectHandle hP = frameCaller.popStack();
                    constPkg.setHandle(hP);
                    container.f_heap.saveConstHandle(constPkg, hP);
                    return frameCaller.pushStack(hP);
                });
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    public static TypeComposition ensureListMapComposition(Container container) {
        return container.ensureClassComposition(LIST_MAP_TYPE, LIST_MAP_TEMPLATE);
    }

    protected int createPackageHandle(Frame frame, TypeComposition clazz) {
        PackageHandle hStruct = new PackageHandle(clazz.ensureAccess(Constants.Access.STRUCT));
        MethodStructure constructor = clazz.getTemplate().getStructure().findMethod("construct", 0, new TypeConstant[0]);
        ObjectHandle[] ahVar = Utils.ensureSize(Utils.OBJECTS_NONE, constructor.getMaxVars());
        return this.proceedConstruction(frame, constructor, true, hStruct, ahVar, -1);
    }

    public static class PackageHandle
    extends ObjectHandle.GenericHandle {
        public PackageHandle(TypeComposition clazz) {
            super(clazz);
        }

        public IdentityConstant getId() {
            return (IdentityConstant)this.getType().getDefiningConstant();
        }

        public boolean isModule() {
            return this.getId() instanceof ModuleConstant;
        }

        public ClassStructure getStructure() {
            return (ClassStructure)this.getId().getComponent();
        }

        @Override
        public boolean isShared(Container container, Map<ObjectHandle, Boolean> mapVisited) {
            return this.isModule() && container instanceof NativeContainer || super.isShared(container, mapVisited);
        }

        @Override
        public boolean isNativeEqual() {
            return true;
        }

        @Override
        public int compareTo(ObjectHandle that) {
            return this.getId().compareTo(((PackageHandle)that).getId());
        }

        @Override
        public int hashCode() {
            return this.getId().hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof PackageHandle)) return false;
            PackageHandle that = (PackageHandle)obj;
            if (!this.getId().equals(that.getId())) return false;
            return true;
        }
    }
}

