/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.reflect;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.NativeRebaseConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.PropertyComposition;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.VarSupport;
import org.xvm.runtime.template.Identity;
import org.xvm.runtime.template.IndexSupport;
import org.xvm.runtime.template._native.reflect.xRTProperty;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.annotations.xFuture;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.reflect.xClass;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;

public class xRef
extends ClassTemplate
implements VarSupport {
    public static xRef INSTANCE;
    public static ClassConstant INCEPTION_CLASS;
    private static SignatureConstant s_sigGet;

    public xRef(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
            INCEPTION_CLASS = new NativeRebaseConstant((ClassConstant)structure.getIdentityConstant());
        }
    }

    @Override
    protected Set<String> registerImplicitFields(Set<String> setFields) {
        if (setFields == null) {
            setFields = new HashSet<String>();
        }
        setFields.add("$value");
        setFields.add("$outer");
        return super.registerImplicitFields(setFields);
    }

    @Override
    public void registerNativeTemplates() {
        if (this == INSTANCE) {
            ClassStructure structId = (ClassStructure)this.f_struct.getChild("Identity");
            this.registerNativeTemplate(new Identity(this.f_container, structId, true));
        }
    }

    @Override
    public void initNative() {
        s_sigGet = this.getStructure().findMethod("get", 0, new TypeConstant[0]).getIdentityConstant().getSignature();
        this.markNativeMethod("equals", null, BOOLEAN);
        this.invalidateTypeInfo();
    }

    @Override
    protected ClassConstant getInceptionClassConstant() {
        return INCEPTION_CLASS;
    }

    @Override
    public ClassTemplate getTemplate(TypeConstant type) {
        ClassTemplate template = super.getTemplate(type);
        return template instanceof xRef ? template : this;
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        RefHandle hRef = (RefHandle)hTarget;
        switch (sPropName) {
            case "type": {
                return this.actOnReferent(frame, hRef, h -> frame.assignValue(iReturn, h.getType().ensureTypeHandle(frame.f_context.f_container)));
            }
            case "class": {
                return this.actOnReferent(frame, hRef, h -> this.ensureClassHandle(frame, (ObjectHandle)h, iReturn));
            }
            case "annotations": {
                return this.getPropertyAnnotations(frame, hRef, iReturn);
            }
            case "assigned": {
                return this.getPropertyAssigned(frame, hRef, iReturn);
            }
            case "identity": {
                return this.actOnReferent(frame, hRef, h -> frame.assignValue(iReturn, Identity.ensureIdentity(h)));
            }
            case "size": {
                return frame.assignValue(iReturn, xInt64.makeHandle(8L));
            }
            case "selfContained": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(hRef.isSelfContained()));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    private int ensureClassHandle(Frame frame, ObjectHandle hTarget, int iReturn) {
        ConstantPool pool = frame.poolContext();
        TypeConstant type = hTarget.getComposition().getType();
        if (!type.isSingleDefiningConstant() || !type.isShared(pool)) {
            TypeComposition typeComposition = hTarget.getComposition();
            if (typeComposition instanceof ClassComposition) {
                final ClassComposition clzTarget = (ClassComposition)typeComposition;
                if (clzTarget.isInception()) {
                    return frame.raiseException(xException.invalidType(frame, "Type \"" + type.getValueString() + "\" is not shared with the TypeSystem of module \"" + frame.f_context.f_container.getModule().getName() + "\""));
                }
                if (clzTarget.getInceptionType().isShared(pool)) {
                    return this.ensureMaskedClassHandle(frame, clzTarget, iReturn);
                }
                Container owner = ((ObjectHandle.GenericHandle)hTarget).getOwner();
                if (owner != null) {
                    ServiceContext ctxOwner = owner.getServiceContext();
                    Op opClassHandle = new Op(this){
                        final /* synthetic */ xRef this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public int process(Frame frame, int iPC) {
                            return this.this$0.ensureMaskedClassHandle(frame, clzTarget, 0);
                        }

                        @Override
                        public String toString() {
                            return "CreateClassHandle";
                        }
                    };
                    return ctxOwner.sendOp1Request(frame, opClassHandle, iReturn, new TypeConstant[0]);
                }
            }
            return frame.raiseException(xException.invalidType(frame, "Unsupported type: " + type.getValueString()));
        }
        if (type.isImmutabilitySpecified()) {
            type = type.removeImmutable();
        }
        return frame.assignDeferredValue(iReturn, frame.getConstHandle(pool.ensureClassConstant(type)));
    }

    private int ensureMaskedClassHandle(Frame frame, ClassComposition clzTarget, int iReturn) {
        ObjectHandle hClass = frame.getConstHandle(frame.poolContext().ensureClassConstant(clzTarget.getInceptionType()));
        return Op.isDeferred(hClass) ? hClass.proceed(frame, frameCaller -> this.maskClassHandle(frameCaller, frameCaller.popStack(), clzTarget.getType(), iReturn)) : this.maskClassHandle(frame, hClass, clzTarget.getType(), iReturn);
    }

    private int maskClassHandle(Frame frame, ObjectHandle hClass, TypeConstant typeMask, int iReturn) {
        ConstantPool pool = frame.poolContext();
        TypeConstant typeOrig = hClass.getType();
        TypeConstant typeClz = pool.ensureParameterizedTypeConstant(pool.typeClass(), typeMask, typeMask.ensureAccess(Constants.Access.PROTECTED), typeMask.ensureAccess(Constants.Access.PRIVATE), pool.typeStruct());
        if (typeOrig.isAnnotated()) {
            List<Annotation> listAnno = Arrays.asList(typeOrig.getAnnotations());
            listAnno.removeIf(anno -> !anno.getAnnotationType().isShared(pool));
            if (!listAnno.isEmpty()) {
                typeClz = pool.ensureAnnotatedTypeConstant(typeClz, listAnno.toArray(Annotation.NO_ANNOTATIONS));
            }
        }
        try {
            TypeComposition clzMask = hClass.getTemplate().ensureClass(frame.f_context.f_container, typeClz);
            return frame.assignValue(iReturn, hClass.cloneAs(clzMask));
        }
        catch (Exception e) {
            return frame.raiseException(xException.invalidType(frame, "Failed to create a class handle for : " + typeMask.getValueString()));
        }
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        RefHandle hRef = (RefHandle)hTarget;
        switch (method.getName()) {
            case "instanceOf": {
                return this.actOnReferent(frame, hRef, h -> frame.assignValue(iReturn, xBoolean.makeHandle(this.instanceOf((ObjectHandle)h, (xRTType.TypeHandle)hArg))));
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        RefHandle hRef = (RefHandle)hTarget;
        switch (method.getName()) {
            case "get": {
                return this.getReferentImpl(frame, hRef, true, iReturn);
            }
            case "equals": {
                RefHandle hRef1 = (RefHandle)ahArg[1];
                RefHandle hRef2 = (RefHandle)ahArg[2];
                return new CompareReferents(hRef1, hRef2, this, iReturn).doNext(frame);
            }
            case "maskAs": {
                return this.actOnReferent(frame, hRef, h -> this.maskAs(frame, (ObjectHandle)h, (xRTType.TypeHandle)ahArg[1], iReturn));
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        RefHandle hRef = (RefHandle)hTarget;
        switch (method.getName()) {
            case "hasName": {
                String sName = hRef.getName();
                return sName == null ? frame.assignValue(aiReturn[0], xBoolean.FALSE) : frame.assignValues(aiReturn, xBoolean.TRUE, xString.makeHandle(sName));
            }
            case "isProperty": {
                return this.invokeIsProperty(frame, hRef, aiReturn);
            }
            case "peek": {
                return hRef.isAssigned() ? this.actOnReferent(frame, hRef, h -> frame.assignValues(aiReturn, xBoolean.TRUE, (ObjectHandle)h)) : frame.assignValue(aiReturn[0], xBoolean.FALSE);
            }
            case "revealAs": {
                return this.actOnReferent(frame, hRef, h -> this.revealAs(frame, (ObjectHandle)h, (xRTType.TypeHandle)ahArg[1], aiReturn));
            }
            case "revealStruct": {
                return this.actOnReferent(frame, hRef, h -> this.revealStruct(frame, (ObjectHandle)h, (xRTType.TypeHandle)ahArg[0], aiReturn));
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    public RefHandle createRefHandle(Frame frame, TypeComposition clazz, String sName) {
        return new RefHandle(clazz, sName);
    }

    @Override
    public int introduceRef(Frame frame, TypeComposition clazz, String sName, int iReturn) {
        boolean fStack;
        int iResult;
        RefHandle hRef;
        TypeConstant typeRef = clazz.getType();
        if (typeRef instanceof AnnotatedTypeConstant) {
            hRef = this.createRefHandle(frame, clazz.ensureAccess(Constants.Access.STRUCT), sName);
            if (hRef.isStruct()) {
                iResult = this.proceedConstruction(frame, null, true, hRef, Utils.OBJECTS_NONE, -1);
                fStack = true;
            } else {
                iResult = -1;
                fStack = false;
            }
        } else {
            hRef = this.createRefHandle(frame, clazz, sName);
            iResult = hRef.initializeCustomFields(frame);
            fStack = false;
        }
        int nStyle = hRef instanceof xFuture.FutureHandle ? 9 : 1;
        switch (iResult) {
            case -1: {
                if (iReturn == -1) {
                    if (!fStack) {
                        frame.pushStack(hRef);
                    }
                } else {
                    frame.introduceResolvedVar(iReturn, typeRef, sName, nStyle, fStack ? frame.popStack() : hRef);
                }
                return -1;
            }
            case -5: {
                if (iReturn == -1) {
                    if (!fStack) {
                        frame.m_frameNext.addContinuation(frameCaller -> frameCaller.pushStack(hRef));
                    }
                } else {
                    frame.m_frameNext.addContinuation(frameCaller -> {
                        frameCaller.introduceResolvedVar(iReturn, typeRef, sName, nStyle, fStack ? frameCaller.popStack() : hRef);
                        return -1;
                    });
                }
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        RefHandle hRef1 = (RefHandle)hValue1;
        RefHandle hRef2 = (RefHandle)hValue2;
        return hRef1.isAssigned() && hRef2.isAssigned() ? new CompareReferents(hRef1, hRef2, this, iReturn).doNext(frame) : frame.assignValue(iReturn, xBoolean.FALSE);
    }

    @Override
    public int getReferent(Frame frame, RefHandle hTarget, int iReturn) {
        return this.getReferentImpl(frame, hTarget, false, iReturn);
    }

    public int getNativeReferent(Frame frame, RefHandle hTarget, int iReturn) {
        return this.getReferentImpl(frame, hTarget, true, iReturn);
    }

    protected int getReferentImpl(Frame frame, RefHandle hRef, boolean fNative, int iReturn) {
        switch (hRef.m_iVar) {
            case -1: {
                return fNative ? this.invokeNativeGetReferent(frame, hRef, iReturn) : this.invokeGetReferent(frame, hRef, iReturn);
            }
            case -2: {
                RefHandle hDelegate = (RefHandle)hRef.getReferentHolder();
                return hDelegate.getVarSupport().getReferent(frame, hDelegate, iReturn);
            }
            case -3: {
                ObjectHandle hDelegate = hRef.getReferentHolder();
                return hDelegate.getTemplate().getPropertyValue(frame, hDelegate, hRef.getPropertyId(), iReturn);
            }
            case -4: {
                IndexedRefHandle hIndexedRef = (IndexedRefHandle)hRef;
                ObjectHandle hArray = hRef.getReferentHolder();
                IndexSupport template = (IndexSupport)((Object)hArray.getTemplate());
                return template.extractArrayValue(frame, hArray, hIndexedRef.f_lIndex, iReturn);
            }
        }
        Frame frameRef = hRef.m_frame;
        int nVar = hRef.m_iVar;
        assert (frameRef != null && nVar >= 0);
        ObjectHandle hValue = frameRef.f_ahVar[nVar];
        return hValue == null ? frame.raiseException(xException.unassignedReference(frame)) : frame.assignValue(iReturn, hValue);
    }

    protected int invokeNativeGetReferent(Frame frame, RefHandle hRef, int iReturn) {
        ObjectHandle hValue = hRef.getReferent();
        return hValue == null ? frame.raiseException(xException.unassignedReference(frame)) : frame.assignValue(iReturn, hValue);
    }

    protected int invokeGetReferent(Frame frame, RefHandle hRef, int iReturn) {
        CallChain chain = hRef.getComposition().getMethodCallChain(s_sigGet);
        return chain.isExplicit() ? chain.invoke(frame, hRef, iReturn) : this.getReferentImpl(frame, hRef, true, iReturn);
    }

    @Override
    public int invokeVarPreInc(Frame frame, RefHandle hTarget, int iReturn) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarPostInc(Frame frame, RefHandle hTarget, int iReturn) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarPreDec(Frame frame, RefHandle hTarget, int iReturn) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarPostDec(Frame frame, RefHandle hTarget, int iReturn) {
        return this.readOnly(frame);
    }

    @Override
    public int setReferent(Frame frame, RefHandle hTarget, ObjectHandle hValue) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarAdd(Frame frame, RefHandle hTarget, ObjectHandle hArg) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarSub(Frame frame, RefHandle hTarget, ObjectHandle hArg) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarMul(Frame frame, RefHandle hTarget, ObjectHandle hArg) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarDiv(Frame frame, RefHandle hTarget, ObjectHandle hArg) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarMod(Frame frame, RefHandle hTarget, ObjectHandle hArg) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarShl(Frame frame, RefHandle hTarget, ObjectHandle hArg) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarShr(Frame frame, RefHandle hTarget, ObjectHandle hArg) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarShrAll(Frame frame, RefHandle hTarget, ObjectHandle hArg) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarAnd(Frame frame, RefHandle hTarget, ObjectHandle hArg) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarOr(Frame frame, RefHandle hTarget, ObjectHandle hArg) {
        return this.readOnly(frame);
    }

    @Override
    public int invokeVarXor(Frame frame, RefHandle hTarget, ObjectHandle hArg) {
        return this.readOnly(frame);
    }

    protected int readOnly(Frame frame) {
        return frame.raiseException("Ref cannot be assigned");
    }

    protected int actOnReferent(Frame frame, RefHandle hRef, ToIntFunction<ObjectHandle> action) {
        switch (this.getReferent(frame, hRef, -1)) {
            case -1: {
                return action.applyAsInt(frame.popStack());
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> action.applyAsInt(frameCaller.popStack()));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    protected int getPropertyAnnotations(Frame frame, RefHandle hRef, int iReturn) {
        Annotation[] aAnno;
        TypeComposition composition = hRef.getComposition();
        if (composition instanceof ClassComposition) {
            aAnno = composition.getType().getAnnotations();
        } else if (composition instanceof PropertyComposition) {
            PropertyComposition clzProp = (PropertyComposition)composition;
            PropertyInfo inoProp = clzProp.getPropertyInfo();
            aAnno = inoProp.getRefAnnotations();
        } else {
            aAnno = Annotation.NO_ANNOTATIONS;
        }
        return aAnno.length > 0 ? new Utils.CreateAnnos(aAnno, iReturn).doNext(frame) : frame.assignValue(iReturn, Utils.makeAnnoArrayHandle(frame.f_context.f_container, Utils.OBJECTS_NONE));
    }

    protected int getPropertyAssigned(Frame frame, RefHandle hRef, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(hRef.isAssigned()));
    }

    protected int invokeIsProperty(Frame frame, RefHandle hRef, int[] aiReturn) {
        TypeComposition composition = hRef.getComposition();
        if (composition instanceof PropertyComposition) {
            PropertyComposition clzProp = (PropertyComposition)composition;
            PropertyInfo infoProp = clzProp.getPropertyInfo();
            TypeConstant typeContainer = infoProp.getType();
            throw new UnsupportedOperationException("TODO GG isProperty " + String.valueOf(typeContainer));
        }
        if (composition instanceof ClassComposition) {
            ObjectHandle hContainer = hRef.isProperty() ? hRef.getReferentHolder() : null;
            String sName = hRef.getName();
            if (hContainer != null && sName != null) {
                TypeConstant typeContainer = hContainer.getType();
                PropertyInfo infoProp = frame.poolContext().ensureAccessTypeConstant(typeContainer, Constants.Access.PRIVATE).ensureTypeInfo().findProperty(sName);
                if (infoProp == null) {
                    return frame.raiseException(xException.unknownProperty(frame, sName, typeContainer));
                }
                ObjectHandle hProp = xRTProperty.makeHandle(frame, typeContainer, infoProp);
                return Op.isDeferred(hProp) ? hProp.proceed(frame, frameCaller -> frameCaller.assignValues(aiReturn, xBoolean.TRUE, frameCaller.popStack(), hContainer)) : frame.assignValues(aiReturn, xBoolean.TRUE, hProp, hContainer);
            }
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected int maskAs(Frame frame, ObjectHandle hTarget, xRTType.TypeHandle hType, int iReturn) {
        ObjectHandle.GenericHandle hGeneric;
        if (hTarget instanceof ObjectHandle.GenericHandle && !((hGeneric = (ObjectHandle.GenericHandle)hTarget) instanceof xClass.ClassHandle) && !(hGeneric instanceof xRTType.TypeHandle)) {
            if (!hGeneric.isPassThrough()) {
                return frame.raiseException("Masked object must be shareable");
            }
            TypeConstant typeMasked = hType.getUnsafeDataType();
            ObjectHandle.GenericHandle hMasked = hGeneric.maskAs(frame.f_context.f_container, typeMasked);
            return hMasked == null ? frame.raiseException(xException.typeMismatch(frame, typeMasked.getValueString())) : frame.assignValue(iReturn, hMasked);
        }
        return frame.raiseException(xException.unsupported(frame, "maskAs() for " + hTarget.getType().removeAccess().getValueString()));
    }

    protected int revealAs(Frame frame, ObjectHandle hTarget, xRTType.TypeHandle hType, int[] aiReturn) {
        if (hTarget instanceof ObjectHandle.GenericHandle) {
            ObjectHandle.GenericHandle hRevealed;
            ObjectHandle.GenericHandle hGeneric = (ObjectHandle.GenericHandle)hTarget;
            ConstantPool pool = frame.poolContext();
            TypeConstant typeReveal = hType.getDataType();
            if (!typeReveal.isA(pool.typeStruct()) && (hRevealed = hGeneric.revealAs(frame, typeReveal)) != null) {
                return frame.assignValues(aiReturn, xBoolean.TRUE, hRevealed);
            }
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected int revealStruct(Frame frame, ObjectHandle hTarget, xRTType.TypeHandle hType, int[] aiReturn) {
        if (hTarget instanceof ObjectHandle.GenericHandle) {
            ObjectHandle.GenericHandle hRevealed;
            ObjectHandle.GenericHandle hGeneric = (ObjectHandle.GenericHandle)hTarget;
            ConstantPool pool = frame.poolContext();
            TypeConstant typeReveal = hType.getDataType();
            if (typeReveal.isA(pool.typeStruct()) && (hRevealed = hGeneric.revealAs(frame, typeReveal = pool.ensureAccessTypeConstant(hTarget.getType(), Constants.Access.STRUCT))) != null) {
                return frame.assignValues(aiReturn, xBoolean.TRUE, hRevealed);
            }
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected boolean instanceOf(ObjectHandle hTarget, xRTType.TypeHandle hType) {
        return hTarget.getType().isA(hType.getUnsafeDataType());
    }

    public static class RefHandle
    extends ObjectHandle.GenericHandle {
        protected ObjectHandle m_hReferent;
        protected PropertyConstant m_idProp;
        protected String m_sName;
        protected Frame m_frame;
        protected int m_iVar;
        protected static final int REF_REFERENT = -1;
        protected static final int REF_REF = -2;
        protected static final int REF_PROPERTY = -3;
        protected static final int REF_ARRAY = -4;
        public static final String REFERENT = "$value";

        protected RefHandle(TypeComposition clazz, String sName) {
            super(clazz);
            this.m_sName = sName;
            this.m_fMutable = true;
            this.m_iVar = -1;
        }

        public RefHandle(TypeComposition clazz, String sName, ObjectHandle hReferent) {
            this(clazz, sName);
            this.setField(null, REFERENT, hReferent);
        }

        public RefHandle(TypeComposition clazz, Frame frame, ObjectHandle hTarget, PropertyConstant idProp) {
            super(clazz);
            assert (hTarget != null);
            this.m_frame = frame;
            this.m_hReferent = hTarget;
            this.m_idProp = idProp;
            this.m_sName = idProp.getNestedIdentity().toString();
            this.m_fMutable = hTarget.isMutable();
            this.m_iVar = -3;
        }

        public RefHandle(TypeComposition clazz, Frame frame, int iVar) {
            super(clazz);
            this.m_fMutable = true;
            assert (iVar >= 0);
            Frame.VarInfo infoSrc = frame.getVarInfo(iVar);
            RefHandle refCurrent = infoSrc.getRef();
            if (refCurrent == null) {
                infoSrc.setRef(this);
                this.m_frame = frame;
                this.m_iVar = iVar;
            } else {
                this.m_iVar = -2;
                this.m_hReferent = refCurrent;
            }
        }

        @Override
        public boolean makeImmutable() {
            boolean fDone = true;
            switch (this.m_iVar) {
                case -1: {
                    ObjectHandle hReferent = this.getField(null, REFERENT);
                    if (hReferent == null) break;
                    fDone = hReferent.makeImmutable();
                    break;
                }
                case -4: 
                case -2: {
                    fDone = this.m_hReferent.makeImmutable();
                    break;
                }
                case -3: {
                    ObjectHandle hValue;
                    ObjectHandle.GenericHandle hTarget = (ObjectHandle.GenericHandle)this.m_hReferent;
                    PropertyConstant idProp = this.m_idProp;
                    if (idProp.isFormalType() || (hValue = hTarget.getField(this.m_frame, idProp)) == null) break;
                    fDone = hValue.makeImmutable();
                    break;
                }
                default: {
                    ObjectHandle hReferent = this.m_frame.f_ahVar[this.m_iVar];
                    if (hReferent == null) break;
                    fDone = hReferent.makeImmutable();
                    break;
                }
            }
            if (fDone) {
                this.m_fMutable = false;
            }
            return fDone;
        }

        public int initializeCustomFields(Frame frame) {
            MethodStructure methodInit = this.getComposition().ensureAutoInitializer();
            if (methodInit == null) {
                return -1;
            }
            Frame frameID = frame.createFrame1(methodInit, this.ensureAccess(Constants.Access.STRUCT), Utils.OBJECTS_NONE, -2);
            frameID.addContinuation(frameCaller -> {
                List<String> listUnassigned = this.validateFields();
                return listUnassigned == null ? -1 : frameCaller.raiseException(xException.unassignedFields(frame, this.getType().getValueString(), listUnassigned));
            });
            return frame.callInitialized(frameID);
        }

        public boolean isProperty() {
            return switch (this.m_iVar) {
                case -1 -> {
                    if (this.getField(null, "$outer") != null) {
                        yield true;
                    }
                    yield false;
                }
                case -3 -> true;
                default -> false;
            };
        }

        public ObjectHandle getReferentHolder() {
            return this.m_iVar == -1 ? this.getField(null, "$outer") : this.m_hReferent;
        }

        public ObjectHandle getReferent() {
            return this.m_iVar == -1 ? this.getField(null, REFERENT) : null;
        }

        public void setReferent(ObjectHandle hReferent) {
            assert (this.m_iVar == -1);
            this.setField(null, REFERENT, hReferent);
        }

        public String getName() {
            String sName = this.m_sName;
            if (sName == null && this.m_iVar >= 0) {
                this.m_sName = sName = this.m_frame.f_aInfo[this.m_iVar].getName();
            }
            return sName;
        }

        public PropertyConstant getPropertyId() {
            return this.m_idProp;
        }

        public VarSupport getVarSupport() {
            return (VarSupport)this.getOpSupport();
        }

        public boolean isAssigned() {
            switch (this.m_iVar) {
                case -1: {
                    return this.getReferent() != null;
                }
                case -2: {
                    return ((RefHandle)this.m_hReferent).isAssigned();
                }
                case -3: {
                    ObjectHandle.GenericHandle hTarget = (ObjectHandle.GenericHandle)this.m_hReferent;
                    PropertyConstant idProp = this.m_idProp;
                    if (idProp.isFormalType()) {
                        return true;
                    }
                    ObjectHandle hValue = hTarget.getField(this.m_frame, idProp);
                    if (hValue == null) {
                        return false;
                    }
                    if (hTarget.isInflated(idProp)) {
                        return ((RefHandle)hValue).isAssigned();
                    }
                    return true;
                }
                case -4: {
                    return this.m_hReferent != null;
                }
            }
            return this.m_frame.f_ahVar[this.m_iVar] != null;
        }

        @Override
        public boolean isSelfContained() {
            return this.m_hReferent == null || this.m_hReferent.isSelfContained();
        }

        public void dereference() {
            assert (this.m_frame != null && this.m_iVar >= 0);
            ObjectHandle hValue = this.m_frame.f_ahVar[this.m_iVar];
            this.m_frame = null;
            this.m_iVar = -1;
            this.setReferent(hValue);
        }

        @Override
        public String toString() {
            String s = super.toString();
            return switch (this.m_iVar) {
                case -1 -> s + String.valueOf(this.isAssigned() ? this.getReferent() : "<unassigned>");
                case -2 -> s + "--> " + String.valueOf(this.m_hReferent);
                case -3 -> s + "-> " + String.valueOf(this.m_hReferent.getComposition()) + "#" + this.m_sName;
                case -4 -> String.valueOf(this.m_hReferent) + "[" + ((IndexedRefHandle)this).f_lIndex + "]";
                default -> s + "-> #" + this.m_iVar;
            };
        }
    }

    protected static class CompareReferents
    implements Frame.Continuation {
        private final RefHandle hRef1;
        private final RefHandle hRef2;
        private final xRef template;
        private final int iReturn;
        private ObjectHandle hReferent1;
        private ObjectHandle hReferent2;
        private int index = -1;

        public CompareReferents(RefHandle hRef1, RefHandle hRef2, xRef template, int iReturn) {
            this.hRef1 = hRef1;
            this.hRef2 = hRef2;
            this.template = template;
            this.iReturn = iReturn;
        }

        @Override
        public int proceed(Frame frameCaller) {
            this.updateResult(frameCaller);
            return this.doNext(frameCaller);
        }

        protected void updateResult(Frame frameCaller) {
            if (this.index == 0) {
                this.hReferent1 = frameCaller.popStack();
            } else {
                this.hReferent2 = frameCaller.popStack();
            }
        }

        public int doNext(Frame frameCaller) {
            block5: while (++this.index < 2) {
                RefHandle hRef = this.index == 0 ? this.hRef1 : this.hRef2;
                switch (this.template.getReferent(frameCaller, hRef, -1)) {
                    case -1: {
                        this.updateResult(frameCaller);
                        continue block5;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
            ClassTemplate template = this.hReferent1.getTemplate();
            boolean fEquals = template == this.hReferent2.getTemplate() && template.compareIdentity(this.hReferent1, this.hReferent2);
            return frameCaller.assignValue(this.iReturn, xBoolean.makeHandle(fEquals));
        }
    }

    public static class IndexedRefHandle
    extends RefHandle {
        protected final long f_lIndex;

        public IndexedRefHandle(TypeComposition clazz, ObjectHandle hTarget, long lIndex) {
            super(clazz, null);
            this.m_iVar = -4;
            this.m_hReferent = hTarget;
            this.f_lIndex = lIndex;
        }

        @Override
        public void dereference() {
        }
    }
}

