/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.reflect;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.NativeRebaseConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.VarSupport;
import org.xvm.runtime.template.IndexSupport;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.xException;

public class xVar
extends xRef
implements VarSupport {
    public static xVar INSTANCE;
    public static ClassConstant INCEPTION_CLASS;
    protected static SignatureConstant s_sigSet;

    public xVar(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
            INCEPTION_CLASS = new NativeRebaseConstant((ClassConstant)structure.getIdentityConstant());
        }
    }

    @Override
    public void initNative() {
        s_sigSet = this.getStructure().findMethod("set", 1, new TypeConstant[0]).getIdentityConstant().getSignature();
    }

    @Override
    protected ClassConstant getInceptionClassConstant() {
        return INCEPTION_CLASS;
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        xRef.RefHandle hThis = (xRef.RefHandle)hTarget;
        switch (method.getName()) {
            case "set": {
                return this.setReferentImpl(frame, hThis, true, hArg);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeVarPreInc(Frame frame, xRef.RefHandle hTarget, int iReturn) {
        CallChain chain = this.findOpChain(hTarget, "preIncrement", "++#", null);
        return chain == null ? new Utils.InPlaceVarUnary(Utils.UnaryAction.INC, hTarget, false, iReturn).doNext(frame) : chain.invoke(frame, hTarget, iReturn);
    }

    @Override
    public int invokeVarPostInc(Frame frame, xRef.RefHandle hTarget, int iReturn) {
        CallChain chain = this.findOpChain(hTarget, "postIncrement", "#++", null);
        return chain == null ? new Utils.InPlaceVarUnary(Utils.UnaryAction.INC, hTarget, true, iReturn).doNext(frame) : chain.invoke(frame, hTarget, iReturn);
    }

    @Override
    public int invokeVarPreDec(Frame frame, xRef.RefHandle hTarget, int iReturn) {
        CallChain chain = this.findOpChain(hTarget, "preDecrement", "--#", null);
        return chain == null ? new Utils.InPlaceVarUnary(Utils.UnaryAction.DEC, hTarget, false, iReturn).doNext(frame) : chain.invoke(frame, hTarget, iReturn);
    }

    @Override
    public int invokeVarPostDec(Frame frame, xRef.RefHandle hTarget, int iReturn) {
        CallChain chain = this.findOpChain(hTarget, "postDecrement", "#--", null);
        return chain == null ? new Utils.InPlaceVarUnary(Utils.UnaryAction.DEC, hTarget, true, iReturn).doNext(frame) : chain.invoke(frame, hTarget, iReturn);
    }

    @Override
    public int setReferent(Frame frame, xRef.RefHandle hTarget, ObjectHandle hValue) {
        return this.setReferentImpl(frame, hTarget, false, hValue);
    }

    public int setNativeReferent(Frame frame, xRef.RefHandle hTarget, ObjectHandle hValue) {
        return this.setReferentImpl(frame, hTarget, true, hValue);
    }

    protected int setReferentImpl(Frame frame, xRef.RefHandle hRef, boolean fNative, ObjectHandle hValue) {
        if (!hRef.isMutable()) {
            return frame.raiseException(xException.readOnly(frame, "Immutable Var"));
        }
        switch (hRef.m_iVar) {
            case -1: {
                if (fNative) {
                    hRef.setReferent(hValue);
                    return -1;
                }
                return this.invokeSetReferent(frame, hRef, hValue);
            }
            case -2: {
                xRef.RefHandle hDelegate = (xRef.RefHandle)hRef.getReferentHolder();
                return hRef.getVarSupport().setReferent(frame, hDelegate, hValue);
            }
            case -3: {
                ObjectHandle hDelegate = hRef.getReferentHolder();
                return hDelegate.getTemplate().setPropertyValue(frame, hDelegate, hRef.getPropertyId(), hValue);
            }
            case -4: {
                xRef.IndexedRefHandle hIndexedRef = (xRef.IndexedRefHandle)hRef;
                ObjectHandle hArray = hRef.getReferentHolder();
                IndexSupport template = (IndexSupport)((Object)hArray.getTemplate());
                return template.assignArrayValue(frame, hArray, hIndexedRef.f_lIndex, hValue);
            }
        }
        Frame frameRef = hRef.m_frame;
        int nVar = hRef.m_iVar;
        assert (frameRef != null && nVar >= 0);
        frameRef.f_ahVar[nVar] = hValue;
        return -1;
    }

    protected int invokeSetReferent(Frame frame, xRef.RefHandle hRef, ObjectHandle hValue) {
        CallChain chain = hRef.getComposition().getMethodCallChain(s_sigSet);
        return chain.isExplicit() ? chain.invoke(frame, (ObjectHandle)hRef, hValue, -2) : this.setReferentImpl(frame, hRef, true, hValue);
    }

    @Override
    public int invokeVarAdd(Frame frame, xRef.RefHandle hTarget, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, "addAssign", "+=", hArg);
        return chain == null ? new Utils.InPlaceVarBinary(Utils.BinaryAction.ADD, hTarget, hArg).doNext(frame) : chain.invoke(frame, (ObjectHandle)hTarget, hArg, -2);
    }

    @Override
    public int invokeVarSub(Frame frame, xRef.RefHandle hTarget, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, "subAssign", "-=", hArg);
        return chain == null ? new Utils.InPlaceVarBinary(Utils.BinaryAction.SUB, hTarget, hArg).doNext(frame) : chain.invoke(frame, (ObjectHandle)hTarget, hArg, -2);
    }

    @Override
    public int invokeVarMul(Frame frame, xRef.RefHandle hTarget, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, "mulAssign", "*=", hArg);
        return chain == null ? new Utils.InPlaceVarBinary(Utils.BinaryAction.MUL, hTarget, hArg).doNext(frame) : chain.invoke(frame, (ObjectHandle)hTarget, hArg, -2);
    }

    @Override
    public int invokeVarDiv(Frame frame, xRef.RefHandle hTarget, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, "divAssign", "/=", hArg);
        return chain == null ? new Utils.InPlaceVarBinary(Utils.BinaryAction.DIV, hTarget, hArg).doNext(frame) : chain.invoke(frame, (ObjectHandle)hTarget, hArg, -2);
    }

    @Override
    public int invokeVarMod(Frame frame, xRef.RefHandle hTarget, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, "modAssign", "%=", hArg);
        return chain == null ? new Utils.InPlaceVarBinary(Utils.BinaryAction.MOD, hTarget, hArg).doNext(frame) : chain.invoke(frame, (ObjectHandle)hTarget, hArg, -2);
    }

    @Override
    public int invokeVarShl(Frame frame, xRef.RefHandle hTarget, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, "shiftLeftAssign", "<<=", hArg);
        return chain == null ? new Utils.InPlaceVarBinary(Utils.BinaryAction.SHL, hTarget, hArg).doNext(frame) : chain.invoke(frame, (ObjectHandle)hTarget, hArg, -2);
    }

    @Override
    public int invokeVarShr(Frame frame, xRef.RefHandle hTarget, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, "shiftRightAssign", ">>=", hArg);
        return chain == null ? new Utils.InPlaceVarBinary(Utils.BinaryAction.SHR, hTarget, hArg).doNext(frame) : chain.invoke(frame, (ObjectHandle)hTarget, hArg, -2);
    }

    @Override
    public int invokeVarShrAll(Frame frame, xRef.RefHandle hTarget, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, "shiftAllRightAssign", ">>>=", hArg);
        return chain == null ? new Utils.InPlaceVarBinary(Utils.BinaryAction.USHR, hTarget, hArg).doNext(frame) : chain.invoke(frame, (ObjectHandle)hTarget, hArg, -2);
    }

    @Override
    public int invokeVarAnd(Frame frame, xRef.RefHandle hTarget, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, "andAssign", "&=", hArg);
        return chain == null ? new Utils.InPlaceVarBinary(Utils.BinaryAction.AND, hTarget, hArg).doNext(frame) : chain.invoke(frame, (ObjectHandle)hTarget, hArg, -2);
    }

    @Override
    public int invokeVarOr(Frame frame, xRef.RefHandle hTarget, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, "orAssign", "|=", hArg);
        return chain == null ? new Utils.InPlaceVarBinary(Utils.BinaryAction.OR, hTarget, hArg).doNext(frame) : chain.invoke(frame, (ObjectHandle)hTarget, hArg, -2);
    }

    @Override
    public int invokeVarXor(Frame frame, xRef.RefHandle hTarget, ObjectHandle hArg) {
        CallChain chain = this.findOpChain(hTarget, "xorAssign", "^=", hArg);
        return chain == null ? new Utils.InPlaceVarBinary(Utils.BinaryAction.XOR, hTarget, hArg).doNext(frame) : chain.invoke(frame, (ObjectHandle)hTarget, hArg, -2);
    }
}

