/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.text;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.CharConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xByteArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.numbers.xUInt32;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xOrdered;
import org.xvm.util.Handy;

public class xChar
extends xConst {
    public static xChar INSTANCE;
    private final ObjectHandle.JavaLong[] cache = new ObjectHandle.JavaLong[128];

    public xChar(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        super.initNative();
        this.markNativeProperty("codepoint");
        this.invalidateTypeInfo();
        if (this == INSTANCE) {
            ClassComposition clz = this.getCanonicalClass();
            for (int i = 0; i < this.cache.length; ++i) {
                this.cache[i] = new ObjectHandle.JavaLong(clz, i);
            }
        }
    }

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof CharConstant) {
            CharConstant constChar = (CharConstant)constant;
            return frame.pushStack(new ObjectHandle.JavaLong(this.getCanonicalClass(), constChar.getValue().intValue()));
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int construct(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahVar, int iReturn) {
        ObjectHandle hArg = ahVar[0];
        if (hArg instanceof ObjectHandle.JavaLong) {
            ObjectHandle.JavaLong hCodepoint = (ObjectHandle.JavaLong)hArg;
            return this.constructHandle(frame, hCodepoint.getValue(), iReturn);
        }
        if (hArg instanceof xString.StringHandle) {
            xString.StringHandle hText = (xString.StringHandle)hArg;
            char[] ach = hText.getValue();
            if (ach.length != 1) {
                return frame.raiseException("illegal argument: String has length=" + ach.length);
            }
            return this.constructHandle(frame, ach[0], iReturn);
        }
        byte[] ab = xByteArray.getBytes((xArray.ArrayHandle)hArg);
        try {
            long lCodepoint = Handy.readUtf8Char(new DataInputStream(new ByteArrayInputStream(ab)));
            return this.constructHandle(frame, lCodepoint, iReturn);
        }
        catch (IOException e) {
            return frame.raiseException(xException.illegalUTF(frame, e.getMessage()));
        }
    }

    protected int constructHandle(Frame frame, long lCodepoint, int iReturn) {
        if (lCodepoint > 0x10FFFFL || lCodepoint > 55295L && lCodepoint < 57344L) {
            return frame.raiseException("illegal code-point: " + lCodepoint);
        }
        return frame.assignValue(iReturn, xChar.makeHandle(lCodepoint));
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        switch (sPropName) {
            case "codepoint": {
                return frame.assignValue(iReturn, xUInt32.INSTANCE.makeJavaLong(((ObjectHandle.JavaLong)hTarget).getValue()));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokePrev(Frame frame, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        if (l == 0L) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, xChar.makeHandle(l - 1L));
    }

    @Override
    public int invokeNext(Frame frame, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        if (l == 65535L) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, xChar.makeHandle(l + 1L));
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(this.compareIdentity(hValue1, hValue2)));
    }

    @Override
    public int callCompare(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        ObjectHandle.JavaLong h1 = (ObjectHandle.JavaLong)hValue1;
        ObjectHandle.JavaLong h2 = (ObjectHandle.JavaLong)hValue2;
        return frame.assignValue(iReturn, xOrdered.makeHandle(Long.compare(h1.getValue(), h2.getValue())));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        return ((ObjectHandle.JavaLong)hValue1).getValue() == ((ObjectHandle.JavaLong)hValue2).getValue();
    }

    @Override
    public int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        ObjectHandle.JavaLong hThis = (ObjectHandle.JavaLong)hTarget;
        return frame.assignValue(iReturn, xInt64.makeHandle(hThis.getValue()));
    }

    public static ObjectHandle.JavaLong makeHandle(long chValue) {
        assert (chValue >= 0L & chValue <= 0x10FFFFL);
        if (chValue < 128L) {
            return xChar.INSTANCE.cache[(int)chValue];
        }
        return new ObjectHandle.JavaLong(INSTANCE.getCanonicalClass(), chValue);
    }
}

