/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.text;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.RegExConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xNullable;

public class xRegEx
extends xConst {
    public static xRegEx INSTANCE;
    private MethodStructure m_constructorMatch;
    private TypeComposition m_clzMatchStruct;
    private TypeComposition m_clzRangeOfInt;
    private TypeComposition m_clzRangeArray;

    public xRegEx(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeProperty("pattern");
        this.markNativeMethod("construct", new String[]{"text.String", "numbers.Int64"}, VOID);
        this.markNativeMethod("find", new String[]{"text.String", "numbers.Int64"}, null);
        this.markNativeMethod("match", STRING, null);
        this.markNativeMethod("matchPrefix", STRING, null);
        this.markNativeMethod("replaceAll", new String[]{"text.String", "text.String"}, STRING);
        this.invalidateTypeInfo();
        ConstantPool pool = this.pool();
        ClassTemplate templateMatch = this.f_container.getTemplate("text.Match");
        ClassComposition clzMatch = templateMatch.getCanonicalClass();
        this.m_clzMatchStruct = clzMatch.ensureAccess(Constants.Access.STRUCT);
        this.m_constructorMatch = templateMatch.getStructure().findMethod("construct", 3, new TypeConstant[0]);
        TypeConstant typeRange = pool.ensureRangeType(pool.typeInt64());
        this.m_clzRangeOfInt = this.f_container.resolveClass(typeRange);
        TypeConstant typeRangeArray = pool.ensureArrayType(pool.ensureNullableTypeConstant(typeRange));
        this.m_clzRangeArray = this.f_container.resolveClass(typeRangeArray);
    }

    @Override
    public int construct(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahVar, int iReturn) {
        xString.StringHandle hPattern = (xString.StringHandle)ahVar[0];
        ObjectHandle hFlags = ahVar[1];
        String regex = hPattern.getStringValue();
        long nFlags = hFlags == ObjectHandle.DEFAULT ? 0L : ((ObjectHandle.JavaLong)hFlags).getValue();
        return frame.assignValue(iReturn, this.makeHandle(regex, nFlags));
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        RegExHandle hPattern = (RegExHandle)hTarget;
        if ("pattern".equals(sPropName)) {
            return frame.assignValue(iReturn, xString.makeHandle(hPattern.f_regex));
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "append": {
                RegExHandle hRegEx = (RegExHandle)hTarget;
                String regex = hRegEx.getRegex() + ((RegExHandle)hArg).getRegex();
                long nFlags = hRegEx.getFlags();
                return frame.assignValue(iReturn, this.makeHandle(regex, nFlags));
            }
            case "appendTo": {
                xString.StringHandle hRegex = xString.makeHandle(((RegExHandle)hTarget).getRegex());
                return xString.callAppendTo(frame, hRegex, hArg, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "replaceAll": {
                xString.StringHandle hText = (xString.StringHandle)ahArg[0];
                String text = hText.getStringValue();
                String replacement = ((xString.StringHandle)ahArg[1]).getStringValue();
                Matcher matcher = ((RegExHandle)hTarget).getPattern().matcher(text);
                xString.StringHandle hResult = xString.makeHandle(matcher.replaceAll(replacement));
                return frame.assignValue(iReturn, hResult);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        RegExHandle hRegEx = (RegExHandle)hTarget;
        switch (method.getName()) {
            case "match": {
                xString.StringHandle hText = (xString.StringHandle)ahArg[0];
                Pattern pattern = hRegEx.getPattern();
                Matcher matcher = pattern.matcher(hText.getStringValue());
                if (matcher.matches()) {
                    MatchResult result = matcher.toMatchResult();
                    return Utils.assignConditionalResult(frame, this.createMatchHandle(frame, result, hText, hRegEx, -1), aiReturn);
                }
                return frame.assignValue(aiReturn[0], xBoolean.FALSE);
            }
            case "matchPrefix": {
                xString.StringHandle hText = (xString.StringHandle)ahArg[0];
                Pattern pattern = hRegEx.getPattern();
                Matcher matcher = pattern.matcher(hText.getStringValue());
                if (matcher.lookingAt()) {
                    MatchResult result = matcher.toMatchResult();
                    return Utils.assignConditionalResult(frame, this.createMatchHandle(frame, result, hText, hRegEx, -1), aiReturn);
                }
                return frame.assignValue(aiReturn[0], xBoolean.FALSE);
            }
            case "find": {
                long nStart;
                xString.StringHandle hText = (xString.StringHandle)ahArg[0];
                Pattern pattern = hRegEx.getPattern();
                Matcher matcher = pattern.matcher(hText.getStringValue());
                ObjectHandle hStart = ahArg[1];
                if (hStart instanceof ObjectHandle.JavaLong) {
                    ObjectHandle.JavaLong hInt = (ObjectHandle.JavaLong)hStart;
                    v0 = hInt.getValue();
                } else {
                    v0 = nStart = 0L;
                }
                if (matcher.find((int)nStart)) {
                    MatchResult result = matcher.toMatchResult();
                    return Utils.assignConditionalResult(frame, this.createMatchHandle(frame, result, hText, hRegEx, -1), aiReturn);
                }
                return frame.assignValue(aiReturn[0], xBoolean.FALSE);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof RegExConstant) {
            RegExConstant regex = (RegExConstant)constant;
            return frame.pushStack(this.makeHandle(regex.getValue(), regex.getFlags()));
        }
        return super.createConstHandle(frame, constant);
    }

    public int createMatchHandle(Frame frame, MatchResult match, xString.StringHandle hText, RegExHandle hRegEx, int iReturn) {
        TypeComposition clzRange = this.m_clzRangeOfInt;
        TypeComposition clzStruct = this.m_clzMatchStruct;
        MethodStructure constructor = this.m_constructorMatch;
        ObjectHandle[] ah = new ObjectHandle[match.groupCount() + 1];
        for (int i = 0; i <= match.groupCount(); ++i) {
            int nStart = match.start(i);
            if (nStart >= 0) {
                ObjectHandle.GenericHandle hRange = new ObjectHandle.GenericHandle(clzRange);
                hRange.setField(frame, "lowerBound", (ObjectHandle)xInt64.makeHandle(nStart));
                hRange.setField(frame, "lowerExclusive", (ObjectHandle)xBoolean.FALSE);
                hRange.setField(frame, "upperBound", (ObjectHandle)xInt64.makeHandle(match.end(i)));
                hRange.setField(frame, "upperExclusive", (ObjectHandle)xBoolean.TRUE);
                hRange.setField(frame, "descending", (ObjectHandle)xBoolean.FALSE);
                hRange.makeImmutable();
                ah[i] = hRange;
                continue;
            }
            ah[i] = xNullable.NULL;
        }
        xArray.ArrayHandle hGroups = xArray.makeArrayHandle(this.m_clzRangeArray, ah.length, ah, xArray.Mutability.Fixed);
        ObjectHandle[] ahArgs = new ObjectHandle[]{hRegEx, hText, hGroups};
        ObjectHandle[] ahVar = Utils.ensureSize(ahArgs, constructor.getMaxVars());
        ObjectHandle.GenericHandle hMatch = new ObjectHandle.GenericHandle(clzStruct);
        return this.proceedConstruction(frame, constructor, true, hMatch, ahVar, iReturn);
    }

    private RegExHandle makeHandle(String regex, long nFlags) {
        return new RegExHandle(this.getCanonicalClass(), regex, nFlags);
    }

    public static class RegExHandle
    extends ObjectHandle {
        private final String f_regex;
        private final long f_nFlags;
        private Pattern m_pattern;

        protected RegExHandle(TypeComposition clazz, String regex, long nFlags) {
            super(clazz);
            this.f_regex = regex;
            this.f_nFlags = nFlags;
        }

        public String getRegex() {
            return this.f_regex;
        }

        public long getFlags() {
            return this.f_nFlags;
        }

        public Pattern getPattern() {
            if (this.m_pattern == null) {
                this.m_pattern = Pattern.compile(this.f_regex, (int)this.f_nFlags);
            }
            return this.m_pattern;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof RegExHandle)) return false;
            RegExHandle that = (RegExHandle)obj;
            if (!this.f_regex.equals(that.f_regex)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.f_regex.hashCode();
        }

        @Override
        public String toString() {
            return super.toString() + this.f_regex;
        }
    }
}

