/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.text;

import java.util.Arrays;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.IndexSupport;
import org.xvm.runtime.template._native.collections.arrays.xRTCharDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTSlicingDelegate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xChar;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xOrdered;
import org.xvm.util.Handy;

public class xString
extends xConst
implements IndexSupport {
    public static xString INSTANCE;
    public static StringHandle EMPTY_STRING;
    public static StringHandle EMPTY_ARRAY;
    public static StringHandle ZERO;
    public static StringHandle ONE;
    private static xArray.ArrayHandle EMPTY_STRING_ARRAY;
    private static MethodStructure METHOD_APPEND_TO;

    public xString(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.pool();
        TypeConstant typeArg = pool.ensureClassTypeConstant(pool.ensureEcstasyClassConstant("Appender"), null, pool.typeChar());
        EMPTY_STRING = new StringHandle(this.getCanonicalClass(), new char[0]);
        EMPTY_ARRAY = xString.makeHandle(new char[]{'[', ']'});
        ZERO = xString.makeHandle(new char[]{'0'});
        ONE = xString.makeHandle(new char[]{'1'});
        METHOD_APPEND_TO = this.getStructure().findMethod("appendTo", 1, typeArg);
        this.markNativeProperty("size");
        this.markNativeProperty("chars");
        this.markNativeMethod("construct", new String[]{"collections.Array<text.Char>"}, VOID);
        this.markNativeMethod("construct", STRING, VOID);
        this.markNativeMethod("indexOf", new String[]{"text.Char", "numbers.Int64"}, new String[]{"Boolean", "numbers.Int64"});
        this.markNativeMethod("indexOf", new String[]{"text.String", "numbers.Int64"}, new String[]{"Boolean", "numbers.Int64"});
        this.markNativeMethod("hashCode", null, INT);
        this.markNativeMethod("equals", null, BOOLEAN);
        this.markNativeMethod("compare", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof StringConstant) {
            StringConstant hString = (StringConstant)constant;
            return frame.pushStack(xString.makeHandle(hString.getValue().toCharArray()));
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int construct(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahVar, int iReturn) {
        if (constructor.getIdentityConstant().getRawParams()[0].equals(frame.poolContext().typeString())) {
            return frame.assignValue(iReturn, ahVar[0]);
        }
        return frame.assignValue(iReturn, xString.makeHandle(xString.getChars((xArray.ArrayHandle)ahVar[0])));
    }

    @Override
    public int invokeAdd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        StringHandle hThis = (StringHandle)hTarget;
        switch (Utils.callToString(frame, hArg)) {
            case -1: {
                return frame.assignValue(iReturn, xString.concat(hThis, (StringHandle)frame.popStack()));
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, xString.concat(hThis, (StringHandle)frame.popStack())));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        StringHandle hThis = (StringHandle)hTarget;
        switch (sPropName) {
            case "size": {
                return frame.assignValue(iReturn, xInt64.makeHandle(hThis.m_achValue.length));
            }
            case "chars": {
                return frame.assignValue(iReturn, xArray.makeCharArrayHandle(hThis.m_achValue, xArray.Mutability.Constant));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (ahArg.length) {
            case 2: {
                switch (method.getName()) {
                    case "indexOf": {
                        int ofResult;
                        int ofStart;
                        StringHandle hThis = (StringHandle)hTarget;
                        ObjectHandle hValue = ahArg[0];
                        ObjectHandle hStart = ahArg[1];
                        int n = ofStart = hStart == ObjectHandle.DEFAULT ? 0 : (int)((ObjectHandle.JavaLong)hStart).getValue();
                        if (hValue instanceof ObjectHandle.JavaLong) {
                            ObjectHandle.JavaLong hChar = (ObjectHandle.JavaLong)hValue;
                            char chValue = (char)hChar.getValue();
                            ofResult = xString.indexOf(hThis.m_achValue, chValue, ofStart);
                        } else {
                            String sValue = ((StringHandle)hValue).getStringValue();
                            ofResult = hThis.getStringValue().indexOf(sValue, ofStart);
                        }
                        return ofResult < 0 ? frame.assignValue(aiReturn[0], xBoolean.FALSE) : frame.assignValues(aiReturn, xBoolean.TRUE, xInt64.makeHandle(ofResult));
                    }
                }
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    public int extractArrayValue(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        char[] ach = ((StringHandle)hTarget).getValue();
        int nIx = (int)lIndex;
        return nIx < 0 || nIx >= ach.length ? frame.raiseException(xException.outOfBounds(frame, lIndex, ach.length)) : frame.assignValue(iReturn, xChar.makeHandle(ach[nIx]));
    }

    @Override
    public int assignArrayValue(Frame frame, ObjectHandle hTarget, long lIndex, ObjectHandle hValue) {
        return frame.raiseException(xException.immutableObject(frame));
    }

    @Override
    public TypeConstant getElementType(Frame frame, ObjectHandle hTarget, long lIndex) {
        return this.pool().typeChar();
    }

    @Override
    public long size(ObjectHandle hTarget) {
        return ((StringHandle)hTarget).getValue().length;
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(this.compareIdentity(hValue1, hValue2)));
    }

    @Override
    public int callCompare(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        StringHandle h1 = (StringHandle)hValue1;
        StringHandle h2 = (StringHandle)hValue2;
        return frame.assignValue(iReturn, xOrdered.makeHandle(Arrays.compare(h1.m_achValue, h2.m_achValue)));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        StringHandle h1 = (StringHandle)hValue1;
        StringHandle h2 = (StringHandle)hValue2;
        return Arrays.equals(h1.m_achValue, h2.m_achValue);
    }

    @Override
    public int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        return frame.assignValue(iReturn, ((StringHandle)hTarget).getHashCode());
    }

    private static char[] getChars(xArray.ArrayHandle hArray) {
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        if (hDelegate instanceof xRTSlicingDelegate.SliceHandle) {
            xRTSlicingDelegate.SliceHandle hSlice = (xRTSlicingDelegate.SliceHandle)hDelegate;
            xRTCharDelegate.CharArrayHandle hChars = (xRTCharDelegate.CharArrayHandle)hSlice.f_hSource;
            return xRTCharDelegate.getChars(hChars, (int)hSlice.f_ofStart, (int)hSlice.m_cSize, hSlice.f_fReverse);
        }
        if (hDelegate instanceof xRTCharDelegate.CharArrayHandle) {
            xRTCharDelegate.CharArrayHandle hChars = (xRTCharDelegate.CharArrayHandle)hDelegate;
            return xRTCharDelegate.getChars(hChars, 0, (int)hChars.m_cSize, false);
        }
        throw new UnsupportedOperationException();
    }

    private static StringHandle concat(StringHandle h1, StringHandle h2) {
        char[] ach1 = h1.m_achValue;
        char[] ach2 = h2.m_achValue;
        int c1 = ach1.length;
        int c2 = ach2.length;
        if (c1 == 0) {
            return h2;
        }
        if (c2 == 0) {
            return h1;
        }
        char[] ach = new char[c1 + c2];
        System.arraycopy(ach1, 0, ach, 0, c1);
        System.arraycopy(ach2, 0, ach, c1, c2);
        return xString.makeHandle(ach);
    }

    private static int indexOf(char[] achSource, char chTarget, int ofStart) {
        int cchSource = achSource.length;
        if (ofStart < 0) {
            ofStart = 0;
        } else if (ofStart >= cchSource) {
            return -1;
        }
        if (chTarget < '\u10000') {
            for (int of = ofStart; of < cchSource; ++of) {
                if (achSource[of] != chTarget) continue;
                return of;
            }
        }
        return -1;
    }

    public static int callAppendTo(Frame frame, StringHandle hString, ObjectHandle hAppender, int iReturn) {
        ObjectHandle[] ahArg = new ObjectHandle[METHOD_APPEND_TO.getMaxVars()];
        ahArg[0] = hAppender;
        return frame.call1(METHOD_APPEND_TO, hString, ahArg, iReturn);
    }

    public static StringHandle makeHandle(String sValue) {
        return xString.makeHandle(sValue.toCharArray());
    }

    public static StringHandle makeHandle(char[] achValue) {
        return achValue.length == 0 ? EMPTY_STRING : new StringHandle(INSTANCE.getCanonicalClass(), achValue);
    }

    public static xArray.ArrayHandle makeArrayHandle(String[] asValue) {
        int cValues = asValue.length;
        StringHandle[] ahValue = new StringHandle[cValues];
        for (int i = 0; i < cValues; ++i) {
            ahValue[i] = xString.makeHandle(asValue[i]);
        }
        return xArray.makeStringArrayHandle(ahValue);
    }

    public static xArray.ArrayHandle ensureEmptyArray() {
        if (EMPTY_STRING_ARRAY == null) {
            EMPTY_STRING_ARRAY = xArray.makeStringArrayHandle(Utils.STRINGS_NONE);
        }
        return EMPTY_STRING_ARRAY;
    }

    public static class StringHandle
    extends ObjectHandle {
        private final char[] m_achValue;
        private transient ObjectHandle.JavaLong m_hash;
        private transient String m_sValue;

        protected StringHandle(TypeComposition clazz, char[] achValue) {
            super(clazz);
            this.m_achValue = achValue;
        }

        public char[] getValue() {
            return this.m_achValue;
        }

        public String getStringValue() {
            String sValue = this.m_sValue;
            return sValue == null ? (this.m_sValue = new String(this.m_achValue)) : sValue;
        }

        public int calcHashCode() {
            char[] ach = this.m_achValue;
            int cch = ach.length;
            int hash = 982451653;
            if (cch <= 64) {
                for (char ch : ach) {
                    hash = hash * 31 + ch;
                }
            } else {
                int cchStep = (cch >>> 6) + 1;
                for (int of = 0; of < cch; of += cchStep) {
                    hash = hash * 31 + ach[of];
                }
            }
            return hash;
        }

        public ObjectHandle.JavaLong getHashCode() {
            ObjectHandle.JavaLong hHash = this.m_hash;
            return hHash == null ? (this.m_hash = xInt64.makeHandle(this.calcHashCode())) : hHash;
        }

        @Override
        public int hashCode() {
            return (int)this.getHashCode().getValue();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof StringHandle) {
                StringHandle that = (StringHandle)obj;
                return Arrays.equals(this.m_achValue, that.m_achValue);
            }
            return false;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append('\"');
            Handy.appendString(sb, this.getStringValue());
            return sb.append('\"').toString();
        }
    }
}

