/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.ByteConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.RangeConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xOrdered;

public class xConst
extends ClassTemplate {
    public static xConst INSTANCE;
    private static final String PROP_HASH = "@hash";
    private static final ClassComposition.FieldInfo[] NO_FIELDS;
    private static MethodStructure FN_ESTIMATE_LENGTH;
    private static MethodStructure FN_APPEND_TO;
    private static MethodStructure FN_FREEZE;
    private static MethodStructure RANGE_CONSTRUCT;
    private static MethodStructure NIBBLE_CONSTRUCT;
    private static MethodStructure TIME_CONSTRUCT;
    private static MethodStructure DATE_CONSTRUCT;
    private static MethodStructure TIMEOFDAY_CONSTRUCT;
    private static MethodStructure DURATION_CONSTRUCT;
    private static MethodStructure VERSION_CONSTRUCT;
    private static MethodStructure PATH_CONSTRUCT;
    private static SignatureConstant HASH_SIG;

    public xConst(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    protected Set<String> registerImplicitFields(Set<String> setFields) {
        if (setFields == null) {
            setFields = new HashSet<String>();
        }
        setFields.add(PROP_HASH);
        return super.registerImplicitFields(setFields);
    }

    @Override
    public void initNative() {
        if (this == INSTANCE) {
            this.getStructure().findMethod("equals", 3, new TypeConstant[0]).markNative();
            this.getStructure().findMethod("compare", 3, new TypeConstant[0]).markNative();
            this.getStructure().findMethod("hashCode", 2, new TypeConstant[0]).markNative();
            this.invalidateTypeInfo();
            FN_ESTIMATE_LENGTH = Utils.CONST_HELPER.findMethod("estimateStringLength", 2, new TypeConstant[0]);
            FN_APPEND_TO = Utils.CONST_HELPER.findMethod("appendTo", 3, new TypeConstant[0]);
            FN_FREEZE = Utils.CONST_HELPER.findMethod("freeze", 1, new TypeConstant[0]);
            RANGE_CONSTRUCT = this.f_container.getClassStructure("Range").findMethod("construct", 4, new TypeConstant[0]);
            ConstantPool pool = this.pool();
            TypeConstant typeBitArray = pool.ensureArrayType(pool.typeBit());
            NIBBLE_CONSTRUCT = this.f_container.getClassStructure("numbers.Nibble").findMethod("construct", 1, typeBitArray);
            TIME_CONSTRUCT = this.f_container.getClassStructure("temporal.Time").findMethod("construct", 1, pool.typeString());
            DATE_CONSTRUCT = this.f_container.getClassStructure("temporal.Date").findMethod("construct", 1, pool.typeString());
            TIMEOFDAY_CONSTRUCT = this.f_container.getClassStructure("temporal.TimeOfDay").findMethod("construct", 1, pool.typeString());
            DURATION_CONSTRUCT = this.f_container.getClassStructure("temporal.Duration").findMethod("construct", 1, pool.typeString());
            VERSION_CONSTRUCT = this.f_container.getClassStructure("reflect.Version").findMethod("construct", 1, pool.typeString());
            PATH_CONSTRUCT = this.f_container.getClassStructure("fs.Path").findMethod("construct", 1, pool.typeString());
            HASH_SIG = this.f_container.getClassStructure("collections.Hashable").findMethod("hashCode", 2, new TypeConstant[0]).getIdentityConstant().getSignature();
        }
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        block12: {
            if (constant instanceof RangeConstant) {
                RangeConstant constRange = (RangeConstant)constant;
                ObjectHandle h1 = frame.getConstHandle(constRange.getFirst());
                ObjectHandle h2 = frame.getConstHandle(constRange.getLast());
                xBoolean.BooleanHandle f1 = xBoolean.makeHandle(constRange.isFirstExcluded());
                xBoolean.BooleanHandle f2 = xBoolean.makeHandle(constRange.isLastExcluded());
                TypeConstant typeRange = constRange.getType();
                TypeComposition clzRange = typeRange.ensureClass(frame);
                MethodStructure constructor = RANGE_CONSTRUCT;
                ObjectHandle[] ahArg = new ObjectHandle[constructor.getMaxVars()];
                ahArg[0] = h1;
                ahArg[1] = h2;
                ahArg[2] = f1;
                ahArg[3] = f2;
                if (Op.anyDeferred(ahArg)) {
                    Frame.Continuation stepNext = frameCaller -> clzRange.getTemplate().construct(frameCaller, constructor, clzRange, null, ahArg, -1);
                    return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
                }
                return clzRange.getTemplate().construct(frame, constructor, clzRange, null, ahArg, -1);
            }
            if (constant instanceof LiteralConstant) {
                MethodStructure constructor;
                TypeComposition clz;
                LiteralConstant constLiteral = (LiteralConstant)constant;
                ConstantPool pool = frame.poolContext();
                Container container = this.f_container;
                switch (constant.getFormat()) {
                    case Time: {
                        clz = this.ensureClass(container, pool.typeTime());
                        constructor = TIME_CONSTRUCT;
                        break;
                    }
                    case Date: {
                        clz = this.ensureClass(container, pool.typeDate());
                        constructor = DATE_CONSTRUCT;
                        break;
                    }
                    case TimeOfDay: {
                        clz = this.ensureClass(container, pool.typeTimeOfDay());
                        constructor = TIMEOFDAY_CONSTRUCT;
                        break;
                    }
                    case Duration: {
                        clz = this.ensureClass(container, pool.typeDuration());
                        constructor = DURATION_CONSTRUCT;
                        break;
                    }
                    case Version: {
                        clz = this.ensureClass(container, pool.typeVersion());
                        constructor = VERSION_CONSTRUCT;
                        break;
                    }
                    case Path: {
                        clz = this.ensureClass(container, pool.typePath());
                        constructor = PATH_CONSTRUCT;
                        break;
                    }
                    default: {
                        break block12;
                    }
                }
                ObjectHandle[] ahArg = new ObjectHandle[constructor.getMaxVars()];
                ahArg[0] = xString.makeHandle(constLiteral.getValue());
                return this.construct(frame, constructor, clz, null, ahArg, -1);
            }
        }
        if (constant.getFormat() == Constant.Format.Nibble) {
            byte[] abValue = new byte[]{(byte)(((ByteConstant)constant).getValue().byteValue() << 4)};
            ObjectHandle[] ahArg = new ObjectHandle[NIBBLE_CONSTRUCT.getMaxVars()];
            ahArg[0] = xArray.makeBitArrayHandle(abValue, 4, xArray.Mutability.Constant);
            return this.construct(frame, NIBBLE_CONSTRUCT, this.ensureClass(frame.f_context.f_container, constant.getType()), null, ahArg, -1);
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    protected int postValidate(Frame frame, ObjectHandle hStruct) {
        if (hStruct.isMutable()) {
            ObjectHandle.GenericHandle hConst = (ObjectHandle.GenericHandle)hStruct;
            if (hConst.containsMutableFields()) {
                TypeComposition clz = hStruct.getComposition();
                ArrayList<ObjectHandle> listFreezable = null;
                ArrayList<ClassComposition.FieldInfo> listInfo = null;
                ArrayList<TypeConstant> listTypes = null;
                for (ClassComposition.FieldInfo field : clz.getFieldLayout().values()) {
                    ObjectHandle hField;
                    if (field.isTransient() || field.isSynthetic() || field.isLazy() || (hField = hConst.getField(field.getIndex())) == null || hField.isPassThrough()) continue;
                    String sName = field.getName();
                    if (hField.getType().isA(frame.poolContext().typeFreezable())) {
                        if (listFreezable == null) {
                            listFreezable = new ArrayList<ObjectHandle>();
                            listInfo = new ArrayList<ClassComposition.FieldInfo>();
                            listTypes = new ArrayList<TypeConstant>();
                        }
                        listFreezable.add(hField);
                        listInfo.add(field);
                        listTypes.add(hField.getType());
                        continue;
                    }
                    return frame.raiseException(xException.notFreezableProperty(frame, sName, hConst.getType()));
                }
                if (listFreezable != null) {
                    ObjectHandle[] ahFreezable = listFreezable.toArray(Utils.OBJECTS_NONE);
                    ClassComposition.FieldInfo[] aFieldInfo = listInfo.toArray(NO_FIELDS);
                    TypeConstant[] atype = listTypes.toArray(TypeConstant.NO_TYPES);
                    xArray.ArrayHandle haValues = xArray.makeObjectArrayHandle(ahFreezable, xArray.Mutability.Fixed);
                    ObjectHandle[] ahVars = new ObjectHandle[FN_FREEZE.getMaxVars()];
                    ahVars[0] = haValues;
                    Frame frameFreeze = frame.createFrame1(FN_FREEZE, null, ahVars, -2);
                    frameFreeze.addContinuation(frameCaller -> {
                        ObjectHandle[] ahValueNew;
                        try {
                            ahValueNew = haValues.getTemplate().toArray(frameCaller, haValues);
                        }
                        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
                            return frameCaller.raiseException(e);
                        }
                        int c = aFieldInfo.length;
                        for (int i = 0; i < c; ++i) {
                            ClassComposition.FieldInfo field = aFieldInfo[i];
                            ObjectHandle hNew = ahValueNew[i];
                            TypeConstant typeOld = field.getType();
                            TypeConstant typeNew = hNew.getType();
                            if (!typeNew.isA(typeOld)) {
                                return frameCaller.raiseException("The freeze() result type for the \"" + field.getName() + "\" field was illegally changed; \"" + typeOld.freeze().getValueString() + "\" expected, \"" + typeNew.getValueString() + "\" returned");
                            }
                            hConst.setField(field.getIndex(), hNew);
                        }
                        hConst.makeImmutable();
                        return -1;
                    });
                    return frame.callInitialized(frameFreeze);
                }
            }
            hConst.makeImmutable();
        }
        return -1;
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        if (method.getName().equals("appendTo")) {
            return this.callAppendTo(frame, hTarget, hArg, iReturn);
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "compare": {
                Container container = frame.f_context.f_container;
                xRTType.TypeHandle hType = (xRTType.TypeHandle)ahArg[0];
                xConst template = this;
                ClassTemplate classTemplate = container.getTemplate(hType.getDataType());
                if (classTemplate instanceof xConst) {
                    xConst templateConst;
                    template = templateConst = (xConst)classTemplate;
                }
                return template.callCompare(frame, this.getCanonicalClass(container), ahArg[1], ahArg[2], iReturn);
            }
            case "estimateStringLength": {
                return this.callEstimateLength(frame, hTarget, iReturn);
            }
            case "equals": {
                Container container = frame.f_context.f_container;
                xRTType.TypeHandle hType = (xRTType.TypeHandle)ahArg[0];
                xConst template = this;
                ClassTemplate classTemplate = container.getTemplate(hType.getDataType());
                if (classTemplate instanceof xConst) {
                    xConst templateConst;
                    template = templateConst = (xConst)classTemplate;
                }
                return template.callEquals(frame, this.getCanonicalClass(container), ahArg[1], ahArg[2], iReturn);
            }
            case "hashCode": {
                xRTType.TypeHandle hType = (xRTType.TypeHandle)ahArg[0];
                return this.callHashCode(frame, hType.getDataType(), ahArg[1], iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    protected int callEqualsImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return this == INSTANCE ? frame.raiseException(xException.abstractMethod(frame, "Const.compare()")) : new Equals((ObjectHandle.GenericHandle)hValue1, (ObjectHandle.GenericHandle)hValue2, (ClassComposition)clazz, iReturn).doNext(frame);
    }

    @Override
    protected int callCompareImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return this == INSTANCE ? frame.raiseException(xException.abstractMethod(frame, "Const.compare()")) : new Compare((ObjectHandle.GenericHandle)hValue1, (ObjectHandle.GenericHandle)hValue2, (ClassComposition)clazz, iReturn).doNext(frame);
    }

    public int callHashCode(Frame frame, TypeConstant type, ObjectHandle hValue, int iReturn) {
        return this == INSTANCE ? frame.raiseException(xException.abstractMethod(frame, "Const.hashCode()")) : this.buildHashCode(frame, this.getCanonicalClass(frame.f_context.f_container), hValue, iReturn);
    }

    protected int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        ObjectHandle.JavaLong hHash;
        ObjectHandle.GenericHandle hConst = (ObjectHandle.GenericHandle)hTarget;
        boolean fCache = hConst.getComposition().equals(clazz);
        if (fCache && (hHash = (ObjectHandle.JavaLong)hConst.getField(frame, PROP_HASH)) != null) {
            return frame.assignValue(iReturn, hHash);
        }
        return new HashCode(hConst, (ClassComposition)clazz, fCache, iReturn).doNext(frame);
    }

    protected int callEstimateLength(Frame frame, ObjectHandle hTarget, int iReturn) {
        ObjectHandle.GenericHandle hConst = (ObjectHandle.GenericHandle)hTarget;
        TypeComposition clz = hConst.getComposition();
        xString.StringHandle[] ahNames = clz.getFieldNameArray();
        ObjectHandle[] ahFields = clz.getFieldValueArray(frame, hConst);
        if (ahNames.length > 0) {
            xArray.ArrayHandle hNames = xArray.makeStringArrayHandle(ahNames);
            xArray.ArrayHandle hValues = xArray.makeObjectArrayHandle(ahFields, xArray.Mutability.Constant);
            ObjectHandle[] ahVars = new ObjectHandle[FN_ESTIMATE_LENGTH.getMaxVars()];
            ahVars[0] = hNames;
            ahVars[1] = hValues;
            return frame.call1(FN_ESTIMATE_LENGTH, null, ahVars, iReturn);
        }
        return frame.assignValue(iReturn, xInt64.makeHandle(0L));
    }

    protected int callAppendTo(Frame frame, ObjectHandle hTarget, ObjectHandle hAppender, int iReturn) {
        ObjectHandle.GenericHandle hConst = (ObjectHandle.GenericHandle)hTarget;
        TypeComposition clz = hConst.getComposition();
        xString.StringHandle[] ahNames = clz.getFieldNameArray();
        ObjectHandle[] ahFields = clz.getFieldValueArray(frame, hConst);
        xArray.ArrayHandle hNames = xArray.makeStringArrayHandle(ahNames);
        xArray.ArrayHandle hValues = xArray.makeObjectArrayHandle(ahFields, xArray.Mutability.Constant);
        ObjectHandle[] ahVars = new ObjectHandle[FN_APPEND_TO.getMaxVars()];
        ahVars[0] = hAppender;
        ahVars[1] = hNames;
        ahVars[2] = hValues;
        return frame.call1(FN_APPEND_TO, null, ahVars, iReturn);
    }

    static {
        NO_FIELDS = new ClassComposition.FieldInfo[0];
    }

    protected static class Equals
    implements Frame.Continuation {
        private final ObjectHandle.GenericHandle hValue1;
        private final ObjectHandle.GenericHandle hValue2;
        private final ClassComposition clzBase;
        private final int iReturn;
        private final Iterator<Map.Entry<Object, ClassComposition.FieldInfo>> iterFields;

        public Equals(ObjectHandle.GenericHandle hValue1, ObjectHandle.GenericHandle hValue2, ClassComposition clzBase, int iReturn) {
            this.hValue1 = hValue1;
            this.hValue2 = hValue2;
            this.clzBase = clzBase;
            this.iReturn = iReturn;
            this.iterFields = clzBase.getFieldLayout().entrySet().iterator();
        }

        @Override
        public int proceed(Frame frameCaller) {
            ObjectHandle hResult = frameCaller.popStack();
            if (hResult == xBoolean.FALSE) {
                return frameCaller.assignValue(this.iReturn, hResult);
            }
            return this.doNext(frameCaller);
        }

        public int doNext(Frame frameCaller) {
            ConstantPool pool = frameCaller.poolContext();
            TypeComposition clz1 = this.hValue1.getComposition();
            TypeComposition clz2 = this.hValue2.getComposition();
            block5: while (this.iterFields.hasNext()) {
                ObjectHandle h2;
                ObjectHandle h1;
                Map.Entry<Object, ClassComposition.FieldInfo> entry = this.iterFields.next();
                Object enid = entry.getKey();
                ClassComposition.FieldInfo field = entry.getValue();
                if (enid instanceof IdentityConstant.NestedIdentity || !field.isRegular()) continue;
                if (clz1 == this.clzBase) {
                    v0 = this.hValue1.getField(field.getIndex());
                } else if (enid instanceof PropertyConstant) {
                    PropertyConstant idProp = (PropertyConstant)enid;
                    v0 = this.hValue1.getField(frameCaller, idProp);
                } else {
                    v0 = h1 = this.hValue1.getField(frameCaller, enid.toString());
                }
                if (clz2 == this.clzBase) {
                    v1 = this.hValue2.getField(field.getIndex());
                } else if (enid instanceof PropertyConstant) {
                    PropertyConstant idProp = (PropertyConstant)enid;
                    v1 = this.hValue2.getField(frameCaller, idProp);
                } else {
                    v1 = h2 = this.hValue2.getField(frameCaller, enid.toString());
                }
                if (h1 == null || h2 == null) {
                    return frameCaller.raiseException("Unassigned property \"" + field.getName() + "\"");
                }
                TypeConstant typeProp = (TypeConstant)pool.register(this.clzBase.getFieldType(enid));
                typeProp = typeProp.resolveGenerics(pool, frameCaller.getGenericsResolver(typeProp.containsDynamicType()));
                switch (typeProp.callEquals(frameCaller, h1, h2, -1)) {
                    case -1: {
                        ObjectHandle hResult = frameCaller.popStack();
                        if (hResult != xBoolean.FALSE) continue block5;
                        return frameCaller.assignValue(this.iReturn, hResult);
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
            return frameCaller.assignValue(this.iReturn, xBoolean.TRUE);
        }
    }

    protected static class Compare
    implements Frame.Continuation {
        private final ObjectHandle.GenericHandle hValue1;
        private final ObjectHandle.GenericHandle hValue2;
        private final ClassComposition clzBase;
        private final int iReturn;
        private final Iterator<Map.Entry<Object, ClassComposition.FieldInfo>> iterFields;

        public Compare(ObjectHandle.GenericHandle hValue1, ObjectHandle.GenericHandle hValue2, ClassComposition clzBase, int iReturn) {
            this.hValue1 = hValue1;
            this.hValue2 = hValue2;
            this.clzBase = clzBase;
            this.iReturn = iReturn;
            this.iterFields = clzBase.getFieldLayout().entrySet().iterator();
        }

        @Override
        public int proceed(Frame frameCaller) {
            xEnum.EnumHandle hResult = (xEnum.EnumHandle)frameCaller.popStack();
            if (hResult != xOrdered.EQUAL) {
                return frameCaller.assignValue(this.iReturn, hResult);
            }
            return this.doNext(frameCaller);
        }

        public int doNext(Frame frameCaller) {
            ConstantPool pool = frameCaller.poolContext();
            TypeComposition clz1 = this.hValue1.getComposition();
            TypeComposition clz2 = this.hValue2.getComposition();
            block5: while (this.iterFields.hasNext()) {
                ObjectHandle h2;
                ObjectHandle h1;
                Map.Entry<Object, ClassComposition.FieldInfo> entry = this.iterFields.next();
                Object enid = entry.getKey();
                ClassComposition.FieldInfo field = entry.getValue();
                if (enid instanceof IdentityConstant.NestedIdentity || !field.isRegular()) continue;
                if (clz1 == this.clzBase) {
                    v0 = this.hValue1.getField(field.getIndex());
                } else if (enid instanceof PropertyConstant) {
                    PropertyConstant idProp = (PropertyConstant)enid;
                    v0 = this.hValue1.getField(frameCaller, idProp);
                } else {
                    v0 = h1 = this.hValue1.getField(frameCaller, enid.toString());
                }
                if (clz2 == this.clzBase) {
                    v1 = this.hValue2.getField(field.getIndex());
                } else if (enid instanceof PropertyConstant) {
                    PropertyConstant idProp = (PropertyConstant)enid;
                    v1 = this.hValue2.getField(frameCaller, idProp);
                } else {
                    v1 = h2 = this.hValue2.getField(frameCaller, enid.toString());
                }
                if (h1 == null || h2 == null) {
                    return frameCaller.raiseException("Unassigned property \"" + field.getName() + "\"");
                }
                TypeConstant typeProp = (TypeConstant)pool.register(this.clzBase.getFieldType(enid));
                if (typeProp.findCallable(pool.sigCompare()) == null) {
                    return frameCaller.raiseException("Property \"" + field.getName() + "\" is not Orderable");
                }
                switch (typeProp.callCompare(frameCaller, h1, h2, -1)) {
                    case -1: {
                        xEnum.EnumHandle hResult = (xEnum.EnumHandle)frameCaller.popStack();
                        if (hResult == xOrdered.EQUAL) continue block5;
                        return frameCaller.assignValue(this.iReturn, hResult);
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
            return frameCaller.assignValue(this.iReturn, xOrdered.EQUAL);
        }
    }

    protected static class HashCode
    implements Frame.Continuation {
        private final ObjectHandle.GenericHandle hConst;
        private final ClassComposition clzBase;
        private final boolean fCache;
        private final int iReturn;
        private long lResult;
        private final Iterator<Map.Entry<Object, ClassComposition.FieldInfo>> iterFields;

        public HashCode(ObjectHandle.GenericHandle hConst, ClassComposition clzBase, boolean fCache, int iReturn) {
            this.hConst = hConst;
            this.clzBase = clzBase;
            this.fCache = fCache;
            this.iReturn = iReturn;
            this.iterFields = clzBase.getFieldLayout().entrySet().iterator();
        }

        @Override
        public int proceed(Frame frameCaller) {
            this.updateResult(frameCaller);
            return this.doNext(frameCaller);
        }

        protected void updateResult(Frame frameCaller) {
            this.lResult = 37L * this.lResult + ((ObjectHandle.JavaLong)frameCaller.popStack()).getValue();
        }

        protected int doNext(Frame frameCaller) {
            Container container = frameCaller.f_context.f_container;
            ConstantPool pool = frameCaller.poolContext();
            TypeComposition clz = this.hConst.getComposition();
            block5: while (this.iterFields.hasNext()) {
                int iResult;
                ObjectHandle hProp;
                Map.Entry<Object, ClassComposition.FieldInfo> entry = this.iterFields.next();
                Object enid = entry.getKey();
                ClassComposition.FieldInfo field = entry.getValue();
                if (enid instanceof IdentityConstant.NestedIdentity || !field.isRegular()) continue;
                if (clz == this.clzBase) {
                    v0 = this.hConst.getField(field.getIndex());
                } else if (enid instanceof PropertyConstant) {
                    PropertyConstant idProp = (PropertyConstant)enid;
                    v0 = this.hConst.getField(frameCaller, idProp);
                } else {
                    v0 = hProp = this.hConst.getField(frameCaller, enid.toString());
                }
                if (hProp == null) {
                    return frameCaller.raiseException("Unassigned property: \"" + field.getName() + "\"");
                }
                TypeConstant typeProp = (TypeConstant)pool.register(this.clzBase.getFieldType(enid));
                MethodStructure methodHash = (typeProp = typeProp.resolveGenerics(pool, frameCaller.getGenericsResolver(typeProp.containsDynamicType()))).findCallable(HASH_SIG);
                if (methodHash == null) continue;
                if (methodHash.isNative()) {
                    iResult = hProp.getTemplate().invokeNativeN(frameCaller, methodHash, null, new ObjectHandle[]{typeProp.ensureTypeHandle(container), hProp}, -1);
                } else {
                    ObjectHandle[] ahVar = new ObjectHandle[methodHash.getMaxVars()];
                    ahVar[0] = typeProp.ensureTypeHandle(container);
                    ahVar[1] = hProp;
                    iResult = frameCaller.call1(methodHash, null, ahVar, -1);
                }
                switch (iResult) {
                    case -1: {
                        this.updateResult(frameCaller);
                        continue block5;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
            ObjectHandle.JavaLong hHash = xInt64.makeHandle(this.lResult);
            if (this.fCache) {
                this.hConst.setField(frameCaller, xConst.PROP_HASH, (ObjectHandle)hHash);
            }
            return frameCaller.assignValue(this.iReturn, hHash);
        }
    }
}

