/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xOrdered;

public class xEnum
extends xConst {
    public static xEnum INSTANCE;
    private static ClassTemplate RANGE_TEMPLATE;
    private static MethodStructure RANGE_CTOR;
    protected List<String> m_listNames;
    protected List<EnumHandle> m_listHandles;

    public xEnum(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        if (this == INSTANCE) {
            RANGE_TEMPLATE = this.f_container.getTemplate("Range");
            RANGE_CTOR = RANGE_TEMPLATE.getStructure().findMethod("construct", 4, new TypeConstant[0]);
        } else if (this.getStructure().getFormat() == Component.Format.ENUM) {
            Collection<? extends Component> listAll = this.getStructure().children();
            ArrayList<String> listNames = new ArrayList<String>(listAll.size());
            ArrayList<EnumHandle> listHandles = new ArrayList<EnumHandle>(listAll.size());
            int iOrdinal = 0;
            for (Component component : listAll) {
                if (component.getFormat() != Component.Format.ENUMVALUE) continue;
                TypeConstant type = ((ClassStructure)component).getCanonicalType();
                EnumHandle hValue = this.makeEnumHandle(this.ensureClass(this.f_container, type, type), iOrdinal++);
                listNames.add(component.getName());
                listHandles.add(hValue);
                if (hValue.isStruct()) continue;
                this.pool().ensureSingletonConstConstant(component.getIdentityConstant()).setHandle(hValue);
            }
            this.m_listNames = listNames;
            this.m_listHandles = listHandles;
        }
    }

    @Override
    public TypeComposition ensureClass(Container container, TypeConstant typeActual) {
        return this.ensureClass(container, typeActual, typeActual);
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof SingletonConstant) {
            SingletonConstant constValue = (SingletonConstant)constant;
            ObjectHandle hValue = constValue.getHandle();
            if (hValue != null) {
                return frame.pushStack(hValue);
            }
            assert (this.getStructure().getFormat() == Component.Format.ENUMVALUE);
            xEnum templateEnum = (xEnum)this.getSuper();
            EnumHandle hEnum = templateEnum.getEnumByConstant(constValue.getClassConstant());
            constValue.setHandle(hEnum);
            return hEnum.isStruct() ? this.completeConstruction(frame, hEnum) : frame.pushStack(hEnum);
        }
        return super.createConstHandle(frame, constant);
    }

    public int completeConstruction(Frame frame, EnumHandle hStruct) {
        assert (hStruct.isStruct());
        MethodStructure ctor = hStruct.getStructure().findConstructor(TypeConstant.NO_TYPES);
        ObjectHandle[] ahVar = Utils.ensureSize(Utils.OBJECTS_NONE, ctor.getMaxVars());
        switch (this.proceedConstruction(frame, ctor, true, hStruct, ahVar, -1)) {
            case -1: {
                hStruct.getTemplate().replaceHandle((EnumHandle)frame.peekStack());
                return -1;
            }
            case -5: {
                Frame.Continuation contNext = frameCaller -> {
                    EnumHandle hEnum = (EnumHandle)frameCaller.peekStack();
                    hEnum.getTemplate().replaceHandle(hEnum);
                    return -1;
                };
                frame.m_frameNext.addContinuation(contNext);
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        EnumHandle hThis = (EnumHandle)hTarget;
        switch (sPropName) {
            case "enumeration": {
                IdentityConstant idValue = (IdentityConstant)hTarget.getType().getDefiningConstant();
                ClassStructure clzEnumeration = ((ClassStructure)idValue.getComponent()).getSuper();
                return frame.assignDeferredValue(iReturn, frame.getConstHandle(clzEnumeration.getIdentityConstant()));
            }
            case "name": {
                return frame.assignValue(iReturn, xString.makeHandle(this.m_listNames.get(hThis.getOrdinal())));
            }
            case "ordinal": {
                return frame.assignValue(iReturn, xInt64.makeHandle(hThis.getOrdinal()));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        EnumHandle hThis = (EnumHandle)hTarget;
        if (method.getName().equals("stepsTo")) {
            EnumHandle hThat = (EnumHandle)hTarget;
            return frame.assignValue(iReturn, xInt64.makeHandle(hThis.getOrdinal() - hThat.getOrdinal()));
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(this.compareIdentity(hValue1, hValue2)));
    }

    @Override
    public int callCompare(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        EnumHandle hEnum1 = (EnumHandle)hValue1;
        EnumHandle hEnum2 = (EnumHandle)hValue2;
        return frame.assignValue(iReturn, xOrdered.makeHandle(hEnum1.getOrdinal() - hEnum2.getOrdinal()));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        return ((EnumHandle)hValue1).getOrdinal() == ((EnumHandle)hValue2).getOrdinal();
    }

    @Override
    public int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        EnumHandle hThis = (EnumHandle)hTarget;
        return frame.assignValue(iReturn, xInt64.makeHandle(hThis.getOrdinal()));
    }

    @Override
    protected int buildStringValue(Frame frame, ObjectHandle hTarget, int iReturn) {
        EnumHandle hThis = (EnumHandle)hTarget;
        return frame.assignValue(iReturn, xString.makeHandle(this.m_listNames.get(hThis.getOrdinal())));
    }

    @Override
    public int invokeIRangeI(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.createRange(frame, (EnumHandle)hTarget, (EnumHandle)hArg, false, false, iReturn);
    }

    @Override
    public int invokeERangeI(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.createRange(frame, (EnumHandle)hTarget, (EnumHandle)hArg, true, false, iReturn);
    }

    @Override
    public int invokeIRangeE(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.createRange(frame, (EnumHandle)hTarget, (EnumHandle)hArg, false, true, iReturn);
    }

    @Override
    public int invokeERangeE(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return this.createRange(frame, (EnumHandle)hTarget, (EnumHandle)hArg, true, true, iReturn);
    }

    private int createRange(Frame frame, EnumHandle hFirst, EnumHandle hLast, boolean fFirstEx, boolean fLastEx, int iReturn) {
        ConstantPool pool = frame.poolContext();
        TypeConstant typeRange = pool.ensureParameterizedTypeConstant(pool.typeRange(), this.getCanonicalType());
        ObjectHandle[] ahVar = new ObjectHandle[]{hFirst, hLast, xBoolean.makeHandle(fFirstEx), xBoolean.makeHandle(fLastEx)};
        return RANGE_TEMPLATE.construct(frame, RANGE_CTOR, typeRange.ensureClass(frame), null, ahVar, iReturn);
    }

    protected EnumHandle makeEnumHandle(TypeComposition clz, int iOrdinal) {
        return new EnumHandle(clz.ensureAccess(Constants.Access.STRUCT), iOrdinal);
    }

    public EnumHandle getEnumByName(String sName) {
        int ix = this.m_listNames.indexOf(sName);
        return ix >= 0 ? this.m_listHandles.get(ix) : null;
    }

    public EnumHandle getEnumByOrdinal(int ix) {
        return ix >= 0 ? this.m_listHandles.get(ix) : null;
    }

    public EnumHandle getEnumByConstant(IdentityConstant id) {
        ClassStructure clzThis = this.getStructure();
        assert (clzThis.getFormat() == Component.Format.ENUM);
        int i = 0;
        for (Component component : clzThis.children()) {
            if (component.getFormat() != Component.Format.ENUMVALUE) continue;
            if (component.getIdentityConstant().equals(id)) {
                return this.getEnumByOrdinal(i);
            }
            ++i;
        }
        return null;
    }

    public String getNameByOrdinal(int ix) {
        return this.m_listNames.get(ix);
    }

    public List<String> getNames() {
        return this.m_listNames;
    }

    public List<EnumHandle> getValues() {
        return this.m_listHandles;
    }

    private void replaceHandle(EnumHandle hEnum) {
        assert (!hEnum.isStruct());
        hEnum.makeImmutable();
        this.m_listHandles.set(hEnum.m_index, hEnum);
    }

    public static class EnumHandle
    extends ObjectHandle.GenericHandle {
        protected int m_index;

        EnumHandle(TypeComposition clz, int index) {
            super(clz);
            this.m_index = index;
            this.m_fMutable = clz.isStruct();
        }

        public int getOrdinal() {
            return this.m_index;
        }

        @Override
        public boolean isNativeEqual() {
            return true;
        }

        @Override
        public int compareTo(ObjectHandle that) {
            return this.getOrdinal() - ((EnumHandle)that).getOrdinal();
        }

        @Override
        public int hashCode() {
            return this.m_index;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof EnumHandle)) return false;
            EnumHandle that = (EnumHandle)obj;
            if (this.getTemplate() != that.getTemplate()) return false;
            if (this.m_index != that.m_index) return false;
            return true;
        }

        public ClassStructure getStructure() {
            xEnum templateEnum = this.getTemplate();
            String sName = templateEnum.getNameByOrdinal(this.m_index);
            return (ClassStructure)templateEnum.getStructure().getChild(sName);
        }

        public String getName() {
            return this.getTemplate().getNameByOrdinal(this.m_index);
        }

        @Override
        public xEnum getTemplate() {
            return (xEnum)super.getTemplate();
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

