/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template;

import java.util.List;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xNullable;

public class xException
extends xConst {
    public static xException INSTANCE;
    private static ClassComposition s_clzDeadlock;
    private static ClassComposition s_clzException;
    private static ClassComposition s_clzIllegalArgument;
    private static ClassComposition s_clzIllegalState;
    private static ClassComposition s_clzInvalidType;
    private static ClassComposition s_clzNotImplemented;
    private static ClassComposition s_clzOutOfBounds;
    private static ClassComposition s_clzOutOfMemory;
    private static ClassComposition s_clzReadOnly;
    private static ClassComposition s_clzSizeLimited;
    private static ClassComposition s_clzStackOverflow;
    private static ClassComposition s_clzTimedOut;
    private static ClassComposition s_clzTypeMismatch;
    private static ClassComposition s_clzUnsupported;
    private static ClassComposition s_clzDivisionByZero;
    private static ClassComposition s_clzPathException;
    private static ClassComposition s_clzFileNotFoundException;
    private static ClassComposition s_clzAccessDeniedException;
    private static ClassComposition s_clzFileAlreadyExistsException;
    private static ClassComposition s_clzIOException;
    private static ClassComposition s_clzIOIllegalUTF;
    private static MethodStructure METHOD_FORMAT_EXCEPTION;

    public xException(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        if (this == INSTANCE) {
            s_clzException = INSTANCE.getCanonicalClass();
            s_clzDeadlock = this.f_container.getTemplate("Deadlock").getCanonicalClass();
            s_clzIllegalArgument = this.f_container.getTemplate("IllegalArgument").getCanonicalClass();
            s_clzIllegalState = this.f_container.getTemplate("IllegalState").getCanonicalClass();
            s_clzInvalidType = this.f_container.getTemplate("reflect.InvalidType").getCanonicalClass();
            s_clzNotImplemented = this.f_container.getTemplate("NotImplemented").getCanonicalClass();
            s_clzOutOfBounds = this.f_container.getTemplate("OutOfBounds").getCanonicalClass();
            s_clzOutOfMemory = this.f_container.getTemplate("OutOfMemory").getCanonicalClass();
            s_clzReadOnly = this.f_container.getTemplate("ReadOnly").getCanonicalClass();
            s_clzSizeLimited = this.f_container.getTemplate("collections.SizeLimited").getCanonicalClass();
            s_clzStackOverflow = this.f_container.getTemplate("StackOverflow").getCanonicalClass();
            s_clzTimedOut = this.f_container.getTemplate("TimedOut").getCanonicalClass();
            s_clzTypeMismatch = this.f_container.getTemplate("TypeMismatch").getCanonicalClass();
            s_clzUnsupported = this.f_container.getTemplate("Unsupported").getCanonicalClass();
            s_clzDivisionByZero = this.f_container.getTemplate("numbers.Number.DivisionByZero").getCanonicalClass();
            s_clzPathException = this.f_container.getTemplate("fs.PathException").getCanonicalClass();
            s_clzFileNotFoundException = this.f_container.getTemplate("fs.FileNotFound").getCanonicalClass();
            s_clzAccessDeniedException = this.f_container.getTemplate("fs.AccessDenied").getCanonicalClass();
            s_clzFileAlreadyExistsException = this.f_container.getTemplate("fs.FileAlreadyExists").getCanonicalClass();
            s_clzIOException = this.f_container.getTemplate("io.IOException").getCanonicalClass();
            s_clzIOIllegalUTF = this.f_container.getTemplate("io.IllegalUTF").getCanonicalClass();
            METHOD_FORMAT_EXCEPTION = this.getStructure().findMethod("formatExceptionString", 2, new TypeConstant[0]);
            this.markNativeMethod("toString", VOID, STRING);
            this.invalidateTypeInfo();
        }
    }

    @Override
    public ObjectHandle createStruct(Frame frame, TypeComposition clazz) {
        return xException.makeMutableStruct(frame, clazz, null);
    }

    @Override
    public int getFieldValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        ObjectHandle.ExceptionHandle hException = (ObjectHandle.ExceptionHandle)hTarget;
        if (idProp.getName().equals("text")) {
            ObjectHandle hText = hException.getField(frame, "text");
            if (hException.f_sRTError != null) {
                String sTag = ((xString.StringHandle)hText).getStringValue();
                System.err.println("*** " + sTag + "\n" + hException.f_sRTError);
            }
            return frame.assignValue(iReturn, hText);
        }
        return super.getFieldValue(frame, hTarget, idProp, iReturn);
    }

    @Override
    protected int buildStringValue(Frame frame, ObjectHandle hTarget, int iReturn) {
        ObjectHandle.ExceptionHandle hException = (ObjectHandle.ExceptionHandle)hTarget;
        ObjectHandle[] ahVars = new ObjectHandle[METHOD_FORMAT_EXCEPTION.getMaxVars()];
        ahVars[0] = xString.makeHandle(this.getClassConstant().getValueString());
        ahVars[1] = hException.getField(frame, "stackTrace");
        return frame.call1(METHOD_FORMAT_EXCEPTION, hException, ahVars, iReturn);
    }

    public static ObjectHandle.ExceptionHandle immutableObject(Frame frame) {
        return xException.makeHandle(frame, "Immutable object");
    }

    public static ObjectHandle.ExceptionHandle notFreezableProperty(Frame frame, String sProp, TypeConstant type) {
        String sDesc = type.isConst() ? "const" : "an immutable";
        return xException.makeHandle(frame, "Property \"" + sProp + "\" on " + sDesc + " \"" + type.removeAccess().getValueString() + "\" is not freezable");
    }

    public static ObjectHandle.ExceptionHandle immutableObjectProperty(Frame frame, String sProp, TypeConstant type) {
        String sDesc = type.isConst() ? "const" : "an immutable";
        return xException.makeHandle(frame, s_clzReadOnly, "Attempt to modify property \"" + sProp + "\" on " + sDesc + " \"" + type.removeAccess().getValueString() + "\"");
    }

    public static ObjectHandle.ExceptionHandle unknownProperty(Frame frame, String sProp, TypeConstant type) {
        return xException.makeHandle(frame, "Unknown property: \"" + sProp + "\" on " + type.getValueString());
    }

    public static ObjectHandle.ExceptionHandle serviceTerminated(Frame frame, String sService) {
        return xException.makeHandle(frame, "Service terminated: " + sService);
    }

    public static ObjectHandle.ExceptionHandle deadlock(Frame frame, String sMsg) {
        return xException.makeHandle(frame, s_clzDeadlock, sMsg);
    }

    public static ObjectHandle.ExceptionHandle illegalArgument(Frame frame, String sMsg) {
        return xException.makeHandle(frame, s_clzIllegalArgument, sMsg);
    }

    public static ObjectHandle.ExceptionHandle typeMismatch(Frame frame, String sType) {
        return xException.makeHandle(frame, s_clzTypeMismatch, sType);
    }

    public static ObjectHandle.ExceptionHandle illegalState(Frame frame, String sMsg) {
        return xException.makeHandle(frame, s_clzIllegalState, sMsg);
    }

    public static ObjectHandle.ExceptionHandle invalidType(Frame frame, String sMsg) {
        return xException.makeHandle(frame, s_clzInvalidType, sMsg);
    }

    public static ObjectHandle.ExceptionHandle mutableObject(Frame frame, TypeConstant type) {
        type = type.removeAccess().resolveGenerics(frame.poolContext(), frame.getGenericsResolver(true));
        return xException.illegalArgument(frame, "Mutable object of type \"" + type.getValueString() + "\" cannot be used for a service call");
    }

    public static ObjectHandle.ExceptionHandle notImplemented(Frame frame, String sMsg) {
        return xException.makeHandle(frame, s_clzNotImplemented, sMsg);
    }

    public static ObjectHandle.ExceptionHandle outOfBounds(Frame frame, long lIndex, long cSize) {
        return xException.outOfBounds(frame, lIndex < 0L ? "Negative index: " + lIndex : "Index " + lIndex + " out of range 0.." + (cSize - 1L));
    }

    public static ObjectHandle.ExceptionHandle outOfBounds(Frame frame, String sMsg) {
        return xException.makeHandle(frame, s_clzOutOfBounds, sMsg);
    }

    public static ObjectHandle.ExceptionHandle outOfMemory(Frame frame) {
        return xException.makeHandle(frame, s_clzOutOfMemory, null);
    }

    public static ObjectHandle.ExceptionHandle readOnly(Frame frame, xArray.Mutability mutability) {
        String sMsg = switch (mutability) {
            case xArray.Mutability.Constant -> "Constant array";
            case xArray.Mutability.Fixed -> "Fixed size array";
            case xArray.Mutability.Persistent -> "Persistent array";
            default -> throw new IllegalStateException();
        };
        return xException.makeHandle(frame, s_clzReadOnly, sMsg);
    }

    public static ObjectHandle.ExceptionHandle readOnly(Frame frame, String sMsg) {
        return xException.makeHandle(frame, s_clzReadOnly, sMsg);
    }

    public static ObjectHandle.ExceptionHandle sizeLimited(Frame frame, String sMsg) {
        return xException.makeHandle(frame, s_clzSizeLimited, sMsg);
    }

    public static ObjectHandle.ExceptionHandle stackOverflow(Frame frame) {
        return xException.makeHandle(frame, s_clzStackOverflow, null);
    }

    public static ObjectHandle.ExceptionHandle timedOut(Frame frame, String sMsg, ObjectHandle hTimeout) {
        ObjectHandle.ExceptionHandle hEx = xException.makeHandle(frame, s_clzTimedOut, sMsg);
        hEx.setField(frame, "timeout", hTimeout);
        return hEx;
    }

    public static boolean isTimedOut(ObjectHandle.ExceptionHandle e) {
        return e.getComposition() == s_clzTimedOut;
    }

    public static ObjectHandle.ExceptionHandle unassignedValue(Frame frame, String sName) {
        return xException.illegalState(frame, "Unassigned value: \"" + sName + "\"");
    }

    public static ObjectHandle.ExceptionHandle unassignedFields(Frame frame, String sClass, List<String> listNames) {
        return xException.illegalState(frame, "Unassigned fields for \"" + sClass + "\": " + String.valueOf(listNames));
    }

    public static ObjectHandle.ExceptionHandle unassignedReference(Frame frame) {
        return xException.illegalState(frame, "Unassigned reference");
    }

    public static ObjectHandle.ExceptionHandle unsupported(Frame frame) {
        return xException.unsupported(frame, null);
    }

    public static ObjectHandle.ExceptionHandle unsupported(Frame frame, String sMsg) {
        return xException.makeHandle(frame, s_clzUnsupported, sMsg);
    }

    public static ObjectHandle.ExceptionHandle divisionByZero(Frame frame) {
        return xException.makeHandle(frame, s_clzDivisionByZero, null);
    }

    public static ObjectHandle.ExceptionHandle pathException(Frame frame, String sMsg, ObjectHandle path) {
        ObjectHandle.ExceptionHandle hException = xException.makeHandle(frame, s_clzPathException, sMsg);
        hException.setField(frame, "path", path);
        return hException;
    }

    public static ObjectHandle.ExceptionHandle fileNotFoundException(Frame frame, String sMsg, ObjectHandle path) {
        ObjectHandle.ExceptionHandle hException = xException.makeHandle(frame, s_clzFileNotFoundException, sMsg);
        hException.setField(frame, "path", path);
        return hException;
    }

    public static ObjectHandle.ExceptionHandle accessDeniedException(Frame frame, String sMsg, ObjectHandle path) {
        ObjectHandle.ExceptionHandle hException = xException.makeHandle(frame, s_clzAccessDeniedException, sMsg);
        hException.setField(frame, "path", path);
        return hException;
    }

    public static ObjectHandle.ExceptionHandle fileAlreadyExistsException(Frame frame, String sMsg, ObjectHandle path) {
        ObjectHandle.ExceptionHandle hException = xException.makeHandle(frame, s_clzFileAlreadyExistsException, sMsg);
        hException.setField(frame, "path", path);
        return hException;
    }

    public static ObjectHandle.ExceptionHandle ioException(Frame frame, String sMsg) {
        return xException.makeHandle(frame, s_clzIOException, sMsg);
    }

    public static ObjectHandle.ExceptionHandle illegalUTF(Frame frame, String sMsg) {
        return xException.makeHandle(frame, s_clzIOIllegalUTF, sMsg);
    }

    public static ObjectHandle.ExceptionHandle abstractMethod(Frame frame, String sMethod) {
        return xException.makeHandle(frame, "No implementation for \"" + sMethod + "\"");
    }

    public static ObjectHandle.ExceptionHandle unknownInjectable(Frame frame, TypeConstant type, String sName) {
        return xException.makeHandle(frame, "Unknown injectable resource \"" + type.getValueString() + " " + sName + "\"");
    }

    public static ObjectHandle.ExceptionHandle makeHandle(Frame frame, String sMessage) {
        return xException.makeHandle(frame, (TypeComposition)s_clzException, sMessage, (ObjectHandle.ExceptionHandle)null);
    }

    public static ObjectHandle.ExceptionHandle makeHandle(Frame frame, String sMessage, ObjectHandle.ExceptionHandle hCause) {
        return xException.makeHandle(frame, (TypeComposition)s_clzException, sMessage, hCause);
    }

    public static ObjectHandle.ExceptionHandle makeHandle(Frame frame, TypeComposition clzEx, String sMessage) {
        return xException.makeHandle(frame, clzEx, sMessage, (ObjectHandle.ExceptionHandle)null);
    }

    public static ObjectHandle.ExceptionHandle makeHandle(Frame frame, TypeComposition clzEx, String sMessage, ObjectHandle.ExceptionHandle hCause) {
        ObjectHandle.ExceptionHandle hException = xException.makeMutableStruct(frame, clzEx, null);
        hException.setField(frame, "text", sMessage == null ? xNullable.NULL : xString.makeHandle(sMessage));
        hException.setField(frame, "cause", (ObjectHandle)(hCause == null ? xNullable.NULL : hCause));
        hException.makeImmutable();
        return (ObjectHandle.ExceptionHandle)hException.ensureAccess(Constants.Access.PUBLIC);
    }

    public static ObjectHandle.ExceptionHandle makeObscure(Frame frame, String sErr) {
        return xException.makeHandle(frame, (TypeComposition)s_clzException, "RTError: " + frame.f_context.f_container.currentTimeMillis(), sErr);
    }

    public static ObjectHandle.ExceptionHandle obscureIoException(Frame frame, String sErr) {
        return xException.makeHandle(frame, (TypeComposition)s_clzIOException, "RTError: " + frame.f_context.f_container.currentTimeMillis(), sErr);
    }

    public static ObjectHandle.ExceptionHandle makeHandle(Frame frame, TypeComposition clzEx, String sMessage, String sRtError) {
        ObjectHandle.ExceptionHandle hException = xException.makeMutableStruct(frame, clzEx, sRtError);
        hException.setField(frame, "text", sMessage == null ? xNullable.NULL : xString.makeHandle(sMessage));
        hException.setField(frame, "cause", (ObjectHandle)xNullable.NULL);
        hException.makeImmutable();
        return (ObjectHandle.ExceptionHandle)hException.ensureAccess(Constants.Access.PUBLIC);
    }

    private static ObjectHandle.ExceptionHandle makeMutableStruct(Frame frame, TypeComposition clxEx, String sRTError) {
        clxEx = clxEx.ensureAccess(Constants.Access.STRUCT);
        ObjectHandle.ExceptionHandle hException = new ObjectHandle.ExceptionHandle(clxEx, sRTError);
        hException.setField(frame, "stackTrace", (ObjectHandle)xString.makeHandle(frame == null ? "" : frame.getStackTrace()));
        return hException;
    }
}

