/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.NativeRebaseConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.Proxy;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template._native.temporal.xNanosTimer;
import org.xvm.runtime.template._native.xRTServiceControl;
import org.xvm.runtime.template.reflect.xClass;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;

public class xService
extends ClassTemplate {
    public static xService INSTANCE;
    public static ClassConstant INCEPTION_CLASS;
    protected static xEnum SYNCHRONICITY;
    private static Set<String> s_setAtomicProperties;
    private static PropertyConstant REMAINING_TIME;

    public xService(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
            INCEPTION_CLASS = new NativeRebaseConstant((ClassConstant)structure.getIdentityConstant());
        }
    }

    @Override
    public void registerNativeTemplates() {
        new Proxy(this.f_container);
    }

    @Override
    public void initNative() {
        if (this == INSTANCE) {
            SYNCHRONICITY = (xEnum)this.f_container.getTemplate("Service.Synchronicity");
            HashSet<String> setAtomic = new HashSet<String>();
            setAtomic.add("serviceName");
            setAtomic.add("serviceControl");
            setAtomic.add("timeout");
            s_setAtomicProperties = setAtomic;
            IdentityConstant idTimeout = this.pool().getImplicitlyImportedIdentity("Timeout");
            ClassStructure clzTimeout = (ClassStructure)idTimeout.getComponent();
            REMAINING_TIME = (PropertyConstant)clzTimeout.getChild("remainingTime").getIdentityConstant();
        }
    }

    @Override
    protected ClassConstant getInceptionClassConstant() {
        return this == INSTANCE ? INCEPTION_CLASS : (ClassConstant)super.getInceptionClassConstant();
    }

    public int constructSync(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahArg, int iReturn) {
        switch (super.construct(frame, constructor, clazz, hParent, ahArg, -1)) {
            case -1: {
                ServiceHandle hService = (ServiceHandle)frame.popStack();
                frame.f_context.setService(hService);
                return frame.assignValue(iReturn, hService);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> {
                    ServiceHandle hService = (ServiceHandle)frameCaller.popStack();
                    frameCaller.f_context.setService(hService);
                    return frameCaller.assignValue(iReturn, hService);
                });
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    public int allocateSync(Frame frame, TypeComposition clazz, ObjectHandle hParent, int iReturn) {
        ObjectHandle hStruct = clazz.getTemplate().createStruct(frame, clazz);
        switch (xClass.completeStructAllocation(frame, hStruct, hParent, new int[]{-2, -1})) {
            case -1: {
                return frame.assignValue(iReturn, hStruct);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, frameCaller.popStack()));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int construct(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahArg, int iReturn) {
        ServiceContext context = frame.f_context;
        ServiceContext contextNew = context.f_container.createServiceContext(this.f_sName);
        ServiceContext.TypeSupplier supplier = i -> constructor.getParamTypes()[i].resolveGenerics(context.f_pool, clazz.getType());
        switch (context.validatePassThrough(frame, contextNew, supplier, ahArg)) {
            case -1: {
                return contextNew.sendConstructRequest(frame, clazz, constructor, hParent, ahArg, iReturn);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> contextNew.sendConstructRequest(frameCaller, clazz, constructor, hParent, ahArg, iReturn));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public ObjectHandle createStruct(Frame frame, TypeComposition clazz) {
        ServiceContext context = frame.f_context;
        ServiceHandle hStruct = this.createStructHandle(clazz, context);
        context.setService(hStruct);
        return hStruct;
    }

    protected ServiceHandle createStructHandle(TypeComposition clazz, ServiceContext context) {
        return new ServiceHandle(clazz.ensureAccess(Constants.Access.STRUCT), context);
    }

    @Override
    protected boolean makeImmutable(ObjectHandle hTarget) {
        return false;
    }

    @Override
    public int invoke1(Frame frame, CallChain chain, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        return frame.f_context == ((ServiceHandle)hTarget).f_context || chain.isAtomic() ? super.invoke1(frame, chain, hTarget, ahVar, iReturn) : xRTFunction.makeAsyncHandle(frame, chain).call1(frame, hTarget, ahVar, iReturn);
    }

    @Override
    public int invokeT(Frame frame, CallChain chain, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
        return frame.f_context == ((ServiceHandle)hTarget).f_context || chain.isAtomic() ? super.invokeT(frame, chain, hTarget, ahVar, iReturn) : xRTFunction.makeAsyncHandle(frame, chain).callT(frame, hTarget, ahVar, iReturn);
    }

    @Override
    public int invokeN(Frame frame, CallChain chain, ObjectHandle hTarget, ObjectHandle[] ahVar, int[] aiReturn) {
        return frame.f_context == ((ServiceHandle)hTarget).f_context || chain.isAtomic() ? super.invokeN(frame, chain, hTarget, ahVar, aiReturn) : xRTFunction.makeAsyncHandle(frame, chain).callN(frame, hTarget, ahVar, aiReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        switch (method.getName()) {
            case "callLater": {
                return hService.f_context.callLater((xRTFunction.FunctionHandle)hArg, Utils.OBJECTS_NONE) == null ? frame.raiseException(xException.serviceTerminated(frame, this.f_sName)) : -1;
            }
            case "registerContextToken": {
                return frame.f_context == hService.f_context ? this.invokeRegisterToken(frame, (ObjectHandle.GenericHandle)hArg) : frame.raiseException("Call out of context");
            }
            case "unregisterContextToken": {
                return frame.f_context == hService.f_context ? this.invokeUnregisterToken(frame, (ObjectHandle.GenericHandle)hArg) : frame.raiseException("Call out of context");
            }
            case "registerTimeout": {
                if (frame.f_context != hService.f_context) {
                    return frame.raiseException("Call out of context");
                }
                if (hArg == xNullable.NULL) {
                    frame.f_fiber.setTimeoutHandle(hArg, 0L);
                    return -1;
                }
                switch (hArg.getTemplate().getPropertyValue(frame, hArg, REMAINING_TIME, -1)) {
                    case -1: {
                        long cRemains = xNanosTimer.millisFromDuration(frame.popStack());
                        frame.f_fiber.setTimeoutHandle(hArg, frame.f_context.f_container.currentTimeMillis() + cRemains);
                        return -1;
                    }
                    case -5: {
                        frame.m_frameNext.addContinuation(frameCaller -> {
                            long cRemains = xNanosTimer.millisFromDuration(frameCaller.popStack());
                            frameCaller.f_fiber.setTimeoutHandle(hArg, frame.f_context.f_container.currentTimeMillis() + cRemains);
                            return -1;
                        });
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
            case "registerSynchronizedSection": {
                return frame.f_context == hService.f_context ? frame.f_context.setSynchronizedSection(frame, hArg) : frame.raiseException("Call out of context");
            }
            case "registerShuttingDownNotification": {
                return frame.raiseException("Not implemented");
            }
            case "registerAsyncSection": {
                return frame.f_context == hService.f_context ? frame.f_fiber.registerAsyncSection(frame, hArg) : frame.raiseException("Call out of context");
            }
            case "registerUnhandledExceptionNotification": {
                hService.f_context.m_hExceptionHandler = (xRTFunction.FunctionHandle)hArg;
                return -1;
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        switch (method.getName()) {
            case "findContextToken": {
                return frame.f_context == hService.f_context ? this.invokeFindToken(frame, ahArg, iReturn) : frame.raiseException("Call out of context");
            }
            case "shutdown": {
                assert (frame.f_context == hService.f_context);
                return hService.f_context.shutdown(frame);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        switch (sPropName) {
            case "typeSystem": {
                assert (frame.f_context == hService.f_context);
                return frame.f_context.f_container.ensureTypeSystemHandle(frame, iReturn);
            }
            case "serviceName": {
                return frame.assignValue(iReturn, xString.makeHandle(hService.f_context.f_sName));
            }
            case "serviceControl": {
                return frame.assignValue(iReturn, xRTServiceControl.makeHandle(hService.f_context));
            }
            case "timeout": {
                return frame.f_context == hService.f_context ? frame.assignValue(iReturn, frame.f_fiber.getTimeoutHandle()) : frame.raiseException("Call out of context");
            }
            case "asyncSection": {
                return frame.assignValue(iReturn, frame.f_fiber.getAsyncSection());
            }
            case "synchronizedSection": {
                ObjectHandle hCriticalSection = hService.f_context.getSynchronizedSection();
                return frame.assignValue(iReturn, hCriticalSection == null ? xNullable.NULL : hCriticalSection);
            }
            case "synchronicity": {
                if (frame.f_context != hService.f_context) {
                    return frame.raiseException("Call out of context");
                }
                xEnum.EnumHandle hSynchronicity = SYNCHRONICITY.getEnumByName(frame.getSynchronicity().name());
                return Utils.assignInitializedEnum(frame, hSynchronicity, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokePreInc(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        if (frame.f_context == hService.f_context || hService.isAtomic(idProp)) {
            return super.invokePreInc(frame, hTarget, idProp, iReturn);
        }
        return hService.f_context.sendProperty01Request(frame, hService, idProp, iReturn, this::invokePreInc);
    }

    @Override
    public int invokePostInc(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        if (frame.f_context == hService.f_context || hService.isAtomic(idProp)) {
            return super.invokePostInc(frame, hTarget, idProp, iReturn);
        }
        return hService.f_context.sendProperty01Request(frame, hService, idProp, iReturn, this::invokePostInc);
    }

    @Override
    public int invokePreDec(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        if (frame.f_context == hService.f_context || hService.isAtomic(idProp)) {
            return super.invokePreDec(frame, hTarget, idProp, iReturn);
        }
        return hService.f_context.sendProperty01Request(frame, hService, idProp, iReturn, this::invokePreDec);
    }

    @Override
    public int invokePostDec(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        if (frame.f_context == hService.f_context || hService.isAtomic(idProp)) {
            return super.invokePostDec(frame, hTarget, idProp, iReturn);
        }
        return hService.f_context.sendProperty01Request(frame, hService, idProp, iReturn, this::invokePostDec);
    }

    @Override
    public int invokePropertyAdd(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        if (frame.f_context == hService.f_context || hService.isAtomic(idProp)) {
            return super.invokePropertyAdd(frame, hTarget, idProp, hArg);
        }
        return hService.f_context.sendProperty10Request(frame, hService, idProp, hArg, this::invokePropertyAdd);
    }

    @Override
    public int invokePropertySub(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hArg) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        if (frame.f_context == hService.f_context || hService.isAtomic(idProp)) {
            return super.invokePropertySub(frame, hTarget, idProp, hArg);
        }
        return hService.f_context.sendProperty10Request(frame, hService, idProp, hArg, this::invokePropertySub);
    }

    @Override
    public int getPropertyValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        if (frame.f_context == hService.f_context || hService.isAtomic(idProp)) {
            return super.getPropertyValue(frame, hTarget, idProp, iReturn);
        }
        return hService.f_context.sendProperty01Request(frame, hService, idProp, iReturn, this::getPropertyValue);
    }

    @Override
    public int getFieldValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        if (frame.f_context == hService.f_context || hService.isAtomic(idProp)) {
            return super.getFieldValue(frame, hTarget, idProp, iReturn);
        }
        throw new IllegalStateException("Invalid context");
    }

    @Override
    public int setPropertyValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hValue) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        if (frame.f_context == hService.f_context || hService.isAtomic(idProp)) {
            return super.setPropertyValue(frame, hTarget, idProp, hValue);
        }
        return hService.f_context.sendProperty10Request(frame, hService, idProp, hValue, this::setPropertyValue);
    }

    @Override
    public int setFieldValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hValue) {
        ServiceHandle hService = (ServiceHandle)hTarget;
        if (hService.f_context == frame.f_context || hService.isAtomic(idProp)) {
            return super.setFieldValue(frame, hTarget, idProp, hValue);
        }
        throw new IllegalStateException("Invalid context");
    }

    private int invokeFindToken(Frame frame, ObjectHandle[] ahArg, int iReturn) {
        ObjectHandle hContext = ahArg[1];
        Map<ObjectHandle, ObjectHandle> mapTokens = frame.f_fiber.getTokens();
        ObjectHandle hToken = mapTokens == null ? null : mapTokens.get(hContext);
        return frame.assignValue(iReturn, hToken == null ? xNullable.NULL : hToken);
    }

    private int invokeRegisterToken(Frame frame, ObjectHandle.GenericHandle hToken) {
        ObjectHandle hContext = hToken.getField(frame, "$outer");
        assert (hContext != null);
        frame.f_fiber.ensureTokens().put(hContext, hToken);
        return -1;
    }

    private int invokeUnregisterToken(Frame frame, ObjectHandle.GenericHandle hToken) {
        ObjectHandle hContext = hToken.getField(frame, "$outer");
        assert (hContext != null);
        frame.f_fiber.ensureTokens().remove(hContext);
        return -1;
    }

    public ServiceHandle createServiceHandle(ServiceContext context, ClassComposition clz, TypeConstant typeMask) {
        ServiceHandle hService = new ServiceHandle(clz.maskAs(typeMask), context);
        context.setService(hService);
        return hService;
    }

    public static class ServiceHandle
    extends ObjectHandle.GenericHandle {
        public final ServiceContext f_context;

        public ServiceHandle(TypeComposition clazz, ServiceContext context) {
            super(clazz);
            this.f_context = context;
            this.m_owner = context.f_container;
        }

        @Override
        public boolean makeImmutable() {
            return false;
        }

        @Override
        public boolean isService() {
            return true;
        }

        @Override
        public ServiceHandle getService() {
            return this;
        }

        @Override
        public boolean isAtomic(PropertyConstant idProp) {
            return s_setAtomicProperties.contains(idProp.getName()) || super.isAtomic(idProp);
        }
    }

    @FunctionalInterface
    public static interface PropertyOperation01 {
        public int invoke(Frame var1, ObjectHandle var2, PropertyConstant var3, int var4);
    }

    @FunctionalInterface
    public static interface PropertyOperation10 {
        public int invoke(Frame var1, ObjectHandle var2, PropertyConstant var3, ObjectHandle var4);
    }

    @FunctionalInterface
    public static interface NativeOperation {
        public int invoke(Frame var1, ObjectHandle[] var2, int var3);
    }
}

