/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.tool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorList;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.FileStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Version;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.BuildRepository;
import org.xvm.compiler.Token;
import org.xvm.tool.Launcher;
import org.xvm.tool.ModuleInfo;
import org.xvm.tool.ModuleInfoRepository;
import org.xvm.util.Auto;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class Compiler
extends Launcher {
    protected static org.xvm.compiler.Compiler[] NO_COMPILERS = new org.xvm.compiler.Compiler[0];
    protected Strictness strictLevel = Strictness.Normal;
    protected ModuleRepository repoLib;
    protected ModuleInfo[] prevModules;
    protected ModuleRepository prevLibs;
    protected ModuleRepository prevOutput;

    public static void main(String[] asArg) {
        try {
            Compiler.launch(asArg);
        }
        catch (Launcher.LauncherException e) {
            System.exit(e.error ? 1 : 0);
        }
    }

    public static void launch(String[] asArg) throws Launcher.LauncherException {
        new Compiler(asArg).run();
    }

    public Compiler(String[] asArg) {
        this(asArg, null);
    }

    public Compiler(String[] asArg, Launcher.Console console) {
        super(asArg, console);
    }

    @Override
    protected void process() {
        File outputDir;
        if (this.options().showVersion()) {
            this.showSystemVersion(this.ensureLibraryRepo());
        }
        this.log(Severity.INFO, "Selecting compilation targets");
        File[] resourceDirs = this.options().getResourceLocation();
        File outputLoc = this.options().getOutputLocation();
        ModuleInfo[] aTarget = this.selectTargets(this.options().getInputLocations(), resourceDirs, outputLoc).toArray(new ModuleInfo[0]);
        this.prevModules = aTarget;
        int cTargets = aTarget.length;
        if (cTargets == 0) {
            if (!this.options().showVersion()) {
                this.displayHelp();
            }
            return;
        }
        if (outputLoc != null && !(outputLoc = Handy.resolveFile(outputLoc)).exists() && ModuleInfo.isExplicitCompiledFile(outputLoc.getName()) && (outputDir = outputLoc.getParentFile()).exists() && !outputDir.isDirectory()) {
            this.log(Severity.ERROR, "The output file is " + String.valueOf(outputLoc) + " but the parent directory cannot be created because a file already exists with the same name");
        }
        ListMap<String, ModuleInfo> infoByName = new ListMap<String, ModuleInfo>(cTargets);
        for (int i = 0; i < cTargets; ++i) {
            ModuleInfo info = aTarget[i];
            String sModule = info.getQualifiedModuleName();
            File srcFile = info.getSourceFile();
            ModuleInfo[] binFile = info.getBinaryFile();
            this.log(srcFile == null ? Severity.ERROR : Severity.INFO, "  [" + i + "]=" + String.valueOf(srcFile) == null ? "<unknown>" : srcFile.getPath());
            if (i == 1 && outputLoc != null && !outputLoc.isDirectory() && ModuleInfo.isExplicitCompiledFile(outputLoc.getName())) {
                this.log(Severity.ERROR, "Multiple modules are being compiled, but only one output module file name (" + String.valueOf(outputLoc) + ") was specified; specify a target directory instead");
            }
            if (srcFile == null || !srcFile.exists()) {
                this.log(Severity.ERROR, "Could not locate the source for the module " + String.valueOf(info.getFileSpec()));
            }
            if (sModule == null) {
                this.log(Severity.ERROR, "Could not determine the module name for " + String.valueOf(info.getFileSpec()));
            } else {
                infoByName.put(sModule, info);
            }
            if (binFile == null) {
                this.log(Severity.ERROR, "Could not determine the target location for " + String.valueOf(info.getFileSpec()) + "; the module project may be missing a \"build\" or \"target\" directory");
                continue;
            }
            File binDir = binFile.getParentFile();
            if (binDir.isDirectory() || !binDir.exists()) continue;
            this.log(Severity.ERROR, "The output file " + String.valueOf(binFile) + " cannot be written because its parent directory cannot be created because a file already exists with the same name");
        }
        this.checkErrors();
        boolean fRebuild = this.options().isForcedRebuild();
        Version verStamp = this.options().getVersion();
        this.log(Severity.INFO, "Output-path=" + String.valueOf(outputLoc) + ", force-rebuild=" + fRebuild);
        ListMap<File, ModuleInfo.Node> mapTargets = new ListMap<File, ModuleInfo.Node>(cTargets);
        int cSystemModules = 0;
        for (ModuleInfo moduleInfo : aTarget) {
            this.log(Severity.INFO, "Loading and parsing sources for module: " + moduleInfo.getQualifiedModuleName());
            ModuleInfo.Node node = moduleInfo.getSourceTree(this);
            if (fRebuild || !moduleInfo.isUpToDate()) {
                mapTargets.put(moduleInfo.getSourceFile(), node);
                if (!moduleInfo.isSystemModule()) continue;
                ++cSystemModules;
                continue;
            }
            if (verStamp == null || verStamp.equals(moduleInfo.getModuleVersion())) continue;
            this.log(Severity.INFO, "Stamping version " + String.valueOf(verStamp) + " onto module: " + moduleInfo.getQualifiedModuleName());
            this.addVersion(moduleInfo, verStamp);
        }
        this.checkErrors();
        if (mapTargets.isEmpty()) {
            this.log(Severity.INFO, "All modules are up to date; terminating compiler");
            return;
        }
        ModuleInfo.Node[] allNodes = mapTargets.values().toArray(new ModuleInfo.Node[0]);
        this.flushAndCheckErrors(allNodes);
        this.ensureLibraryRepo();
        this.checkErrors();
        if (cSystemModules == 0) {
            this.log(Severity.INFO, "Pre-loading and linking system libraries");
            this.prelinkSystemLibraries(this.repoLib);
        }
        this.prevLibs = this.repoLib;
        this.checkErrors();
        ModuleInfoRepository repoOutput = new ModuleInfoRepository(infoByName, false);
        this.prevOutput = repoOutput;
        this.checkErrors();
        this.log(Severity.INFO, "Creating empty modules and populating namespaces");
        Map<String, org.xvm.compiler.Compiler> mapCompilers = this.populateNamespace(allNodes, this.repoLib);
        this.flushAndCheckErrors(allNodes);
        this.log(Severity.INFO, "Resolving names and dependencies");
        org.xvm.compiler.Compiler[] compilers = mapCompilers.values().toArray(NO_COMPILERS);
        this.linkModules(compilers, this.repoLib);
        this.flushAndCheckErrors(allNodes);
        this.resolveNames(compilers);
        this.flushAndCheckErrors(allNodes);
        this.injectNativeTurtle(this.repoLib);
        this.checkErrors();
        this.log(Severity.INFO, "Validating expressions");
        this.validateExpressions(compilers);
        this.flushAndCheckErrors(allNodes);
        this.log(Severity.INFO, "Generating code");
        this.generateCode(compilers);
        this.flushAndCheckErrors(allNodes);
        if (allNodes.length == 1) {
            this.log(Severity.INFO, "Storing results of compilation: " + String.valueOf(allNodes[0].moduleInfo().getBinaryFile()));
        } else {
            this.log(Severity.INFO, "Storing results of compilation:");
            for (ModuleInfo.Node node : allNodes) {
                ModuleInfo info = node.moduleInfo();
                this.log(Severity.INFO, "  " + info.getQualifiedModuleName() + " -> " + String.valueOf(info.getBinaryFile()));
            }
        }
        this.emitModules(allNodes, repoOutput);
        this.flushAndCheckErrors(allNodes);
        this.log(Severity.INFO, "Finished; terminating compiler");
    }

    protected void injectNativeTurtle(ModuleRepository repoLib) {
        BuildRepository repoBuild = this.extractBuildRepo(repoLib);
        ModuleStructure moduleTurtle = repoBuild.loadModule("mack.xtclang.org");
        if (moduleTurtle != null) {
            try (Auto ignore = ConstantPool.withPool(moduleTurtle.getConstantPool());){
                ClassStructure clzNakedRef = (ClassStructure)moduleTurtle.getChild("NakedRef");
                TypeConstant typeNakedRef = clzNakedRef.getFormalType();
                for (String sModule : repoBuild.getModuleNames()) {
                    ModuleStructure module = repoBuild.loadModule(sModule);
                    module.getConstantPool().setNakedRefType(typeNakedRef);
                }
            }
        }
    }

    protected Map<String, org.xvm.compiler.Compiler> populateNamespace(ModuleInfo.Node[] allNodes, ModuleRepository repo) {
        ListMap<String, org.xvm.compiler.Compiler> mapCompilers = new ListMap<String, org.xvm.compiler.Compiler>();
        BuildRepository repoBuild = this.extractBuildRepo(repo);
        for (ModuleInfo.Node node : allNodes) {
            if (node.type().getCategory().getId() != Token.Id.MODULE) {
                this.log(Severity.ERROR, "File \"" + String.valueOf(node) + "\" doesn't contain a module statement");
                continue;
            }
            org.xvm.compiler.Compiler compiler = new org.xvm.compiler.Compiler(node.type(), node.errs());
            FileStructure struct = compiler.generateInitialFileStructure();
            if (struct == null) {
                return null;
            }
            String name = struct.getModuleId().getName();
            if (mapCompilers.containsKey(name)) {
                this.log(Severity.ERROR, "Duplicate module name: \"" + name + "\"");
                continue;
            }
            mapCompilers.put(name, compiler);
            assert (repoBuild.loadModule(name) == null);
            try {
                repo.storeModule(struct.getModule());
                if ($assertionsDisabled || repoBuild.loadModule(name) != null) continue;
                throw new AssertionError();
            }
            catch (IOException e) {
                this.log(Severity.FATAL, e.toString());
            }
        }
        return mapCompilers;
    }

    protected ModuleRepository ensureLibraryRepo() {
        if (this.repoLib == null) {
            this.log(Severity.INFO, "Creating and pre-populating library and build repositories");
            this.repoLib = this.configureLibraryRepo(this.options().getModulePath());
        }
        return this.repoLib;
    }

    protected void linkModules(org.xvm.compiler.Compiler[] compilers, ModuleRepository repo) {
        for (org.xvm.compiler.Compiler compiler : compilers) {
            ModuleConstant idMissing = compiler.linkModules(repo);
            if (idMissing == null) continue;
            compiler.getErrorListener().log(Severity.FATAL, "COMPILER-24", new String[]{idMissing.getName()}, null);
            return;
        }
    }

    protected void resolveNames(org.xvm.compiler.Compiler[] compilers) {
        int cTriesLeft = 63;
        do {
            boolean fDone = true;
            org.xvm.compiler.Compiler[] compilerArray = compilers;
            int n = compilerArray.length;
            for (int i = 0; i < n; ++i) {
                org.xvm.compiler.Compiler compiler = compilerArray[i];
                fDone &= compiler.resolveNames(cTriesLeft == 1);
                if (!compiler.isAbortDesired()) continue;
                return;
            }
            if (!fDone) continue;
            return;
        } while (--cTriesLeft > 0);
        for (org.xvm.compiler.Compiler compiler : compilers) {
            compiler.logRemainingDeferredAsErrors();
        }
    }

    protected void validateExpressions(org.xvm.compiler.Compiler[] compilers) {
        int cTriesLeft = 63;
        do {
            boolean fDone = true;
            org.xvm.compiler.Compiler[] compilerArray = compilers;
            int n = compilerArray.length;
            for (int i = 0; i < n; ++i) {
                org.xvm.compiler.Compiler compiler = compilerArray[i];
                fDone &= compiler.validateExpressions(cTriesLeft == 1);
                if (!compiler.isAbortDesired()) continue;
                return;
            }
            if (!fDone) continue;
            return;
        } while (--cTriesLeft > 0);
        for (org.xvm.compiler.Compiler compiler : compilers) {
            compiler.logRemainingDeferredAsErrors();
        }
    }

    protected void generateCode(org.xvm.compiler.Compiler[] compilers) {
        int cTriesLeft = 63;
        do {
            boolean fDone = true;
            org.xvm.compiler.Compiler[] compilerArray = compilers;
            int n = compilerArray.length;
            for (int i = 0; i < n; ++i) {
                org.xvm.compiler.Compiler compiler = compilerArray[i];
                try {
                    fDone &= compiler.generateCode(cTriesLeft == 1);
                    if (!compiler.isAbortDesired()) continue;
                    return;
                }
                catch (Throwable e) {
                    System.err.println("Failed to generate code for " + String.valueOf(compiler));
                    e.printStackTrace(System.err);
                    this.log(Severity.ERROR, "Failed to generate code for " + String.valueOf(compiler) + " due to exception: " + String.valueOf(e));
                }
            }
            if (!fDone) continue;
            return;
        } while (--cTriesLeft > 0);
        for (org.xvm.compiler.Compiler compiler : compilers) {
            compiler.logRemainingDeferredAsErrors();
        }
    }

    protected boolean addVersion(ModuleInfo info, Version ver) {
        File fileBin = info.getBinaryFile();
        try {
            FileStructure struct = new FileStructure(fileBin);
            struct.getModule().setVersion(ver);
            struct.writeTo(fileBin);
            return true;
        }
        catch (IOException e) {
            this.log(Severity.ERROR, "Failed to stamp version " + String.valueOf(ver) + " onto file " + String.valueOf(fileBin));
            return false;
        }
    }

    protected void emitModules(ModuleInfo.Node[] allNodes, ModuleRepository repoOutput) {
        Version version = this.options().getVersion();
        for (ModuleInfo.Node nodeModule : allNodes) {
            ModuleStructure module = (ModuleStructure)nodeModule.type().getComponent();
            assert (!module.isFingerprint());
            if (version != null) {
                module.setVersion(version);
            }
            if (repoOutput != null) {
                try {
                    repoOutput.storeModule(module);
                }
                catch (IOException e) {
                    this.log(Severity.FATAL, e.toString());
                }
                continue;
            }
            File file = nodeModule.file().getParentFile();
            if (file == null) {
                this.log(Severity.ERROR, "Unable to determine output location for module \"" + nodeModule.name() + "\" from file :" + String.valueOf(nodeModule.file()));
                continue;
            }
            if (file.isDirectory()) {
                int ofDot;
                String sName = nodeModule.name();
                if (!this.options().isOutputFilenameQualified() && (ofDot = sName.indexOf(46)) > 0) {
                    sName = sName.substring(0, ofDot);
                }
                file = new File(file, sName + ".xtc");
            }
            FileStructure struct = module.getFileStructure();
            try {
                struct.writeTo(file);
            }
            catch (IOException e) {
                this.log(Severity.FATAL, "Exception (" + String.valueOf(e) + ") occurred while attempting to write module file \"" + file.getAbsolutePath() + "\"");
            }
        }
    }

    @Override
    protected void log(ErrorList errs) {
        List<ErrorListener.ErrorInfo> listErrs = errs.getErrors();
        int cErrs = listErrs.size();
        if (cErrs > 0) {
            boolean fSuppressVerify = false;
            for (ErrorListener.ErrorInfo err : listErrs) {
                if (!err.getCode().startsWith("COMPILER")) continue;
                fSuppressVerify = true;
                break;
            }
            int cVerify = 0;
            for (ErrorListener.ErrorInfo err : listErrs) {
                if (fSuppressVerify && err.getCode().startsWith("VERIFY") && ++cVerify > 3) continue;
                this.log(err.getSeverity(), err.toString());
            }
        }
    }

    @Override
    public String desc() {
        return "Ecstasy compiler:\n\nConverts \".x\" files into a compiled \".xtc\" Ecstasy module.\n\nUsage:\n\n    xcc <options> <filename>.x ...";
    }

    public ModuleInfo[] getModuleInfos() {
        return this.prevModules;
    }

    public ModuleRepository getLibraryRepo() {
        return this.prevLibs == null ? this.configureLibraryRepo(this.options().getModulePath()) : this.prevLibs;
    }

    public ModuleRepository getOutputRepo() {
        return this.prevOutput == null ? this.getLibraryRepo() : this.prevOutput;
    }

    @Override
    public Options options() {
        return (Options)super.options();
    }

    @Override
    protected Options instantiateOptions() {
        return new Options();
    }

    protected static enum Strictness {
        None,
        Suppressed,
        Normal,
        Stickler;

    }

    public class Options
    extends Launcher.Options {
        public Options() {
            super(Compiler.this);
            this.addOption(null, "rebuild", Launcher.Form.Name, false, "Force rebuild");
            this.addOption(null, "strict", Launcher.Form.Name, false, "Treat warnings as errors");
            this.addOption(null, "nowarn", Launcher.Form.Name, false, "Suppress all warnings");
            this.addOption("L", null, Launcher.Form.Repo, true, "Module path; a \"" + File.pathSeparator + "\"-delimited list of file and/or directory names");
            this.addOption("r", null, Launcher.Form.File, true, "Files and/or directories to read resources from");
            this.addOption("o", null, Launcher.Form.File, false, "File or directory to write output to");
            this.addOption(null, "qualify", Launcher.Form.Name, false, "Use full module name for the output file name");
            this.addOption(null, "set-version", Launcher.Form.String, false, "Specify the version to stamp onto the compiled module(s)");
            this.addOption("<_>", null, Launcher.Form.File, true, "Source file name(s) and/or module location(s) to compile");
        }

        public List<File> getModulePath() {
            List path = (List)this.values().get("L");
            return path == null ? Collections.emptyList() : path;
        }

        public List<File> getInputLocations() {
            List list = (List)this.values().get("<_>");
            return list == null ? Collections.emptyList() : list;
        }

        public File[] getResourceLocation() {
            ArrayList list = (ArrayList)this.values().get("r");
            return list == null || list.isEmpty() ? ModuleInfo.NO_FILES : list.toArray(new File[0]);
        }

        public File getOutputLocation() {
            return (File)this.values().get("o");
        }

        public Version getVersion() {
            String sVersion = (String)this.values().get("set-version");
            return sVersion == null ? null : new Version(sVersion);
        }

        public boolean isOutputFilenameQualified() {
            return this.specified("qualify");
        }

        public boolean isForcedRebuild() {
            return this.specified("rebuild");
        }

        @Override
        public void validate() {
            super.validate();
            if (this.specified("strict")) {
                Compiler.this.strictLevel = Strictness.Stickler;
                if (this.specified("nowarn")) {
                    Compiler.this.log(Severity.ERROR, "Conflicting options specified: \"-strict\" and \"-nowarn\"");
                }
            } else if (this.specified("nowarn")) {
                Compiler.this.strictLevel = Strictness.Suppressed;
            }
            Compiler.this.validateModulePath(this.getModulePath());
            List<File> listInputs = this.getInputLocations();
            int c = listInputs.size();
            for (int i = 0; i < c; ++i) {
                File fileOld = listInputs.get(i);
                File fileNew = Compiler.this.validateSourceInput(fileOld);
                if (fileNew == fileOld) continue;
                listInputs.set(i, fileNew);
            }
            Compiler.this.validateModuleOutput(this.getOutputLocation(), listInputs.size() > 1);
        }

        @Override
        boolean isBadEnoughToPrint(Severity sev) {
            if (this.verbose()) {
                return true;
            }
            return switch (Compiler.this.strictLevel.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> {
                    if (sev.compareTo(Severity.ERROR) >= 0) {
                        yield true;
                    }
                    yield false;
                }
                case 2, 3 -> sev.compareTo(Severity.WARNING) >= 0;
            };
        }

        @Override
        boolean isBadEnoughToAbort(Severity sev) {
            Severity limit = Compiler.this.strictLevel == Strictness.Stickler ? Severity.WARNING : Severity.ERROR;
            return sev.compareTo(limit) >= 0;
        }
    }
}

