/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.TextStyle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.FileStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.constants.FSNodeConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.UInt8ArrayConstant;
import org.xvm.compiler.ast.FileExpression;
import org.xvm.tool.Launcher;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class Disassembler
extends Launcher {
    private static final byte FREE = 0;
    private static final byte DIR = 1;
    private static final byte FILE = 2;
    private static final byte EXISTS = 3;
    private static final byte CLAIMED = 4;
    private static final LocalDateTime SOON = LocalDateTime.now().plusDays(1L);
    private static final LocalDateTime RECENT = LocalDateTime.now().minusMonths(6L);

    public static void main(String[] asArg) {
        try {
            new Disassembler(asArg).run();
        }
        catch (Launcher.LauncherException e) {
            System.exit(e.error ? 1 : 0);
        }
    }

    public Disassembler(String[] asArg) {
        this(asArg, null);
    }

    public Disassembler(String[] asArg, Launcher.Console console) {
        super(asArg, console);
    }

    @Override
    protected void process() {
        File fileModule = this.options().getTarget();
        String sModule = fileModule.getName();
        Component component = null;
        if (sModule.endsWith(".xtc")) {
            this.log(Severity.INFO, "Loading module file: " + sModule);
            try (FileInputStream in = new FileInputStream(fileModule);){
                component = new FileStructure(in);
            }
            catch (IOException e) {
                this.log(Severity.ERROR, "I/O exception (" + String.valueOf(e) + ") reading module file: " + String.valueOf(fileModule));
            }
        } else {
            this.log(Severity.INFO, "Creating and pre-populating library and build repositories");
            ModuleRepository repo = this.configureLibraryRepo(this.options().getModulePath());
            this.checkErrors();
            this.log(Severity.INFO, "Loading module: " + sModule);
            component = repo.loadModule(sModule);
        }
        if (component == null) {
            this.log(Severity.ERROR, "Unable to load module: " + String.valueOf(fileModule));
        }
        this.checkErrors();
        if (this.options().specified("files")) {
            this.dumpFiles(component);
        } else if (this.options().specified("findfile")) {
            this.findFile(component, (File)this.options().values().get("findfile"));
        } else {
            component.visitChildren(this::dump, false, true);
        }
        ConstantPool pool = component.getConstantPool();
    }

    public void dump(Component component) {
        if (component instanceof MethodStructure) {
            MethodStructure method = (MethodStructure)component;
            MethodConstant id = method.getIdentityConstant();
            if (method.hasCode() && method.ensureCode() != null && !method.isNative()) {
                this.out("** code for " + String.valueOf(id));
                this.out(method.ensureCode().toString());
                this.out("");
            } else {
                this.out("** no code for " + String.valueOf(id));
                this.out("");
            }
        }
    }

    public void dumpFiles(Component component) {
        FSNodeConstant fsNode;
        Constant[] aconst = component.getConstantPool().getConstants();
        int cConsts = aconst.length;
        byte[] aflags = new byte[cConsts];
        int maxSize = 0;
        int maxId = 0;
        int cDirs = 0;
        int cFiles = 0;
        for (int i = 0; i < cConsts; ++i) {
            Constant constant = aconst[i];
            if (!(constant instanceof FSNodeConstant)) continue;
            fsNode = (FSNodeConstant)constant;
            if (i > maxId) {
                maxId = i;
            }
            switch (constant.getFormat()) {
                case FSDir: {
                    int n = i;
                    aflags[n] = (byte)(aflags[n] | 1);
                    for (FSNodeConstant fsChildNode : fsNode.getDirectoryContents()) {
                        this.claimNode(fsChildNode, aflags);
                    }
                    ++cDirs;
                    break;
                }
                case FSFile: {
                    int n = i;
                    aflags[n] = (byte)(aflags[n] | 2);
                    int size = fsNode.getFileBytes().length;
                    if (size > maxSize) {
                        maxSize = size;
                    }
                    ++cFiles;
                    break;
                }
                case FSLink: {
                    int n = i;
                    aflags[n] = (byte)(aflags[n] | 2);
                    this.claimNode(fsNode.getLinkTarget(), aflags);
                    ++cFiles;
                }
            }
            ++cFiles;
        }
        if (cDirs > 0 || cFiles > 0) {
            this.out("Module contains " + cDirs + " directories and " + cFiles + " files:");
            boolean[] visited = new boolean[cConsts];
            for (int i = 0; i < cConsts; ++i) {
                if ((aflags[i] & 3) == 0 || (aflags[i] & 4) != 0) continue;
                fsNode = (FSNodeConstant)aconst[i];
                this.printNode(fsNode, "", false, false, visited, String.valueOf(maxId).length(), String.valueOf(maxSize).length());
            }
        } else {
            this.out("Module contains no files.");
        }
    }

    private void claimNode(FSNodeConstant fsNode, byte[] aflags) {
        int i = fsNode.getPosition();
        if ((aflags[i] & 4) == 0) {
            int n = i;
            aflags[n] = (byte)(aflags[n] | 4);
            switch (fsNode.getFormat()) {
                case FSDir: {
                    for (FSNodeConstant fsChildNode : fsNode.getDirectoryContents()) {
                        this.claimNode(fsChildNode, aflags);
                    }
                    break;
                }
                case FSLink: {
                    this.claimNode(fsNode.getLinkTarget(), aflags);
                }
            }
        }
    }

    private void printNode(FSNodeConstant fsNode, String indent, boolean last, boolean linked, boolean[] visited, int idLen, int sizeLen) {
        StringBuilder buf = new StringBuilder();
        int id = fsNode.getPosition();
        String idText = String.valueOf(id);
        buf.append('[');
        int c = Math.max(0, idLen - idText.length());
        for (int i = 0; i < c; ++i) {
            buf.append(' ');
        }
        buf.append(idText).append(']');
        boolean fDir = fsNode.getFormat() == Constant.Format.FSDir;
        buf.append(fDir ? " dr-- " : " -r-- ");
        String sizeText = fsNode.getFormat() == Constant.Format.FSFile ? String.valueOf(fsNode.getFileBytes().length) : "";
        int c22 = Math.max(0, sizeLen - sizeText.length());
        for (int i = 0; i < c22; ++i) {
            buf.append(' ');
        }
        buf.append(sizeText);
        buf.append(' ');
        LocalDateTime time = null;
        try {
            time = OffsetDateTime.parse(fsNode.getModified()).toLocalDateTime();
        }
        catch (Exception c22) {
            // empty catch block
        }
        if (time == null) {
            buf.append("??? ??  ????");
        } else {
            buf.append(time.getMonth().getDisplayName(TextStyle.SHORT, Locale.ENGLISH)).append(' ');
            int day = time.getDayOfMonth();
            if (day < 10) {
                buf.append(' ');
            }
            buf.append(day);
            buf.append(' ');
            if (time.isAfter(RECENT) && time.isBefore(SOON)) {
                int hour = time.getHour();
                if (hour < 10) {
                    buf.append(0);
                }
                buf.append(hour).append(':');
                int minute = time.getMinute();
                if (minute < 10) {
                    buf.append(0);
                }
                buf.append(minute);
            } else {
                buf.append(' ');
                String s = String.valueOf(10000 + time.getYear());
                buf.append(s.substring(s.length() - 4));
            }
        }
        buf.append(' ');
        if (linked) {
            if (indent.length() > 0) {
                buf.append(indent.substring(0, indent.length() - 4)).append(" |  ");
            }
            buf.append("-> ");
        } else {
            buf.append(indent);
        }
        String name = fsNode.getName();
        if (name.length() == 0) {
            buf.append('/');
        } else {
            Handy.appendString(buf, name);
        }
        boolean alreadyVisited = visited[id];
        visited[id] = true;
        switch (fsNode.getFormat()) {
            case FSDir: {
                if (alreadyVisited) {
                    buf.append(" (see above)");
                    this.out(buf);
                    break;
                }
                this.out(buf);
                FSNodeConstant[] aKidNodes = fsNode.getDirectoryContents();
                int cKidNodes = aKidNodes.length;
                Object nextIndent = " |- ";
                if (indent.length() > 0) {
                    nextIndent = indent.substring(0, indent.length() - 4) + (last ? "    " : " |  ") + (String)nextIndent;
                }
                for (int i = 0; i < cKidNodes; ++i) {
                    this.printNode(aKidNodes[i], (String)nextIndent, i == cKidNodes - 1, false, visited, idLen, sizeLen);
                }
                break;
            }
            case FSLink: {
                this.out(buf);
                this.printNode(fsNode.getLinkTarget(), indent, last, true, visited, idLen, sizeLen);
                break;
            }
            default: {
                this.out(buf);
            }
        }
    }

    public void findFile(Component component, File target) {
        byte[] findBytes;
        if (target == null) {
            this.out("No file specified.");
            return;
        }
        if (!target.exists()) {
            this.out("File " + String.valueOf(target) + " does not exist.");
            return;
        }
        if (!target.isFile() || !target.canRead()) {
            this.out("Can not read file: " + String.valueOf(target));
            return;
        }
        try {
            findBytes = Handy.readFileBytes(target);
        }
        catch (IOException e) {
            this.out("Failure reading " + String.valueOf(target) + ":\n" + String.valueOf(e));
            return;
        }
        String findString = null;
        try {
            findString = new String(Handy.readFileChars(target));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String findName = target.getName();
        String findCreated = FileExpression.createdTime(target).toInstant().atOffset(ZoneOffset.UTC).toString();
        String findModified = FileExpression.modifiedTime(target).toInstant().atOffset(ZoneOffset.UTC).toString();
        int findSize = findBytes.length;
        ConstantPool pool = component.getConstantPool();
        int matches = 0;
        int c = pool.size();
        block13: for (int i = 0; i < c; ++i) {
            Constant constant = pool.getConstant(i);
            switch (constant.getFormat()) {
                case FSFile: {
                    FSNodeConstant fsnode = (FSNodeConstant)constant;
                    if (!fsnode.getName().equals(findName) || !Arrays.equals(fsnode.getFileBytes(), findBytes)) continue block13;
                    this.out("File constant [" + constant.getPosition() + "] matches file name and contents");
                    if (!fsnode.getCreated().equals(findCreated)) {
                        this.out("  -> File creation " + findCreated + " does not match constant: " + fsnode.getCreated());
                    }
                    if (!fsnode.getModified().equals(findModified)) {
                        this.out("  -> File modified " + findModified + " does not match constant: " + fsnode.getModified());
                    }
                    ++matches;
                    continue block13;
                }
                case String: {
                    if (findString == null || !((StringConstant)constant).getValue().equals(findString)) continue block13;
                    this.out("String constant [" + constant.getPosition() + "] matches file contents");
                    ++matches;
                    continue block13;
                }
                case UInt8Array: {
                    if (findSize <= 0 || !Arrays.equals(((UInt8ArrayConstant)constant).getValue(), findBytes)) continue block13;
                    this.out("Byte[] constant [" + constant.getPosition() + "] matches file contents");
                    ++matches;
                }
            }
        }
        this.out(switch (matches) {
            case 0 -> "No matches found.";
            case 1 -> "1 match found.";
            default -> matches + " matches found.";
        });
    }

    @Override
    public String desc() {
        return "Ecstasy disassembler:\n\nExamines a compiled Ecstasy module.\n\nNote: The xam command will be removed, and replaced with an option on the xtc command.\n\nUsage:\n\n    xam <options> <modulename>\nor:\n    xam <options> <filename>.xtc\n";
    }

    @Override
    public Options options() {
        return (Options)super.options();
    }

    @Override
    protected Options instantiateOptions() {
        return new Options();
    }

    public class Options
    extends Launcher.Options {
        public Options() {
            super(Disassembler.this);
            this.addOption("L", null, Launcher.Form.Repo, true, "Module path; a \"" + File.pathSeparator + "\"-delimited list of file and/or directory names");
            this.addOption(null, "files", Launcher.Form.Name, false, "List all files embedded in the module");
            this.addOption(null, "findfile", Launcher.Form.File, false, "File to search for in the module");
            this.addOption("<_>", null, Launcher.Form.File, false, "Module file name (.xtc) to disassemble");
        }

        public List<File> getModulePath() {
            return this.values().getOrDefault("L", Collections.emptyList());
        }

        public File getTarget() {
            return (File)this.values().get("<_>");
        }

        @Override
        public void validate() {
            super.validate();
            File fileModule = this.getTarget();
            if (fileModule == null || fileModule.length() == 0L) {
                Disassembler.this.log(Severity.ERROR, "Module file required");
            } else if (fileModule.getName().endsWith(".xtc")) {
                if (!fileModule.exists()) {
                    Disassembler.this.log(Severity.ERROR, "Specified module file does not exist");
                } else if (!fileModule.isFile()) {
                    Disassembler.this.log(Severity.ERROR, "Specified module file is not a file");
                } else if (!fileModule.canRead()) {
                    Disassembler.this.log(Severity.ERROR, "Specified module file cannot be read");
                }
            }
        }
    }
}

