/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.xvm.asm.BuildInfo;
import org.xvm.asm.Constants;
import org.xvm.asm.DirRepository;
import org.xvm.asm.ErrorList;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.FileRepository;
import org.xvm.asm.FileStructure;
import org.xvm.asm.LinkedRepository;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.compiler.BuildRepository;
import org.xvm.tool.Compiler;
import org.xvm.tool.Ecstasy;
import org.xvm.tool.ModuleInfo;
import org.xvm.tool.Runner;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public abstract class Launcher
implements ErrorListener,
Runnable {
    public static final Console DefaultConsole = new Console(){};
    protected static final String Trailing = "<_>";
    protected static final String ArgV = "...";
    public static final String FATAL_ERROR = "LAUNCHER-01";
    public static final String DUP_NAME = "LAUNCHER-02";
    public static final String MISSING_PKG_NODE = "LAUNCHER-03";
    public static final String READ_FAILURE = "LAUNCHER-04";
    protected final Console m_console;
    protected final String[] m_asArgs;
    private Options m_options;
    protected Severity m_sevWorst = Severity.NONE;
    protected int m_cSuspended;
    protected Map<File, ModuleInfo> moduleCache;

    public static void main(String[] asArg) {
        int argc = asArg.length;
        if (argc < 1) {
            System.err.println("Command name is missing");
            return;
        }
        String cmd = asArg[0];
        String[] argv = new String[--argc];
        System.arraycopy(asArg, 1, argv, 0, argc);
        if (cmd.length() > 5 && cmd.toLowerCase().startsWith("debug") && (cmd = cmd.substring("debug".length())).charAt(0) == '_') {
            cmd = cmd.substring(1);
        }
        switch (cmd) {
            case "xtc": {
                Ecstasy.main(argv);
                break;
            }
            case "xcc": {
                Compiler.main(argv);
                break;
            }
            case "xec": {
                Runner.main(argv);
                break;
            }
            default: {
                System.err.println("Command name \"" + cmd + "\" is not supported");
            }
        }
    }

    public Launcher(String[] asArgs, Console console) {
        this.m_asArgs = asArgs;
        this.m_console = console == null ? DefaultConsole : console;
    }

    @Override
    public void run() {
        Options opts = this.options();
        boolean fHelp = opts.parse(this.m_asArgs);
        if (Runtime.version().version().get(0) < 21) {
            this.log(Severity.INFO, "The suggested minimum JVM version is 21; this JVM version (" + String.valueOf(Runtime.version()) + ") appears to be older");
        } else {
            this.log(Severity.INFO, "JVM version: " + String.valueOf(Runtime.version()));
        }
        this.checkErrors(fHelp);
        if (opts.verbose()) {
            this.out();
            this.out(opts);
            this.out();
        }
        opts.validate();
        this.checkErrors();
        this.process();
        if (opts.verbose()) {
            this.out();
        }
    }

    protected abstract void process();

    protected void log(Severity sev, String sMsg) {
        Options opts;
        if (this.errorsSuspended()) {
            return;
        }
        if (sev.compareTo(this.m_sevWorst) > 0) {
            this.m_sevWorst = sev;
        }
        if ((opts = this.options()).isBadEnoughToPrint(sev)) {
            this.m_console.log(sev, sMsg);
        }
        if (sev == Severity.FATAL) {
            this.abort(true);
        }
    }

    protected void log(ErrorList errs) {
        for (ErrorListener.ErrorInfo err : errs.getErrors()) {
            this.log(err.getSeverity(), err.toString());
        }
    }

    public void out() {
        this.m_console.out();
    }

    public void out(Object o) {
        this.m_console.out(o);
    }

    public void err() {
        this.m_console.err();
    }

    public void err(Object o) {
        this.m_console.err(o);
    }

    protected void suspendErrors() {
        ++this.m_cSuspended;
    }

    protected boolean errorsSuspended() {
        return this.m_cSuspended > 0;
    }

    protected void resumeErrors() {
        if (this.m_cSuspended > 0) {
            --this.m_cSuspended;
        } else {
            this.log(Severity.FATAL, "Attempt to resume errors when errors have not been suspended");
        }
    }

    protected void checkErrors() {
        if (this.options().isBadEnoughToAbort(this.m_sevWorst)) {
            this.abort(true);
        }
    }

    protected void checkErrors(boolean fHelp) {
        if (fHelp) {
            this.displayHelp();
        }
        if (fHelp || this.options().isBadEnoughToAbort(this.m_sevWorst)) {
            this.abort(this.options().isBadEnoughToAbort(this.m_sevWorst));
        }
    }

    protected void abort(boolean fError) {
        throw new LauncherException(fError);
    }

    public void displayHelp() {
        this.out();
        this.out(this.desc());
        this.out();
        Options options = this.options();
        Map<String, Option> mapOpts = options.options();
        String[] asName = mapOpts.keySet().toArray(Handy.NO_ARGS);
        int maxSyntax = Arrays.stream(asName).map(n -> ((Option)mapOpts.get(n)).syntax().length()).max(Integer::compareTo).get();
        Arrays.sort(asName, (s1, s2) -> {
            if (s1.equals(s2)) {
                return 0;
            }
            if (s1.equals(ArgV)) {
                return 1;
            }
            if (s2.equals(ArgV)) {
                return -1;
            }
            if (s1.equals(Trailing)) {
                return 1;
            }
            if (s2.equals(Trailing)) {
                return -1;
            }
            int n = s1.compareToIgnoreCase((String)s2);
            if (n == 0) {
                n = s1.compareTo((String)s2);
            }
            return n;
        });
        this.out("Options:");
        HashSet<String> alreadyDisplayed = new HashSet<String>();
        for (String sName : asName) {
            Option opt = mapOpts.get(sName);
            if (opt.posixName() != null && alreadyDisplayed.contains(opt.posixName()) || opt.linuxName() != null && alreadyDisplayed.contains(opt.linuxName())) continue;
            String sMsg = sName.equals(Trailing) && !mapOpts.containsKey(ArgV) ? ArgV : opt.syntax();
            StringBuilder sb = new StringBuilder();
            sb.append("  ").append(sMsg);
            int c = maxSyntax - sMsg.length() + 4;
            for (int i = 0; i < c; ++i) {
                sb.append(' ');
            }
            sb.append(options.descriptionFor(sName));
            this.out(sb);
            alreadyDisplayed.add(sName);
        }
        this.out();
    }

    public String desc() {
        return this.getClass().getSimpleName();
    }

    public static String stringFor(Object oVal, Form form) {
        switch (form.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 7: {
                return String.valueOf(oVal);
            }
            case 3: {
                return Handy.quotedString((String)oVal);
            }
            case 4: {
                return Handy.toPathString((File)oVal);
            }
            case 5: {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (File file : (List)oVal) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(':');
                    }
                    sb.append(Handy.toPathString(file));
                }
                return sb.toString();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean log(ErrorListener.ErrorInfo err) {
        this.log(err.getSeverity(), err.toString());
        return this.isAbortDesired();
    }

    @Override
    public boolean isAbortDesired() {
        return this.options().isBadEnoughToAbort(this.m_sevWorst);
    }

    @Override
    public boolean hasSeriousErrors() {
        return this.m_sevWorst.compareTo(Severity.ERROR) >= 0;
    }

    @Override
    public boolean isSilent() {
        return this.errorsSuspended();
    }

    public Options options() {
        Options options = this.m_options;
        if (options == null) {
            this.m_options = options = this.instantiateOptions();
        }
        return options;
    }

    protected abstract Options instantiateOptions();

    protected ModuleRepository configureLibraryRepo(List<File> path) {
        if (path == null || path.isEmpty()) {
            return this.makeBuildRepo();
        }
        ModuleRepository[] repos = new ModuleRepository[path.size() + 1];
        repos[0] = this.makeBuildRepo();
        int c = path.size();
        for (int i = 0; i < c; ++i) {
            File file = path.get(i);
            repos[i + 1] = file.isDirectory() ? new DirRepository(file, true) : new FileRepository(file, true);
        }
        return new LinkedRepository(true, repos);
    }

    protected BuildRepository makeBuildRepo() {
        return new BuildRepository();
    }

    protected BuildRepository extractBuildRepo(ModuleRepository repoLib) {
        if (repoLib instanceof BuildRepository) {
            BuildRepository repoBuild = (BuildRepository)repoLib;
            return repoBuild;
        }
        LinkedRepository repoLinked = (LinkedRepository)repoLib;
        return (BuildRepository)repoLinked.asList().get(0);
    }

    protected ModuleRepository configureResultRepo(File fileDest) {
        return (fileDest = Handy.resolveFile(fileDest)).isDirectory() ? new DirRepository(fileDest, false) : new FileRepository(fileDest, false);
    }

    protected void prelinkSystemLibraries(ModuleRepository reposLib) {
        ModuleConstant idMissing;
        FileStructure structTurtle;
        ModuleStructure moduleTurtle;
        ModuleConstant idMissing2;
        FileStructure structEcstasy;
        ModuleStructure moduleEcstasy = reposLib.loadModule("ecstasy.xtclang.org");
        if (moduleEcstasy == null) {
            this.log(Severity.FATAL, "Unable to load module: ecstasy.xtclang.org");
        }
        if ((structEcstasy = moduleEcstasy.getFileStructure()) != null && (idMissing2 = structEcstasy.linkModules(reposLib, false)) != null) {
            this.log(Severity.FATAL, "Unable to link module ecstasy.xtclang.org due to missing module:" + idMissing2.getName());
        }
        if ((moduleTurtle = reposLib.loadModule("mack.xtclang.org")) == null) {
            this.log(Severity.FATAL, "Unable to load module: mack.xtclang.org");
        }
        if ((structTurtle = moduleTurtle.getFileStructure()) != null && (idMissing = structTurtle.linkModules(reposLib, false)) != null) {
            this.log(Severity.FATAL, "Unable to link module mack.xtclang.org due to missing module:" + idMissing.getName());
        }
    }

    protected void showSystemVersion(ModuleRepository reposLib) {
        String sVer = null;
        try {
            sVer = reposLib.loadModule("ecstasy.xtclang.org").getVersionString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sVer == null) {
            sVer = BuildInfo.getXdkVersion();
        }
        StringBuilder version = new StringBuilder();
        version.append("xdk version ").append(sVer).append(" (").append(Constants.VERSION_MAJOR_CUR).append(".").append(Constants.VERSION_MINOR_CUR).append(")");
        String gitCommit = BuildInfo.getGitCommit();
        String gitStatus = BuildInfo.getGitStatus();
        if (!gitCommit.isEmpty()) {
            version.append(" [").append(gitCommit).append("]");
        }
        if (!gitStatus.isEmpty()) {
            version.append(" (").append(gitStatus).append(")");
        }
        this.out(version.toString());
    }

    public ModuleInfo ensureModuleInfo(File fileSpec, File[] resourceSpecs, File binarySpec) {
        ModuleInfo info;
        boolean fCache;
        boolean bl = fCache = (resourceSpecs == null || resourceSpecs.length == 0) && binarySpec == null;
        if (fCache && this.moduleCache != null && (info = this.moduleCache.get(fileSpec)) != null) {
            return info;
        }
        info = new ModuleInfo(fileSpec, this.options().deduce(), resourceSpecs, binarySpec);
        if (fCache) {
            if (this.moduleCache == null) {
                this.moduleCache = new HashMap<File, ModuleInfo>();
            }
            this.moduleCache.put(fileSpec, info);
        }
        return info;
    }

    public void validateModulePath(List<File> listPath) throws LauncherException {
        for (File file : listPath) {
            String sMsg = "File or directory";
            if (file.isDirectory()) {
                sMsg = "Directory";
            } else if (file.isFile()) {
                sMsg = "File";
            }
            if (!file.exists()) {
                this.log(Severity.ERROR, "File or directory \"" + String.valueOf(file) + "\" does not exist");
                continue;
            }
            if (!file.canRead()) {
                this.log(Severity.ERROR, sMsg + " \"" + String.valueOf(file) + "\" does not exist");
                continue;
            }
            if (!file.isFile() || file.getName().endsWith(".xtc")) continue;
            this.log(Severity.WARNING, "File \"" + String.valueOf(file) + "\" does not have the \".xtc\" extension");
        }
    }

    public File validateSourceInput(File file) {
        if (!file.exists() || file.isDirectory()) {
            try {
                File srcFile;
                ModuleInfo info = this.ensureModuleInfo(file, null, null);
                File file2 = srcFile = info == null ? null : info.getSourceFile();
                if (srcFile == null || !srcFile.exists()) {
                    this.log(Severity.ERROR, "Failed to locate the module source code for: " + String.valueOf(file));
                }
            }
            catch (RuntimeException e) {
                this.log(Severity.ERROR, "Failed to identify the module for: " + String.valueOf(file) + " (" + String.valueOf(e) + ")");
            }
        } else if (!file.canRead()) {
            this.log(Severity.ERROR, "File not readable: " + String.valueOf(file));
        } else if (!file.getName().endsWith(".x")) {
            this.log(Severity.WARNING, "Source file does not have a \".x\" extension: " + String.valueOf(file));
        }
        return file;
    }

    public void validateModuleOutput(File file, boolean fMulti) {
        File dir;
        if (file == null) {
            return;
        }
        boolean fSingle = ModuleInfo.isExplicitCompiledFile(file.getName());
        if (fSingle && fMulti) {
            this.log(Severity.ERROR, "The single file " + String.valueOf(file) + " is specified, but multiple modules are expected");
            return;
        }
        File file2 = dir = fSingle ? file.getParentFile() : file;
        if (dir != null && !dir.exists()) {
            this.log(Severity.INFO, "Creating directory " + String.valueOf(dir));
            dir.mkdirs();
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                if (!fSingle) {
                    this.log(Severity.WARNING, "File " + String.valueOf(file) + " does not have the \".xtc\" extension");
                }
                if (fMulti) {
                    this.log(Severity.ERROR, "The single file " + String.valueOf(file) + " is specified, but multiple modules are expected");
                }
                if (!file.canWrite()) {
                    this.log(Severity.ERROR, "File " + String.valueOf(file) + " can not be written to");
                }
            }
        } else if (dir != null && !dir.exists()) {
            this.log(Severity.ERROR, "Directory " + String.valueOf(dir) + " is missing");
        }
    }

    protected static List<File> resolvePath(String sPath) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        if (((String)sPath).length() >= 2 && ((String)sPath).charAt(0) == '~' && (((String)sPath).charAt(1) == '/' || ((String)sPath).charAt(1) == File.separatorChar)) {
            sPath = System.getProperty("user.home") + File.separatorChar + ((String)sPath).substring(2);
        }
        if (((String)sPath).indexOf(42) >= 0 || ((String)sPath).indexOf(63) >= 0) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(".", new String[0]), (String)sPath);){
                stream.forEach(path -> files.add(path.toFile()));
            }
        } else {
            files.add(new File((String)sPath));
        }
        return files;
    }

    protected List<ModuleInfo> selectTargets(List<File> listSources, File[] resourceSpecs, File outputSpec) {
        ListMap<File, ModuleInfo> mapResults = new ListMap<File, ModuleInfo>();
        HashSet<File> setDups = null;
        for (File file : listSources) {
            ModuleInfo info = null;
            File srcFile = null;
            try {
                info = this.ensureModuleInfo(file, resourceSpecs, outputSpec);
                if (info != null) {
                    srcFile = info.getSourceFile();
                }
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                String msg = e.getMessage();
                this.log(Severity.ERROR, "Could not find module information for " + Handy.toPathString(file) + " (" + (msg == null ? "Reason unknown" : msg) + ")");
            }
            if (srcFile == null) {
                this.log(Severity.ERROR, "Unable to find module source for file: " + String.valueOf(file));
                continue;
            }
            if (mapResults.containsKey(srcFile)) {
                if (setDups == null) {
                    setDups = new HashSet<File>();
                }
                if (setDups.contains(srcFile)) continue;
                this.log(Severity.WARNING, "Module source was specified multiple times: " + String.valueOf(srcFile));
                setDups.add(srcFile);
                continue;
            }
            mapResults.put(srcFile, info);
        }
        return new ArrayList<ModuleInfo>(mapResults.values());
    }

    protected void flushAndCheckErrors(ModuleInfo.Node[] nodes) {
        if (nodes != null) {
            for (ModuleInfo.Node node : nodes) {
                if (node == null) continue;
                node.logErrors(this);
            }
        }
        this.checkErrors();
    }

    protected void reset() {
        this.m_sevWorst = Severity.NONE;
        this.m_cSuspended = 0;
        this.moduleCache = null;
    }

    public static interface Console {
        default public void out() {
            this.out("");
        }

        default public void out(Object o) {
            System.out.println(o);
        }

        default public void err() {
            this.err("");
        }

        default public void err(Object o) {
            System.err.println(o);
        }

        default public void log(Severity sev, String sMsg) {
            this.out(sev.desc() + ": " + sMsg);
        }
    }

    public class Options {
        private final Map<String, Option> m_mapOptions = new HashMap<String, Option>();
        private final ListMap<String, Object> m_mapValues = new ListMap();
        private boolean m_fArgV;

        public Options() {
            this.addOption(null, "help", Form.Name, false, "Display this help message");
            this.addOption("d", "deduce", Form.Name, false, "Automatically deduce locations when possible");
            this.addOption("v", "verbose", Form.Name, false, "Enable verbose logging and messages");
            this.addOption(null, "version", Form.Name, false, "Display the Ecstasy runtime version");
        }

        public Map<String, Option> options() {
            return this.m_mapOptions;
        }

        protected void addOption(String posixName, String linuxName, Form form, boolean multi, String desc) {
            Option prev;
            assert (posixName != null || linuxName != null);
            assert (posixName == null || posixName.length() == 1 || posixName.equals(Launcher.ArgV) || posixName.equals(Launcher.Trailing));
            assert (!Launcher.Trailing.equals(posixName) || linuxName == null);
            assert (!Launcher.ArgV.equals(posixName) || linuxName == null);
            assert (form != null);
            Option opt = new Option(posixName, linuxName, form, multi, desc);
            if (posixName != null) {
                prev = this.options().put(posixName, opt);
                assert (prev == null);
            }
            if (linuxName != null && !linuxName.equals(posixName)) {
                prev = this.options().put(linuxName, opt);
                assert (prev == null);
            }
            assert (Launcher.ArgV.equals(posixName) == (form == Form.AsIs));
            if (form == Form.AsIs) {
                assert (!this.m_fArgV);
                assert (multi);
                this.m_fArgV = true;
            }
        }

        public Form formOf(String name) {
            Option opt = this.options().get(name);
            return opt == null ? null : opt.form();
        }

        public String simplify(String name) {
            Option opt = this.options().get(name);
            return opt == null ? null : opt.simplestName();
        }

        public boolean allowMultiple(String name) {
            Option opt = this.options().get(name);
            return opt != null && opt.isMulti();
        }

        public Map<String, Object> values() {
            return this.m_mapValues;
        }

        public boolean specified(String name) {
            return this.values().containsKey(this.simplify(name));
        }

        public boolean specify(String name) {
            boolean fMulti;
            if (this.formOf(name = this.simplify(name)) == Form.Name && ((fMulti = this.allowMultiple(name)) || !this.values().containsKey(name))) {
                this.store(name, fMulti, "specified");
                return true;
            }
            return false;
        }

        public boolean specify(String name, boolean value) {
            boolean fMulti;
            if (this.formOf(name = this.simplify(name)) == Form.Boolean && ((fMulti = this.allowMultiple(name)) || !this.values().containsKey(name))) {
                this.store(name, fMulti, value);
                return true;
            }
            return false;
        }

        public boolean specify(String name, int value) {
            boolean multi;
            if (this.formOf(name = this.simplify(name)) == Form.Int && ((multi = this.allowMultiple(name)) || !this.values().containsKey(name))) {
                this.store(name, multi, value);
                return true;
            }
            return false;
        }

        public boolean specify(String name, String value) {
            boolean multi;
            if (this.formOf(name = this.simplify(name)) == Form.String && ((multi = this.allowMultiple(name)) || !this.values().containsKey(name))) {
                this.store(name, multi, value);
                return true;
            }
            return false;
        }

        public boolean specify(String name, File file) {
            boolean multi;
            if (this.formOf(name = this.simplify(name)) == Form.File && ((multi = this.allowMultiple(name)) || !this.values().containsKey(name))) {
                this.store(name, multi, file);
                return true;
            }
            return false;
        }

        public boolean specify(String name, List<File> files) {
            boolean multi;
            if (this.formOf(name = this.simplify(name)) == Form.Repo && ((multi = this.allowMultiple(name)) || !this.values().containsKey(name))) {
                this.store(name, multi, files);
                return true;
            }
            return false;
        }

        public boolean specify(String name, Map<String, String> pairs) {
            boolean multi;
            if (this.formOf(name = this.simplify(name)) == Form.Pair && ((multi = this.allowMultiple(name)) || !this.values().containsKey(name) && pairs.size() <= 1)) {
                if (!pairs.isEmpty()) {
                    this.store(name, multi, pairs);
                }
                return true;
            }
            return false;
        }

        boolean showVersion() {
            return this.specified("version");
        }

        boolean deduce() {
            return this.specified("deduce");
        }

        public boolean parse(String[] asArgs) {
            boolean fHelp = false;
            if (asArgs == null) {
                return fHelp;
            }
            String sPrev = null;
            Map<String, Option> mapNames = this.options();
            int c = asArgs.length;
            block22: for (int i = 0; i < c; ++i) {
                String sArg = asArgs[i];
                assert (sArg != null);
                if (sArg.isEmpty()) continue;
                if (sPrev == null) {
                    if (sArg.charAt(0) == '-') {
                        String sVal;
                        String sOpts;
                        int cch = sArg.length();
                        int ofEq = sArg.indexOf(61);
                        boolean fEq = ofEq >= 0;
                        boolean fLinux = cch > 1 && sArg.charAt(1) == '-';
                        boolean fPosix = !fLinux;
                        String sOrig = sOpts = sArg.substring(fPosix ? 1 : 2, fEq ? ofEq : cch);
                        String string = sVal = fEq ? sArg.substring(ofEq + 1) : null;
                        if (sOpts.isEmpty()) {
                            Launcher.this.log(Severity.FATAL, "Missing argument name. (Name is \"\".)");
                        }
                        if (fLinux && "help".equals(sOpts)) {
                            fHelp = true;
                            continue;
                        }
                        do {
                            Option opt;
                            String sOpt;
                            if (fPosix) {
                                sOpt = sOpts.substring(0, 1);
                                sOpts = sOpts.substring(1);
                                if ("?".equals(sOpt)) {
                                    fHelp = true;
                                    continue;
                                }
                            } else {
                                sOpt = sOpts;
                            }
                            if ((opt = mapNames.get(sOpt)) == null || !sOpt.equals(fPosix ? opt.posixName() : opt.linuxName())) {
                                fHelp = true;
                                if (opt == null && !mapNames.containsKey(sOrig)) {
                                    Launcher.this.log(Severity.ERROR, "Unknown argument: \"" + (fPosix ? "-" : "--") + sOpt + "\"");
                                    continue block22;
                                }
                                if (fPosix) {
                                    Launcher.this.log(Severity.ERROR, "Option \"-" + sOrig + "\" must use two preceding hyphens: \"--" + sOrig + "\"");
                                    continue block22;
                                }
                                Launcher.this.log(Severity.ERROR, "Option \"--" + sOrig + "\" must use only one preceding hyphen: \"-" + sOrig + "\"");
                                continue block22;
                            }
                            Form form = opt.form();
                            String sName = opt.simplestName();
                            if (form == Form.Name) {
                                if (this.specified(sName) && !this.allowMultiple(sName)) {
                                    Launcher.this.log(Severity.WARNING, "Redundant option argument: \"-" + sOpt + "\"");
                                    continue;
                                }
                                this.specify(sName);
                                continue;
                            }
                            if (sPrev != null) {
                                Launcher.this.log(Severity.ERROR, "Options \"-" + sPrev + "\" and \"-" + sOpt + "\" cannot appear in the same cluster, since they both require a trailing value");
                                continue;
                            }
                            sPrev = sName;
                            sArg = sVal;
                        } while (fPosix && !sOpts.isEmpty());
                    } else {
                        Option optTrail = mapNames.get(Launcher.Trailing);
                        if (optTrail != null && (optTrail.isMulti() || !this.specified(Launcher.Trailing))) {
                            sPrev = Launcher.Trailing;
                        } else {
                            Option optArgV = mapNames.get(Launcher.ArgV);
                            if (optArgV != null) {
                                ArrayList<String> listArgs = new ArrayList<String>(c - i);
                                listArgs.addAll(Arrays.asList(asArgs).subList(i, c));
                                this.store(Launcher.ArgV, true, listArgs);
                                break;
                            }
                            Launcher.this.log(Severity.ERROR, "Unsupported argument: " + Handy.quotedString(sArg));
                            fHelp = true;
                        }
                    }
                }
                if (sPrev == null || sArg == null) continue;
                Form form = this.formOf(sPrev);
                boolean fMulti = this.allowMultiple(sPrev);
                ArrayList<File> oVal = null;
                assert (form != null && form != Form.Name);
                block3 : switch (form.ordinal()) {
                    case 1: {
                        if (sArg.length() == 1) {
                            switch (sArg.charAt(0)) {
                                case '1': 
                                case 'T': 
                                case 'Y': 
                                case 't': 
                                case 'y': {
                                    oVal = true;
                                    break;
                                }
                                case '0': 
                                case 'F': 
                                case 'N': 
                                case 'f': 
                                case 'n': {
                                    oVal = false;
                                }
                            }
                            break;
                        }
                        if ("true".equalsIgnoreCase(sArg) || "yes".equalsIgnoreCase(sArg)) {
                            oVal = true;
                            break;
                        }
                        if (!"false".equalsIgnoreCase(sArg) && !"no".equalsIgnoreCase(sArg)) break;
                        oVal = true;
                        break;
                    }
                    case 2: {
                        try {
                            oVal = Integer.valueOf(sArg);
                        }
                        catch (NumberFormatException fLinux) {}
                        break;
                    }
                    case 3: {
                        if (sArg.isEmpty()) {
                            oVal = "";
                            break;
                        }
                        if (sArg.charAt(0) == '\"') {
                            if (sArg.length() < 2 || sArg.charAt(sArg.length() - 1) != '\"') break;
                            sArg = sArg.substring(1, sArg.length() - 1);
                            break;
                        }
                        oVal = sArg;
                        break;
                    }
                    case 4: {
                        List<File> listFiles;
                        if (sArg.isEmpty()) break;
                        try {
                            listFiles = Launcher.resolvePath(sArg);
                        }
                        catch (IOException e) {
                            Launcher.this.log(Severity.ERROR, "Exception resolving path \"" + sArg + "\": " + String.valueOf(e));
                            break;
                        }
                        switch (listFiles.size()) {
                            case 0: {
                                break block3;
                            }
                            case 1: {
                                oVal = listFiles.get(0);
                                break block3;
                            }
                        }
                        if (fMulti) {
                            oVal = listFiles;
                            break;
                        }
                        oVal = listFiles.get(0);
                        Launcher.this.log(Severity.ERROR, "Multiple (" + listFiles.size() + ") files specified for \"" + sPrev + "\", but only one file allowed");
                        break;
                    }
                    case 5: {
                        if (sArg.isEmpty()) break;
                        ArrayList<File> repo = new ArrayList<File>();
                        for (String sPath : Handy.parseDelimitedString(sArg, File.pathSeparatorChar)) {
                            List<File> files;
                            try {
                                files = Launcher.resolvePath(sPath);
                            }
                            catch (IOException e) {
                                Launcher.this.log(Severity.ERROR, "Exception resolving path \"" + sPath + "\": " + String.valueOf(e));
                                continue;
                            }
                            if (files.isEmpty()) {
                                Launcher.this.log(Severity.ERROR, "Could not resolve: \"" + sPath + "\"");
                                continue;
                            }
                            for (File file : files) {
                                if (file.canRead()) {
                                    repo.add(file);
                                    continue;
                                }
                                if (!file.exists()) continue;
                                Launcher.this.log(Severity.ERROR, (file.isDirectory() ? "Directory" : "File") + " not readable: " + String.valueOf(file));
                            }
                        }
                        oVal = repo;
                        break;
                    }
                    case 6: {
                        if (sArg.isEmpty()) break;
                        oVal = Handy.parseStringMap(sArg);
                    }
                }
                if (oVal == null) {
                    Launcher.this.log(Severity.ERROR, "Illegal " + form.name() + " value: \"" + sArg + "\"");
                } else if (!this.specified(sPrev) || fMulti) {
                    this.store(sPrev, fMulti, oVal);
                } else {
                    Launcher.this.log(Severity.ERROR, "A value for \"-" + sPrev + "\" is specified more than once.");
                }
                sPrev = null;
            }
            if (sPrev != null) {
                Launcher.this.log(Severity.ERROR, "Missing value for \"" + sPrev + "\" option");
            }
            return fHelp;
        }

        public void validate() {
        }

        public String descriptionFor(String sName) {
            Option opt = this.options().get(sName);
            if (opt == null) {
                return null;
            }
            String sDesc = opt.desc();
            return sDesc == null ? opt.form().desc() : sDesc;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Options\n    {\n");
            String sIndent = "    ";
            for (Map.Entry<String, Object> entry : this.values().entrySet()) {
                String sName = entry.getKey();
                Object oVal = entry.getValue();
                Form form = this.formOf(sName);
                boolean fMulti = this.allowMultiple(sName);
                if (sName.equals(Launcher.Trailing)) {
                    sb.append("    Target(s)");
                } else {
                    sb.append("    ").append('-').append(sName);
                }
                if (oVal instanceof Map) {
                    sb.append(":\n");
                    Map map = (Map)oVal;
                    for (Map.Entry e : map.entrySet()) {
                        sb.append("    ").append("   ").append((String)e.getKey()).append("=").append(Handy.quotedString(String.valueOf(e.getValue()))).append('\n');
                    }
                    continue;
                }
                if (fMulti || oVal instanceof List) {
                    sb.append(":\n");
                    List list = (List)oVal;
                    int i = 0;
                    for (Object oEach : list) {
                        sb.append("    ").append("   [").append(i++).append("]=").append(Launcher.stringFor(oEach, form == Form.Repo ? Form.File : form)).append('\n');
                    }
                    continue;
                }
                if (form == Form.Name) {
                    sb.append('\n');
                    continue;
                }
                sb.append('=').append(Launcher.stringFor(oVal, form)).append('\n');
            }
            return sb.append("}").toString();
        }

        protected void store(String sName, boolean fMulti, Object value) {
            if (value instanceof List) {
                this.values().compute(sName, (k, v) -> {
                    ArrayList list = v == null ? new ArrayList() : (ArrayList)v;
                    list.addAll((List)value);
                    return list;
                });
            } else if (value instanceof Map) {
                this.values().compute(sName, (k, v) -> {
                    ListMap map = v == null ? new ListMap() : (ListMap)v;
                    map.putAll((Map)value);
                    return map;
                });
            } else if (fMulti) {
                this.values().compute(sName, (k, v) -> {
                    ArrayList<Object> list = v == null ? new ArrayList<Object>() : (ArrayList)v;
                    list.add(value);
                    return list;
                });
            } else {
                this.values().putIfAbsent(sName, value);
            }
        }

        boolean verbose() {
            return this.specified("verbose");
        }

        boolean isBadEnoughToPrint(Severity sev) {
            return this.verbose() || sev.compareTo(Severity.WARNING) >= 0;
        }

        boolean isBadEnoughToAbort(Severity sev) {
            return sev.compareTo(Severity.ERROR) >= 0;
        }
    }

    public static class LauncherException
    extends RuntimeException {
        public final boolean error;

        public LauncherException(boolean error) {
            this(error, null);
        }

        public LauncherException(boolean error, String msg) {
            super(msg);
            this.error = error;
        }

        @Override
        public String toString() {
            return "[" + this.getClass().getSimpleName() + ": isError=" + this.error + ", msg=" + this.getMessage() + "]";
        }
    }

    public static class Option {
        private final String m_sPosix;
        private final String m_sLinux;
        private transient String m_sSyntax;
        private final Form m_form;
        private final boolean m_fMulti;
        private final String m_sDesc;

        public Option(String sPosix, String sLinux, Form form, boolean fMulti, String sDesc) {
            assert (sPosix != null || sLinux != null);
            assert (!(sPosix != null && sPosix.isEmpty() || sLinux != null && sLinux.isEmpty()));
            assert (form != null);
            this.m_sPosix = sPosix;
            this.m_sLinux = sLinux;
            this.m_form = form;
            this.m_fMulti = fMulti;
            this.m_sDesc = sDesc;
        }

        public String posixName() {
            return this.m_sPosix;
        }

        public String linuxName() {
            return this.m_sLinux;
        }

        public String simplestName() {
            return this.m_sPosix == null ? this.m_sLinux : this.m_sPosix;
        }

        public Form form() {
            return this.m_form;
        }

        public boolean isMulti() {
            return this.m_fMulti;
        }

        public String desc() {
            return this.m_sDesc;
        }

        public String syntax() {
            if (this.m_sSyntax == null) {
                this.m_sSyntax = Launcher.Trailing.equals(this.m_sPosix) || Launcher.ArgV.equals(this.m_sPosix) ? this.m_sPosix : (String)(this.m_sPosix == null ? "" : "-" + this.m_sPosix) + (this.m_sPosix == null || this.m_sLinux == null ? "" : " | ") + (String)(this.m_sLinux == null ? "" : "--" + this.m_sLinux);
            }
            return this.m_sSyntax;
        }

        public String toString() {
            return this.syntax() + " : " + String.valueOf((Object)this.m_form) + (this.m_fMulti ? "*" : "");
        }
    }

    public static enum Form {
        Name("Switch"),
        Boolean,
        Int,
        String,
        File,
        Repo("\"" + java.io.File.pathSeparator + "\"-delimited File list"),
        Pair("\"key=value\" Pair"),
        AsIs;

        private final String DESC;

        private Form() {
            this(null);
        }

        private Form(String desc) {
            this.DESC = desc;
        }

        public String desc() {
            return this.DESC == null ? this.name() : this.DESC;
        }
    }

    protected static enum Stage {
        Init,
        Parsed,
        Named,
        Linked;

    }
}

