/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.tool;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.xvm.asm.ErrorList;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.FileStructure;
import org.xvm.asm.Version;
import org.xvm.compiler.CompilerException;
import org.xvm.compiler.Constants;
import org.xvm.compiler.Parser;
import org.xvm.compiler.Source;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.TypeCompositionStatement;
import org.xvm.tool.ResourceDir;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class ModuleInfo {
    public static final File[] NO_FILES = new File[0];
    transient long accumulator;
    private final File fileSpec;
    private final boolean deduce;
    private String fileName;
    private String moduleName;
    private File projectDir;
    private final Status sourceStatus;
    private File sourceDir;
    private File sourceFile;
    private boolean sourceIsTree;
    private Content sourceContent = Content.Unknown;
    private long sourceTimestamp;
    private Node sourceNode;
    private ResourceDir resourceDir;
    private long resourceTimestamp;
    private Status binaryStatus = Status.Unknown;
    private File binaryDir;
    private File binaryFile;
    private Version binaryVersion;
    private Content binaryContent = Content.Unknown;
    private long binaryTimestamp;

    public ModuleInfo(File fileSpec, boolean deduce) {
        this(fileSpec, deduce, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ModuleInfo(File fileSpec, boolean deduce, File[] resourceSpecs, File binarySpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException("A file specification is required for the module");
        }
        this.fileSpec = fileSpec;
        this.deduce = deduce;
        File resolved = Handy.resolveFile(fileSpec);
        File dirSpec = resolved.getParentFile();
        this.fileName = resolved.getName();
        if (this.fileName.isEmpty()) {
            this.fileName = null;
        }
        if (resolved.isDirectory() && (dirSpec == null || this.fileName != null && !new File(dirSpec, this.fileName + ".x").exists())) {
            dirSpec = resolved;
            this.fileName = null;
        }
        if (dirSpec == null || !dirSpec.isDirectory()) {
            throw new IllegalArgumentException("Unable to identify a module directory for " + String.valueOf(fileSpec));
        }
        String shorterName = null;
        if (this.fileName != null) {
            int dot;
            if (ModuleInfo.isExplicitEcstasyFile(this.fileName)) {
                this.fileName = Handy.removeExtension(this.fileName);
            }
            if ((dot = this.fileName.indexOf(46)) > 0) {
                shorterName = this.fileName.substring(0, dot);
            }
        }
        File curDir = null;
        File[] srcFiles = ModuleInfo.sourceFiles(dirSpec);
        File[] binFiles = ModuleInfo.compiledFiles(dirSpec);
        int srcCount = srcFiles.length;
        int binCount = binFiles.length;
        if (srcCount > 0 && binCount > 0) {
            this.binaryDir = this.sourceDir = dirSpec;
            this.projectDir = this.sourceDir;
        } else if (srcCount == 0 && binCount > 0) {
            this.binaryDir = dirSpec;
        } else {
            assert (binCount == 0);
            if (srcCount == 0) {
                curDir = dirSpec;
            } else {
                File searchDir = dirSpec;
                String srcName = this.fileName == null ? null : this.fileName + ".x";
                String srcName2 = shorterName == null ? null : shorterName + ".x";
                do {
                    this.sourceDir = searchDir;
                    if (srcName == null) {
                        if (srcCount == 1) {
                            File file = srcFiles[0];
                            this.moduleName = ModuleInfo.extractModuleName(file);
                            if (this.moduleName != null) {
                                this.fileName = Handy.removeExtension(file.getName());
                                this.sourceFile = file;
                                this.sourceContent = Content.Module;
                                break;
                            }
                        }
                    } else if (Arrays.stream(srcFiles).anyMatch(f -> !f.isDirectory() && (f.getName().equals(srcName) || f.getName().equals(srcName2)))) break;
                    if ((searchDir = searchDir.getParentFile()) == null) break;
                    srcFiles = ModuleInfo.sourceFiles(searchDir);
                    srcCount = srcFiles.length;
                } while (deduce && srcCount > 0);
            }
        }
        if (this.projectDir == null) {
            if (this.sourceDir != null) {
                this.projectDir = deduce ? ModuleInfo.projectDirFromSubDir(this.sourceDir) : this.sourceDir;
            } else if (this.binaryDir != null) {
                this.projectDir = deduce ? ModuleInfo.projectDirFromSubDir(this.binaryDir) : this.binaryDir;
            } else {
                if (curDir == null) throw new IllegalArgumentException("Unable to identify a module project directory for " + String.valueOf(fileSpec));
                this.projectDir = deduce ? ModuleInfo.projectDirFromSubDir(curDir) : curDir;
            }
        }
        if (this.sourceFile == null) {
            if (deduce && this.sourceDir == null) {
                this.sourceDir = ModuleInfo.sourceDirFromPrjDir(this.projectDir);
            }
            if (this.sourceDir != null) {
                File[] files;
                if (this.fileName == null && (files = ModuleInfo.sourceFiles(this.sourceDir)).length == 1) {
                    this.fileName = Handy.removeExtension(files[0].getName());
                }
                if (this.fileName != null) {
                    this.sourceFile = new File(this.sourceDir, this.fileName + ".x");
                }
            }
        }
        if (this.sourceFile == null || !this.sourceFile.exists()) {
            this.sourceStatus = Status.NotExists;
        } else {
            this.sourceStatus = Status.Exists;
            if (this.sourceDir == null) {
                this.sourceDir = this.sourceFile.getParentFile();
            }
            this.sourceIsTree = new File(this.sourceDir, this.fileName).exists();
        }
        if (binarySpec != null) {
            if ((binarySpec = Handy.resolveFile(binarySpec)).exists()) {
                if (binarySpec.isDirectory()) {
                    this.binaryDir = binarySpec;
                } else {
                    String sExt = Handy.getExtension(binarySpec.getName());
                    if (!"xtc".equals(sExt)) throw new IllegalArgumentException("Target destination " + String.valueOf(binarySpec) + " must use an .xtc extension");
                    this.binaryFile = binarySpec;
                    this.binaryDir = binarySpec.getParentFile();
                    this.binaryStatus = Status.Exists;
                }
            } else {
                Object fileParent = binarySpec.getParentFile();
                while (true) {
                    if (fileParent == null) {
                        throw new IllegalArgumentException("Target destination " + String.valueOf(binarySpec) + " is illegal because it does not exist and cannot be created");
                    }
                    if (((File)fileParent).exists()) {
                        if (((File)fileParent).isDirectory()) break;
                        throw new IllegalArgumentException("Target destination " + String.valueOf(binarySpec) + " is illegal because parent file " + String.valueOf(fileParent) + " is not a directory");
                    }
                    fileParent = ((File)fileParent).getParentFile();
                }
                String sExt = Handy.getExtension(binarySpec.getName());
                if ("xtc".equals(sExt)) {
                    this.binaryFile = binarySpec;
                    this.binaryDir = binarySpec.getParentFile();
                    this.binaryStatus = Status.NotExists;
                } else {
                    this.binaryDir = binarySpec;
                }
            }
        }
        if (resourceSpecs == null || resourceSpecs.length <= 0) return;
        for (File file : resourceSpecs) {
            if (file == null) {
                throw new IllegalArgumentException("A resource location is specified as null");
            }
            if (file.exists()) continue;
            throw new IllegalArgumentException("The resource location " + String.valueOf(file) + " does not exist");
        }
        File[] dftResDirs = this.getResourceDir().getLocations();
        int cDfts = dftResDirs.length;
        if (cDfts > 0) {
            int cSpecs = resourceSpecs.length;
            File[] allResDirs = new File[cSpecs + cDfts];
            System.arraycopy(resourceSpecs, 0, allResDirs, 0, cSpecs);
            System.arraycopy(dftResDirs, 0, allResDirs, cSpecs, cDfts);
            resourceSpecs = allResDirs;
        }
        this.resourceDir = new ResourceDir(resourceSpecs);
    }

    public File getFileSpec() {
        return this.fileSpec;
    }

    public String getFileName() {
        return this.fileName;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public boolean isUpToDate() {
        long binTimestamp = this.getBinaryTimestamp();
        return binTimestamp > 0L && binTimestamp >= this.getSourceTimestamp() && binTimestamp >= this.getResourceTimestamp();
    }

    public boolean isModuleNameQualified() {
        return this.getQualifiedModuleName().indexOf(46) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getQualifiedModuleName() {
        if (this.moduleName != null) return this.moduleName;
        if (this.sourceStatus == Status.Exists && this.sourceContent != Content.Invalid) {
            this.moduleName = ModuleInfo.extractModuleName(this.sourceFile);
            if (this.moduleName != null) {
                this.sourceContent = Content.Module;
                return this.moduleName;
            }
            this.sourceContent = Content.Invalid;
        }
        if (this.getBinaryFile() != null && this.binaryContent != Content.Invalid && this.loadBinaryFile()) {
            return this.moduleName;
        }
        if (this.sourceFile != null) {
            this.moduleName = Handy.removeExtension(this.sourceFile.getName());
            return this.moduleName;
        }
        if (this.binaryFile != null) {
            this.moduleName = Handy.removeExtension(this.binaryFile.getName());
            return this.moduleName;
        }
        if (this.fileName != null) {
            this.moduleName = this.fileName;
            return this.moduleName;
        }
        this.moduleName = this.projectDir.getName();
        return this.moduleName;
    }

    public boolean isSystemModule() {
        String sModule = this.getQualifiedModuleName();
        return sModule.equals("ecstasy.xtclang.org") || sModule.equals("mack.xtclang.org");
    }

    public String getSimpleModuleName() {
        String moduleName = this.getQualifiedModuleName();
        int firstDot = moduleName.indexOf(46);
        return firstDot >= 0 ? moduleName.substring(0, firstDot) : moduleName;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public boolean isSourceTree() {
        return this.sourceIsTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSourceTimestamp() {
        File fileSrc = this.getSourceFile();
        if (fileSrc != null && fileSrc.exists() && this.sourceTimestamp == 0L) {
            this.sourceTimestamp = this.sourceFile.lastModified();
            if (this.sourceIsTree) {
                ModuleInfo moduleInfo = this;
                synchronized (moduleInfo) {
                    File subDir = new File(this.sourceFile.getParentFile(), Handy.removeExtension(this.sourceFile.getName()));
                    if (subDir.isDirectory()) {
                        this.accumulator = this.sourceTimestamp;
                        this.visitTree(subDir, "x", f -> {
                            this.accumulator = Math.max(this.accumulator, f.lastModified());
                        });
                        this.sourceTimestamp = this.accumulator;
                        this.accumulator = 0L;
                    }
                }
            }
        }
        return this.sourceTimestamp;
    }

    public ResourceDir getResourceDir() {
        if (this.resourceDir == null) {
            File sourceFile = this.getSourceFile();
            this.resourceDir = sourceFile.exists() ? ResourceDir.forSource(sourceFile, this.deduce) : ResourceDir.NoResources;
        }
        return this.resourceDir;
    }

    public long getResourceTimestamp() {
        if (this.resourceTimestamp == 0L) {
            this.resourceTimestamp = this.getResourceDir().getTimestamp();
        }
        return this.resourceTimestamp;
    }

    public File getBinaryFile() {
        if (this.binaryFile == null) {
            this.binaryFile = new File(this.getBinaryDir(), this.fileName + ".xtc");
            this.binaryStatus = this.binaryFile.exists() ? Status.Exists : Status.NotExists;
        }
        return this.binaryFile;
    }

    public File getBinaryDir() {
        if (this.binaryDir == null) {
            this.binaryDir = this.binaryFile == null ? (this.deduce ? ModuleInfo.binaryDirFromPrjDir(this.projectDir) : this.projectDir) : this.binaryFile.getParentFile();
        }
        return this.binaryDir;
    }

    public Version getModuleVersion() {
        if (this.binaryVersion == null) {
            this.loadBinaryFile();
        }
        return this.binaryVersion;
    }

    private boolean loadBinaryFile() {
        if (this.binaryStatus != Status.NotExists && this.binaryContent == Content.Unknown) {
            File file = this.getBinaryFile();
            if (file != null && file.exists()) {
                this.binaryStatus = Status.Exists;
                this.binaryContent = Content.Invalid;
                try {
                    FileStructure struct = new FileStructure(file);
                    this.moduleName = struct.getModuleId().getName();
                    this.binaryVersion = struct.getModule().getVersion();
                    this.binaryContent = Content.Module;
                    return true;
                }
                catch (Exception exception) {}
            } else {
                this.binaryStatus = Status.NotExists;
            }
        }
        return false;
    }

    public long getBinaryTimestamp() {
        File file;
        if (this.binaryTimestamp == 0L && (file = this.getBinaryFile()) != null && file.exists()) {
            this.binaryTimestamp = file.lastModified();
        }
        return this.binaryTimestamp;
    }

    private File[] getBinaryFiles(File dir) {
        return dir == null || !dir.isDirectory() ? NO_FILES : dir.listFiles(f -> !f.isDirectory() && "xtc".equalsIgnoreCase(Handy.getExtension(f.getName())));
    }

    public String toString() {
        return "Module(name=" + (this.moduleName == null ? "<unknown>" : this.moduleName) + ", fileSpec=" + String.valueOf(this.fileSpec) + ", fileName=" + this.fileName + ", moduleName=" + (this.moduleName == null ? "<unknown>" : this.moduleName) + ", projectDir=" + String.valueOf(this.projectDir) + ", sourceStatus=" + String.valueOf((Object)this.sourceStatus) + ", sourceDir=" + String.valueOf(this.sourceDir) + ", sourceIsTree=" + this.sourceIsTree + ", sourceFile=" + String.valueOf(this.sourceFile) + ", sourceContent=" + String.valueOf((Object)this.sourceContent) + ", sourceTimestamp=" + (this.sourceTimestamp == 0L ? "<unknown>" : Handy.dateString(this.sourceTimestamp)) + ", resourceDir=" + String.valueOf(this.resourceDir) == null ? "<unknown>" : (String.valueOf(this.resourceDir) + ", resourceTimestamp=" + (this.resourceTimestamp == 0L ? "<unknown>" : Handy.dateString(this.resourceTimestamp)) + ", binaryStatus=" + String.valueOf((Object)this.binaryStatus) + ", binaryDir=" + String.valueOf(this.binaryDir) == null ? "<unknown>" : (String.valueOf(this.binaryDir) + ", binaryFile=" + String.valueOf(this.binaryFile) == null ? "<unknown>" : (String.valueOf(this.binaryFile) + ", binaryVersion=" + String.valueOf(this.binaryVersion) == null ? "<unknown>" : String.valueOf(this.binaryVersion) + ", binaryContent=" + String.valueOf((Object)this.binaryContent) + ", binaryTimestamp=" + (this.binaryTimestamp == 0L ? "<unknown>" : Handy.dateString(this.binaryTimestamp)))));
    }

    private void visitTree(File dir, String ext, Consumer<File> visitor) {
        TreeMap<String, File> children = new TreeMap<String, File>(String.CASE_INSENSITIVE_ORDER);
        for (File child : dir.listFiles()) {
            String name = child.getName();
            if (ext != null && !ext.equalsIgnoreCase(Handy.getExtension(name))) continue;
            assert (!children.containsKey(name));
            children.put(name, child);
        }
        for (File child : children.values()) {
            if (child.isDirectory()) {
                this.visitTree(child, ext, visitor);
                continue;
            }
            visitor.accept(child);
        }
    }

    public Node getSourceTree(ErrorListener errs) {
        if (this.sourceNode != null) {
            return this.sourceNode;
        }
        File srcDir = this.getSourceDir();
        File srcFile = this.getSourceFile();
        if (srcDir == null || srcFile == null) {
            return null;
        }
        if (errs == null) {
            errs = new ErrorList(100);
        }
        if (this.sourceIsTree) {
            assert (this.fileName != null);
            File subDir = new File(srcDir, this.fileName);
            assert (subDir.exists());
            DirNode dirNode = new DirNode(null, subDir, srcFile);
            dirNode.buildSourceTree();
            this.sourceNode = dirNode;
        } else {
            this.sourceNode = new FileNode(null, srcFile);
        }
        this.sourceNode.logErrors(errs);
        if (errs.hasSeriousErrors() || errs.isAbortDesired()) {
            return null;
        }
        this.sourceNode.parse();
        this.sourceNode.logErrors(errs);
        if (errs.hasSeriousErrors() || errs.isAbortDesired()) {
            return null;
        }
        this.sourceNode.registerNames();
        this.sourceNode.logErrors(errs);
        if (errs.hasSeriousErrors() || errs.isAbortDesired()) {
            return null;
        }
        this.sourceNode.linkParseTrees();
        this.sourceNode.logErrors(errs);
        if (errs.hasSeriousErrors() || errs.isAbortDesired()) {
            return null;
        }
        return this.sourceNode;
    }

    public static String extractModuleName(File file) {
        if (file.exists() && file.canRead()) {
            String name = file.getName();
            if (ModuleInfo.isExplicitSourceFile(name)) {
                try {
                    Source source = new Source(file);
                    Parser parser = new Parser(source, ErrorListener.BLACKHOLE);
                    return parser.parseModuleNameIgnoreEverythingElse();
                }
                catch (IOException | CompilerException exception) {}
            } else if (ModuleInfo.isExplicitCompiledFile(name)) {
                try {
                    return new FileStructure(file).getModuleId().getName();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Version getXvmVersion() {
        return new Version(new int[]{Constants.VERSION_MAJOR_CUR, Constants.VERSION_MINOR_CUR}, ModuleInfo.fileTimestampToBuildString(ModuleInfo.getJarFile()));
    }

    public static Version getXvmVersion(File moduleFile) {
        if (moduleFile == null) {
            throw new IllegalArgumentException("Compiled module file required");
        }
        if (!moduleFile.exists()) {
            throw new IllegalArgumentException("Compiled module file (" + String.valueOf(moduleFile) + ") does not exist");
        }
        try {
            FileStructure struct = new FileStructure(moduleFile);
            return new Version(new int[]{struct.getFileMajorVersion(), struct.getFileMinorVersion()}, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read module file: " + String.valueOf(moduleFile));
        }
    }

    public static Version getXdkVersion() {
        try {
            return ModuleInfo.getModuleVersion(new File(ModuleInfo.getJarFile().getParentFile().getParentFile(), "lib/ecstasy.xtc"));
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static Version getModuleVersion(File moduleFile) {
        if (moduleFile == null) {
            throw new IllegalArgumentException("Compiled module file required");
        }
        if (!moduleFile.exists()) {
            throw new IllegalArgumentException("Compiled module file (" + String.valueOf(moduleFile) + ") does not exist");
        }
        try {
            return new FileStructure(moduleFile).getModule().getVersion();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private static File getJarFile() {
        File jarFile;
        block10: {
            String clzTail;
            String clzPath;
            URL clzUrl;
            Class<ModuleInfo> clz = ModuleInfo.class;
            URL jarUrl = null;
            try {
                jarUrl = clz.getProtectionDomain().getCodeSource().getLocation();
            }
            catch (NullPointerException | SecurityException runtimeException) {
                // empty catch block
            }
            if (jarUrl == null && (clzUrl = clz.getResource(clz.getSimpleName() + ".class")) != null && (clzPath = clzUrl.toString()).endsWith(clzTail = clz.getCanonicalName().replace('.', '/') + ".class")) {
                try {
                    jarUrl = new URI(clzPath.substring(0, clzPath.length() - clzTail.length())).toURL();
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
            }
            if (jarUrl == null) {
                return null;
            }
            Object jarPath = jarUrl.toString();
            if (((String)jarPath).startsWith("jar:")) {
                int dot = ((String)jarPath).indexOf("!/");
                jarPath = dot < 0 ? ((String)jarPath).substring(4) : ((String)jarPath).substring(4, dot);
            }
            jarFile = null;
            try {
                if (((String)jarPath).matches("file:[A-Za-z]:.*")) {
                    jarPath = "file:/" + ((String)jarPath).substring(5);
                }
                jarFile = new File(new URI((String)jarPath));
            }
            catch (Exception ignore) {
                if (!((String)jarPath).startsWith("file:")) break block10;
                jarFile = new File(((String)jarPath).substring(5));
            }
        }
        return jarFile;
    }

    private static String fileTimestampToBuildString(File file) {
        try {
            long timestamp = file.lastModified();
            return timestamp == 0L ? null : Handy.dateString(timestamp).replace(':', '-').replace(' ', '.');
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    public static boolean isExplicitEcstasyFile(String sFile) {
        String sExt = Handy.getExtension(sFile);
        return "x".equalsIgnoreCase(sExt) || "xtc".equalsIgnoreCase(sExt);
    }

    public static boolean isExplicitSourceFile(String sFile) {
        String sExt = Handy.getExtension(sFile);
        return "x".equalsIgnoreCase(sExt);
    }

    public static File[] sourceFiles(File dir) {
        return Handy.listFiles(dir, "x");
    }

    public static boolean isExplicitCompiledFile(String sFile) {
        String sExt = Handy.getExtension(sFile);
        return "xtc".equalsIgnoreCase(sExt);
    }

    public static File[] compiledFiles(File dir) {
        return Handy.listFiles(dir, "xtc");
    }

    public static boolean isProjectDir(File dir) {
        return dir != null && dir.isDirectory() && (new File(dir, "src").exists() && !new File(dir, "src.x").exists() || new File(dir, "source").exists() && !new File(dir, "source.x").exists());
    }

    public static File projectDirFromSubDir(File dir) {
        File prjDir;
        assert (dir != null);
        String name = dir.getName();
        if ("build".equalsIgnoreCase(name) || "target".equalsIgnoreCase(name)) {
            prjDir = dir.getParentFile();
        } else {
            prjDir = dir;
            if ("x".equalsIgnoreCase(name) || "xtc".equalsIgnoreCase(name) || "ecstasy".equalsIgnoreCase(name)) {
                dir = prjDir.getParentFile();
                if (dir == null) {
                    return prjDir;
                }
                prjDir = dir;
                name = dir.getName();
            }
            if ("main".equalsIgnoreCase(name) || "test".equalsIgnoreCase(name)) {
                dir = prjDir.getParentFile();
                if (dir == null) {
                    return prjDir;
                }
                prjDir = dir;
                name = dir.getName();
            }
            if ("src".equalsIgnoreCase(name) || "source".equalsIgnoreCase(name)) {
                dir = prjDir.getParentFile();
                if (dir == null) {
                    return prjDir;
                }
                prjDir = dir;
            }
        }
        if (prjDir == null) {
            prjDir = dir;
        }
        return prjDir;
    }

    public static File sourceDirFromPrjDir(File prjDir) {
        File curDir;
        assert (prjDir != null);
        File srcDir = curDir = prjDir;
        block5: for (int i = 0; i <= 3; ++i) {
            File[] srcFiles = ModuleInfo.sourceFiles(curDir);
            if (srcFiles.length == 0) {
                switch (i) {
                    case 0: {
                        File subdir = new File(curDir, "src");
                        if (subdir.isDirectory() || (subdir = new File(curDir, "source")).isDirectory()) {
                            curDir = subdir;
                            continue block5;
                        }
                        ++i;
                    }
                    case 1: {
                        File subdir = new File(curDir, "main");
                        if (subdir.isDirectory()) {
                            curDir = subdir;
                            continue block5;
                        }
                        ++i;
                    }
                    case 2: {
                        File subdir = new File(curDir, "x");
                        if (subdir.isDirectory() || (subdir = new File(curDir, "xtc")).isDirectory() || (subdir = new File(curDir, "ecstasy")).isDirectory()) {
                            curDir = subdir;
                            continue block5;
                        }
                        ++i;
                    }
                }
                break;
            }
            srcDir = curDir;
            break;
        }
        return srcDir;
    }

    public static File binaryDirFromPrjDir(File prjDir) {
        assert (prjDir != null);
        File subdir = new File(prjDir, "build");
        if (subdir.isDirectory() || (subdir = new File(prjDir, "target")).isDirectory()) {
            return subdir;
        }
        if (ModuleInfo.sourceFiles(prjDir).length > 0 || ModuleInfo.compiledFiles(prjDir).length > 0) {
            return prjDir;
        }
        return new File(prjDir, "build");
    }

    private static enum Content {
        Unknown,
        Invalid,
        Module;

    }

    private static enum Status {
        Unknown,
        NotExists,
        Exists;

    }

    public abstract class Node
    implements ErrorListener {
        protected DirNode m_parent;
        protected File m_file;
        protected ResourceDir m_resdir;
        private ErrorList m_errs;

        protected Node(DirNode parent, File file) {
            assert (parent != null || file != null);
            this.m_parent = parent;
            this.m_file = file;
        }

        public DirNode parent() {
            return this.m_parent;
        }

        public Node root() {
            return this.m_parent == null ? this : this.m_parent.root();
        }

        public FileNode module() {
            Node rootNode = this.root();
            if (rootNode instanceof DirNode) {
                DirNode rootDir = (DirNode)rootNode;
                return rootDir.sourceNode();
            }
            return (FileNode)rootNode;
        }

        public ModuleInfo moduleInfo() {
            return ModuleInfo.this;
        }

        public int depth() {
            return this.parent() == null ? 0 : 1 + this.parent().depth();
        }

        public File file() {
            return this.m_file;
        }

        public abstract ResourceDir resourceDir();

        protected String resourcePathPart() {
            return null;
        }

        public abstract void parse();

        public abstract void registerNames();

        public void linkParseTrees() {
        }

        public abstract String name();

        public abstract String descriptiveName();

        public abstract Statement ast();

        public abstract TypeCompositionStatement type();

        @Override
        public boolean log(ErrorListener.ErrorInfo err) {
            return this.errs().log(err);
        }

        @Override
        public boolean isAbortDesired() {
            return this.m_errs != null && this.m_errs.isAbortDesired();
        }

        @Override
        public boolean hasSeriousErrors() {
            return this.m_errs != null && this.m_errs.hasSeriousErrors();
        }

        @Override
        public boolean hasError(String sCode) {
            return this.m_errs != null && this.m_errs.hasError(sCode);
        }

        public ErrorList errs() {
            ErrorList errs = this.m_errs;
            if (errs == null) {
                this.m_errs = errs = new ErrorList(341);
            }
            return errs;
        }

        public void logErrors(ErrorListener errs) {
            ErrorList deferred = this.m_errs;
            if (deferred != null) {
                for (ErrorListener.ErrorInfo err : deferred.getErrors()) {
                    errs.log(err);
                }
                deferred.clear();
            }
        }
    }

    public class DirNode
    extends Node {
        private File m_fileSrc;
        private FileNode m_nodeSrc;
        private final ListMap<File, FileNode> m_mapClzNodes;
        private final List<DirNode> m_listPkgNodes;
        private final Map<String, Node> m_mapChildren;

        DirNode(DirNode parent, File dir, File fileSrc) {
            super(parent, dir);
            this.m_mapClzNodes = new ListMap();
            this.m_listPkgNodes = new ArrayList<DirNode>();
            this.m_mapChildren = new HashMap<String, Node>();
            assert (dir.isDirectory());
            if (fileSrc != null) {
                this.m_fileSrc = fileSrc;
                this.m_nodeSrc = new FileNode(this, fileSrc);
            }
        }

        void buildSourceTree() {
            File thisDir = this.file();
            for (File file : Handy.listFiles(thisDir)) {
                String name = file.getName();
                if (file.isDirectory()) {
                    if (new File(thisDir, name + ".x").exists() || name.indexOf(46) >= 0) continue;
                    DirNode child = new DirNode(this, file, null);
                    this.packageNodes().add(child);
                    child.buildSourceTree();
                    continue;
                }
                if (!name.endsWith(".x")) continue;
                File subDir = new File(thisDir, Handy.removeExtension(name));
                if (subDir.exists() && subDir.isDirectory()) {
                    DirNode child = new DirNode(this, subDir, file);
                    this.packageNodes().add(child);
                    child.buildSourceTree();
                    continue;
                }
                this.classNodes().put(file, new FileNode(this, file));
            }
        }

        @Override
        public String name() {
            return this.file().getName();
        }

        @Override
        public String descriptiveName() {
            if (this.parent() == null) {
                return "module " + this.name();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("package ").append(this.name());
            DirNode node = this.parent();
            while (node.parent() != null) {
                sb.insert(8, node.name() + ".");
                node = node.parent();
            }
            return sb.toString();
        }

        @Override
        public ResourceDir resourceDir() {
            if (this.m_resdir == null) {
                DirNode parent = this.parent();
                ResourceDir parentDir = parent == null ? ModuleInfo.this.getResourceDir() : parent.resourceDir();
                this.m_resdir = parentDir.getDirectory(this.resourcePathPart());
                if (this.m_resdir == null) {
                    this.m_resdir = ResourceDir.NoResources;
                }
            }
            return this.m_resdir;
        }

        @Override
        protected String resourcePathPart() {
            String name = this.file().getName();
            int dot = name.indexOf(46);
            return dot >= 0 ? name.substring(0, dot) : name;
        }

        @Override
        public void parse() {
            if (this.m_nodeSrc == null) {
                assert (this.m_parent != null);
                this.m_nodeSrc = new FileNode(this, "package " + this.file().getName() + "{}");
            }
            this.m_nodeSrc.parse();
            for (FileNode cmpFile : this.m_mapClzNodes.values()) {
                cmpFile.parse();
            }
            for (DirNode child : this.m_listPkgNodes) {
                child.parse();
            }
        }

        @Override
        public void registerNames() {
            assert (this.sourceNode() != null);
            this.sourceNode().registerNames();
            for (FileNode clz : this.classNodes().values()) {
                clz.registerNames();
                this.registerName(clz.name(), clz);
            }
            for (DirNode pkg : this.packageNodes()) {
                pkg.registerNames();
                this.registerName(pkg.name(), pkg);
            }
        }

        public void registerName(String name, Node node) {
            if (name != null) {
                if (this.children().containsKey(name)) {
                    this.log(Severity.ERROR, "LAUNCHER-02", new Object[]{name, this.descriptiveName()}, null);
                } else {
                    this.children().put(name, node);
                }
            }
        }

        @Override
        public void linkParseTrees() {
            FileNode nodePkg = this.sourceNode();
            if (nodePkg == null) {
                this.log(Severity.ERROR, "LAUNCHER-03", new Object[]{this.descriptiveName()}, null);
            } else {
                TypeCompositionStatement typePkg = ((Node)nodePkg).type();
                for (FileNode nodeClz : this.classNodes().values()) {
                    typePkg.addEnclosed(nodeClz.ast());
                }
                for (DirNode nodeNestedPkg : this.packageNodes()) {
                    typePkg.addEnclosed(nodeNestedPkg.sourceNode().ast());
                    nodeNestedPkg.linkParseTrees();
                }
            }
        }

        @Override
        public Statement ast() {
            return this.sourceNode() == null ? null : this.sourceNode().ast();
        }

        @Override
        public TypeCompositionStatement type() {
            return this.sourceNode() == null ? null : this.sourceNode().type();
        }

        @Override
        public ErrorList errs() {
            if (this.sourceNode() != null) {
                return this.sourceNode().errs();
            }
            return null;
        }

        @Override
        public void logErrors(ErrorListener errs) {
            super.logErrors(errs);
            if (this.sourceNode() != null) {
                this.sourceNode().logErrors(errs);
            }
            for (FileNode clz : this.classNodes().values()) {
                clz.logErrors(errs);
            }
            for (DirNode pkg : this.packageNodes()) {
                pkg.logErrors(errs);
            }
        }

        public File sourceFile() {
            return this.m_fileSrc;
        }

        public FileNode sourceNode() {
            return this.m_nodeSrc;
        }

        public List<DirNode> packageNodes() {
            return this.m_listPkgNodes;
        }

        public ListMap<File, FileNode> classNodes() {
            return this.m_mapClzNodes;
        }

        public Map<String, Node> children() {
            return this.m_mapChildren;
        }

        public String toString() {
            DirNode parent = this.parent();
            return parent == null ? "/" + this.name() + "/" : String.valueOf(parent) + this.name() + "/";
        }
    }

    public class FileNode
    extends Node {
        private String m_text;
        private Source m_source;
        private Statement m_stmtAST;
        private TypeCompositionStatement m_stmtType;

        FileNode(DirNode parent, File file) {
            super(parent, file);
        }

        public FileNode(DirNode parent, String code) {
            super(parent, null);
            this.m_text = code;
        }

        @Override
        public int depth() {
            int cDepth = super.depth();
            DirNode nodeParent = this.parent();
            if (nodeParent != null && nodeParent.parent() == null) {
                --cDepth;
            }
            return cDepth;
        }

        @Override
        public String name() {
            TypeCompositionStatement stmtType = this.type();
            if (stmtType != null) {
                return stmtType.getName();
            }
            File file = this.file();
            if (file != null) {
                String sName = this.file().getName();
                if (sName.endsWith(".x")) {
                    sName = sName.substring(0, sName.length() - 2);
                }
                return sName;
            }
            DirNode parent = this.parent();
            return parent == null ? "<unknown>" : parent.file().getParent();
        }

        @Override
        public String descriptiveName() {
            return this.m_stmtType == null ? this.file().getAbsolutePath() : this.type().getCategory().getId().TEXT + " " + this.name();
        }

        @Override
        public ResourceDir resourceDir() {
            if (this.m_resdir == null) {
                DirNode parent = this.parent();
                this.m_resdir = parent == null || parent.parent() == null && this.isPackageSource() ? ModuleInfo.this.getResourceDir() : (this.isPackageSource() ? parent.parent().resourceDir() : parent.resourceDir());
            }
            return this.m_resdir;
        }

        public boolean isPackageSource() {
            DirNode parent = this.parent();
            return parent == null || this == parent.sourceNode();
        }

        public char[] content() {
            if (this.m_text != null) {
                return this.m_text.toCharArray();
            }
            try {
                return Handy.readFileChars(this.m_file);
            }
            catch (IOException e) {
                this.log(Severity.ERROR, "LAUNCHER-04", new Object[]{this.m_file}, null);
                return new char[0];
            }
        }

        public Source source() {
            if (this.m_source == null) {
                this.m_source = new Source(this);
            }
            return this.m_source;
        }

        public Object resolveResource(String path) {
            ResourceDir dir;
            if (path.startsWith("/")) {
                if ((path = path.substring(1)).startsWith("/")) {
                    return null;
                }
                dir = ModuleInfo.this.getResourceDir();
            } else {
                dir = this.resourceDir();
            }
            boolean fRequireDir = path.endsWith("/");
            if (fRequireDir && (path = path.substring(0, path.length() - 1)).endsWith("/")) {
                return null;
            }
            if (dir == null || path.isEmpty()) {
                return dir;
            }
            String[] segments = Handy.parseDelimitedString(path, '/');
            int last = segments.length - 1;
            for (int i = 0; i <= last; ++i) {
                String segment = segments[i];
                if (segment.isEmpty() || ".".equals(segment)) continue;
                if ("..".equals(segment)) {
                    if ((dir = dir.getParent()) != null) continue;
                    return null;
                }
                Object resource = dir.getByName(segment);
                if (resource instanceof ResourceDir) {
                    ResourceDir subdir;
                    dir = subdir = (ResourceDir)resource;
                    continue;
                }
                return i == last && !fRequireDir ? resource : null;
            }
            return dir;
        }

        @Override
        public void parse() {
            block2: {
                Source source = this.source();
                try {
                    this.m_stmtAST = new Parser(source, this).parseSource();
                }
                catch (CompilerException e) {
                    if (this.hasSeriousErrors()) break block2;
                    this.log(Severity.FATAL, "PARSER-01", null, source, source.getPosition(), source.getPosition());
                }
            }
        }

        @Override
        public void registerNames() {
            Statement stmt = this.ast();
            if (stmt != null) {
                if (stmt instanceof TypeCompositionStatement) {
                    TypeCompositionStatement stmtType;
                    this.m_stmtType = stmtType = (TypeCompositionStatement)stmt;
                } else {
                    List<Statement> list = ((StatementBlock)stmt).getStatements();
                    this.m_stmtType = (TypeCompositionStatement)list.getLast();
                }
            }
        }

        @Override
        public Statement ast() {
            return this.m_stmtAST;
        }

        @Override
        public TypeCompositionStatement type() {
            return this.m_stmtType;
        }

        public String toString() {
            String text = "";
            DirNode parent = this.parent();
            if (parent != null && (text = ((Object)parent).toString()).endsWith("/")) {
                text = text.substring(0, text.length() - 1);
            }
            return text + this.name() + ".x";
        }
    }
}

