/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.tool;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.xvm.asm.FileRepository;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.VersionTree;
import org.xvm.tool.ModuleInfo;

public class ModuleInfoRepository
implements ModuleRepository {
    private final Map<String, ModuleInfo> infos;
    private final boolean readOnly;
    private final Map<String, FileRepository> repos = new HashMap<String, FileRepository>();

    public ModuleInfoRepository(Map<String, ModuleInfo> infos, boolean readOnly) {
        assert (infos.keySet().stream().allMatch(Objects::nonNull));
        assert (infos.values().stream().allMatch(info -> info != null && info.getQualifiedModuleName() != null && info.getBinaryFile() != null));
        this.infos = infos;
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public Set<String> getModuleNames() {
        return Collections.unmodifiableSet(this.infos.keySet());
    }

    @Override
    public VersionTree<Boolean> getAvailableVersions(String name) {
        ModuleInfo info = this.infos.get(name);
        return info == null ? null : this.ensureRepo(info).getAvailableVersions(name);
    }

    @Override
    public ModuleStructure loadModule(String name) {
        ModuleInfo info = this.infos.get(name);
        return info == null ? null : this.ensureRepo(info).loadModule(name);
    }

    @Override
    public void storeModule(ModuleStructure module) throws IOException {
        if (this.readOnly) {
            throw new IOException("repository is read-only: " + String.valueOf(this));
        }
        String name = module.getName();
        ModuleInfo info = this.infos.get(name);
        if (info != null) {
            this.ensureRepo(info).storeModule(module);
        }
    }

    private FileRepository ensureRepo(ModuleInfo info) {
        String name = info.getQualifiedModuleName();
        FileRepository repo = this.repos.get(name);
        if (repo == null) {
            File file = info.getBinaryFile();
            File dir = file.getParentFile();
            if (!(this.readOnly || dir.isDirectory() || dir.mkdirs())) {
                throw new IllegalStateException("could not create directory: " + String.valueOf(dir));
            }
            repo = new FileRepository(file, this.readOnly);
            this.repos.put(name, repo);
        }
        return repo;
    }

    public int hashCode() {
        return this.infos.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this || !(obj instanceof ModuleInfoRepository)) {
            return obj == this;
        }
        ModuleInfoRepository that = (ModuleInfoRepository)obj;
        return this.infos.equals(that.infos) && this.readOnly == that.readOnly;
    }

    public String toString() {
        return "ModuleInfoRepository(Infos=" + String.valueOf(this.infos) + ", RO=" + this.readOnly + ")";
    }
}

