/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.tool;

import java.io.File;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import org.xvm.compiler.ast.FileExpression;
import org.xvm.tool.ModuleInfo;

public class ResourceDir {
    public static final ResourceDir NoResources = new ResourceDir(new File[0]);
    private final ResourceDir parent;
    private final String name;
    private final File[] resourcePath;

    public ResourceDir(File resourceLoc) {
        this(new File[]{resourceLoc});
    }

    public ResourceDir(File[] resourcePath) {
        this(null, "", (File[])resourcePath.clone());
        for (File file : resourcePath) {
            if (file == null) {
                throw new IllegalArgumentException("Resource location must not be null");
            }
            if (file.exists()) continue;
            throw new IllegalArgumentException("Resource location \"" + String.valueOf(file) + "\" does not exist");
        }
    }

    protected ResourceDir(ResourceDir parent, String name, File[] resourcePath) {
        this.parent = parent;
        this.name = name;
        this.resourcePath = resourcePath;
    }

    public static ResourceDir forSource(File sourceFile, boolean deduce) {
        if (sourceFile == null) {
            return NoResources;
        }
        ModuleInfo info = new ModuleInfo(sourceFile, deduce);
        File prjDir = info.getProjectDir();
        File srcDir = info.getSourceDir();
        if (deduce && prjDir != null && srcDir != null && !prjDir.equals(srcDir)) {
            for (File parentDir = srcDir.getParentFile(); parentDir != null && parentDir.isDirectory(); parentDir = parentDir.getParentFile()) {
                File resDir = new File(parentDir, "resources");
                if (resDir.isDirectory()) {
                    return new ResourceDir(new File[]{srcDir, resDir});
                }
                if (parentDir.equals(prjDir)) break;
            }
        }
        if (srcDir != null) {
            return new ResourceDir(new File[]{srcDir});
        }
        return NoResources;
    }

    public ResourceDir getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public FileTime getCreatedTime() {
        FileTime created = null;
        for (File file : this.resourcePath) {
            if (!file.isDirectory()) continue;
            FileTime newTime = FileExpression.createdTime(file);
            if (created == null) {
                created = newTime;
                continue;
            }
            if (newTime.compareTo(created) <= 0) continue;
            created = newTime;
        }
        return created;
    }

    public FileTime getModifiedTime() {
        FileTime modified = null;
        for (File file : this.resourcePath) {
            if (!file.isDirectory()) continue;
            FileTime newTime = FileExpression.modifiedTime(file);
            if (modified == null) {
                modified = newTime;
                continue;
            }
            if (newTime.compareTo(modified) <= 0) continue;
            modified = newTime;
        }
        return modified;
    }

    public int getDepth() {
        return this.parent == null ? 0 : 1 + this.parent.getDepth();
    }

    public File[] getLocations() {
        return (File[])this.resourcePath.clone();
    }

    public Set<String> getNames() {
        TreeMap names = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (File file : this.resourcePath) {
            if (file.isDirectory()) {
                for (String name : file.list()) {
                    names.putIfAbsent(name, null);
                }
                continue;
            }
            if (!file.exists()) continue;
            names.putIfAbsent(file.getName(), null);
        }
        return names.keySet();
    }

    public Object getByName(String name) {
        ArrayList<File> subdirs = null;
        for (File file : this.resourcePath) {
            if (file.isDirectory()) {
                File child = new File(file, name);
                if (!child.exists()) continue;
                if (child.isDirectory()) {
                    if (subdirs == null) {
                        subdirs = new ArrayList<File>();
                    }
                    subdirs.add(child);
                    continue;
                }
                if (subdirs != null) continue;
                return child;
            }
            if (subdirs != null || !file.getName().equalsIgnoreCase(name)) continue;
            return file;
        }
        return subdirs == null ? null : new ResourceDir(this, name, subdirs.toArray(new File[0]));
    }

    public ResourceDir getDirectory(String name) {
        ResourceDir dir;
        Object object = this.getByName(name);
        return object instanceof ResourceDir ? (dir = (ResourceDir)object) : null;
    }

    public File getFile(String name) {
        File file;
        Object object = this.getByName(name);
        return object instanceof File ? (file = (File)object) : null;
    }

    public long getTimestamp() {
        long timestamp = 0L;
        for (File file : this.resourcePath) {
            timestamp = Math.max(timestamp, this.calcTimestamp(file));
        }
        return timestamp;
    }

    private long calcTimestamp(File dirOrFile) {
        File[] files;
        long timestamp = dirOrFile.lastModified();
        if (dirOrFile.isDirectory() && (files = dirOrFile.listFiles()) != null) {
            for (File file : files) {
                timestamp = Math.max(timestamp, this.calcTimestamp(file));
            }
        }
        return timestamp;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("ResourceDir(");
        int c = this.resourcePath.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.resourcePath[i]);
        }
        return buf.append(')').toString();
    }
}

