/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xvm.api.Connector;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.FileStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Version;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.JitConnector;
import org.xvm.tool.Compiler;
import org.xvm.tool.Launcher;
import org.xvm.tool.ModuleInfo;
import org.xvm.util.Auto;
import org.xvm.util.Handy;
import org.xvm.util.ListSet;
import org.xvm.util.Severity;

public class Runner
extends Launcher {
    public static void main(String[] asArg) {
        try {
            Runner.launch(asArg);
        }
        catch (Launcher.LauncherException e) {
            System.exit(e.error ? 1 : 0);
        }
    }

    public static void launch(String[] asArg) throws Launcher.LauncherException {
        new Runner(asArg).run();
    }

    public Runner(String[] asArg) {
        this(asArg, null);
    }

    public Runner(String[] asArg, Launcher.Console console) {
        super(asArg, console);
    }

    @Override
    protected void process() {
        Object binLocDesc;
        File fileSpec;
        Options options = this.options();
        ModuleRepository repo = this.configureLibraryRepo(options.getModulePath());
        this.checkErrors();
        boolean fShowVer = options.showVersion();
        if (fShowVer) {
            this.showSystemVersion(repo);
        }
        if ((fileSpec = options.getTarget()) == null) {
            if (!fShowVer) {
                this.displayHelp();
            }
            return;
        }
        String filePath = fileSpec.getPath();
        File fileBin = null;
        boolean binExists = false;
        ModuleStructure module = null;
        if (ModuleInfo.isExplicitCompiledFile(filePath) && fileSpec.exists() && (this.options().isCompileDisabled() || Handy.isPathed(filePath))) {
            fileBin = fileSpec;
            binExists = true;
            binLocDesc = "the specified target " + filePath;
        } else if (!Handy.isPathed(filePath) && !ModuleInfo.isExplicitEcstasyFile(filePath) && (module = repo.loadModule(filePath)) != null) {
            binLocDesc = "the repository";
        } else {
            ModuleInfo info = null;
            File outFile = (File)options.values().get("o");
            try {
                info = new ModuleInfo(fileSpec, this.options().deduce(), null, outFile);
            }
            catch (RuntimeException e) {
                this.log(Severity.ERROR, "Failed to identify the module for: " + String.valueOf(fileSpec) + " (" + String.valueOf(e) + ")");
            }
            this.checkErrors();
            fileBin = info.getBinaryFile();
            binExists = fileBin != null && fileBin.exists();
            boolean fCompile = false;
            if (!binExists) {
                String qualName = info.getQualifiedModuleName();
                module = repo.loadModule(qualName);
                if (module == null) {
                    File fileSrc = info.getSourceFile();
                    if (fileSrc != null && fileSrc.exists() && !options.isCompileDisabled()) {
                        this.log(Severity.INFO, "The compiled module \"" + info.getQualifiedModuleName() + "\" is missing; attempting to compile it from " + String.valueOf(info.getSourceFile()) + " ....");
                        fCompile = true;
                    } else {
                        ListSet<String> possibles = null;
                        if (qualName.indexOf(46) < 0) {
                            for (String string : repo.getModuleNames()) {
                                int n = string.indexOf(46);
                                if (n <= 0 || !string.substring(0, n).equals(qualName)) continue;
                                if (possibles == null) {
                                    possibles = new ListSet<String>();
                                }
                                possibles.add(string);
                            }
                        }
                        if (possibles == null) {
                            this.log(Severity.ERROR, "Failed to locate the module for: " + String.valueOf(fileSpec));
                        } else if (possibles.size() == 1) {
                            this.log(Severity.ERROR, "Unable to locate the module for " + String.valueOf(fileSpec) + "; did you mean " + Handy.quotedString((String)possibles.iterator().next()) + "?");
                        } else {
                            StringBuilder buf = new StringBuilder();
                            for (String string : possibles) {
                                buf.append(", ").append(Handy.quotedString(string));
                            }
                            this.log(Severity.ERROR, "Unable to locate the module for " + String.valueOf(fileSpec) + "; did you mean one of: " + buf.substring(2) + "?");
                        }
                    }
                } else {
                    binExists = true;
                }
            }
            if (binExists && !this.options().isCompileDisabled() && info.getSourceFile() != null && info.getSourceFile().exists() && !info.isUpToDate()) {
                this.log(Severity.INFO, "The compiled module \"" + info.getQualifiedModuleName() + "\" is out-of-date; recompiling ....");
                fCompile = true;
            }
            this.checkErrors();
            if (fCompile) {
                List<File> libPath;
                ArrayList<String> compilerArgs = new ArrayList<String>();
                if (options.verbose()) {
                    compilerArgs.add("-v");
                }
                if (options.deduce()) {
                    compilerArgs.add("-d");
                }
                if (!(libPath = options.getModulePath()).isEmpty()) {
                    for (File libFile : libPath) {
                        compilerArgs.add("-L");
                        compilerArgs.add(libFile.getPath());
                    }
                }
                if (outFile != null) {
                    compilerArgs.add("-o");
                    compilerArgs.add(outFile.getPath());
                }
                compilerArgs.add(fileSpec.getPath());
                new Compiler(compilerArgs.toArray(new String[0]), this.m_console).run();
                info = new ModuleInfo(fileSpec, this.options().deduce(), null, outFile);
                fileBin = info.getBinaryFile();
                binExists = fileBin != null && fileBin.exists();
                repo = this.configureLibraryRepo(libPath);
                module = repo.loadModule(info.getQualifiedModuleName());
            }
            binLocDesc = info.getBinaryFile().getPath();
        }
        if (module == null && binExists && Handy.checkReadable(fileBin)) {
            try (FileInputStream in = new FileInputStream(fileBin);){
                FileStructure struct = new FileStructure(in);
                module = struct.getModule();
            }
            catch (IOException e) {
                this.log(Severity.FATAL, "I/O exception (" + String.valueOf(e) + ") reading module file: " + String.valueOf(fileBin));
                this.abort(true);
            }
        }
        if (module == null) {
            this.log(Severity.ERROR, "Missing module for " + String.valueOf(fileSpec));
            this.abort(true);
        } else {
            try {
                repo.storeModule(module);
            }
            catch (IOException e) {
                this.log(Severity.FATAL, "I/O exception (" + String.valueOf(e) + ") storing module file: " + String.valueOf(fileSpec));
                this.abort(true);
            }
            this.checkErrors();
        }
        String sName = module.getName();
        if (sName.equals(module.getSimpleName())) {
            sName = Handy.quotedString(sName);
        }
        if (fShowVer) {
            Version ver = module.getVersion();
            String sVer = ver == null ? "<none>" : ver.toString();
            this.out(sName + " version " + sVer);
        }
        boolean fJit = options.isJit();
        this.log(Severity.INFO, "Executing " + sName + " from " + (String)binLocDesc);
        try {
            Connector connector = fJit ? new JitConnector(repo) : new Connector(repo);
            connector.loadModule(module.getName());
            connector.start(options.getInjections());
            ConstantPool pool = connector.getConstantPool();
            try (Auto ignore = ConstantPool.withPool(pool);){
                String sMethod = this.options().getMethodName();
                Set<MethodStructure> setMethods = connector.findMethods(sMethod);
                if (setMethods.size() != 1) {
                    if (setMethods.isEmpty()) {
                        this.log(Severity.ERROR, "Missing method \"" + sMethod + "\" in module " + sName);
                    } else {
                        this.log(Severity.ERROR, "Ambiguous method \"" + sMethod + "\" in module " + sName);
                    }
                    this.abort(true);
                }
                String[] stringArray = this.options().getMethodArgs();
                MethodStructure methodStructure = setMethods.iterator().next();
                TypeConstant typeStrings = pool.ensureArrayType(pool.typeString());
                switch (methodStructure.getRequiredParamCount()) {
                    case 0: {
                        if (stringArray == null) break;
                        if (methodStructure.getParamCount() > 0) {
                            TypeConstant typeArg = methodStructure.getParam(0).getType();
                            if (typeStrings.isA(typeArg)) break;
                            this.log(Severity.ERROR, "Unsupported argument type \"" + typeArg.getValueString() + "\" for method \"" + sMethod + "\"");
                            this.abort(true);
                            break;
                        }
                        this.log(Severity.WARNING, "Method \"" + sMethod + "\" does not take any parameters; ignoring the specified arguments");
                        break;
                    }
                    case 1: {
                        TypeConstant typeArg = methodStructure.getParam(0).getType();
                        if (typeStrings.isA(typeArg)) break;
                        this.log(Severity.ERROR, "Unsupported argument type \"" + typeArg.getValueString() + "\" for method \"" + sMethod + "\"");
                        this.abort(true);
                        break;
                    }
                    default: {
                        this.log(Severity.ERROR, "Unsupported method arguments \"" + methodStructure.getIdentityConstant().getSignature().getValueString());
                        this.abort(true);
                    }
                }
                connector.invoke0(methodStructure, stringArray);
                System.exit(connector.join());
            }
        }
        catch (InterruptedException connector) {
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log(Severity.FATAL, e.toString());
        }
    }

    @Override
    public String desc() {
        return "Ecstasy runner:\n\n    Executes an Ecstasy module, compiling it first if necessary.\n\nUsage:\n\n    xec <options> <modulename>\n\nAlso supports any of:\n\n    xec <options> <filename>\n    xec <options> <filename>.x\n    xec <options> <filename>.xtc\n";
    }

    @Override
    public Options options() {
        return (Options)super.options();
    }

    @Override
    protected Options instantiateOptions() {
        return new Options();
    }

    public class Options
    extends Launcher.Options {
        public Options() {
            this.addOption("I", "inject", Launcher.Form.Pair, true, "Specifies name/value pairs for injection; the format is \"name1=value1,name2=value2\"");
            this.addOption("J", "jit", Launcher.Form.Name, false, "Enable the JIT-to-Java back-end");
            this.addOption("L", null, Launcher.Form.Repo, true, "Module path; a \"" + File.pathSeparator + "\"-delimited list of file and/or directory names");
            this.addOption("M", "method", Launcher.Form.String, false, "Method name; defaults to \"run\"");
            this.addOption(null, "no-recompile", Launcher.Form.Name, false, "Disable automatic compilation");
            this.addOption("o", null, Launcher.Form.File, false, "If compilation is necessary, the file or directory to write compiler output to");
            this.addOption("<_>", null, Launcher.Form.File, false, "Module file name (.xtc) to execute");
            this.addOption("...", null, Launcher.Form.AsIs, true, "Arguments to pass to the method");
        }

        public List<File> getModulePath() {
            return this.values().getOrDefault("L", Collections.emptyList());
        }

        public String getMethodName() {
            return (String)this.values().getOrDefault("M", "run");
        }

        public boolean isCompileDisabled() {
            return this.specified("no-recompile");
        }

        public boolean isJit() {
            return this.specified("jit");
        }

        public File getTarget() {
            return (File)this.values().get("<_>");
        }

        public String[] getMethodArgs() {
            List listArgs = (List)this.values().get("...");
            return listArgs == null ? null : listArgs.toArray(Handy.NO_ARGS);
        }

        public Map<String, String> getInjections() {
            return this.values().getOrDefault("I", Collections.emptyMap());
        }

        @Override
        public void validate() {
            super.validate();
            Runner.this.validateModulePath(this.getModulePath());
        }
    }
}

