/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.type;

import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.xvm.type.Decimal128;
import org.xvm.type.Decimal32;
import org.xvm.type.Decimal64;

public abstract class Decimal {
    public static final double LOG2_10 = 1.0 / Math.log10(2.0);

    public int getBitLength() {
        return this.getByteLength() * 8;
    }

    public abstract int getByteLength();

    public abstract MathContext getMathContext();

    public abstract int getByte(int var1);

    protected int leftmost7Bits() {
        return this.getByte(0) >>> 1;
    }

    public abstract boolean isZero();

    public int getSignum() {
        if (this.isZero()) {
            return 0;
        }
        return this.isSigned() ? -1 : 1;
    }

    public boolean isSigned() {
        return (this.leftmost7Bits() & 0x40) == 64;
    }

    public boolean isFinite() {
        return (this.leftmost7Bits() & 0x3C) != 60;
    }

    public boolean isInfinite() {
        return (this.leftmost7Bits() & 0x3E) == 60;
    }

    public boolean isNaN() {
        return (this.leftmost7Bits() & 0x3E) == 62;
    }

    public boolean isSignalingNaN() {
        return (this.leftmost7Bits() & 0x3F) == 63;
    }

    public boolean isQuietNaN() {
        return (this.leftmost7Bits() & 0x3F) == 62;
    }

    public static Decimal valueOf(BigDecimal bigdec) {
        Decimal64 dec64 = new Decimal64(bigdec);
        Decimal128 dec128 = new Decimal128(bigdec);
        if (!dec64.isSameValue(dec128)) {
            return dec128;
        }
        Decimal32 dec32 = new Decimal32(bigdec);
        return dec32.isSameValue(dec64) ? dec32 : dec64;
    }

    public boolean isSameValue(Decimal that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() == that.getClass()) {
            return this.equals(that);
        }
        if (!this.isFinite() || !that.isFinite()) {
            return this.isSigned() == that.isSigned() && this.isInfinite() == that.isInfinite() && this.isQuietNaN() == that.isQuietNaN() && this.isSignalingNaN() == that.isSignalingNaN();
        }
        Decimal dec1 = this;
        Decimal dec2 = that;
        switch (dec1.getBitLength() << 8 | dec2.getBitLength()) {
            case 16416: {
                dec1 = that;
                dec2 = this;
            }
            case 8256: {
                Decimal32 dec32 = (Decimal32)dec1;
                Decimal64 dec64 = (Decimal64)dec2;
                return dec32.isSigned() == dec64.isSigned() && dec32.getExponent() == dec64.getExponent() && (long)dec32.getSignificand() == dec64.getSignificand();
            }
            case 32800: {
                dec1 = that;
                dec2 = this;
            }
            case 8320: {
                Decimal32 dec32 = (Decimal32)dec1;
                Decimal128 dec128 = (Decimal128)dec2;
                return dec32.isSigned() == dec128.isSigned() && dec32.getExponent() == dec128.getExponent() && BigInteger.valueOf(dec32.getSignificand()).equals(dec128.getSignificand());
            }
            case 32832: {
                dec1 = that;
                dec2 = this;
            }
            case 16512: {
                Decimal64 dec64 = (Decimal64)dec1;
                Decimal128 dec128 = (Decimal128)dec2;
                return dec64.isSigned() == dec128.isSigned() && dec64.getExponent() == dec128.getExponent() && BigInteger.valueOf(dec64.getSignificand()).equals(dec128.getSignificand());
            }
        }
        throw new UnsupportedOperationException("dec1=" + dec1.getClass().getName() + ", dec2=" + dec1.getClass().getName());
    }

    public void writeBytes(DataOutput out) throws IOException {
        int c = this.getByteLength();
        for (int i = 0; i < c; ++i) {
            out.writeByte(this.getByte(i));
        }
    }

    public int compareForObjectOrder(Decimal that) {
        if (this == that) {
            return 0;
        }
        BigDecimal bdecThis = this.toBigDecimal();
        BigDecimal bdecThat = that.toBigDecimal();
        if (bdecThis == null || bdecThat == null) {
            int nThis;
            int n = this.isNaN() ? -2 : (this.isFinite() ? 0 : (nThis = this.isSigned() ? -1 : 1));
            int nThat = that.isNaN() ? -2 : (that.isFinite() ? 0 : (that.isSigned() ? -1 : 1));
            return nThis - nThat;
        }
        return bdecThis.compareTo(bdecThat);
    }

    public Decimal abs() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(big.abs());
        }
        return this.isSigned() ? this.infinity(false) : this;
    }

    public Decimal neg() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(big.negate());
        }
        return this.infinity(!this.isSigned());
    }

    public Decimal floor() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(big.setScale(0, RoundingMode.FLOOR));
        }
        return this;
    }

    public Decimal ceil() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(big.setScale(0, RoundingMode.CEILING));
        }
        return this;
    }

    public Decimal exp() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.exp(big.doubleValue())));
        }
        return this.isSigned() ? this.zero(false) : this;
    }

    public Decimal log() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.log(big.doubleValue())));
        }
        return this.isSigned() ? this.nan() : this;
    }

    public Decimal log2() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(new BigDecimal(Math.log10(big.doubleValue()) * LOG2_10));
        }
        return this.isSigned() ? this.nan() : this;
    }

    public Decimal log10() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.log10(big.doubleValue())));
        }
        return this.isSigned() ? this.nan() : this;
    }

    public Decimal sqrt() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(big.sqrt(this.getMathContext()));
        }
        return this.isSigned() ? this.nan() : this;
    }

    public Decimal cbrt() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.cbrt(big.doubleValue())));
        }
        return this;
    }

    public Decimal sin() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.sin(big.doubleValue())));
        }
        return this.nan();
    }

    public Decimal tan() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.tan(big.doubleValue())));
        }
        return this.nan();
    }

    public Decimal asin() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.asin(big.doubleValue())));
        }
        return this.nan();
    }

    public Decimal acos() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.acos(big.doubleValue())));
        }
        return this.nan();
    }

    public Decimal atan() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.atan(big.doubleValue())));
        }
        return this.nan();
    }

    public Decimal sinh() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.sinh(big.doubleValue())));
        }
        return this.nan();
    }

    public Decimal cosh() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.cosh(big.doubleValue())));
        }
        return this.nan();
    }

    public Decimal tanh() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.tanh(big.doubleValue())));
        }
        return this.nan();
    }

    public Decimal asinh() {
        if (this.isFinite()) {
            double d = this.toBigDecimal().doubleValue();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.log(d + Math.sqrt(d * d + 1.0))));
        }
        return this.nan();
    }

    public Decimal acosh() {
        if (this.isFinite()) {
            double d = this.toBigDecimal().doubleValue();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.log(d + Math.sqrt(d * d - 1.0))));
        }
        return this.nan();
    }

    public Decimal atanh() {
        if (this.isFinite()) {
            double d = this.toBigDecimal().doubleValue();
            return this.fromBigDecimal(BigDecimal.valueOf(0.5 * Math.log((d + 1.0) / (d - 1.0))));
        }
        return this.nan();
    }

    public Decimal deg2rad() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.toRadians(big.doubleValue())));
        }
        return this;
    }

    public Decimal rad2deg() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.toDegrees(big.doubleValue())));
        }
        return this;
    }

    public Decimal nextUp() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.nextUp(big.doubleValue())));
        }
        return this;
    }

    public Decimal nextDown() {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(BigDecimal.valueOf(Math.nextDown(big.doubleValue())));
        }
        return this;
    }

    public Decimal round(RoundingMode mode) {
        if (this.isFinite()) {
            BigDecimal big = this.toBigDecimal();
            return this.fromBigDecimal(big.setScale(0, mode));
        }
        return this;
    }

    public Decimal add(Decimal that) {
        if (this.isFinite() && that.isFinite()) {
            BigDecimal big1 = this.toBigDecimal();
            BigDecimal big2 = that.toBigDecimal();
            return this.fromBigDecimal(big1.add(big2, this.getMathContext()));
        }
        return this.isFinite() ? that : (that.isFinite() ? this : (this.isSigned() == that.isSigned() ? this : this.nan()));
    }

    public Decimal subtract(Decimal that) {
        if (this.isFinite() && that.isFinite()) {
            BigDecimal big1 = this.toBigDecimal();
            BigDecimal big2 = that.toBigDecimal();
            return this.fromBigDecimal(big1.subtract(big2, this.getMathContext()));
        }
        return this.isFinite() ? this.infinity(!that.isSigned()) : (that.isFinite() ? this : (this.isSigned() == that.isSigned() ? this.nan() : this));
    }

    public Decimal multiply(Decimal that) {
        if (this.isFinite() && that.isFinite()) {
            BigDecimal big1 = this.toBigDecimal();
            BigDecimal big2 = that.toBigDecimal();
            return this.fromBigDecimal(big1.multiply(big2, this.getMathContext()));
        }
        return this.infinity(that.isSigned() != this.isSigned());
    }

    public Decimal divide(Decimal that) {
        if (this.isFinite() && that.isFinite()) {
            BigDecimal big1 = this.toBigDecimal();
            BigDecimal big2 = that.toBigDecimal();
            return this.fromBigDecimal(big1.divide(big2, this.getMathContext()));
        }
        return this.isFinite() ? this.zero(this.isSigned() != that.isSigned()) : this.nan();
    }

    public Decimal mod(Decimal that) {
        if (this.isFinite() && that.isFinite()) {
            BigDecimal big2;
            BigDecimal big1 = this.toBigDecimal();
            BigDecimal bigR = big1.remainder(big2 = that.toBigDecimal(), this.getMathContext());
            return this.fromBigDecimal(bigR.signum() >= 0 ? bigR : bigR.add(big2));
        }
        return this.nan();
    }

    public Decimal pow(Decimal that) {
        if (this.isFinite()) {
            if (that.isFinite()) {
                BigDecimal big1 = this.toBigDecimal();
                BigDecimal big2 = that.toBigDecimal();
                return this.fromBigDecimal(big1.pow(big2.intValue(), this.getMathContext()));
            }
            return this.nan();
        }
        return this;
    }

    public Decimal pow(int nPow) {
        if (this.isFinite()) {
            BigDecimal big1 = this.toBigDecimal();
            return this.fromBigDecimal(big1.pow(nPow, this.getMathContext()));
        }
        return this;
    }

    public Decimal atan2(Decimal that) {
        if (this.isFinite()) {
            if (that.isFinite()) {
                BigDecimal big1 = this.toBigDecimal();
                BigDecimal big2 = that.toBigDecimal();
                return this.fromBigDecimal(BigDecimal.valueOf(Math.atan2(big1.doubleValue(), big2.doubleValue())));
            }
            return that;
        }
        return this;
    }

    public abstract BigDecimal toBigDecimal();

    public abstract Decimal fromBigDecimal(BigDecimal var1);

    public abstract Decimal infinity(boolean var1);

    public abstract Decimal zero(boolean var1);

    public abstract Decimal nan();

    public abstract byte[] toByteArray();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public String toString() {
        if (this.isFinite()) {
            return this.isZero() && this.isSigned() ? "-0" : this.toBigDecimal().stripTrailingZeros().toEngineeringString();
        }
        if (this.isInfinite()) {
            return String.valueOf(this.isSigned() ? Character.valueOf('-') : "") + "Infinity";
        }
        return this.isSignalingNaN() ? "sNaN" : "NaN";
    }

    public static int intToDeclet(int nDigits) {
        return Decimal.digitsToDeclet(nDigits / 100 % 10, nDigits / 10 % 10, nDigits % 10);
    }

    public static int digitsToDeclet(int d1, int d2, int d3) {
        return switch ((d1 & 8) >>> 1 | (d2 & 8) >>> 2 | (d3 & 8) >>> 3) {
            case 0 -> 0 | (d1 & 7) << 7 | (d2 & 7) << 4 | d3 & 7;
            case 1 -> 8 | (d1 & 7) << 7 | (d2 & 7) << 4 | d3 & 1;
            case 2 -> 0xA | (d1 & 7) << 7 | (d3 & 6 | d2 & 1) << 4 | d3 & 1;
            case 3 -> 0x4E | (d1 & 7) << 7 | (d2 & 1) << 4 | d3 & 1;
            case 4 -> 0xC | (d3 & 6 | d1 & 1) << 7 | (d2 & 7) << 4 | d3 & 1;
            case 5 -> 0x2E | (d2 & 6 | d1 & 1) << 7 | (d2 & 1) << 4 | d3 & 1;
            case 6 -> 0xE | (d3 & 6 | d1 & 1) << 7 | (d2 & 1) << 4 | d3 & 1;
            case 7 -> 0x6E | (d1 & 1) << 7 | (d2 & 1) << 4 | d3 & 1;
            default -> throw new IllegalArgumentException("d1=" + d1 + ", d2=" + d2 + ", d3=" + d3);
        };
    }

    public static int decletToInt(int nBits) {
        switch ((nBits & 0xE) << 1 | (nBits & 0x60) >>> 5) {
            default: {
                return 100 * ((nBits & 0x380) >>> 7) + 10 * ((nBits & 0x70) >>> 4) + (nBits & 7);
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 100 * ((nBits & 0x380) >>> 7) + 10 * ((nBits & 0x70) >>> 4) + (8 + (nBits & 1));
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return 100 * ((nBits & 0x380) >>> 7) + 10 * (8 + ((nBits & 0x10) >>> 4)) + (((nBits & 0x60) >>> 4) + (nBits & 1));
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return 100 * (8 + ((nBits & 0x80) >>> 7)) + 10 * ((nBits & 0x70) >>> 4) + (((nBits & 0x300) >>> 7) + (nBits & 1));
            }
            case 28: {
                return 100 * (8 + ((nBits & 0x80) >>> 7)) + 10 * (8 + ((nBits & 0x10) >>> 4)) + (((nBits & 0x300) >>> 7) + (nBits & 1));
            }
            case 29: {
                return 100 * (8 + ((nBits & 0x80) >>> 7)) + 10 * (((nBits & 0x300) >>> 7) + ((nBits & 0x10) >>> 4)) + (8 + (nBits & 1));
            }
            case 30: {
                return 100 * ((nBits & 0x380) >>> 7) + 10 * (8 + ((nBits & 0x10) >>> 4)) + (8 + (nBits & 1));
            }
            case 31: 
        }
        return 100 * (8 + ((nBits & 0x80) >>> 7)) + 10 * (8 + ((nBits & 0x10) >>> 4)) + (8 + (nBits & 1));
    }

    public static int decletToDigits(int nBits) {
        switch ((nBits & 0xE) << 1 | (nBits & 0x60) >>> 5) {
            default: {
                return 256 * ((nBits & 0x380) >>> 7) + 16 * ((nBits & 0x70) >>> 4) + (nBits & 7);
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 256 * ((nBits & 0x380) >>> 7) + 16 * ((nBits & 0x70) >>> 4) + (8 + (nBits & 1));
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return 256 * ((nBits & 0x380) >>> 7) + 16 * (8 + ((nBits & 0x10) >>> 4)) + (((nBits & 0x60) >>> 4) + (nBits & 1));
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return 256 * (8 + ((nBits & 0x80) >>> 7)) + 16 * ((nBits & 0x70) >>> 4) + (((nBits & 0x300) >>> 7) + (nBits & 1));
            }
            case 28: {
                return 256 * (8 + ((nBits & 0x80) >>> 7)) + 16 * (8 + ((nBits & 0x10) >>> 4)) + (((nBits & 0x300) >>> 7) + (nBits & 1));
            }
            case 29: {
                return 256 * (8 + ((nBits & 0x80) >>> 7)) + 16 * (((nBits & 0x300) >>> 7) + ((nBits & 0x10) >>> 4)) + (8 + (nBits & 1));
            }
            case 30: {
                return 256 * ((nBits & 0x380) >>> 7) + 16 * (8 + ((nBits & 0x10) >>> 4)) + (8 + (nBits & 1));
            }
            case 31: 
        }
        return 256 * (8 + ((nBits & 0x80) >>> 7)) + 16 * (8 + ((nBits & 0x10) >>> 4)) + (8 + (nBits & 1));
    }

    public static class RangeException
    extends ArithmeticException {
        private final Decimal f_decNaN;

        public RangeException(String s, Decimal decNaN) {
            super(s);
            this.f_decNaN = decNaN;
        }

        public Decimal getDecimal() {
            return this.f_decNaN;
        }
    }
}

