/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.type;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.xvm.type.Decimal;

public class Decimal128
extends Decimal {
    private static final BigInteger BIGINT_ZERO = BigInteger.ZERO;
    private static final BigInteger BIGINT_THOUSAND = BigInteger.valueOf(1000L);
    private static final BigInteger BIGINT_10_TO_18TH = new BigInteger("1000000000000000000");
    private static final long LS46BITS = 0x3FFFFFFFFFFFL;
    private static final long SIGN_BIT = Long.MIN_VALUE;
    private static final int G3_SHIFT = 59;
    private static final long G0_G3_MASK = 0x7800000000000000L;
    private static final int G4_SHIFT = 58;
    private static final long G0_G4_NAN = 0x7C00000000000000L;
    private static final long G0_G4_INF = 0x7800000000000000L;
    private static final int G5_SHIFT = 57;
    private static final long G5_SIGNAL = 0x200000000000000L;
    public static final Decimal128 POS_ZERO = new Decimal128(0x2208000000000000L, 0L);
    public static final Decimal128 NEG_ZERO = new Decimal128(-6771162039751540736L, 0L);
    public static final Decimal128 POS_ONE = new Decimal128(0x2208000000000000L, 1L);
    public static final Decimal128 NEG_ONE = new Decimal128(-6771162039751540736L, 1L);
    public static final Decimal128 NaN = new Decimal128(0x7C00000000000000L, 0L);
    public static final Decimal128 SNaN = new Decimal128(0x7E00000000000000L, 0L);
    public static final Decimal128 POS_INFINITY = new Decimal128(0x7800000000000000L, 0L);
    public static final Decimal128 NEG_INFINITY = new Decimal128(-576460752303423488L, 0L);
    private long m_nHBits;
    private long m_nLBits;
    private transient BigDecimal m_dec;

    public Decimal128(DataInput in) throws IOException {
        this.m_nHBits = in.readLong();
        this.m_nLBits = in.readLong();
    }

    public Decimal128(long nHBits, long nLBits) {
        this.m_nHBits = nHBits;
        this.m_nLBits = nLBits;
    }

    public Decimal128(byte[] abValue) {
        if (abValue == null) {
            throw new IllegalArgumentException("value required");
        }
        if (abValue.length != 16) {
            throw new IllegalArgumentException("byte count != 16 (actual=" + abValue.length + ")");
        }
        int MSB = (abValue[0] & 0xFF) << 24 | (abValue[1] & 0xFF) << 16 | (abValue[2] & 0xFF) << 8 | abValue[3] & 0xFF;
        int LSB = (abValue[4] & 0xFF) << 24 | (abValue[5] & 0xFF) << 16 | (abValue[6] & 0xFF) << 8 | abValue[7] & 0xFF;
        this.m_nHBits = (long)MSB << 32 | (long)LSB & 0xFFFFFFFFL;
        MSB = (abValue[8] & 0xFF) << 24 | (abValue[9] & 0xFF) << 16 | (abValue[10] & 0xFF) << 8 | abValue[11] & 0xFF;
        LSB = (abValue[12] & 0xFF) << 24 | (abValue[13] & 0xFF) << 16 | (abValue[14] & 0xFF) << 8 | abValue[15] & 0xFF;
        this.m_nLBits = (long)MSB << 32 | (long)LSB & 0xFFFFFFFFL;
    }

    public Decimal128(BigDecimal dec) {
        if (dec == null) {
            throw new IllegalArgumentException("value required");
        }
        this.convertBigDecToLongs(dec.round(MathContext.DECIMAL128));
    }

    @Override
    public int getByteLength() {
        return 16;
    }

    @Override
    public MathContext getMathContext() {
        return MathContext.DECIMAL128;
    }

    @Override
    public int getByte(int i) {
        if ((i & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("index out of range: " + i);
        }
        long lBits = i < 8 ? this.m_nHBits : this.m_nLBits;
        return (int)(lBits >>> (i & 7) * 8) & 0xFF;
    }

    @Override
    protected int leftmost7Bits() {
        return (int)(this.m_nHBits >>> 57);
    }

    @Override
    public boolean isZero() {
        return (this.leftmost7Bits() & 0x30) != 48 && (this.m_nHBits & 0x3FFFFFFFFFFFL) == 0L && this.m_nLBits == 0L;
    }

    @Override
    public void writeBytes(DataOutput out) throws IOException {
        out.writeLong(this.m_nHBits);
        out.writeLong(this.m_nLBits);
    }

    public BigInteger getSignificand() {
        long nHBits = Decimal128.ensureFiniteHighBits(this.m_nHBits);
        long nLBits = this.m_nLBits;
        int nToG4 = (int)(nHBits >>> 58);
        int nD0 = (nToG4 & 0x18) == 24 ? (nToG4 & 1) + 8 : nToG4 & 7;
        long nHSig = nD0;
        if (nHSig != 0L || (nHBits &= 0x3FFFFFFFFFFFL) != 0L) {
            for (int of = 36; of >= 0; of -= 10) {
                nHSig = nHSig * 1000L + (long)Decimal128.decletToInt((int)(nHBits >>> of));
            }
        }
        long nLSig = 0L;
        if (nHSig != 0L || nLBits != 0L) {
            nHSig = nHSig * 1000L + (long)Decimal128.decletToInt((int)(nHBits << 4 | nLBits >>> 60));
            for (int of = 50; of >= 0; of -= 10) {
                nLSig = nLSig * 1000L + (long)Decimal128.decletToInt((int)(nLBits >>> of));
            }
        }
        BigInteger bintL = nLSig == 0L ? BIGINT_ZERO : BigInteger.valueOf(nLSig);
        return nHSig == 0L ? bintL : BigInteger.valueOf(nHSig).multiply(BIGINT_10_TO_18TH).add(bintL);
    }

    public int getExponent() {
        int nCombo = (int)(Decimal128.ensureFiniteHighBits(this.m_nHBits) >>> 46);
        int nExp = (nCombo & 0x18000) == 98304 ? (nCombo & 0x6000) >>> 1 : (nCombo & 0x18000) >>> 3;
        return (nExp | nCombo & 0xFFF) - 6176;
    }

    public long getHighBits() {
        return this.m_nHBits;
    }

    public long getLowBits() {
        return this.m_nLBits;
    }

    @Override
    public BigDecimal toBigDecimal() {
        BigDecimal dec = this.m_dec;
        if (dec == null && this.isFinite()) {
            dec = new BigDecimal(this.getSignificand(), -this.getExponent(), MathContext.DECIMAL128);
            dec = this.isSigned() ? dec.negate() : dec;
            this.m_dec = dec;
        }
        return dec;
    }

    @Override
    public Decimal fromBigDecimal(BigDecimal big) {
        try {
            return new Decimal128(big);
        }
        catch (Decimal.RangeException e) {
            return e.getDecimal();
        }
    }

    @Override
    public Decimal infinity(boolean fSigned) {
        return fSigned ? NEG_INFINITY : POS_INFINITY;
    }

    @Override
    public Decimal zero(boolean fSigned) {
        return fSigned ? NEG_ZERO : POS_ZERO;
    }

    @Override
    public Decimal nan() {
        return NaN;
    }

    @Override
    public byte[] toByteArray() {
        byte[] ab = new byte[16];
        long nBits = this.m_nHBits;
        int MSB = (int)(nBits >>> 32);
        int LSB = (int)nBits;
        ab[0] = (byte)(MSB >>> 24);
        ab[1] = (byte)(MSB >>> 16);
        ab[2] = (byte)(MSB >>> 8);
        ab[3] = (byte)MSB;
        ab[4] = (byte)(LSB >>> 24);
        ab[5] = (byte)(LSB >>> 16);
        ab[6] = (byte)(LSB >>> 8);
        ab[7] = (byte)LSB;
        nBits = this.m_nLBits;
        MSB = (int)(nBits >>> 32);
        LSB = (int)nBits;
        ab[8] = (byte)(MSB >>> 24);
        ab[9] = (byte)(MSB >>> 16);
        ab[10] = (byte)(MSB >>> 8);
        ab[11] = (byte)MSB;
        ab[12] = (byte)(LSB >>> 24);
        ab[13] = (byte)(LSB >>> 16);
        ab[14] = (byte)(LSB >>> 8);
        ab[15] = (byte)LSB;
        return ab;
    }

    @Override
    public int hashCode() {
        return (int)(this.m_nHBits >>> 32) ^ (int)this.m_nHBits ^ (int)(this.m_nLBits >>> 32) ^ (int)this.m_nLBits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Decimal128)) return false;
        Decimal128 that = (Decimal128)obj;
        if (!(this.m_nHBits == that.m_nHBits & that.m_nLBits == that.m_nLBits)) return false;
        return true;
    }

    private static long ensureFiniteHighBits(long nHBits) {
        if ((nHBits & 0x7800000000000000L) == 0x7800000000000000L) {
            throw new NumberFormatException("Not a finite value");
        }
        return nHBits;
    }

    private void convertBigDecToLongs(BigDecimal dec) {
        boolean fNeg;
        switch (dec.signum()) {
            case -1: {
                fNeg = true;
                break;
            }
            case 0: {
                this.m_nHBits = Decimal128.POS_ZERO.m_nHBits;
                this.m_nLBits = Decimal128.POS_ZERO.m_nLBits;
                return;
            }
            case 1: {
                fNeg = false;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        BigInteger bint = dec.unscaledValue().abs();
        if (bint.bitLength() > 114) {
            throw new ArithmeticException("significand is >34 digits: " + String.valueOf(bint));
        }
        int nExp = 6176 - dec.scale();
        if (nExp < 0 || nExp >= 12288) {
            throw new ArithmeticException("biased exponent is out of range [0,12288): " + nExp);
        }
        long nHBits = 0L;
        long nLBits = 0L;
        for (int i = 0; i < 11 && bint.signum() > 0; ++i) {
            BigInteger[] abintDivRem = bint.divideAndRemainder(BIGINT_THOUSAND);
            BigInteger bintTriad = abintDivRem[1];
            int nDeclet = Decimal128.intToDeclet(bintTriad.intValue());
            if (i < 6) {
                nLBits |= (long)nDeclet << i * 10;
            } else if (i == 6) {
                nLBits |= (long)nDeclet << 60;
                nHBits = nDeclet >>> 4;
            } else {
                nHBits |= (long)nDeclet << (i - 7) * 10 + 6;
            }
            bint = abintDivRem[0];
        }
        nHBits |= ((long)nExp & 0xFFFL) << 46;
        int nSigRem = bint.intValueExact();
        if (nSigRem > 9) {
            throw new ArithmeticException("significand is >34 digits: " + String.valueOf(dec.unscaledValue().abs()));
        }
        int nGBits = nSigRem >= 8 ? 0x18 | nSigRem & 1 | (nExp & 0x3000) >>> 11 : nSigRem & 7 | (nExp & 0x3000) >>> 9;
        nHBits |= (long)nGBits << 58;
        if (fNeg) {
            nHBits |= Long.MIN_VALUE;
        }
        this.m_nHBits = nHBits;
        this.m_nLBits = nLBits;
    }
}

