/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.type;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.xvm.type.Decimal;

public class Decimal32
extends Decimal {
    private static final int SIGN_BIT = Integer.MIN_VALUE;
    private static final int G3_SHIFT = 27;
    private static final int G0_G3_MASK = 0x78000000;
    private static final int G4_SHIFT = 26;
    private static final int G0_G4_NAN = 0x7C000000;
    private static final int G0_G4_INF = 0x78000000;
    private static final int G5_SHIFT = 25;
    private static final int G5_SIGNAL = 0x2000000;
    public static final Decimal32 POS_ZERO = new Decimal32(0x22500000);
    public static final Decimal32 NEG_ZERO = new Decimal32(-1571815424);
    public static final Decimal32 POS_ONE = new Decimal32(575668225);
    public static final Decimal32 NEG_ONE = new Decimal32(-1571815423);
    public static final Decimal32 NaN = new Decimal32(0x7C000000);
    public static final Decimal32 SNaN = new Decimal32(0x7E000000);
    public static final Decimal32 POS_INFINITY = new Decimal32(0x78000000);
    public static final Decimal32 NEG_INFINITY = new Decimal32(-134217728);
    private final int m_nBits;
    private transient BigDecimal m_dec;

    public Decimal32(DataInput in) throws IOException {
        this.m_nBits = in.readInt();
    }

    public Decimal32(int nBits) {
        this.m_nBits = nBits;
    }

    public Decimal32(byte[] abValue) {
        if (abValue == null) {
            throw new IllegalArgumentException("value required");
        }
        if (abValue.length != 4) {
            throw new IllegalArgumentException("byte count != 4 (actual=" + abValue.length + ")");
        }
        this.m_nBits = (abValue[0] & 0xFF) << 24 | (abValue[1] & 0xFF) << 16 | (abValue[2] & 0xFF) << 8 | abValue[3] & 0xFF;
    }

    public Decimal32(BigDecimal dec) {
        if (dec == null) {
            throw new IllegalArgumentException("value required");
        }
        this.m_nBits = Decimal32.toIntBits(dec);
    }

    @Override
    public int getByteLength() {
        return 4;
    }

    @Override
    public MathContext getMathContext() {
        return MathContext.DECIMAL32;
    }

    @Override
    public int getByte(int i) {
        if ((i & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("index out of range: " + i);
        }
        return this.m_nBits >>> i * 8 & 0xFF;
    }

    @Override
    protected int leftmost7Bits() {
        return this.m_nBits >>> 25;
    }

    @Override
    public boolean isZero() {
        return (this.leftmost7Bits() & 0x30) != 48 && (this.m_nBits & 0x1C0FFFFF) == 0;
    }

    @Override
    public void writeBytes(DataOutput out) throws IOException {
        out.writeInt(this.m_nBits);
    }

    public int getSignificand() {
        int nBits = Decimal32.ensureFiniteBits(this.m_nBits);
        int nToG4 = nBits >>> 26;
        int nSig = (nToG4 & 0x18) == 24 ? (nToG4 & 1) + 8 : nToG4 & 7;
        nSig = nSig * 1000 + Decimal32.decletToInt(nBits >>> 10);
        return nSig * 1000 + Decimal32.decletToInt(nBits);
    }

    public int getExponent() {
        int nCombo = Decimal32.ensureFiniteBits(this.m_nBits) >>> 20;
        int nExp = (nCombo & 0x600) == 1536 ? (nCombo & 0x180) >>> 1 : (nCombo & 0x600) >>> 3;
        return (nExp | nCombo & 0x3F) - 101;
    }

    public int toIntBits() {
        return this.m_nBits;
    }

    @Override
    public BigDecimal toBigDecimal() {
        BigDecimal dec = this.m_dec;
        if (dec == null && this.isFinite()) {
            this.m_dec = dec = Decimal32.toBigDecimal(this.m_nBits);
        }
        return dec;
    }

    @Override
    public Decimal fromBigDecimal(BigDecimal big) {
        try {
            return new Decimal32(big);
        }
        catch (Decimal.RangeException e) {
            return e.getDecimal();
        }
    }

    @Override
    public Decimal infinity(boolean fSigned) {
        return fSigned ? NEG_INFINITY : POS_INFINITY;
    }

    @Override
    public Decimal zero(boolean fSigned) {
        return fSigned ? NEG_ZERO : POS_ZERO;
    }

    @Override
    public Decimal nan() {
        return NaN;
    }

    @Override
    public byte[] toByteArray() {
        int n = this.m_nBits;
        byte[] ab = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        return ab;
    }

    @Override
    public int hashCode() {
        return this.m_nBits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Decimal32)) return false;
        Decimal32 that = (Decimal32)obj;
        if (this.m_nBits != that.m_nBits) return false;
        return true;
    }

    public static int ensureFiniteBits(int nBits) {
        if ((nBits & 0x78000000) == 0x78000000) {
            throw new NumberFormatException("Not a finite value");
        }
        return nBits;
    }

    public static int toIntBits(BigDecimal dec) {
        int nExp;
        int nSig = (dec = dec.round(MathContext.DECIMAL32)).unscaledValue().intValueExact();
        if (nSig < -9999999 || nSig > 9999999) {
            throw new ArithmeticException("significand is >7 digits: " + nSig);
        }
        int nBits = 0;
        if (nSig < 0) {
            nBits = Integer.MIN_VALUE;
            nSig = -nSig;
        }
        if ((nExp = 101 - dec.scale()) < 0 || nExp >= 192) {
            throw new ArithmeticException("biased exponent is out of range [0,192): " + nExp);
        }
        nBits |= (nExp & 0x3F) << 20 | Decimal32.intToDeclet(nSig / 1000 % 1000) << 10 | Decimal32.intToDeclet(nSig % 1000);
        return nBits |= (nSig /= 1000000) >= 8 ? (0x18 | nSig & 1 | (nExp & 0xC0) >>> 5) << 26 : (nSig & 7 | (nExp & 0xC0) >>> 3) << 26;
    }

    public static BigDecimal toBigDecimal(int nBits) {
        int nSig;
        Decimal32.ensureFiniteBits(nBits);
        int nCombo = nBits >>> 20;
        int nExp = nCombo & 0x3F;
        if ((nCombo & 0x600) == 1536) {
            nExp |= (nCombo & 0x180) >>> 1;
            nSig = ((nCombo & 0x40) >>> 6) + 8;
        } else {
            nExp |= (nCombo & 0x600) >>> 3;
            nSig = (nCombo & 0x1C0) >>> 6;
        }
        nSig = ((nSig * 1000 + Decimal32.decletToInt(nBits >>> 10)) * 1000 + Decimal32.decletToInt(nBits)) * ((nBits & Integer.MIN_VALUE) >> 31 | 1);
        return new BigDecimal(BigInteger.valueOf(nSig), -(nExp -= 101), MathContext.DECIMAL32);
    }
}

