/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.type;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.xvm.type.Decimal;

public class Decimal64
extends Decimal {
    private static final long SIGN_BIT = Long.MIN_VALUE;
    private static final int G3_SHIFT = 59;
    private static final long G0_G3_MASK = 0x7800000000000000L;
    private static final int G4_SHIFT = 58;
    private static final long G0_G4_NAN = 0x7C00000000000000L;
    private static final long G0_G4_INF = 0x7800000000000000L;
    private static final int G5_SHIFT = 57;
    private static final long G5_SIGNAL = 0x200000000000000L;
    public static final Decimal64 POS_ZERO = new Decimal64(2465720795985346560L);
    public static final Decimal64 NEG_ZERO = new Decimal64(-6757651240869429248L);
    public static final Decimal64 POS_ONE = new Decimal64(2465720795985346561L);
    public static final Decimal64 NEG_ONE = new Decimal64(-6757651240869429247L);
    public static final Decimal64 NaN = new Decimal64(0x7C00000000000000L);
    public static final Decimal64 SNaN = new Decimal64(0x7E00000000000000L);
    public static final Decimal64 POS_INFINITY = new Decimal64(0x7800000000000000L);
    public static final Decimal64 NEG_INFINITY = new Decimal64(-576460752303423488L);
    private final long m_nBits;
    private transient BigDecimal m_dec;

    public Decimal64(DataInput in) throws IOException {
        this.m_nBits = in.readLong();
    }

    public Decimal64(long nBits) {
        this.m_nBits = nBits;
    }

    public Decimal64(byte[] abValue) {
        if (abValue == null) {
            throw new IllegalArgumentException("value required");
        }
        if (abValue.length != 8) {
            throw new IllegalArgumentException("byte count != 8 (actual=" + abValue.length + ")");
        }
        int MSB = (abValue[0] & 0xFF) << 24 | (abValue[1] & 0xFF) << 16 | (abValue[2] & 0xFF) << 8 | abValue[3] & 0xFF;
        int LSB = (abValue[4] & 0xFF) << 24 | (abValue[5] & 0xFF) << 16 | (abValue[6] & 0xFF) << 8 | abValue[7] & 0xFF;
        this.m_nBits = (long)MSB << 32 | (long)LSB & 0xFFFFFFFFL;
    }

    public Decimal64(BigDecimal dec) {
        if (dec == null) {
            throw new IllegalArgumentException("value required");
        }
        this.m_nBits = Decimal64.toLongBits(dec);
    }

    @Override
    public int getByteLength() {
        return 8;
    }

    @Override
    public MathContext getMathContext() {
        return MathContext.DECIMAL64;
    }

    @Override
    public int getByte(int i) {
        if ((i & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException("index out of range: " + i);
        }
        return (int)(this.m_nBits >>> i * 8) & 0xFF;
    }

    @Override
    protected int leftmost7Bits() {
        return (int)(this.m_nBits >>> 57);
    }

    @Override
    public boolean isZero() {
        return (this.leftmost7Bits() & 0x30) != 48 && (this.m_nBits & 0x1C03FFFFFFFFFFFFL) == 0L;
    }

    @Override
    public void writeBytes(DataOutput out) throws IOException {
        out.writeLong(this.m_nBits);
    }

    public long getSignificand() {
        long nBits = Decimal64.ensureFiniteBits(this.m_nBits);
        int nToG4 = (int)(nBits >>> 58);
        long nSig = (nToG4 & 0x18) == 24 ? (long)((nToG4 & 1) + 8) : (long)(nToG4 & 7);
        for (int cShift = 40; cShift >= 0; cShift -= 10) {
            nSig = nSig * 1000L + (long)Decimal64.decletToInt((int)(nBits >>> cShift));
        }
        return nSig;
    }

    public int getExponent() {
        int nCombo = (int)(Decimal64.ensureFiniteBits(this.m_nBits) >>> 50);
        int nExp = (nCombo & 0x1800) == 6144 ? (nCombo & 0x600) >>> 1 : (nCombo & 0x1800) >>> 3;
        return (nExp | nCombo & 0xFF) - 398;
    }

    public long toLongBits() {
        return this.m_nBits;
    }

    @Override
    public BigDecimal toBigDecimal() {
        BigDecimal dec = this.m_dec;
        if (dec == null && this.isFinite()) {
            this.m_dec = dec = Decimal64.toBigDecimal(this.m_nBits);
        }
        return dec;
    }

    @Override
    public Decimal fromBigDecimal(BigDecimal big) {
        try {
            return new Decimal64(big);
        }
        catch (Decimal.RangeException e) {
            return e.getDecimal();
        }
    }

    @Override
    public Decimal infinity(boolean fSigned) {
        return fSigned ? NEG_INFINITY : POS_INFINITY;
    }

    @Override
    public Decimal zero(boolean fSigned) {
        return fSigned ? NEG_ZERO : POS_ZERO;
    }

    @Override
    public Decimal nan() {
        return NaN;
    }

    @Override
    public byte[] toByteArray() {
        long nBits = this.m_nBits;
        int MSB = (int)(nBits >>> 32);
        int LSB = (int)nBits;
        byte[] ab = new byte[]{(byte)(MSB >>> 24), (byte)(MSB >>> 16), (byte)(MSB >>> 8), (byte)MSB, (byte)(LSB >>> 24), (byte)(LSB >>> 16), (byte)(LSB >>> 8), (byte)LSB};
        return ab;
    }

    @Override
    public int hashCode() {
        return (int)(this.m_nBits >>> 32) ^ (int)this.m_nBits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Decimal64)) return false;
        Decimal64 that = (Decimal64)obj;
        if (this.m_nBits != that.m_nBits) return false;
        return true;
    }

    public static long ensureFiniteBits(long nBits) {
        if ((nBits & 0x7800000000000000L) == 0x7800000000000000L) {
            throw new NumberFormatException("Not a finite value");
        }
        return nBits;
    }

    public static long toLongBits(BigDecimal dec) {
        long nSig = (dec = dec.round(MathContext.DECIMAL64)).unscaledValue().longValueExact();
        if (nSig < -9999999999999999L || nSig > 9999999999999999L) {
            throw new Decimal.RangeException("significand is >16 digits: " + nSig, nSig > 0L ? POS_INFINITY : NEG_INFINITY);
        }
        int nExp = 398 - dec.scale();
        if (nExp < 0 || nExp >= 768) {
            throw new Decimal.RangeException("biased exponent is out of range [0,768): " + nExp, nSig > 0L ? (nExp > 0 ? POS_INFINITY : POS_ZERO) : (nExp > 0 ? NEG_INFINITY : NEG_ZERO));
        }
        long nBits = 0L;
        if (nSig < 0L) {
            nBits = Long.MIN_VALUE;
            nSig = -nSig;
        }
        int nLeft = (int)(nSig / 1000000000L);
        int nRight = (int)(nSig % 1000000000L);
        int nSigRem = nLeft / 1000000;
        int nGBits = nSigRem >= 8 ? 0x18 | nSigRem & 1 | (nExp & 0x300) >>> 7 : nSigRem & 7 | (nExp & 0x300) >>> 5;
        return (nBits |= (long)(nExp & 0xFF) << 50 | (long)Decimal64.intToDeclet(nLeft / 1000 % 1000) << 40 | (long)Decimal64.intToDeclet(nLeft % 1000) << 30 | (long)Decimal64.intToDeclet(nRight / 1000000 % 1000) << 20 | (long)Decimal64.intToDeclet(nRight / 1000 % 1000) << 10 | (long)Decimal64.intToDeclet(nRight % 1000)) | (long)nGBits << 58;
    }

    public static BigDecimal toBigDecimal(long nBits) {
        long nSig;
        Decimal64.ensureFiniteBits(nBits);
        int nCombo = (int)(nBits >>> 50);
        int nExp = nCombo & 0xFF;
        if ((nCombo & 0x1800) == 6144) {
            nExp |= (nCombo & 0x600) >>> 1;
            nSig = ((nCombo & 0x100) >>> 8) + 8;
        } else {
            nExp |= (nCombo & 0x1800) >>> 3;
            nSig = (nCombo & 0x700) >>> 8;
        }
        nSig = (((((nSig * 1000L + (long)Decimal64.decletToInt((int)(nBits >>> 40))) * 1000L + (long)Decimal64.decletToInt((int)(nBits >>> 30))) * 1000L + (long)Decimal64.decletToInt((int)(nBits >>> 20))) * 1000L + (long)Decimal64.decletToInt((int)(nBits >>> 10))) * 1000L + (long)Decimal64.decletToInt((int)nBits)) * ((nBits & Long.MIN_VALUE) >> 63 | 1L);
        return new BigDecimal(BigInteger.valueOf(nSig), -(nExp -= 398), MathContext.DECIMAL64);
    }
}

