/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.BitSet;

public class BitCube {
    private final int f_cDims;
    private final int f_cTotal;
    private final int[] f_acSize;
    private final BitSet f_bs;

    public BitCube(int[] acSize) {
        this.f_cDims = acSize.length;
        this.f_acSize = acSize;
        assert (this.f_cDims >= 2);
        int cTotal = 1;
        for (int i = 0; i < this.f_cDims; ++i) {
            cTotal *= acSize[i];
        }
        this.f_cTotal = cTotal;
        this.f_bs = new BitSet(cTotal);
    }

    public int getDimensions() {
        return this.f_cDims;
    }

    public int getSize(int nDim) {
        return this.f_acSize[nDim];
    }

    public void set(int[] an) {
        this.f_bs.set(this.toId(an));
    }

    public boolean isFull() {
        return this.f_bs.cardinality() == this.f_cTotal;
    }

    private int toId(int[] an) {
        int n = an[this.f_cDims - 1];
        for (int i = this.f_cDims - 2; i >= 0; --i) {
            n *= this.f_acSize[i];
            n += an[i];
        }
        return n;
    }

    private int[] fromId(int n) {
        int[] an = new int[this.f_cDims];
        for (int i = 0; i < this.f_cDims; ++i) {
            int c = this.f_acSize[i];
            an[i] = n % c;
            n /= c;
        }
        return an;
    }
}

