/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.ArrayList;

public class ConsoleLog {
    private final String[] m_asLine = new String[1024];
    private int m_cLines = 0;
    private int m_iLine = 0;

    public void log(char[] ach, boolean addNewline) {
        int of;
        if (ach == null) {
            if (addNewline) {
                this.advance();
            }
            return;
        }
        int cch = ach.length;
        int ofStart = 0;
        for (of = 0; of < cch; ++of) {
            char ch = ach[of];
            if (ch == '\n') {
                if (of > ofStart) {
                    this.append(ach, ofStart, of - ofStart);
                }
                this.advance();
                ofStart = of + 1;
                continue;
            }
            if (Character.isDefined(ch) && !Character.isISOControl(ch)) continue;
            ach = (char[])ach.clone();
            ach[of] = 63;
        }
        if (of > ofStart) {
            this.append(ach, ofStart, of - ofStart);
        }
        if (addNewline) {
            this.advance();
        }
    }

    public int size() {
        return this.m_cLines;
    }

    public String get(int i) {
        int iLine = this.m_iLine - this.m_cLines + i;
        if (iLine < 0) {
            iLine += 1024;
        }
        return this.m_asLine[iLine];
    }

    public String render(int width, int height) {
        if (this.m_cLines == 0) {
            return "(No logged output.)";
        }
        int cchWide = width - 2;
        int cHigh = height - 2;
        StringBuilder sb = new StringBuilder(width);
        sb.append('|').append("-".repeat(Math.max(0, cchWide))).append('|');
        String sHeader = sb.toString();
        ArrayList<String> listLines = new ArrayList<String>();
        int iNext = this.m_asLine[this.m_iLine] == null ? this.m_iLine - 1 : this.m_iLine;
        int cRemain = this.m_cLines;
        String sChunk = null;
        for (int iLine = 0; iLine < cHigh; ++iLine) {
            int cchChunk;
            boolean fWasLeftover;
            boolean bl = fWasLeftover = sChunk != null;
            if (!fWasLeftover) {
                if (cRemain <= 0) break;
                if (iNext < 0) {
                    iNext = 1023;
                }
                sChunk = this.m_asLine[iNext--];
                --cRemain;
            }
            boolean fHasLeftover = (cchChunk = sChunk.length()) > cchWide;
            sb = new StringBuilder(width);
            if (fHasLeftover) {
                sb.append('\\');
                int cchChop = cchChunk % cchWide;
                if (cchChop == 0) {
                    cchChop = cchWide;
                }
                sb.append(sChunk.substring(cchChunk - cchChop));
                sChunk = sChunk.substring(0, cchChunk - cchChop);
            } else {
                sb.append('|');
                sb.append(sChunk);
                sChunk = null;
            }
            int cchFill = cchWide + 1 - sb.length();
            for (int i = 0; i < cchFill; ++i) {
                sb.append(' ');
            }
            sb.append(fWasLeftover ? (char)'\\' : '|');
            listLines.add(sb.toString());
        }
        int cLines = listLines.size();
        sb = new StringBuilder((width + 1) * (cLines + 2) - 1);
        sb.append(sHeader);
        for (int iLine = 0; iLine < cLines; ++iLine) {
            sb.append('\n').append((String)listLines.get(cLines - iLine - 1));
        }
        sb.append('\n').append(sHeader);
        return sb.toString();
    }

    private void append(char[] ach, int of, int cch) {
        String sAppend;
        String string = sAppend = cch <= 0 ? "" : new String(ach, of, cch);
        if (this.m_asLine[this.m_iLine] == null) {
            this.m_asLine[this.m_iLine] = sAppend;
            this.addLine();
        } else {
            this.m_asLine[this.m_iLine] = this.m_asLine[this.m_iLine] + sAppend;
        }
    }

    private void advance() {
        if (this.m_asLine[this.m_iLine] == null) {
            this.m_asLine[this.m_iLine] = "";
            this.addLine();
        }
        if (++this.m_iLine >= 1024) {
            this.m_iLine = 0;
        }
        this.m_asLine[this.m_iLine] = null;
    }

    private void addLine() {
        if (++this.m_cLines >= 1024) {
            this.m_cLines = 1023;
        }
    }
}

