/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import org.xvm.util.Handy;
import org.xvm.util.PackedInteger;

public class ConstBitSet {
    private final byte[] m_ab;

    public ConstBitSet(BitSet bs) {
        this(ConstBitSet.compress(bs));
    }

    public ConstBitSet(byte[] ab) {
        assert (ab != null);
        this.m_ab = ab;
    }

    public BitSet toBitSet() {
        return ConstBitSet.decompress(this.m_ab);
    }

    public byte[] getBytes() {
        return (byte[])this.m_ab.clone();
    }

    public int length() {
        long lIntVal = PackedInteger.unpackInt(this.m_ab, 0);
        int nCount = (int)lIntVal;
        if (nCount == 0) {
            return 0;
        }
        int ofCur = (int)(lIntVal >>> 32);
        if (nCount < 0) {
            return (int)PackedInteger.unpackInt(this.m_ab, ofCur);
        }
        int idCur = 0;
        while (true) {
            lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
            ofCur += (int)(lIntVal >>> 32);
            int idSkip = (int)lIntVal;
            if (idSkip == 0) {
                lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
                ofCur += (int)(lIntVal >>> 32);
                int idNext = (int)lIntVal;
                lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
                ofCur += (int)(lIntVal >>> 32);
                int cBytes = (int)lIntVal;
                if (idNext == 0) {
                    assert (cBytes > 0);
                    int bLast = this.m_ab[ofCur + cBytes - 1] & 0xFF;
                    int nHigh = Integer.highestOneBit(bLast);
                    assert (nHigh != 0);
                    return (idCur + cBytes - 1) * 8 + Integer.numberOfTrailingZeros(nHigh) + 1;
                }
                idCur += idNext;
                ofCur += cBytes;
                continue;
            }
            lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
            ofCur += (int)(lIntVal >>> 32);
            int ofSkip = (int)lIntVal;
            idCur += idSkip;
            ofCur += ofSkip;
        }
    }

    public boolean isEmpty() {
        return this.cardinality() == 0;
    }

    public int cardinality() {
        long lCount = PackedInteger.unpackInt(this.m_ab, 0);
        int nCount = (int)lCount;
        return nCount < 0 ? -nCount : nCount;
    }

    public int size() {
        return this.m_ab.length * 8;
    }

    public boolean get(int iBit) {
        int cBytes;
        long lIntVal = PackedInteger.unpackInt(this.m_ab, 0);
        int nCount = (int)lIntVal;
        if (nCount == 0) {
            return false;
        }
        int ofCur = (int)(lIntVal >>> 32);
        boolean fInverse = false;
        int cInverseLen = 0;
        if (nCount < 0) {
            fInverse = true;
            lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
            ofCur += (int)(lIntVal >>> 32);
            cInverseLen = (int)lIntVal;
        }
        int iByte = iBit >>> 3;
        int idCur = 0;
        while (true) {
            lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
            ofCur += (int)(lIntVal >>> 32);
            int idSkip = (int)lIntVal;
            if (idSkip != 0) {
                lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
                ofCur += (int)(lIntVal >>> 32);
                int ofSkip = (int)lIntVal;
                if (iByte >= idCur + idSkip) {
                    idCur += idSkip;
                    ofCur += ofSkip;
                    continue;
                }
            }
            lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
            ofCur += (int)(lIntVal >>> 32);
            int idNext = (int)lIntVal;
            lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
            ofCur += (int)(lIntVal >>> 32);
            cBytes = (int)lIntVal;
            if (idNext == 0 || iByte < idCur + idNext) break;
            idCur += idNext;
            ofCur += cBytes;
        }
        if (iByte < idCur + cBytes) {
            assert (iByte >= idCur);
            return fInverse == ((this.m_ab[ofCur + iByte] & 1 << (iBit & 7)) == 0);
        }
        return fInverse && iBit < cInverseLen;
    }

    public static BitSet invert(BitSet bs) {
        int length = bs.length();
        BitSet bsInverse = new BitSet(length);
        int id = bs.nextClearBit(0);
        while (id < length) {
            bsInverse.set(id);
            id = bs.nextClearBit(id + 1);
        }
        return bsInverse;
    }

    public static byte[] compress(BitSet bs) {
        byte[] ab;
        try {
            ByteArrayOutputStream outRaw = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outRaw);
            int c = bs.cardinality();
            PackedInteger.writeLong(out, c);
            if (c != 0) {
                ConstBitSet.writeCompressedNodes(out, bs);
            }
            ab = outRaw.toByteArray();
            if (c != 0) {
                outRaw = new ByteArrayOutputStream();
                out = new DataOutputStream(outRaw);
                BitSet bsInverse = ConstBitSet.invert(bs);
                PackedInteger.writeLong(out, -c);
                PackedInteger.writeLong(out, bs.length());
                ConstBitSet.writeCompressedNodes(out, bsInverse);
                byte[] abInverse = outRaw.toByteArray();
                if (abInverse.length < ab.length) {
                    ab = abInverse;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ab;
    }

    public static BitSet decompress(byte[] ab) {
        BitSet bs = new BitSet();
        try {
            ByteArrayInputStream inRaw = new ByteArrayInputStream(ab);
            DataInputStream in = new DataInputStream(inRaw);
            int c = Handy.readPackedInt(in);
            int length = 0;
            if (c != 0) {
                boolean fInverse = false;
                if (c < 0) {
                    length = Handy.readPackedInt(in);
                    c = -c;
                    fInverse = true;
                }
                int id = 0;
                while (true) {
                    RawNode node = ConstBitSet.readRawNode(in);
                    byte[] bits = node.bits;
                    assert (bits != null && (id == 0 || bits.length > 0));
                    int cBytes = bits.length;
                    for (int iByte = 0; iByte < cBytes; ++iByte) {
                        int curByte = bits[iByte] & 0xFF;
                        for (int iBit = 0; iBit < 8; ++iBit) {
                            boolean curBit;
                            boolean bl = curBit = (curByte & 1 << iBit) != 0;
                            if (!curBit) continue;
                            bs.set(id * 8 + iByte * 8 + iBit);
                        }
                    }
                    int iAdd = node.idNext;
                    if (iAdd == 0) break;
                    id += iAdd;
                }
                if (fInverse) {
                    int inverseLength = bs.length();
                    assert (inverseLength <= length);
                    bs = ConstBitSet.invert(bs);
                    for (int iBit = inverseLength; iBit < length; ++iBit) {
                        bs.set(iBit);
                    }
                }
                assert (c == bs.cardinality());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bs;
    }

    private static void writeCompressedNodes(DataOutputStream out, BitSet bs) throws IOException {
        int i;
        assert (bs.cardinality() > 0);
        byte[] abAll = bs.toByteArray();
        int cbAll = abAll.length;
        int iFirst = 0;
        int iLast = -1;
        ArrayList<Node> listNodes = new ArrayList<Node>();
        boolean fInNode = true;
        int cSkip = 0;
        for (int iCur = 0; iCur < cbAll; ++iCur) {
            byte b = abAll[iCur];
            if (b == 0) {
                if (!fInNode || ++cSkip < 6) continue;
                listNodes.add(ConstBitSet.makeNode(abAll, iFirst, iLast));
                fInNode = false;
                continue;
            }
            if (!fInNode) {
                fInNode = true;
                iFirst = iCur;
            }
            iLast = iCur;
            cSkip = 0;
        }
        if (fInNode && iLast >= iFirst) {
            listNodes.add(ConstBitSet.makeNode(abAll, iFirst, iLast));
        }
        Node[] aNode = listNodes.toArray(new Node[0]);
        int cNodes = aNode.length;
        for (int i2 = 1; i2 < cNodes; ++i2) {
            aNode[i2 - 1].next = aNode[i2];
        }
        ConstBitSet.createSkips(aNode, 0, aNode.length - 1);
        byte[][] aabNode = new byte[cNodes][];
        Node nodeNext = null;
        for (i = cNodes - 1; i >= 0; --i) {
            Node node = aNode[i];
            RawNode nodeRaw = new RawNode();
            nodeRaw.idNext = nodeNext == null ? 0 : nodeNext.id - node.id;
            nodeRaw.bits = node.bits;
            assert (nodeRaw.bits != null);
            Node nodeJmp = node.jmp;
            if (nodeJmp != null) {
                int iJmp = ConstBitSet.findNode(aNode, nodeJmp);
                assert (iJmp > i);
                nodeRaw.idJmp = nodeJmp.id - node.id;
                nodeRaw.ofJmp = ConstBitSet.calcSkip(aabNode, i, nodeRaw, iJmp);
            }
            aabNode[i] = ConstBitSet.toBytes(nodeRaw);
            nodeNext = node;
        }
        for (i = 0; i < cNodes; ++i) {
            out.write(aabNode[i]);
        }
    }

    private static Node makeNode(byte[] ab, int iFirst, int iLast) {
        int cbNode = iLast - iFirst + 1;
        assert (cbNode >= 0);
        byte[] abNode = new byte[cbNode];
        System.arraycopy(ab, iFirst, abNode, 0, cbNode);
        Node node = new Node();
        node.id = iFirst;
        node.bits = abNode;
        return node;
    }

    private static int findNode(Node[] aNode, Node node) {
        int c = aNode.length;
        for (int i = 0; i < c; ++i) {
            if (aNode[i] != node) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    private static void createSkips(Node[] aNode, int iFirst, int iLast) {
        Node node = aNode[iFirst];
        assert (node.jmp == null);
        int cNodes = iLast - iFirst + 1;
        if (cNodes <= 2) {
            return;
        }
        int ofJmp = Integer.highestOneBit(cNodes - 1);
        node.jmp = aNode[iFirst + ofJmp];
        ConstBitSet.createSkips(aNode, iFirst + 1, iFirst + ofJmp - 1);
        ConstBitSet.createSkips(aNode, iFirst + ofJmp, iLast);
    }

    private static RawNode readRawNode(DataInputStream in) throws IOException {
        RawNode node = new RawNode();
        node.idJmp = Handy.readPackedInt(in);
        if (node.idJmp != 0) {
            node.ofJmp = Handy.readPackedInt(in);
        }
        node.idNext = Handy.readPackedInt(in);
        int cb = Handy.readPackedInt(in);
        byte[] ab = new byte[cb];
        in.readFully(ab);
        node.bits = ab;
        return node;
    }

    private static byte[] toBytes(RawNode node) {
        ByteArrayOutputStream outRaw = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outRaw);
        try {
            PackedInteger.writeLong(out, node.idJmp);
            if (node.idJmp > 0) {
                PackedInteger.writeLong(out, node.ofJmp);
            }
            PackedInteger.writeLong(out, node.idNext);
            PackedInteger.writeLong(out, node.bits.length);
            out.write(node.bits);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outRaw.toByteArray();
    }

    private static int calcSkip(byte[][] aabNode, int iFrom, RawNode nodeFrom, int iTo) {
        assert (iTo > iFrom + 1);
        ByteArrayOutputStream outRaw = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outRaw);
        try {
            PackedInteger.writeLong(out, nodeFrom.idNext);
            PackedInteger.writeLong(out, nodeFrom.bits.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int cb = outRaw.size() + nodeFrom.bits.length;
        for (int i = iFrom + 1; i < iTo; ++i) {
            cb += aabNode[i].length;
        }
        return cb;
    }

    private static class RawNode {
        int idJmp;
        int ofJmp;
        int idNext;
        byte[] bits;

        private RawNode() {
        }
    }

    private static class Node {
        int id;
        Node jmp;
        Node next;
        byte[] bits;

        private Node() {
        }
    }
}

