/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xvm.util.Handy;
import org.xvm.util.PackedInteger;

public class ConstOrdinalList
extends AbstractList<Integer> {
    private final byte[] m_ab;

    public ConstOrdinalList(List<Integer> list) {
        this(list.stream().mapToInt(n -> n).toArray());
    }

    public ConstOrdinalList(int[] an) {
        assert (an != null);
        this.m_ab = ConstOrdinalList.compress(an, 0);
    }

    public ConstOrdinalList(byte[] ab) {
        assert (ab != null);
        this.m_ab = ab;
    }

    public int[] toIntArray() {
        return ConstOrdinalList.decompress(this.m_ab);
    }

    public byte[] getBytes() {
        return (byte[])this.m_ab.clone();
    }

    @Override
    public int size() {
        long lCount = PackedInteger.unpackInt(this.m_ab, 0);
        return (int)lCount;
    }

    @Override
    public Integer get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index: " + index);
        }
        long lIntVal = PackedInteger.unpackInt(this.m_ab, 0);
        int ofCur = (int)(lIntVal >>> 32);
        int nCount = (int)lIntVal;
        if (index >= nCount) {
            throw new IndexOutOfBoundsException("requested index=" + index + ", highest legal index=" + (nCount - 1));
        }
        lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
        ofCur += (int)(lIntVal >>> 32);
        int nDefault = (int)lIntVal;
        lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
        ofCur += (int)(lIntVal >>> 32);
        int cBitsPer = (int)lIntVal;
        lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
        ofCur += (int)(lIntVal >>> 32);
        int idCur = (int)lIntVal;
        if (index < idCur) {
            return nDefault;
        }
        while (true) {
            lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
            ofCur += (int)(lIntVal >>> 32);
            int idSkip = (int)lIntVal;
            if (idSkip != 0) {
                lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
                ofCur += (int)(lIntVal >>> 32);
                int ofSkip = (int)lIntVal;
                if (index >= idCur + idSkip) {
                    idCur += idSkip;
                    ofCur += ofSkip;
                    continue;
                }
            }
            lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
            ofCur += (int)(lIntVal >>> 32);
            int idNext = (int)lIntVal;
            lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
            ofCur += (int)(lIntVal >>> 32);
            int nLen = (int)lIntVal;
            if (nLen < 0) {
                lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
                ofCur += (int)(lIntVal >>> 32);
                int nVal = (int)lIntVal;
                if (index < idCur - nLen) {
                    return nVal;
                }
            } else {
                if (index < idCur + nLen) {
                    return ConstOrdinalList.unpackOne(this.m_ab, ofCur, cBitsPer, index - idCur);
                }
                ofCur += (nLen * cBitsPer + 7) / 8;
            }
            if (idNext == 0 || index < idCur + idNext) break;
            idCur += idNext;
        }
        return nDefault;
    }

    @Override
    public Iterator<Integer> iterator() {
        long lIntVal = PackedInteger.unpackInt(this.m_ab, 0);
        int ofCur = (int)(lIntVal >>> 32);
        final int nCount = (int)lIntVal;
        if (nCount == 0) {
            return Collections.emptyIterator();
        }
        lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
        ofCur += (int)(lIntVal >>> 32);
        final int nDefault = (int)lIntVal;
        lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
        ofCur += (int)(lIntVal >>> 32);
        final int cBitsPer = (int)lIntVal;
        lIntVal = PackedInteger.unpackInt(this.m_ab, ofCur);
        final int idFirst = (int)lIntVal;
        final int ofFirst = ofCur += (int)(lIntVal >>> 32);
        return new Iterator<Integer>(){
            final byte[] ab;
            int idNode;
            RawNode nodeCur;
            int ofNext;
            int iNext;
            final /* synthetic */ ConstOrdinalList this$0;
            {
                this.this$0 = this$0;
                this.ab = this.this$0.m_ab;
                this.idNode = 0;
                this.nodeCur = null;
                this.ofNext = ofFirst;
                this.iNext = 0;
            }

            @Override
            public boolean hasNext() {
                return this.currentNode() != null;
            }

            @Override
            public Integer next() {
                RawNode node = this.currentNode();
                if (node == null) {
                    throw new NoSuchElementException();
                }
                if (node.cVals < 0) {
                    return this.iNext++ >= -node.cVals ? nDefault : node.nVal;
                }
                if (this.iNext < node.cVals) {
                    return ConstOrdinalList.unpackOne(node.abVals, node.ofVals, cBitsPer, this.iNext++);
                }
                ++this.iNext;
                return nDefault;
            }

            RawNode currentNode() {
                RawNode node = this.nodeCur;
                if (node == null) {
                    this.nodeCur = node = new RawNode();
                    if (idFirst > 0) {
                        node.cVals = -idFirst;
                        node.nVal = nDefault;
                        node.idNext = idFirst;
                        return node;
                    }
                }
                if (this.iNext >= node.idNext) {
                    if (this.ofNext >= this.ab.length) {
                        return null;
                    }
                    this.idNode += node.idNext;
                    this.ofNext += ConstOrdinalList.fromBytes(node, this.ab, this.ofNext, cBitsPer);
                    this.iNext = 0;
                    if (node.idNext == 0) {
                        node.idNext = nCount - this.idNode;
                    }
                }
                return node;
            }
        };
    }

    public static byte[] compress(int[] an, int cFast) {
        assert (an != null);
        assert (cFast >= 0 && cFast <= an.length);
        int cVals = an.length;
        if (cVals == 0) {
            try {
                ByteArrayOutputStream outRaw = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(outRaw);
                PackedInteger.writeLong(out, cVals);
                return outRaw.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        HashMap<Integer, Integer> mapN = new HashMap<Integer, Integer>();
        int nHigh = -1;
        for (int i = 0; i < cVals; ++i) {
            int n = an[i];
            assert (n >= 0);
            mapN.compute(n, (k, v) -> (v == null ? 0 : v) + 1);
            if (n <= nHigh) continue;
            nHigh = n;
        }
        int nDefault = -1;
        int cDefault = 0;
        for (Map.Entry entry : mapN.entrySet()) {
            if ((Integer)entry.getValue() <= cDefault) continue;
            nDefault = (Integer)entry.getKey();
            cDefault = (Integer)entry.getValue();
        }
        int cBitsPer = Integer.numberOfTrailingZeros(Integer.highestOneBit(nHigh)) + 1 & 0x1F;
        assert (cBitsPer > 0 && cBitsPer <= 32);
        int cMinRun = 47 / cBitsPer + 1;
        List<Node> list = ConstOrdinalList.buildNodeList(an, cMinRun, nDefault);
        ConstOrdinalList.ensureFastNode(list, cFast, cMinRun, an);
        Node[] aNode = list.toArray(new Node[0]);
        int cNodes = aNode.length;
        for (int i = 1; i < cNodes; ++i) {
            aNode[i - 1].next = aNode[i];
        }
        ConstOrdinalList.createSkips(aNode, 0, aNode.length - 1);
        byte[][] aabNode = ConstOrdinalList.toBytes(aNode, cBitsPer);
        try {
            ByteArrayOutputStream outRaw = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outRaw);
            PackedInteger.writeLong(out, cVals);
            PackedInteger.writeLong(out, nDefault);
            PackedInteger.writeLong(out, cBitsPer);
            PackedInteger.writeLong(out, aNode.length == 0 ? (long)cVals : (long)aNode[0].id);
            for (int i = 0; i < cNodes; ++i) {
                out.write(aabNode[i]);
            }
            return outRaw.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int[] decompress(byte[] ab) {
        try {
            int iAdd;
            ByteArrayInputStream inRaw = new ByteArrayInputStream(ab);
            DataInputStream in = new DataInputStream(inRaw);
            int cVals = Handy.readPackedInt(in);
            int[] anVal = new int[cVals];
            if (cVals == 0) {
                return anVal;
            }
            int nDefault = Handy.readPackedInt(in);
            if (nDefault != 0) {
                Arrays.fill(anVal, nDefault);
            }
            int cBitsPer = Handy.readPackedInt(in);
            assert (cBitsPer > 0 && cBitsPer <= 32);
            for (int iCur = Handy.readPackedInt(in); iCur < cVals; iCur += iAdd) {
                RawNode node = ConstOrdinalList.readRawNode(in, cBitsPer);
                if (node.cVals < 0) {
                    int c = -node.cVals;
                    for (int i = 0; i < c; ++i) {
                        anVal[iCur + i] = node.nVal;
                    }
                } else {
                    int[] anNode = ConstOrdinalList.unpack(node.abVals, node.ofVals, node.cVals, cBitsPer);
                    int c = node.cVals;
                    for (int i = 0; i < c; ++i) {
                        anVal[iCur + i] = anNode[i];
                    }
                }
                if ((iAdd = node.idNext) == 0) break;
            }
            return anVal;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Node> buildNodeList(int[] an, int cMinRun, int nDefault) {
        int cVals = an.length;
        int iFirstN = -1;
        int iLastN = -1;
        int nPrev = -1;
        int cRun = 0;
        ArrayList<Node> list = new ArrayList<Node>();
        for (int i = 0; i < cVals; ++i) {
            int n = an[i];
            if (n == nPrev) {
                ++cRun;
            } else {
                if (cRun >= cMinRun) {
                    ConstOrdinalList.createNodes(list, an, i, nPrev, cRun, cMinRun, iFirstN, iLastN, nDefault);
                    iFirstN = -1;
                    iLastN = -1;
                }
                cRun = 1;
            }
            if (n != nDefault) {
                if (iFirstN < 0) {
                    iFirstN = i;
                }
                iLastN = i;
            }
            nPrev = n;
        }
        ConstOrdinalList.createNodes(list, an, cVals, nPrev, cRun, cMinRun, iFirstN, iLastN, nDefault);
        return list;
    }

    private static void createNodes(List<Node> list, int[] an, int i, int nRun, int cRun, int cMinRun, int iFirstN, int iLastN, int nDefault) {
        if (cRun >= cMinRun) {
            Node node;
            int iRun = i - cRun;
            if (iFirstN >= 0 && iFirstN < iRun) {
                if (iLastN >= iRun) {
                    for (iLastN = iRun - 1; iLastN > iFirstN && an[iLastN] == nDefault; --iLastN) {
                    }
                }
                node = new Node();
                node.rle = false;
                node.id = iFirstN;
                node.vals = an;
                node.ofVals = iFirstN;
                node.cVals = iLastN - iFirstN + 1;
                list.add(node);
            }
            if (an[iRun] != nDefault) {
                node = new Node();
                node.rle = true;
                node.id = iRun;
                node.val = nRun;
                node.cVals = cRun;
                list.add(node);
            }
        } else if (iFirstN >= 0) {
            Node node = new Node();
            node.rle = false;
            node.id = iFirstN;
            node.vals = an;
            node.ofVals = iFirstN;
            node.cVals = iLastN - iFirstN + 1;
            list.add(node);
        }
    }

    private static void ensureFastNode(List<Node> list, int cFast, int cMinRun, int[] an) {
        if (cFast > 0) {
            int cNodes = 0;
            for (Node node : list) {
                if (node.id >= cFast) break;
                ++cNodes;
            }
            if (cNodes <= 1) {
                return;
            }
            Node nodeLast = list.get(cNodes - 1);
            int iFirst = list.get((int)0).id;
            int iLast = nodeLast.id + nodeLast.cVals - 1;
            if (nodeLast.rle && iLast - cFast > cMinRun) {
                iLast = cFast - 1;
                int cAdjust = cFast - nodeLast.id;
                assert (cAdjust > 0);
                nodeLast.id += cAdjust;
                nodeLast.cVals -= cAdjust;
                --cNodes;
            }
            while (cNodes > 1) {
                list.remove(0);
                --cNodes;
            }
            Node nodeFast = new Node();
            nodeFast.id = iFirst;
            nodeFast.vals = an;
            nodeFast.ofVals = iFirst;
            nodeFast.cVals = iLast - iFirst + 1;
            nodeFast.rle = false;
            list.set(0, nodeFast);
        }
    }

    private static byte[][] toBytes(Node[] aNode, int cBitsPer) {
        int cNodes = aNode.length;
        byte[][] aabNode = new byte[cNodes][];
        Node nodeNext = null;
        for (int i = cNodes - 1; i >= 0; --i) {
            Node node = aNode[i];
            RawNode nodeRaw = new RawNode();
            assert (nodeNext == null || nodeNext.id > node.id);
            int n = nodeRaw.idNext = nodeNext == null ? 0 : nodeNext.id - node.id;
            if (node.rle) {
                nodeRaw.cVals = -node.cVals;
                nodeRaw.nVal = node.val;
            } else {
                nodeRaw.cVals = node.cVals;
                nodeRaw.abVals = ConstOrdinalList.pack(node.vals, node.ofVals, node.cVals, cBitsPer);
            }
            Node nodeJmp = node.jmp;
            if (nodeJmp != null) {
                int iJmp = ConstOrdinalList.findNode(aNode, nodeJmp);
                assert (iJmp > i);
                nodeRaw.idJmp = nodeJmp.id - node.id;
                nodeRaw.ofJmp = ConstOrdinalList.calcSkip(aabNode, i, nodeRaw, iJmp);
            }
            aabNode[i] = ConstOrdinalList.toBytes(nodeRaw, cBitsPer);
            nodeNext = node;
        }
        return aabNode;
    }

    private static int findNode(Node[] aNode, Node node) {
        int c = aNode.length;
        for (int i = 0; i < c; ++i) {
            if (aNode[i] != node) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    private static void createSkips(Node[] aNode, int iFirst, int iLast) {
        int cNodes = iLast - iFirst + 1;
        if (cNodes <= 2) {
            return;
        }
        Node node = aNode[iFirst];
        assert (node.jmp == null);
        int ofJmp = Integer.highestOneBit(cNodes - 1);
        node.jmp = aNode[iFirst + ofJmp];
        ConstOrdinalList.createSkips(aNode, iFirst + 1, iFirst + ofJmp - 1);
        ConstOrdinalList.createSkips(aNode, iFirst + ofJmp, iLast);
    }

    private static RawNode readRawNode(DataInputStream in, int cBitsPer) throws IOException {
        RawNode node = new RawNode();
        node.idJmp = Handy.readPackedInt(in);
        if (node.idJmp != 0) {
            node.ofJmp = Handy.readPackedInt(in);
        }
        node.idNext = Handy.readPackedInt(in);
        node.cVals = Handy.readPackedInt(in);
        if (node.cVals < 0) {
            node.nVal = Handy.readPackedInt(in);
        } else {
            int cb = (node.cVals * cBitsPer + 7) / 8;
            node.abVals = new byte[cb];
            in.readFully(node.abVals);
        }
        return node;
    }

    private static int fromBytes(RawNode node, byte[] ab, int of, int cBitsPer) {
        int ofOrig = of;
        long lIntVal = PackedInteger.unpackInt(ab, of);
        of += (int)(lIntVal >>> 32);
        node.idJmp = (int)lIntVal;
        if (node.idJmp != 0) {
            lIntVal = PackedInteger.unpackInt(ab, of);
            of += (int)(lIntVal >>> 32);
            node.ofJmp = (int)lIntVal;
        }
        lIntVal = PackedInteger.unpackInt(ab, of);
        of += (int)(lIntVal >>> 32);
        node.idNext = (int)lIntVal;
        lIntVal = PackedInteger.unpackInt(ab, of);
        of += (int)(lIntVal >>> 32);
        node.cVals = (int)lIntVal;
        if (node.cVals < 0) {
            lIntVal = PackedInteger.unpackInt(ab, of);
            of += (int)(lIntVal >>> 32);
            node.nVal = (int)lIntVal;
        } else {
            int cb = (node.cVals * cBitsPer + 7) / 8;
            node.abVals = ab;
            node.ofVals = of;
            of += cb;
        }
        return of - ofOrig;
    }

    private static byte[] toBytes(RawNode node, int cBitsPer) {
        ByteArrayOutputStream outRaw = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outRaw);
        try {
            PackedInteger.writeLong(out, node.idJmp);
            if (node.idJmp > 0) {
                PackedInteger.writeLong(out, node.ofJmp);
            }
            PackedInteger.writeLong(out, node.idNext);
            PackedInteger.writeLong(out, node.cVals);
            if (node.cVals < 0) {
                PackedInteger.writeLong(out, node.nVal);
            } else {
                int cb = (node.cVals * cBitsPer + 7) / 8;
                out.write(node.abVals, node.ofVals, cb);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outRaw.toByteArray();
    }

    private static int calcSkip(byte[][] aabNode, int iFrom, RawNode nodeFrom, int iTo) {
        assert (iTo > iFrom + 1);
        int cb = PackedInteger.packedLength(nodeFrom.idNext) + PackedInteger.packedLength(nodeFrom.cVals);
        if (nodeFrom.cVals < 0) {
            cb += PackedInteger.packedLength(nodeFrom.nVal);
        } else {
            assert (nodeFrom.ofVals == 0);
            cb += nodeFrom.abVals.length;
        }
        for (int i = iFrom + 1; i < iTo; ++i) {
            cb += aabNode[i].length;
        }
        return cb;
    }

    private static byte[] pack(int[] an, int of, int cn, int cBitsPer) {
        int cBytes = (cn * cBitsPer + 7) / 8;
        byte[] ab = new byte[cBytes];
        for (int i = 0; i < cn; ++i) {
            int n = an[of + i];
            int ofBit = i * cBitsPer;
            while (n != 0) {
                int ofByte = ofBit / 8;
                int nByte = ab[ofByte];
                int cStore = 8 - (ofBit & 7);
                int ofStore = 8 - cStore;
                ab[ofByte] = (byte)(nByte |= n << ofStore);
                n >>>= cStore;
                ofBit += cStore;
            }
        }
        return ab;
    }

    private static int[] unpack(byte[] ab, int of, int cVals, int cBitsPer) {
        int[] an = new int[cVals];
        for (int i = 0; i < cVals; ++i) {
            an[i] = ConstOrdinalList.unpackOne(ab, of, cBitsPer, i);
        }
        return an;
    }

    private static int unpackOne(byte[] ab, int of, int cBitsPer, int idVal) {
        int cPartBits;
        int n = 0;
        int ofReadBit = idVal * cBitsPer;
        for (int cBitsRemain = cBitsPer; cBitsRemain > 0; cBitsRemain -= cPartBits) {
            byte b = ab[of + ofReadBit / 8];
            int ofPartBit = ofReadBit & 7;
            cPartBits = Math.min(8 - ofPartBit, cBitsRemain);
            n |= (b >>> ofPartBit & (1 << cPartBits) - 1) << cBitsPer - cBitsRemain;
            ofReadBit += cPartBits;
        }
        return n;
    }

    private static class Node {
        int id;
        boolean rle;
        int cVals;
        int val;
        int[] vals;
        int ofVals;
        Node jmp;
        Node next;

        private Node() {
        }
    }

    private static class RawNode {
        int idJmp;
        int ofJmp;
        int idNext;
        int cVals;
        int nVal;
        byte[] abVals;
        int ofVals;

        private RawNode() {
        }
    }
}

