/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.io.InterruptedIOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CooperativelyCleanableReference<V>
extends WeakReference<V> {
    private static final Logger LOGGER = Logger.getLogger(CooperativelyCleanableReference.class.getName());
    private static final ReferenceQueue<Object>[] QUEUE = new ReferenceQueue[Integer.highestOneBit(Runtime.getRuntime().availableProcessors() << 1)];
    private static final Set<CooperativelyCleanableReference<?>> KEEP_ALIVE;
    private final AutoCloseable cleaner;

    public CooperativelyCleanableReference(V referent, AutoCloseable cleaner) {
        super(referent, CooperativelyCleanableReference.clean(QUEUE[ThreadLocalRandom.current().nextInt(QUEUE.length)]));
        this.cleaner = Objects.requireNonNull(cleaner, "null cleaner");
        KEEP_ALIVE.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReferenceQueue<Object> clean(ReferenceQueue<Object> queue) {
        long startMillis = System.currentTimeMillis();
        boolean restoreInterrupt = Thread.interrupted();
        try {
            CooperativelyCleanableReference ref;
            int c = 0;
            do {
                ++c;
                ref = (CooperativelyCleanableReference)queue.poll();
                try {
                    if (!KEEP_ALIVE.remove(ref)) continue;
                    ref.cleaner.close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, "ignoring exception during cooperative cleanup", e);
                    for (Throwable t = e; !restoreInterrupt && t != null; t = t.getCause()) {
                        if (!(t instanceof InterruptedException) && !(t instanceof InterruptedIOException)) continue;
                        restoreInterrupt = true;
                    }
                }
            } while (ref != null && (c < 2 || System.currentTimeMillis() <= startMillis + 1L));
        }
        finally {
            if (restoreInterrupt) {
                Thread.currentThread().interrupt();
            }
        }
        return queue;
    }

    static {
        for (int i = 0; i < QUEUE.length; ++i) {
            CooperativelyCleanableReference.QUEUE[i] = new ReferenceQueue();
        }
        KEEP_ALIVE = ConcurrentHashMap.newKeySet();
    }
}

