/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilterIterator<T>
implements Iterator<T> {
    private final Iterator<T> delegate;
    private final Predicate<? super T> filter;
    private T next;
    private boolean removeReady;

    public FilterIterator(Iterator<T> delegate, Predicate<? super T> filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        this.removeReady = false;
        while (this.next == null && this.delegate.hasNext()) {
            T item = this.delegate.next();
            if (!this.filter.test(item)) continue;
            this.next = item;
        }
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T result = this.next;
            this.next = null;
            this.removeReady = true;
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (!this.removeReady) {
            throw new IllegalStateException();
        }
        this.removeReady = false;
        this.delegate.remove();
    }
}

