/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.xvm.util.Hash;
import org.xvm.util.ListMap;
import org.xvm.util.PackedInteger;

public final class Handy {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final String[] NO_ARGS = new String[0];
    public static final File[] NO_FILES = new File[0];

    private Handy() {
    }

    public static char nibbleToChar(int n) {
        return (n &= 0xF) <= 9 ? (char)(48 + n) : (char)(87 + n);
    }

    public static StringBuilder appendByteAsHex(StringBuilder sb, int n) {
        return sb.append(Handy.nibbleToChar(n >> 4)).append(Handy.nibbleToChar(n));
    }

    public static String byteToHexString(int n) {
        return Handy.appendByteAsHex(new StringBuilder(4).append("0x"), n).toString();
    }

    public static StringBuilder appendByteArrayAsHex(StringBuilder sb, byte[] ab, int of, int cb) {
        sb.ensureCapacity(sb.length() + cb * 2);
        while (--cb >= 0) {
            byte n = ab[of++];
            sb.append(Handy.nibbleToChar(n >> 4)).append(Handy.nibbleToChar(n));
        }
        return sb;
    }

    public static StringBuilder appendByteArrayAsHex(StringBuilder sb, byte[] ab) {
        return Handy.appendByteArrayAsHex(sb, ab, 0, ab.length);
    }

    public static String byteArrayToHexString(byte[] ab, int of, int cb) {
        return Handy.appendByteArrayAsHex(new StringBuilder(2 + cb * 2).append("0x"), ab, of, cb).toString();
    }

    public static String byteArrayToHexString(byte[] ab) {
        return Handy.byteArrayToHexString(ab, 0, ab.length);
    }

    public static byte[] hexStringToByteArray(String s) {
        int ofch = 0;
        int cch = s.length();
        int ofb = 0;
        int cb = (cch + 1) / 2;
        if (s.charAt(0) == '0' && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
            ofch += 2;
            --cb;
        }
        byte[] ab = new byte[cb];
        if ((cch & 1) != 0) {
            ab[ofb++] = (byte)Handy.hexitValue(s.charAt(ofch++));
        }
        while (ofch < cch) {
            ab[ofb++] = (byte)(Handy.hexitValue(s.charAt(ofch)) << 4 | Handy.hexitValue(s.charAt(ofch + 1)));
            ofch += 2;
        }
        return ab;
    }

    public static String byteArrayToHexDump(byte[] ab, int of, int cb, int cBytesPerLine) {
        assert (ab != null);
        assert (of >= 0 && cb >= 0 && of + cb <= ab.length);
        assert (cBytesPerLine > 0);
        int cchAddr = Handy.countHexDigits(of + cb) + 1 & 0xFFFFFFFE;
        int cch = cchAddr + cBytesPerLine * 4 + 3;
        char[] ach = new char[cch];
        Arrays.fill(ach, ' ');
        ach[cchAddr] = 58;
        ach[cch - 1] = 10;
        int cLines = Math.max((cb + cBytesPerLine - 1) / cBytesPerLine, 1);
        StringBuilder sb = new StringBuilder(cLines * cch);
        int ofHex = cchAddr + 2;
        int ofChar = ofHex + cBytesPerLine * 3;
        for (int iLine = 0; iLine < cLines; ++iLine) {
            Handy.renderIntToHex(of, ach, 0, cchAddr);
            for (int iByte = 0; iByte < cBytesPerLine; ++iByte) {
                if (cb > 0) {
                    byte b = ab[of];
                    Handy.renderByteToHex(b, ach, ofHex + iByte * 3);
                    char ch = (char)(b & 0xFF);
                    ach[ofChar + iByte] = Character.isISOControl(ch) ? 46 : (int)ch;
                } else {
                    ach[ofHex + iByte * 3] = 32;
                    ach[ofHex + iByte * 3 + 1] = 32;
                    ach[ofChar + iByte] = 32;
                }
                ++of;
                --cb;
            }
            sb.append(ach, 0, iLine < cLines - 1 ? cch : cch - 1);
        }
        return sb.toString();
    }

    public static String byteArrayToHexDump(byte[] ab, int cBytesPerLine) {
        return Handy.byteArrayToHexDump(ab, 0, ab.length, cBytesPerLine);
    }

    public static long byteArrayToLong(byte[] ab, int of) {
        return ((long)ab[of++] << 56) + ((long)(ab[of++] & 0xFF) << 48) + ((long)(ab[of++] & 0xFF) << 40) + ((long)(ab[of++] & 0xFF) << 32) + ((long)(ab[of++] & 0xFF) << 24) + (long)((ab[of++] & 0xFF) << 16) + (long)((ab[of++] & 0xFF) << 8) + (long)(ab[of] & 0xFF);
    }

    public static byte[] toByteArray(long l) {
        return new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
    }

    public static void toByteArray(long l, byte[] ab, int of) {
        ab[of++] = (byte)(l >> 56);
        ab[of++] = (byte)(l >> 48);
        ab[of++] = (byte)(l >> 40);
        ab[of++] = (byte)(l >> 32);
        ab[of++] = (byte)(l >> 24);
        ab[of++] = (byte)(l >> 16);
        ab[of++] = (byte)(l >> 8);
        ab[of] = (byte)l;
    }

    public static int countHexDigits(int n) {
        return Math.max((32 - Integer.numberOfLeadingZeros(n) + 3) / 4, 1);
    }

    public static StringBuilder appendIntAsHex(StringBuilder sb, int n, int cch) {
        assert (cch >= 0 && cch <= 8);
        for (int cBits = (cch - 1) * 4; cBits >= 0; cBits -= 4) {
            sb.append(Handy.nibbleToChar(n >> cBits));
        }
        return sb;
    }

    public static StringBuilder appendIntAsHex(StringBuilder sb, int n) {
        return Handy.appendIntAsHex(sb, n, 8);
    }

    public static String intToHexString(int n) {
        return Handy.appendIntAsHex(new StringBuilder(10).append("0x"), n).toString();
    }

    public static int countHexDigits(long n) {
        return Math.max((64 - Long.numberOfLeadingZeros(n) + 3) / 4, 1);
    }

    public static StringBuilder appendLongAsHex(StringBuilder sb, long n, int cch) {
        assert (cch >= 0 && cch <= 16);
        for (int cBits = (cch - 1) * 4; cBits >= 0; cBits -= 4) {
            sb.append(Handy.nibbleToChar((int)(n >> cBits)));
        }
        return sb;
    }

    public static StringBuilder appendLongAsHex(StringBuilder sb, long n) {
        return Handy.appendLongAsHex(sb, n, 16);
    }

    public static String longToHexString(long n) {
        return Handy.appendLongAsHex(new StringBuilder(18).append("0x"), n).toString();
    }

    public static int renderByteToHex(int n, char[] ach, int of) {
        ach[of] = Handy.nibbleToChar(n >> 4);
        ach[of + 1] = Handy.nibbleToChar(n);
        return of + 2;
    }

    public static int renderIntToHex(int n, char[] ach, int of, int cch) {
        for (int i = 0; i < cch; ++i) {
            ach[of + cch - i - 1] = Handy.nibbleToChar(n);
            n >>>= 4;
        }
        return of + cch;
    }

    public static int renderLongToHex(long n, char[] ach, int of, int cch) {
        for (int i = 0; i < cch; ++i) {
            ach[of + cch - i - 1] = Handy.nibbleToChar((int)n);
            n >>>= 4;
        }
        return of + cch;
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' & ch <= '9';
    }

    public static int digitValue(char ch) {
        assert (Handy.isDigit(ch));
        return ch - 48;
    }

    public static boolean isHexit(char ch) {
        return ch >= '0' & ch <= 'f' & (1L << 102 - ch & 0x7FE03F0000003FL) != 0L;
    }

    public static int hexitValue(char ch) {
        assert (Handy.isHexit(ch));
        return ch <= '9' ? ch - 48 : (ch | 0x20) - 87;
    }

    public static boolean isAsciiLetter(char ch) {
        return ch >= 'A' & ch <= 'z' & (1L << 122 - ch & 0x3FFFFFF03FFFFFFL) != 0L;
    }

    public static int countChar(String s, char ch) {
        int c = 0;
        int of = s.indexOf(ch);
        while (of >= 0) {
            ++c;
            of = s.indexOf(ch, of + 1);
        }
        return c;
    }

    public static String[] parseDelimitedString(String s, char chDelim) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return NO_ARGS;
        }
        int of = s.indexOf(chDelim);
        if (of < 0) {
            return new String[]{s};
        }
        ArrayList<String> list = new ArrayList<String>();
        int ofPrev = 0;
        do {
            list.add(s.substring(ofPrev, of));
        } while ((of = s.indexOf(chDelim, ofPrev = of + 1)) >= 0);
        list.add(s.substring(ofPrev));
        return list.toArray(NO_ARGS);
    }

    public static Map<String, String> parseStringMap(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyMap();
        }
        ListMap<String, String> map = new ListMap<String, String>();
        int of = 0;
        int cch = s.length();
        boolean doKey = true;
        String key = "";
        String val = "";
        while (of < cch) {
            String cur;
            if (doKey) {
                if (!key.isEmpty()) {
                    map.put(key, val);
                } else if (!val.isEmpty()) {
                    return null;
                }
                key = "";
                val = "";
            }
            switch (s.charAt(of)) {
                case '\"': 
                case '\'': 
                case '`': {
                    int close = Handy.closingQuote(s, of);
                    if (close > of) {
                        cur = Handy.unquotedString(s.substring(of, close + 1));
                        of = close + 1;
                        break;
                    }
                }
                default: {
                    int ofVal;
                    int next = s.indexOf(44, of);
                    if (next < 0) {
                        next = cch;
                    }
                    if (doKey && (ofVal = s.indexOf(61, of)) >= 0 && ofVal < next) {
                        next = ofVal;
                    }
                    cur = s.substring(of, next);
                    of = next;
                }
            }
            if (doKey) {
                key = cur;
            } else {
                val = cur;
            }
            if (of >= cch) continue;
            char delim = s.charAt(of++);
            if (doKey && delim == '=') {
                doKey = false;
                continue;
            }
            if (delim == ',') {
                doKey = true;
                continue;
            }
            return null;
        }
        if (!key.isEmpty()) {
            map.put(key, val);
        } else if (!val.isEmpty()) {
            return null;
        }
        return map;
    }

    public static String dup(char ch, int cch) {
        StringBuilder sb = new StringBuilder(cch);
        while (cch-- > 0) {
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String indentLines(String sText, String sIndent) {
        int cchOld = sText.length();
        if (cchOld == 0) {
            return "";
        }
        int cLines = Handy.countChar(sText, '\n') + 1;
        int cchNew = cchOld + cLines * sIndent.length();
        StringBuilder sb = new StringBuilder(cchNew);
        int ofLine = 0;
        int ofNewline = sText.indexOf(10);
        while (ofNewline >= 0) {
            if (ofNewline > ofLine) {
                sb.append(sIndent);
            }
            sb.append(sText, ofLine, ofNewline + 1);
            ofLine = ofNewline + 1;
            ofNewline = sText.indexOf(10, ofLine);
        }
        if (ofLine < cchOld) {
            sb.append(sIndent).append(sText, ofLine, cchOld);
        }
        return sb.toString();
    }

    public static boolean isCharEscaped(char ch) {
        if (ch < '\u0080') {
            return ch < ' ' || ch == '\'' || ch == '\"' || ch == '\\' || ch == '\u007f';
        }
        return !Character.isValidCodePoint(ch) || Character.getType(ch) == 15 || ch == '\u2028' || ch == '\u2029';
    }

    public static StringBuilder appendChar(StringBuilder sb, char ch) {
        if (Handy.isCharEscaped(ch)) {
            return switch (ch) {
                case '\\' -> sb.append("\\\\");
                case '\b' -> sb.append("\\b");
                case '\f' -> sb.append("\\f");
                case '\n' -> sb.append("\\n");
                case '\r' -> sb.append("\\r");
                case '\t' -> sb.append("\\t");
                case '\'' -> sb.append("\\'");
                case '\"' -> sb.append("\\\"");
                case '\u0000' -> sb.append("\\0");
                case '\u000b' -> sb.append("\\v");
                case '\u001a' -> sb.append("\\z");
                case '\u001b' -> sb.append("\\e");
                case '\u007f' -> sb.append("\\d");
                default -> Handy.appendIntAsHex(sb.append('\\').append('u'), ch, 4);
            };
        }
        return sb.append(ch);
    }

    public static String quotedChar(char ch) {
        return Handy.appendChar(new StringBuilder(9).append('\''), ch).append('\'').toString();
    }

    public static StringBuilder appendString(StringBuilder sb, String s) {
        int cch = s.length();
        for (int of = 0; of < cch; ++of) {
            Handy.appendChar(sb, s.charAt(of));
        }
        return sb;
    }

    public static String quotedString(String s) {
        return Handy.appendString(new StringBuilder(s.length() + 2).append('\"'), s).append('\"').toString();
    }

    public static int closingQuote(String s, int of) {
        if (s == null || of < 0) {
            throw new IllegalArgumentException();
        }
        int cch = s.length();
        if (cch <= of + 1) {
            return -1;
        }
        char quote = s.charAt(of);
        if (quote != '\"' && quote != '\'' && quote != '`') {
            return -1;
        }
        ++of;
        while (of < cch) {
            char ch = s.charAt(of);
            switch (ch) {
                case '\"': 
                case '\'': 
                case '`': {
                    if (ch != quote) break;
                    return of;
                }
                case '\\': {
                    if (cch <= of + 2) {
                        return -1;
                    }
                    switch (s.charAt(of + 1)) {
                        case '\"': 
                        case '\'': 
                        case '0': 
                        case '\\': 
                        case 'b': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': 
                        case 'v': 
                        case 'z': {
                            ++of;
                        }
                    }
                }
            }
            ++of;
        }
        return -1;
    }

    public static String unquotedString(String s) {
        int cch = s.length();
        if (cch < 2 || s.charAt(0) != s.charAt(cch - 1) || "\"'`".indexOf(s.charAt(0)) < 0) {
            return s;
        }
        StringBuilder buf = new StringBuilder(cch - 2);
        --cch;
        for (int of = 1; of < cch; ++of) {
            char ch = s.charAt(of);
            if (ch == '\\' && of + 1 < cch) {
                char escaped = s.charAt(++of);
                switch (escaped) {
                    case '\\': {
                        buf.append('\\');
                        break;
                    }
                    case '\'': {
                        buf.append('\'');
                        break;
                    }
                    case '\"': {
                        buf.append('\"');
                        break;
                    }
                    case '0': {
                        buf.append('\u0000');
                        break;
                    }
                    case 'b': {
                        buf.append('\b');
                        break;
                    }
                    case 'd': {
                        buf.append('\u007f');
                        break;
                    }
                    case 'e': {
                        buf.append('\u001b');
                        break;
                    }
                    case 'f': {
                        buf.append('\f');
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        break;
                    }
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    case 'v': {
                        buf.append('\u000b');
                        break;
                    }
                    case 'z': {
                        buf.append('\u001a');
                        break;
                    }
                    default: {
                        --of;
                        buf.append('\\');
                        break;
                    }
                }
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String dateString(long cMillis) {
        Date date = new Date(cMillis);
        return String.valueOf(11900 + date.getYear()).substring(1, 5) + "-" + String.valueOf(101 + date.getMonth()).substring(1) + "-" + String.valueOf(100 + date.getDate()).substring(1) + " " + String.valueOf(100 + date.getHours()).substring(1) + ":" + String.valueOf(100 + date.getMinutes()).substring(1) + ":" + String.valueOf(100 + date.getSeconds()).substring(1);
    }

    public static long readPackedLong(DataInput in) throws IOException {
        return PackedInteger.readLong(in);
    }

    public static void writePackedLong(DataOutput out, long n) throws IOException {
        PackedInteger.writeLong(out, n);
    }

    public static int readPackedInt(DataInput in) throws IOException {
        long n = Handy.readPackedLong(in);
        if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
            throw new IOException("value (" + n + ") exceeds 32-bit range");
        }
        return (int)n;
    }

    public static int readMagnitude(DataInput in) throws IOException {
        long n = Handy.readPackedLong(in);
        if (n > Integer.MAX_VALUE) {
            throw new IOException("magnitude (" + n + ") exceeds 32-bit maximum");
        }
        if (n < 0L) {
            throw new IOException("negative magnitude (" + n + ") is illegal");
        }
        return (int)n;
    }

    public static int readIndex(DataInput in) throws IOException {
        long n = Handy.readPackedLong(in);
        if (n > Integer.MAX_VALUE) {
            throw new IOException("index (" + n + ") exceeds 32-bit maximum");
        }
        if (n < -1L) {
            throw new IOException("negative index (" + n + ") is illegal");
        }
        return (int)n;
    }

    public static int readUtf8Char(DataInput in) throws IOException {
        int b = in.readUnsignedByte();
        if ((b & 0x80) == 0) {
            return b;
        }
        switch (Integer.highestOneBit(~(0xFFFFFF00 | b))) {
            case 32: {
                return (b & 0x1F) << 6 | Handy.nextCharBits(in);
            }
            case 16: {
                return (b & 0xF) << 12 | Handy.nextCharBits(in) << 6 | Handy.nextCharBits(in);
            }
            case 8: {
                return (b & 7) << 18 | Handy.nextCharBits(in) << 12 | Handy.nextCharBits(in) << 6 | Handy.nextCharBits(in);
            }
            case 4: {
                return (b & 3) << 24 | Handy.nextCharBits(in) << 18 | Handy.nextCharBits(in) << 12 | Handy.nextCharBits(in) << 6 | Handy.nextCharBits(in);
            }
            case 2: {
                return (b & 1) << 30 | Handy.nextCharBits(in) << 24 | Handy.nextCharBits(in) << 18 | Handy.nextCharBits(in) << 12 | Handy.nextCharBits(in) << 6 | Handy.nextCharBits(in);
            }
        }
        throw new UTFDataFormatException("initial byte: " + Handy.byteToHexString(b));
    }

    private static int nextCharBits(DataInput in) throws IOException {
        int n = in.readUnsignedByte();
        if ((n & 0xC0) != 128) {
            throw new UTFDataFormatException("trailing unicode byte does not match 10xxxxxx");
        }
        return n & 0x3F;
    }

    public static void writeUtf8Char(DataOutput out, int ch) throws IOException {
        if ((ch & 0xFFFFFF80) == 0) {
            out.write(ch);
            return;
        }
        int cTrail = switch (Integer.highestOneBit(ch)) {
            case 128, 256, 512, 1024 -> {
                out.write(0xC0 | ch >>> 6);
                yield 1;
            }
            case 2048, 4096, 8192, 16384, 32768 -> {
                out.write(0xE0 | ch >>> 12);
                yield 2;
            }
            case 65536, 131072, 262144, 524288, 0x100000 -> {
                out.write(0xF0 | ch >>> 18);
                yield 3;
            }
            case 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000 -> {
                out.write(0xF8 | ch >>> 24);
                yield 4;
            }
            case 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000 -> {
                out.write(0xFC | ch >>> 30);
                yield 5;
            }
            default -> throw new UTFDataFormatException("illegal character: " + Handy.intToHexString(ch));
        };
        while (cTrail > 0) {
            out.write(0x80 | ch >>> --cTrail * 6 & 0x3F);
        }
    }

    public static String readUtf8String(DataInput in) throws IOException {
        int cb = Handy.readMagnitude(in);
        int cch = cb - Handy.readMagnitude(in);
        StringBuilder sb = new StringBuilder(cch);
        for (int ofch = 0; ofch < cch; ++ofch) {
            int ch = Handy.readUtf8Char(in);
            if (ch >= 65535) {
                if (!Character.isSupplementaryCodePoint(ch)) {
                    throw new UTFDataFormatException("Character is outside of UTF-16 (including supplemental) range: " + Handy.intToHexString(ch));
                }
                sb.append(Character.highSurrogate(ch)).append(Character.lowSurrogate(ch));
                continue;
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public static void writeUtf8String(DataOutput out, String s) throws IOException {
        int cch = s.length();
        int[] anch = new int[cch];
        int cb = 0;
        int cnch = 0;
        for (int ofch = 0; ofch < cch; ++ofch) {
            int nch;
            int ch = s.charAt(ofch);
            if (Character.isSurrogate((char)ch)) {
                char ch2;
                if (!Character.isHighSurrogate((char)ch)) {
                    throw new UTFDataFormatException("low surrogate unexpected: " + Handy.intToHexString(ch));
                }
                if (++ofch >= cch || !Character.isLowSurrogate(ch2 = s.charAt(ofch))) {
                    throw new UTFDataFormatException("low surrogate expected after: " + Handy.intToHexString(ch));
                }
                nch = Character.toCodePoint((char)ch, ch2);
            } else {
                nch = ch;
            }
            anch[cnch++] = nch;
            cb += Handy.calcUtf8Length(nch);
        }
        assert (cb >= cnch);
        Handy.writePackedLong(out, cb);
        Handy.writePackedLong(out, cb - cnch);
        for (int of = 0; of < cnch; ++of) {
            Handy.writeUtf8Char(out, anch[of]);
        }
    }

    private static int calcUtf8Length(int ch) throws IOException {
        if ((ch & 0xFFFFFF80) == 0) {
            return 1;
        }
        switch (Integer.highestOneBit(ch)) {
            case 128: 
            case 256: 
            case 512: 
            case 1024: {
                return 2;
            }
            case 2048: 
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: {
                return 3;
            }
            case 65536: 
            case 131072: 
            case 262144: 
            case 524288: 
            case 0x100000: {
                return 4;
            }
            case 0x200000: 
            case 0x400000: 
            case 0x800000: 
            case 0x1000000: 
            case 0x2000000: {
                return 5;
            }
            case 0x4000000: 
            case 0x8000000: 
            case 0x10000000: 
            case 0x20000000: 
            case 0x40000000: {
                return 6;
            }
        }
        throw new UTFDataFormatException("illegal character: " + Handy.intToHexString(ch));
    }

    public static File resolveFile(File file) {
        if (file != null) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException e) {
                return file.getAbsoluteFile();
            }
        }
        try {
            return new File(".").getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException e) {
            return new File(".").getAbsoluteFile();
        }
    }

    static File navigateTo(File file, String sPath) {
        if (file == null) {
            return null;
        }
        file = Handy.resolveFile(file);
        if (File.separatorChar != '/') {
            sPath = sPath.replace(File.separatorChar, '/');
        }
        String[] stringArray = Handy.parseDelimitedString(sPath, '/');
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String sPart;
            switch (sPart = stringArray[i]) {
                case ".": {
                    File file2 = file;
                    break;
                }
                case "..": {
                    File file2 = file.getParentFile();
                    break;
                }
                default: {
                    File file2 = file = file.isDirectory() ? new File(file, sPart) : null;
                }
            }
            if (file != null && file.exists()) continue;
            return null;
        }
        return file;
    }

    public static File[] listFiles(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return NO_FILES;
        }
        File[] aFile = dir.listFiles();
        Arrays.sort(aFile, Comparator.comparing(File::getName, String.CASE_INSENSITIVE_ORDER));
        return aFile;
    }

    public static File[] listFiles(File dir, String extension) {
        return extension == null ? dir.listFiles(f -> !f.isDirectory() && Handy.getExtension(f.getName()) == null) : dir.listFiles(f -> !f.isDirectory() && extension.equalsIgnoreCase(Handy.getExtension(f.getName())));
    }

    public static boolean isPathed(String sFile) {
        return sFile.indexOf(47) >= 0 || sFile.indexOf(File.separatorChar) >= 0;
    }

    public static String getExtension(File file) {
        return file == null ? null : Handy.getExtension(file.getName());
    }

    public static String getExtension(String sFile) {
        if (sFile == null) {
            return null;
        }
        int ofDot = sFile.lastIndexOf(46);
        if (ofDot <= 0) {
            return null;
        }
        String sExt = sFile.substring(ofDot + 1);
        return Handy.isPathed(sExt) ? null : sExt;
    }

    public static String removeExtension(String sFile) {
        int ofDot = sFile.lastIndexOf(46);
        if (ofDot <= 0) {
            return sFile;
        }
        return sFile.lastIndexOf(47) < ofDot && sFile.lastIndexOf(File.separatorChar) < ofDot ? sFile.substring(0, ofDot) : sFile;
    }

    public static String toPathString(File file) {
        String sAbs;
        if (file == null) {
            return "<null>";
        }
        String sPath = file.getPath();
        try {
            sAbs = file.getCanonicalPath();
        }
        catch (IOException e) {
            sAbs = file.getAbsolutePath();
        }
        return sPath.equals(sAbs) ? sPath : sPath + " (" + sAbs + ")";
    }

    public static boolean checkReadable(File file) {
        return file != null && file.exists() && !file.isDirectory() && file.canRead();
    }

    public static InputStream toInputStream(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("file does not exist: " + String.valueOf(file));
        }
        if (!file.isFile() || !file.canRead()) {
            throw new IOException("not a readable file: " + String.valueOf(file));
        }
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static byte[] readFileBytes(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file required");
        }
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException(file.toString());
        }
        long lcb = file.length();
        if (lcb == 0L) {
            return EMPTY_BYTE_ARRAY;
        }
        if (lcb > 0x7FFFFBFFL) {
            throw new IOException("file exceeds max supported length (2GB): " + String.valueOf(file) + "=" + lcb + " bytes");
        }
        int cb = (int)lcb;
        byte[] ab = new byte[cb];
        try (FileInputStream stream = new FileInputStream(file);){
            int cbChunk;
            for (int of = 0; of < cb; of += cbChunk) {
                cbChunk = stream.read(ab, of, cb - of);
                if (cbChunk >= 0) continue;
                throw new EOFException("unexpected end-of-file: " + String.valueOf(file));
            }
        }
        if (file.length() != lcb) {
            throw new IOException("file was concurrently modified while being read: " + String.valueOf(file));
        }
        return ab;
    }

    public static char[] readFileChars(File file) throws IOException {
        return Handy.readFileChars(file, null);
    }

    public static char[] readFileChars(File file, String sEncoding) throws IOException {
        int cbBOM;
        int cb;
        byte[] ab;
        block14: {
            ab = Handy.readFileBytes(file);
            cb = ab.length;
            if (cb == 0) {
                return EMPTY_CHAR_ARRAY;
            }
            cbBOM = 0;
            if (sEncoding == null) {
                switch (cb) {
                    default: {
                        if (ab[0] == 0 && ab[1] == 0 && (ab[2] & 0xFF) == 254 && (ab[3] & 0xFF) == 255) {
                            sEncoding = "UTF-32BE";
                            cbBOM = 4;
                            break;
                        }
                        if ((ab[0] & 0xFF) == 255 && (ab[1] & 0xFF) == 254 && ab[2] == 0 && ab[3] == 0) {
                            sEncoding = "UTF-32LE";
                            cbBOM = 4;
                            break;
                        }
                    }
                    case 3: {
                        if ((ab[0] & 0xFF) == 239 && (ab[1] & 0xFF) == 187 && (ab[2] & 0xFF) == 191) {
                            sEncoding = "UTF-8";
                            cbBOM = 3;
                            break;
                        }
                    }
                    case 2: {
                        if ((ab[0] & 0xFF) == 254 && (ab[1] & 0xFF) == 255) {
                            sEncoding = "UTF-16BE";
                            cbBOM = 2;
                            break;
                        }
                        if ((ab[0] & 0xFF) != 255 || (ab[1] & 0xFF) != 254) break;
                        sEncoding = "UTF-16LE";
                        cbBOM = 2;
                    }
                    case 0: 
                    case 1: 
                }
            }
            if (sEncoding == null) {
                char[] ach = new char[cb];
                for (int of = 0; of < cb; ++of) {
                    int b = ab[of] & 0xFF;
                    if (b <= 127) {
                        ach[of] = (char)(b & 0xFF);
                        continue;
                    }
                    break block14;
                }
                return ach;
            }
        }
        Charset charset = sEncoding == null ? Charset.defaultCharset() : Charset.forName(sEncoding);
        ByteBuffer bytebuf = ByteBuffer.wrap(ab, cbBOM, cb - cbBOM);
        CharBuffer charbuf = charset.decode(bytebuf);
        char[] ach = new char[charbuf.length()];
        charbuf.get(ach);
        return ach;
    }

    public static <T> int scan(T[] array, T value) {
        if (value == null) {
            return Handy.scanRef(array, value);
        }
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int scanRef(T[] array, T value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T[] sorted(T[] array) {
        Object[] result = (Object[])array.clone();
        Arrays.sort(result);
        return result;
    }

    public static <T> T[] sorted(T[] array, Comparator<T> order) {
        Object[] result = (Object[])array.clone();
        Arrays.sort(result, order);
        return result;
    }

    public static <T> T[] dedupAdds(T[] aoBase, T[] aoAdd) {
        int cBase = aoBase.length;
        int cAdd = aoAdd.length;
        boolean fAllDups = true;
        boolean fNoDups = true;
        ArrayList<T> listDeDup = null;
        block0: for (int iAdd = 0; iAdd < cAdd; ++iAdd) {
            T oAdd = aoAdd[iAdd];
            for (int iBase = 0; iBase < cBase; ++iBase) {
                if (!oAdd.equals(aoBase[iBase])) continue;
                if (!fNoDups) continue block0;
                fNoDups = false;
                if (fAllDups) continue block0;
                assert (listDeDup == null);
                listDeDup = Handy.startList(aoAdd, iAdd);
                continue block0;
            }
            if (fAllDups) {
                fAllDups = false;
                if (!fNoDups) {
                    assert (listDeDup == null);
                    listDeDup = new ArrayList<T>();
                }
            }
            if (listDeDup == null) continue;
            listDeDup.add(oAdd);
        }
        if (fNoDups) {
            assert (listDeDup == null);
            return aoAdd;
        }
        int cResult = listDeDup == null ? 0 : listDeDup.size();
        Object[] aoResult = (Object[])Array.newInstance(aoAdd.getClass().getComponentType(), cResult);
        if (cResult > 0) {
            aoResult = listDeDup.toArray(aoResult);
        }
        return aoResult;
    }

    public static <T> T[] append(T[] aoBase, T[] aoAdd) {
        int cBase = aoBase.length;
        if (cBase == 0) {
            return aoAdd;
        }
        int cAdd = aoAdd.length;
        if (cAdd == 0) {
            return aoBase;
        }
        int cResult = cBase + cAdd;
        Object[] aoResult = (Object[])Array.newInstance(aoAdd.getClass().getComponentType(), cResult);
        System.arraycopy(aoBase, 0, aoResult, 0, cBase);
        System.arraycopy(aoAdd, 0, aoResult, cBase, cAdd);
        return aoResult;
    }

    public static <T> T[] append(T[] array, T value) {
        assert (array != null && value != null);
        int oldSize = array.length;
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), oldSize + 1);
        System.arraycopy(array, 0, newArray, 0, oldSize);
        newArray[oldSize] = value;
        return newArray;
    }

    public static <T> T[] prepend(T[] aoBase, T oAdd) {
        int c = aoBase.length;
        Object[] aNew = (Object[])Array.newInstance(oAdd.getClass(), c + 1);
        aNew[0] = oAdd;
        System.arraycopy(aoBase, 0, aNew, 1, c);
        return aNew;
    }

    public static <T> T[] delete(T[] array, int index) {
        assert (array != null && index >= 0 && index < array.length);
        int oldSize = array.length;
        int newSize = oldSize - 1;
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), newSize);
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        if (index < newSize) {
            System.arraycopy(array, index + 1, newArray, index, newSize - index);
        }
        return newArray;
    }

    public static <T> ArrayList<T> startList(T[] ao, int c) {
        return Handy.appendList(new ArrayList(), ao, 0, c);
    }

    public static <T> ArrayList<T> appendList(ArrayList<T> list, T[] ao, int of, int c) {
        int ofEnd = of + c;
        while (of < ofEnd) {
            list.add(ao[of]);
            ++of;
        }
        return list;
    }

    public static int hashCode(Object o) {
        return Hash.of(o);
    }

    public static boolean equals(Object o1, Object o2) {
        Class<?> clz2;
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        Class<?> clz1 = o1.getClass();
        if (clz1 != (clz2 = o2.getClass())) {
            return false;
        }
        Class<?> clzComp = clz1.getComponentType();
        return clzComp == null || clzComp != clz2.getComponentType() ? o1.equals(o2) : (clzComp.isPrimitive() ? (clzComp == Integer.TYPE ? Arrays.equals((int[])o1, (int[])o2) : (clzComp == Long.TYPE ? Arrays.equals((long[])o1, (long[])o2) : (clzComp == Byte.TYPE ? Arrays.equals((byte[])o1, (byte[])o2) : (clzComp == Character.TYPE ? Arrays.equals((char[])o1, (char[])o2) : (clzComp == Double.TYPE ? Arrays.equals((double[])o1, (double[])o2) : (clzComp == Float.TYPE ? Arrays.equals((float[])o1, (float[])o2) : (clzComp == Short.TYPE ? Arrays.equals((short[])o1, (short[])o2) : Arrays.equals((boolean[])o1, (boolean[])o2)))))))) : Arrays.equals((Object[])o1, (Object[])o2));
    }

    public static int compareArrays(Comparable[] ao1, Comparable[] ao2) {
        if (ao1 == ao2) {
            return 0;
        }
        if (ao1 == null) {
            return -1;
        }
        if (ao2 == null) {
            return 1;
        }
        int c1 = ao1.length;
        int c2 = ao2.length;
        int c = Math.min(c1, c2);
        for (int i = 0; i < c; ++i) {
            int n = ao1[i].compareTo(ao2[i]);
            if (n == 0) continue;
            return n;
        }
        return c1 - c2;
    }

    public static boolean checkElementsNonNull(Object[] ao) {
        if (ao == null) {
            throw new IllegalArgumentException("array is null");
        }
        for (Object o : ao) {
            if (o != null) continue;
            throw new IllegalArgumentException("array element is null");
        }
        return true;
    }

    public static boolean require(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException((name == null ? "Required value" : name) + " is null");
        }
        return true;
    }
}

