/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.Objects;
import java.util.function.Function;

public interface Hasher<T> {
    public int hash(T var1);

    public boolean equals(T var1, T var2);

    public static <T> Hasher<T> natural() {
        return Natural.INSTANCE;
    }

    public static <T> Hasher<T> identity() {
        return Identity.INSTANCE;
    }

    default public <U> Hasher<U> using(final Function<? super U, ? extends T> extractor) {
        final Hasher outer = this;
        return new Hasher<U>(this){

            @Override
            public int hash(U object) {
                return outer.hash(extractor.apply(object));
            }

            @Override
            public boolean equals(U a, U b) {
                return outer.equals(extractor.apply(a), extractor.apply(b));
            }
        };
    }

    public static final class Natural
    implements Hasher<Object> {
        static final Hasher<Object> INSTANCE = new Natural();

        private Natural() {
        }

        @Override
        public int hash(Object object) {
            return Objects.hashCode(object);
        }

        @Override
        public boolean equals(Object a, Object b) {
            return Objects.equals(a, b);
        }
    }

    public static final class Identity
    implements Hasher<Object> {
        static final Hasher<Object> INSTANCE = new Identity();

        private Identity() {
        }

        @Override
        public int hash(Object object) {
            return System.identityHashCode(object);
        }

        @Override
        public boolean equals(Object a, Object b) {
            return a == b;
        }
    }
}

