/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.xvm.util.Hasher;
import org.xvm.util.HasherReference;
import org.xvm.util.TransientHasherReference;
import org.xvm.util.converter.AbstractConverterMap;

public class HasherMap<K, V>
extends AbstractConverterMap<K, V, Supplier<K>, V> {
    final Hasher<K> hasher;

    public HasherMap(Hasher<K> hasher) {
        this(hasher, HashMap::new);
    }

    public HasherMap(Hasher<K> hasher, Supplier<? extends Map<Supplier<K>, V>> storage) {
        super(storage.get());
        this.hasher = hasher;
    }

    @Override
    protected Supplier<K> keyDown(K key) {
        return new HasherReference<K>(key, this.hasher);
    }

    protected TransientHasherReference<K> transientKeyDown(K key) {
        return TransientHasherReference.of(key, this.hasher);
    }

    @Override
    protected K keyUp(Supplier<K> key) {
        return key == null ? null : (K)key.get();
    }

    @Override
    protected V valueDown(V value) {
        return value;
    }

    @Override
    protected V valueUp(V value) {
        return value;
    }

    @Override
    public V get(Object key) {
        try (TransientHasherReference tmpKeyDown = this.transientKeyDown(this.unchecked(key));){
            Object SV = this.read().get(tmpKeyDown);
            return (V)SV;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try (TransientHasherReference tmpKeyDown = this.transientKeyDown(this.unchecked(key));){
            boolean bl = this.read().containsKey(tmpKeyDown);
            return bl;
        }
    }

    @Override
    public V remove(Object key) {
        try (TransientHasherReference tmpKeyDown = this.transientKeyDown(this.unchecked(key));){
            Object SV = this.write().remove(tmpKeyDown);
            return (V)SV;
        }
    }

    @Override
    public V replace(K key, V value) {
        try (TransientHasherReference<K> tmpKeyDown = this.transientKeyDown(key);){
            Object SV = this.write().replace(tmpKeyDown, value);
            return (V)SV;
        }
    }

    @Override
    protected Set<K> newKeySet() {
        return new KeySet();
    }

    protected class KeySet
    extends AbstractConverterMap.KeySet {
        protected KeySet() {
            super(HasherMap.this);
        }

        @Override
        public boolean contains(Object o) {
            try (TransientHasherReference tmpKeyDown = HasherMap.this.transientKeyDown(this.unchecked(o));){
                boolean bl = this.read().contains(tmpKeyDown);
                return bl;
            }
        }

        @Override
        public boolean remove(Object o) {
            try (TransientHasherReference tmpKeyDown = HasherMap.this.transientKeyDown(this.unchecked(o));){
                boolean bl = this.write().remove(tmpKeyDown);
                return bl;
            }
        }
    }
}

