/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.function.Supplier;
import org.xvm.util.Hasher;

public class HasherReference<T>
implements Supplier<T> {
    private Hasher<? super T> hasher;
    private T referent;

    public HasherReference(T referent, Hasher<? super T> hasher) {
        this.reset(referent, hasher);
    }

    protected void reset(T referent, Hasher<? super T> hasher) {
        this.referent = referent;
        this.hasher = hasher;
    }

    @Override
    public T get() {
        return this.referent;
    }

    public int hashCode() {
        return this.hasher.hash(this.referent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Supplier)) return false;
        Supplier that = (Supplier)obj;
        if (!this.hasher.equals(this.get(), that.get())) return false;
        return true;
    }
}

