/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class LinkedIterator<E>
implements Iterator<E> {
    private final Iterator<E>[] f_aIter;
    private Iterator<E> m_iterCur = Collections.emptyIterator();
    private static final int NOT_READY = 0;
    private static final int HAS_NEXT = 1;
    private static final int CAN_REMOVE = 2;
    private int m_nState = 0;
    private static final Iterator[] NO_ITERATORS = new Iterator[0];

    public LinkedIterator(Iterator<E> ... aIter) {
        this.f_aIter = Objects.requireNonNullElse(aIter, NO_ITERATORS);
    }

    @Override
    public boolean hasNext() {
        return this.m_nState == 1 || this.prepareNextElement();
    }

    @Override
    public E next() {
        if (this.m_nState == 1 || this.prepareNextElement()) {
            E eNext = this.m_iterCur.next();
            this.m_nState = 2;
            return eNext;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.m_nState != 2) {
            throw new IllegalStateException();
        }
        this.m_iterCur.remove();
        this.m_nState = 0;
    }

    private boolean prepareNextElement() {
        do {
            if (this.m_iterCur.hasNext()) {
                this.m_nState = 1;
                return true;
            }
            this.m_nState = 0;
        } while (this.prepareNextIterator());
        return false;
    }

    private boolean prepareNextIterator() {
        for (Iterator<E> iter : this.f_aIter) {
            if (iter == null) continue;
            this.m_iterCur = iter;
            this.m_nState = 0;
            this.f_aIter[i] = null;
            return true;
        }
        this.m_iterCur = Collections.emptyIterator();
        return false;
    }
}

