/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListMap<K, V>
extends AbstractMap<K, V> {
    private final ArrayList<AbstractMap.SimpleEntry<K, V>> m_list;
    private final Set<Map.Entry<K, V>> m_setEntries = new AbstractSet<Map.Entry<K, V>>(){

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return ListMap.this.m_list.iterator();
        }

        @Override
        public int size() {
            return ListMap.this.m_list.size();
        }
    };
    private static final ArrayList<?> EMPTY_ARRAY_LIST = new ArrayList(0);
    public static final ListMap EMPTY = new ListMap(-1);

    public ListMap() {
        this.m_list = new ArrayList();
    }

    public ListMap(int cInitSize) {
        this.m_list = cInitSize >= 0 ? new ArrayList(cInitSize) : EMPTY_ARRAY_LIST;
    }

    public ListMap(ListMap<K, V> map) {
        this.m_list = new ArrayList<AbstractMap.SimpleEntry<K, V>>(map.m_list);
    }

    @Override
    public V put(K key, V value) {
        AbstractMap.SimpleEntry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            return entry.setValue(value);
        }
        if (this.m_list == EMPTY_ARRAY_LIST) {
            throw new UnsupportedOperationException();
        }
        this.m_list.add(new AbstractMap.SimpleEntry<K, V>(key, value));
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.m_setEntries;
    }

    public List<Map.Entry<K, V>> asList() {
        List<Map.Entry<K, V>> list = this.m_list;
        assert ((list = Collections.unmodifiableList(list)) != null);
        return list;
    }

    public Map.Entry<K, V> entryAt(int index) {
        return this.m_list.get(index);
    }

    protected AbstractMap.SimpleEntry<K, V> getEntry(Object key) {
        ArrayList<AbstractMap.SimpleEntry<K, V>> list = this.m_list;
        int c = list.size();
        for (int i = 0; i < c; ++i) {
            AbstractMap.SimpleEntry<K, V> entry = list.get(i);
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public V get(Object key) {
        AbstractMap.SimpleEntry<K, V> entry = this.getEntry(key);
        return entry == null ? null : (V)entry.getValue();
    }
}

