/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ListSet<E>
extends AbstractSet<E> {
    private static final Object NULL = new Null();
    private static final int INDEX_MIN = 12;
    private static final int[] INDEX_SIZE = new int[]{0, 0, 0, 0, 23, 47, 97, 191, 373, 757, 1543, 2999, 5987, 11987, 23993, 47981, 95989, 189877, 389447, 779353, 1499977, 2999999, 5999993, 11999989, 23999999, 47999969, 95999993, 191999987, 383999983, 767999993};
    private Object[] m_aElem;
    private int m_iHead;
    private int m_iTail;
    private int m_cBlank;
    private int m_cReorgs;
    private int m_cStops;
    private int[] m_anHash;
    private boolean m_fSuppressEquals;
    private boolean m_fSuppressHash;
    private boolean m_fSuppressNull;

    public ListSet() {
        this(16);
    }

    public ListSet(int cInitSize) {
        this.m_aElem = new Object[Integer.highestOneBit(Math.max(cInitSize, 4) * 2 - 1)];
    }

    public ListSet(Collection<? extends E> that) {
        this(that.size());
        this.addAll(that);
    }

    public ListSet<E> useIdentityEquality() {
        assert (this.isEmpty());
        this.m_fSuppressEquals = true;
        return this;
    }

    public ListSet<E> disableHashIndex() {
        assert (this.isEmpty());
        this.m_fSuppressHash = true;
        this.m_anHash = null;
        return this;
    }

    public ListSet<E> disallowNulls() {
        assert (this.isEmpty());
        this.m_fSuppressNull = true;
        return this;
    }

    public E first() {
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        return this.get(0);
    }

    public E last() {
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        return this.get(this.size() - 1);
    }

    public E get(int index) {
        int cSize = this.size();
        if (index < 0 || index >= cSize) {
            throw new IllegalArgumentException();
        }
        Object[] aElem = this.m_aElem;
        int nMask = aElem.length - 1;
        if (index > cSize / 2) {
            int cSkip = cSize - index - 1;
            int i = this.m_iHead - 1;
            while (true) {
                Object o;
                if ((o = aElem[i & nMask]) != null && !(o instanceof Stop) && cSkip-- == 0) {
                    return ListSet.toExternal(o);
                }
                --i;
            }
        }
        int cSkip = index;
        int i = this.m_iTail;
        Object o;
        while ((o = aElem[i & nMask]) == null || o instanceof Stop || cSkip-- != 0) {
            ++i;
        }
        return ListSet.toExternal(o);
    }

    @Override
    public int size() {
        return this.m_iHead - this.m_iTail - this.m_cBlank;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(ListSet.toInternal(o)) >= 0;
    }

    @Override
    public boolean add(E e) {
        boolean fNew;
        if (this.m_fSuppressNull && e == null) {
            throw new IllegalArgumentException("null value is not permitted");
        }
        Object o = ListSet.toInternal(e);
        boolean bl = fNew = this.indexOf(o) < 0;
        if (fNew) {
            this.addInternal(o);
        }
        return fNew;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(ListSet.toInternal(o));
        if (i < 0) {
            return false;
        }
        this.remove(i);
        return true;
    }

    @Override
    public void clear() {
        if (this.m_iHead > this.m_iTail) {
            Arrays.fill(this.m_aElem, null);
            if (this.m_anHash != null) {
                Arrays.fill(this.m_anHash, -1);
            }
            this.m_iHead = 0;
            this.m_iTail = 0;
            this.m_cBlank = 0;
            ++this.m_cReorgs;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.isEmpty() ? Collections.emptyIterator() : new SafeIterator();
    }

    private int indexOf(Object o) {
        int i;
        int iHead = this.m_iHead;
        int iTail = this.m_iTail;
        if (iHead == iTail) {
            return -1;
        }
        if (this.indexEnabled()) {
            return this.indexSearch(o);
        }
        Object[] aElem = this.m_aElem;
        int nMask = aElem.length - 1;
        for (i = iTail; i < iHead; ++i) {
            if (o != aElem[i & nMask]) continue;
            return i;
        }
        if (!this.m_fSuppressEquals) {
            for (i = iTail; i < iHead; ++i) {
                Object eCur = aElem[i & nMask];
                if (eCur == null || eCur instanceof Special || !eCur.equals(o)) continue;
                return i;
            }
        }
        return -1;
    }

    private static Object toInternal(Object o) {
        return o == null ? NULL : o;
    }

    private static <E> E toExternal(Object o) {
        assert (o != null && !(o instanceof Stop));
        return (E)(o == NULL ? null : o);
    }

    private void addInternal(Object o) {
        Object oPrev;
        if (this.m_iHead - this.m_iTail >= this.m_aElem.length) {
            this.ensureSpace();
        }
        Object[] aElem = this.m_aElem;
        int nMask = aElem.length - 1;
        int iElem = this.m_iHead;
        if (iElem > this.m_iTail && (oPrev = this.m_aElem[iElem - 1 & nMask]) instanceof Stop && ((Stop)oPrev).isDisposable()) {
            --iElem;
            --this.m_cBlank;
        }
        aElem[iElem & nMask] = o;
        this.m_iHead = iElem + 1;
        if (!this.m_fSuppressHash && !(o instanceof Stop)) {
            if (this.indexEnabled()) {
                this.indexAdd(o.hashCode(), iElem);
            } else if (this.size() >= 12) {
                this.indexInit();
            }
        }
    }

    private Stop ensureStop() {
        Object last;
        if (this.m_iHead > this.m_iTail && (last = this.m_aElem[this.m_iHead - 1 & this.m_aElem.length - 1]) instanceof Stop) {
            return (Stop)last;
        }
        Stop stop = new Stop(++this.m_cStops);
        this.addInternal(stop);
        ++this.m_cBlank;
        return stop;
    }

    private void ensureSpace() {
        if (this.m_cBlank > this.m_aElem.length >>> 3) {
            int cPrev = this.m_cBlank;
            this.compact();
            if (cPrev - this.m_cBlank > Math.min(1024, this.m_aElem.length >>> 4)) {
                return;
            }
        }
        this.grow();
    }

    private void compact() {
        int iSrc;
        Object[] aElem = this.m_aElem;
        int cElem = aElem.length;
        int nMask = cElem - 1;
        boolean fFront = true;
        Stop stop = null;
        int iSrcEnd = this.m_iHead;
        int iDest = iSrc;
        int iDestEnd = iSrcEnd - this.m_cBlank;
        int cBlanks = 0;
        boolean fAdjust = this.indexEnabled();
        for (iSrc = this.m_iTail; iSrc < iSrcEnd; ++iSrc) {
            Object elem = aElem[iSrc & nMask];
            if (elem instanceof Stop) {
                Stop stopCur = (Stop)elem;
                if (fFront || stopCur.isDisposable()) continue;
                if (stop == null) {
                    stop = stopCur;
                    continue;
                }
                stopCur.mergeInto(stop);
                continue;
            }
            if (elem == null) continue;
            fFront = false;
            if (iSrc >= iDestEnd) {
                aElem[iSrc & nMask] = null;
            }
            if (stop != null) {
                aElem[iDest++ & nMask] = stop;
                ++cBlanks;
                stop = null;
            }
            if (fAdjust) {
                this.indexAdjust(elem.hashCode(), iSrc, iDest);
            }
            aElem[iDest++ & nMask] = elem;
        }
        if (stop != null) {
            aElem[iDest++ & nMask] = stop;
            ++cBlanks;
        }
        int iTailOld = this.m_iTail;
        int iTailNew = iTailOld & nMask;
        int cDelta = iTailOld - iTailNew;
        this.m_iHead = iDest - cDelta;
        this.m_iTail = iTailNew;
        this.m_cBlank = cBlanks;
        if (fAdjust) {
            this.indexAdjustAll(cDelta);
        }
        ++this.m_cReorgs;
    }

    private void grow() {
        Object[] aOld = this.m_aElem;
        int cOld = aOld.length;
        int cNew = cOld + cOld;
        assert (cNew <= 0x20000000);
        Object[] aNew = new Object[cNew];
        int nOldMask = cOld - 1;
        int nNewMask = cNew - 1;
        int c = this.m_iHead;
        for (int i = this.m_iTail; i < c; ++i) {
            aNew[i & nNewMask] = aOld[i & nOldMask];
        }
        this.m_aElem = aNew;
        if (this.indexEnabled()) {
            this.indexInit();
        }
        ++this.m_cReorgs;
    }

    private int verify(int i, Object elem) {
        Object eVerify;
        Object[] aElem = this.m_aElem;
        int nMask = aElem.length - 1;
        if (i >= this.m_iTail && i < this.m_iHead && elem == (eVerify = aElem[i & nMask])) {
            return i;
        }
        if (this.indexEnabled()) {
            return this.indexSearch(elem);
        }
        int iLast = this.m_iHead - 1;
        for (int iTest = this.m_iTail; iTest <= iLast; ++iTest) {
            if (aElem[iTest & nMask] != elem) continue;
            return iTest;
        }
        return -1;
    }

    private int verifyIterator(Object eNext, int nStop) {
        Object[] aElem = this.m_aElem;
        int nMask = aElem.length - 1;
        int iNext = -1;
        if (this.indexEnabled()) {
            iNext = this.indexSearch(eNext);
            if (iNext < 0) {
                return -1;
            }
            int iLast = this.m_iHead - 1;
            for (int iTest = iNext + 1; iTest <= iLast; ++iTest) {
                Object eCur = aElem[iTest & nMask];
                if (!(eCur instanceof Stop)) continue;
                Stop stop = (Stop)eCur;
                if (stop.appliesTo(nStop)) {
                    return iNext;
                }
                if (stop.id() <= nStop) continue;
                return -1;
            }
        } else {
            int iLast = this.m_iHead - 1;
            for (int iTest = this.m_iTail; iTest <= iLast; ++iTest) {
                Object eCur = aElem[iTest & nMask];
                if (eCur == eNext) {
                    assert (iNext < 0);
                    iNext = iTest;
                    continue;
                }
                if (!(eCur instanceof Stop) || !((Stop)eCur).appliesTo(nStop)) continue;
                return iNext;
            }
        }
        return -1;
    }

    private void remove(int i) {
        assert (i >= this.m_iTail && i < this.m_iHead);
        int nMask = this.m_aElem.length - 1;
        Object o = this.m_aElem[i & nMask];
        assert (o != null);
        this.m_aElem[i & nMask] = null;
        if (this.indexEnabled()) {
            this.indexRemove(o.hashCode(), i);
        }
        if (i == this.m_iTail) {
            ++this.m_iTail;
        } else {
            ++this.m_cBlank;
        }
    }

    private boolean indexEnabled() {
        return this.m_anHash != null;
    }

    private void indexInit() {
        int[] anHashOld = this.m_anHash;
        int cBucketsOld = anHashOld == null ? 0 : anHashOld.length;
        int nModuloOld = cBucketsOld >>> 1;
        int nModuloNew = INDEX_SIZE[Integer.numberOfTrailingZeros(this.m_aElem.length)];
        assert (nModuloNew > 0);
        if (nModuloNew == nModuloOld) {
            return;
        }
        int cBucketsNew = nModuloNew << 1;
        int[] anHashNew = new int[cBucketsNew];
        Arrays.fill(anHashNew, -1);
        this.m_anHash = anHashNew;
        if (cBucketsOld == 0) {
            Object[] aElem = this.m_aElem;
            int nMask = aElem.length - 1;
            int c = this.m_iHead;
            for (int i = this.m_iTail; i < c; ++i) {
                Object o = aElem[i & nMask];
                if (o == null || o instanceof Stop) continue;
                this.indexAdd(o.hashCode(), i);
            }
        } else {
            int cOld = anHashOld.length;
            block1: for (int iOld = 0; iOld < cOld; iOld += 2) {
                int iElem = anHashOld[iOld];
                if (iElem < 0) continue;
                int nHash = anHashOld[iOld + 1];
                int iNew = (int)(((long)nHash & 0xFFFFFFFFFL) % (long)nModuloNew) << 1;
                while (true) {
                    if (anHashNew[iNew] < 0) {
                        anHashNew[iNew] = iElem;
                        anHashNew[iNew + 1] = nHash;
                        continue block1;
                    }
                    if ((iNew += 2) < cBucketsNew) continue;
                    iNew = 0;
                }
            }
        }
    }

    private void indexAdd(int nHash, int index) {
        int[] anIndex = this.m_anHash;
        int cBuckets = anIndex.length;
        int nModulo = cBuckets >>> 1;
        int iBucket = (int)(((long)nHash & 0xFFFFFFFFFL) % (long)nModulo) << 1;
        while (true) {
            int iElem;
            if ((iElem = anIndex[iBucket]) < 0) {
                anIndex[iBucket] = index;
                anIndex[iBucket + 1] = nHash;
                return;
            }
            if ((iBucket += 2) < cBuckets) continue;
            iBucket = 0;
        }
    }

    private void indexRemove(int nHash, int index) {
        int[] anIndex = this.m_anHash;
        int cBuckets = anIndex.length;
        int nModulo = cBuckets >>> 1;
        int iBucket = (int)(((long)nHash & 0xFFFFFFFFFL) % (long)nModulo) << 1;
        while (true) {
            int iElem = anIndex[iBucket];
            assert (iElem >= 0);
            if (iElem == index) {
                assert (anIndex[iBucket + 1] == nHash);
                break;
            }
            if ((iBucket += 2) < cBuckets) continue;
            iBucket = 0;
        }
        anIndex[iBucket] = -1;
        int iBucketDest = iBucket;
        int iBucketSrc = iBucket;
        boolean fStraddled = false;
        while (true) {
            int iElem;
            if ((iBucketSrc += 2) >= cBuckets) {
                assert (!fStraddled);
                iBucketSrc = 0;
                fStraddled = true;
            }
            if ((iElem = anIndex[iBucketSrc]) < 0) {
                return;
            }
            nHash = anIndex[iBucketSrc + 1];
            iBucket = (int)(((long)nHash & 0xFFFFFFFFFL) % (long)nModulo) << 1;
            if (iBucket == iBucketSrc || (!fStraddled || iBucket <= iBucketSrc || iBucket > iBucketDest) && (fStraddled || iBucket <= iBucketSrc && iBucket > iBucketDest)) continue;
            anIndex[iBucketDest] = iElem;
            anIndex[iBucketDest + 1] = nHash;
            anIndex[iBucketSrc] = -1;
            iBucketDest = iBucketSrc;
            fStraddled = false;
        }
    }

    private int indexSearch(Object o) {
        int[] anIndex = this.m_anHash;
        int cBuckets = anIndex.length;
        int nModulo = cBuckets >>> 1;
        int nHash = o.hashCode();
        int iBucket = (int)(((long)nHash & 0xFFFFFFFFFL) % (long)nModulo) << 1;
        Object[] aElem = this.m_aElem;
        int nMask = aElem.length - 1;
        while (true) {
            int iElem;
            if ((iElem = anIndex[iBucket]) >= 0) {
                Object oElem;
                if (anIndex[iBucket + 1] == nHash && (o == (oElem = aElem[iElem & nMask]) || !this.m_fSuppressEquals && o != null && !(o instanceof Special) && oElem.equals(o))) {
                    return iElem;
                }
            } else {
                return -1;
            }
            if ((iBucket += 2) < cBuckets) continue;
            iBucket = 0;
        }
    }

    private void indexAdjust(int nHash, int indexOld, int indexNew) {
        int[] anIndex = this.m_anHash;
        int cBuckets = anIndex.length;
        int nModulo = cBuckets >>> 1;
        int iBucket = (int)(((long)nHash & 0xFFFFFFFFFL) % (long)nModulo) << 1;
        while (true) {
            int iElem = anIndex[iBucket];
            assert (iElem >= 0);
            if (iElem == indexOld) {
                assert (anIndex[iBucket + 1] == nHash);
                anIndex[iBucket] = indexNew;
                return;
            }
            if ((iBucket += 2) < cBuckets) continue;
            iBucket = 0;
        }
    }

    private void indexAdjustAll(int indexDelta) {
        int[] anIndex = this.m_anHash;
        int c = anIndex.length;
        for (int i = 0; i < c; i += 2) {
            int index = anIndex[i];
            if (index < 0) continue;
            anIndex[i] = index - indexDelta;
        }
    }

    private static class Stop
    extends Special {
        int first;
        int last;
        int active;
        Stop next;

        Stop(int nStop) {
            this.first = this.last = nStop;
        }

        int id() {
            return this.next == null ? this.last : this.next.id();
        }

        boolean appliesTo(int nStop) {
            return this.next == null ? nStop >= this.first && nStop <= this.last : this.next.appliesTo(nStop);
        }

        void beginUse() {
            if (this.next == null) {
                ++this.active;
            } else {
                this.next.beginUse();
            }
        }

        void finishUse() {
            if (this.next == null) {
                --this.active;
                assert (this.active >= 0);
            } else {
                this.next.finishUse();
            }
        }

        void mergeInto(Stop that) {
            that.first = Math.min(this.first, that.first);
            that.last = Math.max(this.last, that.last);
            that.active = this.active + that.active;
            this.first = -1;
            this.last = -1;
            this.active = 0;
            this.next = that;
        }

        boolean isDisposable() {
            return this.active <= 0;
        }

        public String toString() {
            return "<stop:" + (String)(this.first == this.last ? String.valueOf(this.last) : this.first + "-" + this.last) + ">";
        }
    }

    private class SafeIterator
    implements Iterator<E>,
    AutoCloseable {
        private int m_iPrev = -1;
        private Object m_ePrev;
        private int m_iNext = -1;
        private Object m_eNext;
        private final Stop m_stop;
        private int m_nExpect;

        public SafeIterator() {
            this.m_stop = ListSet.this.ensureStop();
            this.m_stop.beginUse();
            this.m_nExpect = ListSet.this.m_cReorgs;
            this.loadNext(ListSet.this.m_iTail);
        }

        @Override
        public boolean hasNext() {
            return this.m_eNext != null && this.synced();
        }

        @Override
        public E next() {
            Object eCur = this.m_eNext;
            if (eCur == null || !this.synced()) {
                throw new NoSuchElementException();
            }
            this.m_iPrev = this.m_iNext;
            this.m_ePrev = eCur;
            this.loadNext(this.m_iNext + 1);
            return ListSet.toExternal(eCur);
        }

        @Override
        public void remove() {
            int iActual;
            if (this.m_iPrev >= 0 && (iActual = ListSet.this.verify(this.m_iPrev, this.m_ePrev)) >= 0) {
                ListSet.this.remove(this.m_iPrev);
                this.m_iPrev = -1;
                this.m_ePrev = null;
                return;
            }
            throw new IllegalStateException();
        }

        @Override
        public void close() {
            if (this.m_nExpect >= 0) {
                this.m_iNext = -1;
                this.m_eNext = null;
                this.m_nExpect = -1;
                this.m_stop.finishUse();
            }
        }

        public String toString() {
            return "SafeIterator-" + this.m_stop.id();
        }

        private void loadNext(int iNext) {
            Object[] aElem = ListSet.this.m_aElem;
            int nMask = aElem.length - 1;
            int iLast = ListSet.this.m_iHead - 1;
            while (iNext <= iLast) {
                Object eNext = aElem[iNext & nMask];
                if (eNext instanceof Stop) {
                    if (((Stop)eNext).appliesTo(this.m_stop.id())) {
                        break;
                    }
                } else if (eNext != null) {
                    this.m_iNext = iNext;
                    this.m_eNext = eNext;
                    return;
                }
                ++iNext;
            }
            this.close();
        }

        private boolean synced() {
            if (this.m_nExpect != ListSet.this.m_cReorgs) {
                assert (this.m_nExpect >= 0);
                this.m_iNext = ListSet.this.verifyIterator(this.m_eNext, this.m_stop.id());
                if (this.m_iNext < 0) {
                    this.m_eNext = null;
                    return false;
                }
                this.m_nExpect = ListSet.this.m_cReorgs;
            }
            return true;
        }
    }

    private static class Special {
        private Special() {
        }
    }

    private static class Null
    extends Special {
        private Null() {
        }

        public int hashCode() {
            return 2147483629;
        }

        public boolean equals(Object obj) {
            return obj instanceof Null;
        }

        public String toString() {
            return "<null>";
        }
    }
}

