/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;

public class PackedInteger
implements Comparable<PackedInteger> {
    private boolean m_fInitialized;
    private boolean m_fBig;
    private long m_lValue;
    private BigInteger m_bigint;
    private static final PackedInteger[] CACHE = new PackedInteger[4096];
    private static final long CACHE_MIN = -(CACHE.length >> 2);
    private static final long CACHE_MAX = CACHE_MIN + (long)CACHE.length - 1L;
    public static final PackedInteger ZERO = PackedInteger.valueOf(0L);
    public static final PackedInteger ONE = PackedInteger.valueOf(1L);
    public static final PackedInteger NEG_ONE = PackedInteger.valueOf(-1L);
    public static final PackedInteger SINT1_MIN = PackedInteger.valueOf(-128L);
    public static final PackedInteger SINT2_MIN = PackedInteger.valueOf(-32768L);
    public static final PackedInteger SINT4_MIN = PackedInteger.valueOf(Integer.MIN_VALUE);
    public static final PackedInteger SINT8_MIN = PackedInteger.valueOf(Long.MIN_VALUE);
    public static final PackedInteger SINT16_MIN = new PackedInteger(new BigInteger("-8" + "0".repeat(31), 16));
    public static final PackedInteger SINTN_MIN = new PackedInteger(new BigInteger("-8" + "0".repeat(2047), 16));
    public static final PackedInteger SINT1_MAX = PackedInteger.valueOf(127L);
    public static final PackedInteger SINT2_MAX = PackedInteger.valueOf(32767L);
    public static final PackedInteger SINT4_MAX = PackedInteger.valueOf(Integer.MAX_VALUE);
    public static final PackedInteger SINT8_MAX = PackedInteger.valueOf(Long.MAX_VALUE);
    public static final PackedInteger SINT16_MAX = new PackedInteger(new BigInteger("7" + "F".repeat(31), 16));
    public static final PackedInteger SINTN_MAX = new PackedInteger(new BigInteger("7" + "F".repeat(2047), 16));
    public static final PackedInteger UINT1_MAX = PackedInteger.valueOf(255L);
    public static final PackedInteger UINT2_MAX = PackedInteger.valueOf(65535L);
    public static final PackedInteger UINT4_MAX = PackedInteger.valueOf(0xFFFFFFFFL);
    public static final PackedInteger UINT8_MAX = new PackedInteger(new BigInteger("F".repeat(16), 16));
    public static final PackedInteger UINT16_MAX = new PackedInteger(new BigInteger("F".repeat(32), 16));
    public static final PackedInteger UINTN_MAX = SINTN_MAX;
    public static final PackedInteger KB = PackedInteger.valueOf(1000L);
    public static final PackedInteger KI = PackedInteger.valueOf(1024L);
    public static final PackedInteger MB = PackedInteger.valueOf(1000000L);
    public static final PackedInteger MI = PackedInteger.valueOf(0x100000L);
    public static final PackedInteger GB = PackedInteger.valueOf(1000000000L);
    public static final PackedInteger GI = PackedInteger.valueOf(0x40000000L);
    public static final PackedInteger TB = PackedInteger.valueOf(1000000000000L);
    public static final PackedInteger TI = PackedInteger.valueOf(0x10000000000L);
    public static final PackedInteger PB = PackedInteger.valueOf(1000000000000000L);
    public static final PackedInteger PI = PackedInteger.valueOf(0x4000000000000L);
    public static final PackedInteger EB = PackedInteger.valueOf(1000000000000000000L);
    public static final PackedInteger EI = PackedInteger.valueOf(0x1000000000000000L);
    public static final PackedInteger ZB = EB.mul(KB);
    public static final PackedInteger ZI = EI.mul(KI);
    public static final PackedInteger YB = ZB.mul(KB);
    public static final PackedInteger YI = ZI.mul(KI);
    public static final PackedInteger[] xB_FACTORS = new PackedInteger[]{KB, MB, GB, TB, PB, EB, ZB, YB};
    public static final PackedInteger[] xI_FACTORS = new PackedInteger[]{KI, MI, GI, TI, PI, EI, ZI, YI};

    public PackedInteger() {
    }

    public PackedInteger(long lVal) {
        this.setLong(lVal);
    }

    public PackedInteger(BigInteger bigint) {
        this.setBigInteger(bigint);
    }

    public PackedInteger(DataInput in) throws IOException {
        this.readObject(in);
    }

    public static PackedInteger valueOf(long lVal) {
        if (lVal >= CACHE_MIN & lVal <= CACHE_MAX) {
            int iCache = (int)(lVal - CACHE_MIN);
            PackedInteger pint = CACHE[iCache];
            if (pint == null) {
                PackedInteger.CACHE[iCache] = pint = new PackedInteger(lVal);
            }
            return pint;
        }
        return new PackedInteger(lVal);
    }

    public int getSignedByteSize() {
        int nBytes;
        this.verifyInitialized();
        int n = nBytes = this.m_fBig ? PackedInteger.calculateSignedByteCount(this.m_bigint) : Math.max(1, ((64 - Long.numberOfLeadingZeros(Math.max(this.m_lValue, this.m_lValue ^ 0xFFFFFFFFFFFFFFFFL)) & 0x3F) + 7) / 8);
        assert (nBytes >= 1 && nBytes <= 8192);
        return nBytes;
    }

    public int getUnsignedByteSize() {
        int nBytes;
        this.verifyInitialized();
        if (this.m_fBig && this.m_bigint.signum() < 0) {
            throw new IllegalStateException("negative value");
        }
        int n = nBytes = this.m_fBig ? PackedInteger.calculateUnsignedByteCount(this.m_bigint) : Math.max(1, (64 - Long.numberOfLeadingZeros(this.m_lValue) + 7) / 8);
        assert (nBytes >= 1 && nBytes <= 32);
        return nBytes;
    }

    public boolean isBig() {
        this.verifyInitialized();
        return this.m_fBig;
    }

    public boolean checkRange(long nLo, long nHi) {
        if (this.isBig()) {
            return false;
        }
        return this.m_lValue >= nLo && this.m_lValue <= nHi;
    }

    public boolean isNegative() {
        this.verifyInitialized();
        return this.m_fBig ? this.m_bigint.signum() < 0 : this.m_lValue < 0L;
    }

    public int getInt() {
        long n = this.getLong();
        if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
            throw new IllegalStateException(n + " exceeds the 32-bit integer range (-2147483648..2147483647)");
        }
        return (int)n;
    }

    public long getLong() {
        this.verifyInitialized();
        if (this.m_fBig && this.m_lValue == 0L) {
            throw new IllegalStateException("too big!");
        }
        return this.m_lValue;
    }

    public void setLong(long lVal) {
        this.verifyUninitialized();
        this.m_lValue = lVal;
        this.m_fInitialized = true;
    }

    public BigInteger getBigInteger() {
        this.verifyInitialized();
        BigInteger bigint = this.m_bigint;
        if (bigint == null) {
            this.m_bigint = bigint = BigInteger.valueOf(this.m_lValue);
        }
        return bigint;
    }

    public void setBigInteger(BigInteger bigint) {
        this.verifyUninitialized();
        if (bigint == null) {
            throw new IllegalArgumentException("big integer value required");
        }
        this.m_fBig = PackedInteger.calculateSignedByteCount(bigint) > 8;
        this.m_lValue = !this.m_fBig ? bigint.longValue() : (PackedInteger.calculateUnsignedByteCount(bigint) <= 8 ? bigint.longValue() : 0L);
        this.m_bigint = bigint;
        this.m_fInitialized = true;
    }

    public PackedInteger negate() {
        return new PackedInteger(this.getBigInteger().negate());
    }

    public PackedInteger complement() {
        return new PackedInteger(this.getBigInteger().not());
    }

    public PackedInteger previous() {
        return this.sub(ONE);
    }

    public PackedInteger next() {
        return this.add(ONE);
    }

    public PackedInteger add(PackedInteger that) {
        return new PackedInteger(this.getBigInteger().add(that.getBigInteger()));
    }

    public PackedInteger sub(PackedInteger that) {
        return new PackedInteger(this.getBigInteger().subtract(that.getBigInteger()));
    }

    public PackedInteger mul(PackedInteger that) {
        return new PackedInteger(this.getBigInteger().multiply(that.getBigInteger()));
    }

    public PackedInteger div(PackedInteger that) {
        return new PackedInteger(this.getBigInteger().divide(that.getBigInteger()));
    }

    public PackedInteger mod(PackedInteger that) {
        return new PackedInteger(this.getBigInteger().mod(that.getBigInteger()));
    }

    public PackedInteger[] divrem(PackedInteger that) {
        BigInteger[] aBigInt = this.getBigInteger().divideAndRemainder(that.getBigInteger());
        PackedInteger[] aPacked = new PackedInteger[]{new PackedInteger(aBigInt[0]), new PackedInteger(aBigInt[1])};
        return aPacked;
    }

    public PackedInteger and(PackedInteger that) {
        return new PackedInteger(this.getBigInteger().and(that.getBigInteger()));
    }

    public PackedInteger or(PackedInteger that) {
        return new PackedInteger(this.getBigInteger().or(that.getBigInteger()));
    }

    public PackedInteger xor(PackedInteger that) {
        return new PackedInteger(this.getBigInteger().xor(that.getBigInteger()));
    }

    public PackedInteger shl(PackedInteger that) {
        return this.shl(that.getInt());
    }

    public PackedInteger shl(int count) {
        return new PackedInteger(this.getBigInteger().shiftLeft(count));
    }

    public PackedInteger shr(PackedInteger that) {
        return this.shr(that.getInt());
    }

    public PackedInteger shr(int count) {
        return count <= 0 ? this : new PackedInteger(this.getBigInteger().shiftRight(count));
    }

    public PackedInteger ushr(PackedInteger that) {
        return this.shr(that.getInt());
    }

    public PackedInteger ushr(int count) {
        return this.shr(count);
    }

    public int cmp(PackedInteger that) {
        return this.getBigInteger().compareTo(that.getBigInteger());
    }

    public String toString(int radix) {
        if (radix == 10) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        if (this.isNegative()) {
            sb.append('-');
        }
        switch (radix) {
            case 2: {
                sb.append("0b");
                break;
            }
            case 8: {
                sb.append("0o");
                break;
            }
            case 16: {
                sb.append("0x");
                break;
            }
            default: {
                throw new IllegalArgumentException("radix=" + radix);
            }
        }
        sb.append(this.isBig() ? this.getBigInteger().abs().toString(radix) : Long.toUnsignedString(Math.abs(this.getLong()), radix));
        return sb.toString();
    }

    public void readObject(DataInput in) throws IOException {
        this.verifyUninitialized();
        byte b = in.readByte();
        if ((b & 0xE0) == 160) {
            int cBytes = 1 + (b & 0x1F);
            if (cBytes == 1) {
                long len = PackedInteger.readLong(in, in.readByte(), true);
                if (len < 33L) {
                    throw new IOException("huge integer size of " + len + " bytes; minimum is 33");
                }
                if (len > 8192L) {
                    throw new IOException("huge integer size of " + len + " bytes; maximum is 8192");
                }
                cBytes = (int)len;
            }
            if (cBytes > 8) {
                byte[] ab = new byte[cBytes];
                in.readFully(ab);
                this.setBigInteger(new BigInteger(ab));
                return;
            }
        }
        this.setLong(PackedInteger.readLong(in, b, false));
    }

    public void writeObject(DataOutput out) throws IOException {
        this.verifyInitialized();
        if (this.isBig()) {
            int of;
            byte bSkip;
            byte[] ab = this.m_bigint.toByteArray();
            int cb = ab.length;
            boolean fNeg = (ab[0] & 0x80) != 0;
            byte by = bSkip = fNeg ? (byte)255 : 0;
            for (of = 0; of < cb - 1 && ab[of] == bSkip && (ab[of + 1] & 0x80) == (bSkip & 0x80); ++of) {
            }
            assert ((cb -= of) > 8 && cb <= 8192);
            if (cb <= 32) {
                out.writeByte(0xA0 | cb - 1);
            } else {
                out.writeByte(160);
                PackedInteger.writeLong(out, cb);
            }
            out.write(ab, of, cb);
        } else {
            PackedInteger.writeLong(out, this.m_lValue);
        }
    }

    public void verifyUninitialized() {
        if (this.m_fInitialized) {
            throw new IllegalStateException("already initialized");
        }
    }

    public void verifyInitialized() {
        if (!this.m_fInitialized) {
            throw new IllegalStateException("not yet initialized");
        }
    }

    public int hashCode() {
        return this.isBig() ? this.m_bigint.hashCode() : Long.hashCode(this.m_lValue);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PackedInteger)) {
            return false;
        }
        PackedInteger that = (PackedInteger)obj;
        return this.isBig() ? that.isBig() && this.getBigInteger().equals(that.getBigInteger()) : !that.isBig() && this.getLong() == that.getLong();
    }

    public String toString() {
        return this.isBig() ? this.m_bigint.toString() : Long.toString(this.m_lValue);
    }

    @Override
    public int compareTo(PackedInteger that) {
        if (this.isBig() || that.isBig()) {
            return this.getBigInteger().compareTo(that.getBigInteger());
        }
        long lThis = this.m_lValue;
        long lThat = that.m_lValue;
        return Long.compare(lThis, lThat);
    }

    public static void writeLong(DataOutput out, long l) throws IOException {
        if (l <= 127L && l >= -64L) {
            out.writeByte((int)l);
            return;
        }
        int i = (int)l;
        int cBits = 65 - Long.numberOfLeadingZeros(Math.max(l, l ^ 0xFFFFFFFFFFFFFFFFL));
        if (cBits <= 13) {
            out.writeShort(0x8000 | i & 0x1FFF);
            return;
        }
        int cBytes = cBits + 7 >>> 3;
        out.writeByte(0xA0 | cBytes - 1);
        switch (cBytes) {
            case 2: {
                out.writeShort(i);
                break;
            }
            case 3: {
                out.writeByte(i >>> 16);
                out.writeShort(i);
                break;
            }
            case 4: {
                out.writeInt(i);
                break;
            }
            case 5: {
                out.writeByte((int)(l >>> 32));
                out.writeInt(i);
                break;
            }
            case 6: {
                out.writeShort((int)(l >>> 32));
                out.writeInt(i);
                break;
            }
            case 7: {
                out.writeByte((int)(l >>> 48));
                out.writeShort((int)(l >>> 32));
                out.writeInt(i);
                break;
            }
            case 8: {
                out.writeLong(l);
                break;
            }
            default: {
                throw new IllegalStateException("n=" + l);
            }
        }
    }

    public static long readLong(DataInput in) throws IOException {
        return PackedInteger.readLong(in, in.readByte(), false);
    }

    public static int packedLength(byte[] ab, int of) {
        byte b = ab[of];
        if ((b & 0xC0) != 128) {
            return 1;
        }
        if ((b & 0x20) == 0) {
            return 2;
        }
        int cb = 1 + (b & 0x1F);
        if (cb > 1) {
            return 1 + cb;
        }
        long sizeAndValue = PackedInteger.unpackInt(ab, of + 1);
        return 1 + (int)(sizeAndValue >>> 32) + (int)sizeAndValue;
    }

    public static int packedLength(long n) {
        if (n <= 127L && n >= -64L) {
            return 1;
        }
        int cBits = 65 - Long.numberOfLeadingZeros(Math.max(n, n ^ 0xFFFFFFFFFFFFFFFFL));
        if (cBits <= 13) {
            return 2;
        }
        int cBytes = cBits + 7 >>> 3;
        return 1 + cBytes;
    }

    public static long unpackInt(byte[] ab, int of) {
        int cb;
        int n;
        int b = ab[of];
        if ((b & 0xC0) != 128) {
            n = b;
            cb = 1;
        } else if ((b & 0x20) == 0) {
            n = b << 27 >> 19 | ab[of + 1] & 0xFF;
            cb = 2;
        } else {
            int cBytes = 1 + (b & 0x1F);
            cb = 1 + cBytes;
            ++of;
            switch (cBytes) {
                case 2: {
                    n = ab[of] << 8 | ab[of + 1] & 0xFF;
                    break;
                }
                case 3: {
                    n = ab[of] << 16 | (ab[of + 1] & 0xFF) << 8 | ab[of + 2] & 0xFF;
                    break;
                }
                case 4: {
                    n = ab[of] << 24 | (ab[of + 1] & 0xFF) << 16 | (ab[of + 2] & 0xFF) << 8 | ab[of + 3] & 0xFF;
                    break;
                }
                default: {
                    throw new IllegalStateException("# trailing bytes=" + cBytes);
                }
            }
        }
        return (long)cb << 32 | (long)n & 0xFFFFFFFFL;
    }

    private static long readLong(DataInput in, int b, boolean recursion) throws IOException {
        if ((b & 0xC0) != 128) {
            return b;
        }
        if ((b & 0x20) == 0) {
            b = b << 27 >> 19 | in.readUnsignedByte();
            return b;
        }
        int size = 1 + (b & 0x1F);
        if (size == 1) {
            if (recursion) {
                throw new IOException("illegal recursive format");
            }
            long nestedSize = PackedInteger.readLong(in, in.readUnsignedByte(), true);
            if (nestedSize < 1L) {
                throw new IOException("huge integer length (" + nestedSize + " bytes) below minimum (1 bytes)");
            }
            if (nestedSize > 8L) {
                throw new IOException("huge integer length (" + nestedSize + " bytes) exceeds maximum (8 bytes)");
            }
            size = (int)nestedSize;
        }
        switch (size) {
            case 1: {
                return in.readByte();
            }
            case 2: {
                return in.readShort();
            }
            case 3: {
                return in.readByte() << 16 | in.readUnsignedShort();
            }
            case 4: {
                return in.readInt();
            }
            case 5: {
                return (long)in.readByte() << 32 | PackedInteger.readUnsignedInt(in);
            }
            case 6: {
                return (long)in.readShort() << 32 | PackedInteger.readUnsignedInt(in);
            }
            case 7: {
                return (long)in.readByte() << 48 | (long)in.readUnsignedShort() << 32 | PackedInteger.readUnsignedInt(in);
            }
            case 8: {
                return in.readLong();
            }
        }
        throw new IllegalStateException("# trailing bytes=" + size);
    }

    private static long readUnsignedInt(DataInput in) throws IOException {
        return (long)in.readInt() & 0xFFFFFFFFL;
    }

    private static int calculateSignedByteCount(BigInteger bigint) {
        return bigint.bitLength() / 8 + 1;
    }

    private static int calculateUnsignedByteCount(BigInteger bigint) {
        return (bigint.bitLength() + 7) / 8;
    }
}

