/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.function.Consumer;

@FunctionalInterface
public interface Sentry<T>
extends AutoCloseable {
    @Override
    public void close();

    default public T get() {
        return null;
    }

    public static <T> Sentry<T> of(final T value) {
        return new Sentry<T>(){

            @Override
            public void close() {
            }

            @Override
            public T get() {
                return value;
            }
        };
    }

    public static <T> Sentry<T> of(final T value, final Consumer<? super T> closer) {
        return new Sentry<T>(){

            @Override
            public void close() {
                closer.accept(this.get());
            }

            @Override
            public T get() {
                return value;
            }
        };
    }
}

