/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.lang.constant.ClassDesc;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ShallowSizeOf {
    static final boolean COMPRESSED = Runtime.getRuntime().maxMemory() < 0x780000000L;
    private static final int HEADER = COMPRESSED ? 12 : 16;
    private static final Map<Class<?>, Long> SIZE_BY_CLASS = new ConcurrentHashMap();

    private ShallowSizeOf() {
    }

    public static long object(Object o) {
        if (o == null) {
            return 0L;
        }
        Class<?> clz = o.getClass();
        return clz.isArray() ? ShallowSizeOf.arrayOf(clz.getComponentType(), Array.getLength(o)) : ShallowSizeOf.align(ShallowSizeOf.instanceOf(clz));
    }

    public static long arrayOf(Class<?> clzComp, int slots) {
        return ShallowSizeOf.align((long)(HEADER + 4) + (long)ShallowSizeOf.fieldOf(clzComp) * (long)slots);
    }

    public static long instanceOf(Class<?> clz) {
        Long size = SIZE_BY_CLASS.get(clz);
        if (size == null) {
            Class<?> clzSuper;
            long cb = clz == Object.class ? (long)HEADER : 0L;
            for (Field f : clz.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                cb += (long)ShallowSizeOf.fieldOf(f.getType());
            }
            if (clz.isArray()) {
                cb += (long)ShallowSizeOf.fieldOf(Integer.TYPE);
            }
            if ((clzSuper = clz.getSuperclass()) != null) {
                cb += ShallowSizeOf.instanceOf(clzSuper);
            }
            SIZE_BY_CLASS.put(clz, cb);
            return cb;
        }
        return size;
    }

    public static int fieldOf(Class<?> clz) {
        if (clz.isPrimitive()) {
            if (clz == Long.TYPE) {
                return 8;
            }
            if (clz == Double.TYPE) {
                return 8;
            }
            if (clz == Integer.TYPE) {
                return 4;
            }
            if (clz == Float.TYPE) {
                return 4;
            }
            if (clz == Boolean.TYPE) {
                return 1;
            }
            if (clz == Byte.TYPE) {
                return 1;
            }
            if (clz == Character.TYPE) {
                return 2;
            }
            if (clz == Short.TYPE) {
                return 2;
            }
            throw new IllegalStateException();
        }
        return COMPRESSED ? 4 : 8;
    }

    public static int fieldOf(ClassDesc cd) {
        if (cd.isPrimitive()) {
            return switch (cd.descriptorString()) {
                case "J", "D" -> 8;
                case "I", "F" -> 4;
                case "C", "S" -> 2;
                case "B", "Z" -> 1;
                default -> throw new IllegalStateException();
            };
        }
        return COMPRESSED ? 4 : 8;
    }

    public static long align(long cb) {
        return cb + 7L & 0xFFFFFFFFFFFFFFF8L;
    }
}

