/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.xvm.util.Hasher;
import org.xvm.util.HasherReference;

class TransientHasherReference<T>
extends HasherReference<T>
implements AutoCloseable {
    private static final AtomicReferenceArray<TransientHasherReference<?>> HEADS = new AtomicReferenceArray(Integer.highestOneBit(Runtime.getRuntime().availableProcessors()) << 1);
    private TransientHasherReference<?> next;

    protected TransientHasherReference(T referent, Hasher<? super T> hasher) {
        super(referent, hasher);
    }

    public static <T> TransientHasherReference<T> of(T referent, Hasher<? super T> hasher) {
        int slot = Thread.currentThread().hashCode() & HEADS.length() - 1;
        TransientHasherReference<?> ref = HEADS.get(slot);
        while (ref != null && !HEADS.compareAndSet(slot, ref, ref.next)) {
            ref = HEADS.get(slot);
        }
        if (ref == null) {
            return new TransientHasherReference<T>(referent, hasher);
        }
        TransientHasherReference<?> keyRef = ref;
        keyRef.next = null;
        keyRef.reset(referent, hasher);
        return keyRef;
    }

    @Override
    public void close() {
        this.reset(null, null);
        int slot = Thread.currentThread().hashCode() & HEADS.length() - 1;
        this.next = HEADS.get(slot);
        while (!HEADS.compareAndSet(slot, this.next, this)) {
            this.next = HEADS.get(slot);
        }
    }
}

