/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.xvm.util.Sentry;

public class TransientThreadLocal<T>
extends ThreadLocal<T> {
    private static final ThreadLocal<Map<TransientThreadLocal<?>, Object>> TRANSIENT_MAP = ThreadLocal.withInitial(IdentityHashMap::new);
    private final Sentry<T> m_sentryRemove = this::remove;

    public static <S> TransientThreadLocal<S> withInitial(final Supplier<? extends S> supplier) {
        Objects.requireNonNull(supplier, "null supplier");
        return new TransientThreadLocal<S>(){

            @Override
            protected S initialValue() {
                return supplier.get();
            }
        };
    }

    @Override
    public T get() {
        Map<TransientThreadLocal<?>, Object> map = TRANSIENT_MAP.get();
        Object value = map.get(this);
        if (value == null) {
            value = this.initialValue();
            map.put(this, value);
        }
        return (T)value;
    }

    @Override
    public void set(T value) {
        TRANSIENT_MAP.get().put(this, value);
    }

    @Override
    public void remove() {
        TRANSIENT_MAP.get().remove(this);
    }

    public T compute(Function<? super T, ? extends T> fn) {
        Map<TransientThreadLocal<?>, Object> map = TRANSIENT_MAP.get();
        Object valueOld = map.get(this);
        T valueNew = fn.apply(valueOld == null ? this.initialValue() : valueOld);
        if (valueNew == null) {
            map.remove(this);
        } else {
            map.put(this, valueNew);
        }
        return valueNew;
    }

    public T computeIfAbsent(Supplier<? extends T> fn) {
        Map<TransientThreadLocal<?>, Object> map = TRANSIENT_MAP.get();
        Object valueOld = map.get(this);
        if (valueOld == null) {
            T valueNew = fn.get();
            if (valueNew != null) {
                map.put(this, valueNew);
            }
            return valueNew;
        }
        return (T)valueOld;
    }

    public Sentry<T> push(final T value) {
        final Map<TransientThreadLocal<?>, Object> map = TRANSIENT_MAP.get();
        Object valuePrev = map.put(this, value);
        final Object valueRestore = valuePrev == null ? this.initialValue() : valuePrev;
        return valueRestore == null ? this.m_sentryRemove : new Sentry<T>(this){
            final /* synthetic */ TransientThreadLocal this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T get() {
                return value;
            }

            @Override
            public void close() {
                map.put(this.this$0, valueRestore);
            }
        };
    }
}

