/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.xvm.util.FilterIterator;
import org.xvm.util.Hasher;
import org.xvm.util.HasherMap;
import org.xvm.util.WeakHasherReference;
import org.xvm.util.converter.AbstractConverterMap;

public class WeakHasherMap<K, V>
extends HasherMap<K, V> {
    private static final int MIN_GC_INTERVAL = Integer.highestOneBit(Runtime.getRuntime().availableProcessors());
    final ReferenceQueue<K> garbage = new ReferenceQueue();
    int fullGcInterval = MIN_GC_INTERVAL;

    public WeakHasherMap(Hasher<K> hasher) {
        super(hasher);
    }

    public WeakHasherMap(Hasher<K> hasher, Supplier<? extends Map<Supplier<K>, V>> storage) {
        super(hasher, storage);
    }

    @Override
    protected Supplier<K> keyDown(K key) {
        return new WeakHasherReference<K>(key, this.hasher, this.garbage);
    }

    @Override
    protected Map<Supplier<K>, V> read() {
        Map storage = super.read();
        return ThreadLocalRandom.current().nextInt(this.fullGcInterval) == 0 ? this.gc(storage, true, storage instanceof ConcurrentMap) : storage;
    }

    @Override
    protected Map<Supplier<K>, V> write() {
        Map storage = super.write();
        int rand = ThreadLocalRandom.current().nextInt();
        return this.gc(storage, (rand & this.fullGcInterval - 1) == 0, (rand & MIN_GC_INTERVAL - 1) == 0);
    }

    protected Map<Supplier<K>, V> gc(Map<Supplier<K>, V> storage, boolean mark, boolean sweep) {
        if (mark) {
            int c = 0;
            Iterator<Supplier<K>> iter = storage.keySet().iterator();
            while (iter.hasNext()) {
                Supplier<K> ref = iter.next();
                if (ref.get() == null) {
                    if (sweep) {
                        iter.remove();
                        continue;
                    }
                    ((WeakHasherReference)ref).enqueue();
                }
                ++c;
            }
            this.fullGcInterval = Integer.highestOneBit(Math.max(MIN_GC_INTERVAL, c + c / 2));
        }
        if (sweep) {
            Reference<K> key;
            while ((key = this.garbage.poll()) != null) {
                storage.remove((WeakHasherReference)key);
            }
        }
        return storage;
    }

    @Override
    protected Set<K> newKeySet() {
        return new KeySet(this);
    }

    @Override
    protected Set<Map.Entry<K, V>> newEntrySet() {
        return new EntrySet(this);
    }

    protected class KeySet
    extends HasherMap.KeySet {
        protected KeySet(WeakHasherMap this$0) {
        }

        @Override
        public Iterator<K> iterator() {
            return new FilterIterator<Object>(super.iterator(), Objects::nonNull);
        }
    }

    protected class EntrySet
    extends AbstractConverterMap.EntrySet {
        protected EntrySet(WeakHasherMap this$0) {
            super(this$0);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new FilterIterator(super.iterator(), e -> e.getKey() != null);
        }
    }
}

