/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.function.Supplier;
import org.xvm.util.Hasher;

public class WeakHasherReference<T>
extends WeakReference<T>
implements Supplier<T> {
    private final Hasher<? super T> hasher;
    private final int hash;

    public WeakHasherReference(T referent, Hasher<? super T> hasher, ReferenceQueue<? super T> queue) {
        super(referent, queue);
        this.hasher = hasher;
        this.hash = hasher.hash(referent);
    }

    public int hashCode() {
        return this.hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Supplier)) return false;
        Supplier that = (Supplier)obj;
        if (!this.hasher.equals(this.get(), that.get())) return false;
        return true;
    }
}

